/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.mass.Compare;
import agent.mass.DoubleCompare;
import agent.mass.SortVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import utilities.Distribution;

public class LDist {
    public static final int QUALITY = 0;
    public static final int COST = 1;
    public static final int DURATION = 2;
    protected String taskname;
    protected int winsize;
    protected Vector quality = new Vector();
    protected Vector cost = new Vector();
    protected Vector duration = new Vector();
    protected Hashtable quality_count = new Hashtable();
    protected Hashtable cost_count = new Hashtable();
    protected Hashtable duration_count = new Hashtable();
    protected int datasize;
    protected boolean errorflag = false;

    public LDist(boolean error) {
        this.errorflag = error;
    }

    public LDist(String actionname, int wsize) {
        this.taskname = actionname;
        this.winsize = wsize;
    }

    public LDist(String actionname, int wsize, Double q, Double c, Double d) {
        this.taskname = actionname;
        this.winsize = wsize;
        this.addElement(q, c, d);
    }

    public LDist(String actionname, int wsize, Distribution q, Distribution c, Distribution d, int numofdata) {
        this.taskname = actionname;
        this.winsize = wsize;
        this.datasize = numofdata;
        int i = 0;
        while (i < q.size()) {
            Float tmpval = (Float)q.elementAt(i);
            Float tmpcount = (Float)q.elementAt(i + 1);
            Double tmp = new Double((float)numofdata * tmpcount.floatValue());
            this.quality_count.put(new Double(tmpval.doubleValue()), new Integer(tmp.intValue()));
            i += 2;
        }
        int i2 = 0;
        while (i2 < c.size()) {
            Float tmpval = (Float)c.elementAt(i2);
            Float tmpcount = (Float)c.elementAt(i2 + 1);
            Double tmp = new Double((float)numofdata * tmpcount.floatValue());
            this.cost_count.put(new Double(tmpval.doubleValue()), new Integer(tmp.intValue()));
            i2 += 2;
        }
        int i3 = 0;
        while (i3 < d.size()) {
            Float tmpval = (Float)d.elementAt(i3);
            Float tmpcount = (Float)d.elementAt(i3 + 1);
            Double tmp = new Double((float)numofdata * tmpcount.floatValue());
            this.duration_count.put(new Double(tmpval.doubleValue()), new Integer(tmp.intValue()));
            i3 += 2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Vector getSortedKeys(int type) {
        SortVector sval = new SortVector((Compare)new DoubleCompare());
        Enumeration e = null;
        if (type == 0) {
            e = this.quality_count.keys();
        } else if (type == 1) {
            e = this.cost_count.keys();
        } else {
            if (type != 2) {
                return null;
            }
            e = this.duration_count.keys();
        }
        while (e.hasMoreElements()) {
            sval.addElement(e.nextElement());
        }
        sval.sort();
        return sval;
    }

    public Vector getDataDist(int type) {
        if (type == 0) {
            return this.quality;
        }
        if (type == 1) {
            return this.cost;
        }
        if (type == 2) {
            return this.duration;
        }
        return new Vector();
    }

    public Hashtable getCountDist(int type) {
        if (type == 0) {
            return this.quality_count;
        }
        if (type == 1) {
            return this.cost_count;
        }
        if (type == 2) {
            return this.duration_count;
        }
        return new Hashtable();
    }

    public Distribution getTaemsDist(int type) {
        Distribution tmptaems = new Distribution();
        Hashtable tmphash = null;
        if (type == 0) {
            tmphash = this.quality_count;
        } else if (type == 1) {
            tmphash = this.cost_count;
        } else if (type == 2) {
            tmphash = this.duration_count;
        }
        if (tmphash != null) {
            Enumeration enumeration = tmphash.keys();
            while (enumeration.hasMoreElements()) {
                Double tmpkey = (Double)enumeration.nextElement();
                Integer tmpcount = (Integer)tmphash.get(tmpkey);
                tmptaems.insertElementAt(new Float(Double.toString(tmpcount.doubleValue() / (double)this.datasize)), 0);
                tmptaems.insertElementAt(new Float(tmpkey.toString()), 0);
            }
            return tmptaems;
        }
        return new Distribution();
    }

    public int getWinSize() {
        return this.winsize;
    }

    public String getTaskName() {
        return this.taskname;
    }

    public int getStatNum() {
        return this.datasize;
    }

    public double getMedian(int type) {
        SortVector sval = new SortVector((Compare)new DoubleCompare());
        Vector tmpvec = new Vector();
        if (type == 0) {
            tmpvec = this.quality;
        } else if (type == 1) {
            tmpvec = this.cost;
        } else if (type == 2) {
            tmpvec = this.duration;
        }
        Enumeration enumeration = tmpvec.elements();
        while (enumeration.hasMoreElements()) {
            sval.addElement(enumeration.nextElement());
        }
        sval.sort();
        return this.calcMedian((Vector)sval, 0, sval.size());
    }

    private double calcMedian(Vector sortedvec, int startpos, int endpos) {
        int vsize = sortedvec.size();
        int esize = endpos - startpos;
        double median = Double.MIN_VALUE;
        median = esize % 2 == 0 ? ((Double)sortedvec.elementAt(esize / 2 + 1) + (Double)sortedvec.elementAt(esize / 2)) / 2.0 : (Double)sortedvec.elementAt(esize / 2);
        return median;
    }

    public double getInterQuart(int type) {
        SortVector sval = new SortVector((Compare)new DoubleCompare());
        Vector tmpvec = new Vector();
        if (type == 0) {
            tmpvec = this.quality;
        } else if (type == 1) {
            tmpvec = this.cost;
        } else if (type == 2) {
            tmpvec = this.duration;
        }
        Enumeration enumeration = tmpvec.elements();
        while (enumeration.hasMoreElements()) {
            sval.addElement(enumeration.nextElement());
        }
        sval.sort();
        int vsize = sval.size();
        double median_m = this.calcMedian((Vector)sval, 0, vsize);
        double median_l = this.calcMedian((Vector)sval, 0, vsize / 2);
        double median_r = this.calcMedian((Vector)sval, vsize / 2, vsize);
        Enumeration enum2 = sval.elements();
        double oldval = Double.MIN_VALUE;
        double l_value = Double.MIN_VALUE;
        double r_value = Double.MAX_VALUE;
        boolean l_notyet = true;
        boolean r_notyet = true;
        while (enum2.hasMoreElements()) {
            double tmpval = (Double)enum2.nextElement();
            if (tmpval > median_l && l_notyet) {
                l_value = tmpval;
                l_notyet = false;
            }
            if (tmpval > median_r && r_notyet) {
                r_value = oldval;
                r_notyet = false;
            }
            oldval = tmpval;
        }
        return r_value - l_value;
    }

    public double getMode(int type) {
        double newvalue = Double.MIN_VALUE;
        Hashtable tmphash = new Hashtable();
        if (type == 0) {
            tmphash = this.quality_count;
        } else if (type == 1) {
            tmphash = this.cost_count;
        } else if (type == 2) {
            tmphash = this.duration_count;
        }
        int count = 0;
        Enumeration enumeration = tmphash.keys();
        while (enumeration.hasMoreElements()) {
            Double currkey = (Double)enumeration.nextElement();
            int tmpcount = (Integer)tmphash.get(currkey);
            if (tmpcount <= count) continue;
            count = tmpcount;
            newvalue = (Double)tmphash.get(currkey);
        }
        return newvalue;
    }

    public double getMax(int type) {
        Hashtable tmphash = new Hashtable();
        if (type == 0) {
            tmphash = this.quality_count;
        } else if (type == 1) {
            tmphash = this.cost_count;
        } else if (type == 2) {
            tmphash = this.duration_count;
        }
        double maxval = Double.MIN_VALUE;
        Enumeration enumeration = tmphash.keys();
        while (enumeration.hasMoreElements()) {
            Double currkey = (Double)enumeration.nextElement();
            double newvalue = currkey;
            if (!(newvalue > maxval)) continue;
            maxval = newvalue;
        }
        return maxval;
    }

    public double getMin(int type) {
        Hashtable tmphash = new Hashtable();
        if (type == 0) {
            tmphash = this.quality_count;
        } else if (type == 1) {
            tmphash = this.cost_count;
        } else if (type == 2) {
            tmphash = this.duration_count;
        }
        double minval = Double.MAX_VALUE;
        Enumeration enumeration = tmphash.keys();
        while (enumeration.hasMoreElements()) {
            Double currkey = (Double)enumeration.nextElement();
            double newvalue = currkey;
            if (!(newvalue < minval)) continue;
            minval = newvalue;
        }
        return minval;
    }

    public double getMean(int type) {
        double accvalue = 0.0;
        Vector tmpvec = new Vector();
        if (type == 0) {
            tmpvec = this.quality;
        } else if (type == 1) {
            tmpvec = this.cost;
        } else if (type == 2) {
            tmpvec = this.duration;
        }
        Enumeration enumeration = tmpvec.elements();
        while (enumeration.hasMoreElements()) {
            double newvalue = (Double)enumeration.nextElement();
            accvalue += newvalue;
        }
        return accvalue / (double)this.getStatNum();
    }

    public double getRange(int type) {
        double maxi = this.getMax(type);
        double mini = this.getMin(type);
        if (maxi > Double.MIN_VALUE && mini > Double.MIN_VALUE) {
            return maxi - mini;
        }
        return Double.MIN_VALUE;
    }

    public double getStandDev(int type) {
        return Math.sqrt(this.getVar(type));
    }

    public double getVar(int type) {
        double accvalue = 0.0;
        Vector tmpvec = new Vector();
        if (type == 0) {
            tmpvec = this.quality;
        } else if (type == 1) {
            tmpvec = this.cost;
        } else if (type == 2) {
            tmpvec = this.duration;
        }
        double mean = this.getMean(type);
        Enumeration enumeration = tmpvec.elements();
        while (enumeration.hasMoreElements()) {
            double newvalue = (Double)enumeration.nextElement();
            accvalue += Math.pow(newvalue - mean, 2.0);
        }
        return accvalue / (double)this.getStatNum();
    }

    public void addElement(Double qualvalue, Double cosvalue, Double durvalue) {
        if (this.quality.size() >= this.winsize) {
            Double q0 = (Double)this.quality.elementAt(0);
            Double c0 = (Double)this.cost.elementAt(0);
            Double d0 = (Double)this.duration.elementAt(0);
            this.quality.removeElementAt(0);
            this.cost.removeElementAt(0);
            this.duration.removeElementAt(0);
            int tmpval = (Integer)this.quality_count.get(q0);
            if (tmpval > 1) {
                this.quality_count.put(q0, new Integer(tmpval - 1));
            } else {
                this.quality_count.remove(q0);
            }
            tmpval = (Integer)this.cost_count.get(c0);
            if (tmpval > 1) {
                this.cost_count.put(c0, new Integer(tmpval - 1));
            } else {
                this.quality_count.remove(c0);
            }
            tmpval = (Integer)this.duration_count.get(d0);
            if (tmpval > 1) {
                this.duration_count.put(d0, new Integer(tmpval - 1));
            } else {
                this.duration_count.remove(d0);
            }
            --this.datasize;
        }
        this.quality.addElement(qualvalue);
        this.cost.addElement(cosvalue);
        this.duration.addElement(durvalue);
        if (this.quality_count.containsKey(qualvalue)) {
            this.quality_count.put(qualvalue, new Integer((Integer)this.quality_count.get(qualvalue) + 1));
        } else {
            this.quality_count.put(qualvalue, new Integer(1));
        }
        if (this.cost_count.containsKey(cosvalue)) {
            this.cost_count.put(cosvalue, new Integer((Integer)this.cost_count.get(cosvalue) + 1));
        } else {
            this.cost_count.put(cosvalue, new Integer(1));
        }
        if (this.duration_count.containsKey(durvalue)) {
            this.duration_count.put(durvalue, new Integer((Integer)this.duration_count.get(durvalue) + 1));
        } else {
            this.duration_count.put(durvalue, new Integer(1));
        }
        ++this.datasize;
    }

    public boolean errorp() {
        return this.errorflag;
    }

    public void reset() {
        this.quality_count.clear();
        this.cost_count.clear();
        this.duration_count.clear();
        this.quality.removeAllElements();
        this.cost.removeAllElements();
        this.duration.removeAllElements();
    }

    public String toString() {
        return "[LDist: Name=" + this.taskname + ", winsize=" + this.winsize + ", Quality=" + this.quality_count + ", Cost=" + this.cost_count + ", Duration=" + this.duration_count + "]";
    }
}

