/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

public class GammaFunct {
    public static double getGammaQ(double a, double x) {
        return GammaFunct.gammaq(a, x);
    }

    public static double gammaq(double a, double x) {
        if (x < 0.0 || a <= 0.0) {
            System.out.println("gammaq: error");
        }
        if (x < a + 1.0) {
            return 1.0 - GammaFunct.gser(a, x);
        }
        return GammaFunct.gcf(a, x);
    }

    public static double gser(double a, double x) {
        int ITMAX = 100;
        double EPS = 3.0E-7;
        double gln = GammaFunct.gammaln(a);
        double gamser = Double.MIN_VALUE;
        if (x <= 0.0) {
            if (!(x < 0.0)) {
                return 0.0;
            }
        } else {
            double ap = a;
            double del = 1.0 / a;
            double sum = 1.0 / a;
            int n = 1;
            while (n <= 100) {
                del = del * x / (ap += 1.0);
                sum += del;
                if (Math.abs(del) < Math.abs(sum) * 3.0E-7) {
                    gamser = sum * Math.exp(-x + a * Math.log(x) - gln);
                    return gamser;
                }
                ++n;
            }
            System.out.println("Gser: error2");
            return Double.MIN_VALUE;
        }
        System.out.println("Gser: error");
        return Double.MIN_VALUE;
    }

    public static double gammaln(double xx) {
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.2317395172450154, 0.001208650973866179, -5.395239384953E-6};
        double x = xx;
        double y = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            ser += cof[j] / (y += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    public static double gcf(double a, double x) {
        double d;
        int ITMAX = 100;
        double EPS = 3.0E-7;
        double FPMIN = 1.0E-300;
        double gln = GammaFunct.gammaln(a);
        double b = x + 1.0 - a;
        double c = 9.999999999999999E299;
        double h = d = 1.0 / b;
        int i = 1;
        while (i <= 100) {
            double an = (double)(-i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < 1.0E-300) {
                d = 1.0E-300;
            }
            if (Math.abs(c = b + an / c) < 1.0E-300) {
                c = 1.0E-300;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < 3.0E-7) break;
            ++i;
        }
        if (i > 100) {
            System.out.println("Gcf: error");
        }
        return Math.exp(-x + a * Math.log(x) - gln) * h;
    }
}

