/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.learn.LearnedEvent;
import agent.learn.LearnedEventListener;
import agent.learn.Learning;
import agent.simplest.Log;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.LimitsInterrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.ProducesInterrelationship;
import taems.Taems;
import taems.Task;
import utilities.Distribution;

public class FakeLearning
extends Learning
implements PropertyEventListener {
    static final long serialVersionUID = 1234567890L;
    protected ListenerVector listeners = new ListenerVector();
    protected State state;
    protected Log log;
    protected Taems objective;

    public void init() {
        this.state = (State)State.findComponent((String)"State");
        this.log = (Log)State.findComponent((String)"Log");
        this.state.setProperty((Object)"StoreObjTask", (Object)new Boolean(true));
        this.state.addPropertyEventListener((PropertyEventListener)this);
    }

    public void begin() {
        this.objective = (Taems)this.state.getProperty((Object)"ObjTaemsTask");
    }

    public void end() {
    }

    public void pulse() {
    }

    protected void fireLearnedEvent(LearnedEvent e) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            LearnedEventListener l = (LearnedEventListener)enumeration.nextElement();
            switch (e.getID()) {
                case 0: {
                    l.learnedMethodDistribution(e);
                    break;
                }
                case 1: {
                    l.learnedNle(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((AgentEvent)e, 2, agent.learn.Learning.FAC_LEARN);
        }
    }

    public void addLearnedEventListener(LearnedEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeLearnedEventListener(LearnedEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    public void resetSchedule() {
    }

    public Distribution getLearnedTaemsMethodDist(String m, int type) {
        Method method = this.getLearnedTaemsMethod(m);
        Outcome o = method.getGlobalOutcome();
        if (method == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return o.getQuality();
            }
            case 1: {
                return o.getCost();
            }
            case 2: {
                return o.getDuration();
            }
        }
        return null;
    }

    public Method getLearnedTaemsMethod(String m) {
        if (this.objective == null) {
            this.log.log("Warning: Objective structure is null.", 1, agent.learn.Learning.FAC_LEARN);
            return null;
        }
        Method method = (Method)this.objective.findNode((Node)new Method(m, null));
        if (method == null) {
            return null;
        }
        return method;
    }

    public Task getLearnedTaemsTask(String t) {
        if (this.objective == null) {
            this.log.log("Warning: Objective structure is null.", 1, agent.learn.Learning.FAC_LEARN);
            return null;
        }
        Task task = (Task)this.objective.findNode((Node)new Task(t, null, null));
        if (task == null) {
            return null;
        }
        return task;
    }

    public Vector getLearnedNLEforTask(String mname) {
        Vector<Interrelationship> NLE = new Vector<Interrelationship>();
        Task task = this.getLearnedTaemsTask(mname);
        if (task == null) {
            task = this.getLearnedTaemsMethod(mname);
        }
        if (task == null) {
            this.log.log("Warning: Couldn't find task/method " + mname + " in task structure", 1, agent.learn.Learning.FAC_LEARN);
            return NLE;
        }
        Enumeration e = task.getAffectingInterrelationships();
        while (e.hasMoreElements()) {
            Interrelationship rel = (Interrelationship)e.nextElement();
            if (rel instanceof ConsumesInterrelationship && rel instanceof ProducesInterrelationship && rel instanceof LimitsInterrelationship) continue;
            NLE.addElement(rel);
        }
        return NLE;
    }

    public Vector getLearnedResourceNLEforMethod(String mname) {
        Interrelationship rel;
        Vector<Interrelationship> NLE = new Vector<Interrelationship>();
        Method m = this.getLearnedTaemsMethod(mname);
        Enumeration e = m.getAffectingInterrelationships();
        while (e.hasMoreElements()) {
            rel = (Interrelationship)e.nextElement();
            if (!(rel instanceof ConsumesInterrelationship) && !(rel instanceof ProducesInterrelationship)) continue;
            NLE.addElement(rel);
        }
        e = m.getAffectedInterrelationships();
        while (e.hasMoreElements()) {
            rel = (Interrelationship)e.nextElement();
            if (!(rel instanceof LimitsInterrelationship)) continue;
            NLE.addElement(rel);
        }
        return NLE;
    }

    public void printInfoDist(String kind, int loglevel) {
    }

    public void printInfoSoft(int loglevel) {
    }

    public void printInfoHard(int loglevel) {
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("ObjTaemsTask")) {
            this.objective = (Taems)this.state.getProperty((Object)"ObjTaemsTask");
        }
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyRemoved(PropertyEvent e) {
    }
}

