/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.Dists;
import agent.learn.LDist;
import agent.learn.Learning;
import agent.learn.Nles;
import agent.learn.ScheduleObj;
import agent.learn.ToolsLearning;
import agent.simplest.GenericPointer;
import agent.simplest.Log;
import agent.simplest.State;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DistLearning
implements Serializable {
    Dists unaffectdist_DB;
    Dists affectdist_DB;
    Nles nles_DB;
    ToolsLearning toolsLearn;
    Integer winsize;
    GenericPointer NleConfThresh;
    protected Log log;
    protected int FAC_LEARN = Learning.FAC_LEARN;

    public void Instantiate(Dists in_unaffectdist_DB, Dists in_affectdist_DB, Nles in_nles_DB, ToolsLearning in_toolsLearn, Integer in_winsize, GenericPointer in_NleConfThresh) {
        this.unaffectdist_DB = in_unaffectdist_DB;
        this.affectdist_DB = in_affectdist_DB;
        this.nles_DB = in_nles_DB;
        this.toolsLearn = in_toolsLearn;
        this.winsize = in_winsize;
        this.NleConfThresh = in_NleConfThresh;
        this.log = (Log)State.findComponent((String)"Log");
        this.FAC_LEARN = Learning.FAC_LEARN;
    }

    public boolean isUnaffected(ScheduleObj schedobj, Vector sched) {
        String mname = schedobj.getName();
        if (schedobj.getQuality() == 0.0) {
            return false;
        }
        Vector cleansched = new Vector();
        this.toolsLearn.cleanSchedule(sched, cleansched);
        ScheduleObj firstschedobj = (ScheduleObj)cleansched.firstElement();
        if (firstschedobj.toString().equals(schedobj.toString())) {
            return true;
        }
        Enumeration enumeration = cleansched.elements();
        while (enumeration.hasMoreElements()) {
            ScheduleObj tmpsched = (ScheduleObj)enumeration.nextElement();
            String tmpname = tmpsched.getName();
            if (this.nles_DB.getEntry(mname, tmpname, "enables") == null || this.nles_DB.getEntry(mname, tmpname, "disables") == null || this.nles_DB.getEntry(mname, tmpname, "softrel") == null || this.nles_DB.getStatus(mname, tmpname, "enables").equals("N") && this.nles_DB.getStatus(mname, tmpname, "disables").equals("N") && this.nles_DB.getStatus(mname, tmpname, "softrel").equals("N")) continue;
            return false;
        }
        return true;
    }

    public void updateUnaffectedDist(ScheduleObj entry) {
        LDist olddist = (LDist)this.unaffectdist_DB.get(entry.getName());
        if (olddist == null) {
            this.unaffectdist_DB.put(entry.getName(), new LDist(entry.getName(), this.winsize, entry.getQuality(), entry.getCost(), entry.getDuration()));
        } else {
            olddist.addElement(entry.getQuality(), entry.getCost(), entry.getDuration());
        }
        this.log.log("Put " + entry + " into unaffected distribution", 5, this.FAC_LEARN);
    }

    public void updateAffectedDist(ScheduleObj entry, Vector schedule_sofar) {
        double adaptq = entry.getQuality();
        double adaptc = entry.getCost();
        double adaptd = entry.getDuration();
        String toname = entry.getName();
        this.log.log("Extracting learned power factors!", 5, this.FAC_LEARN);
        Enumeration e = schedule_sofar.elements();
        while (e.hasMoreElements()) {
            ScheduleObj tmpmeth = (ScheduleObj)e.nextElement();
            if (!(tmpmeth.getQuality() > 0.0) || tmpmeth.getName().equals(toname)) continue;
            String fromname = tmpmeth.getName();
            LDist nlepower = this.nles_DB.getPower(toname, fromname, "softrel");
            Double powq = (Double)nlepower.getDataDist(0).elementAt(0);
            Double powc = (Double)nlepower.getDataDist(1).elementAt(0);
            Double powd = (Double)nlepower.getDataDist(2).elementAt(0);
            this.log.log("Checking method " + fromname + " -> powq=" + powq + " powc=" + powc + " powd=" + powd, 5, this.FAC_LEARN);
            this.log.log("Checking whether those values are significant", 5, this.FAC_LEARN);
            Double sigq = (Double)nlepower.getDataDist(0).elementAt(1);
            Double sigc = (Double)nlepower.getDataDist(1).elementAt(1);
            Double sigd = (Double)nlepower.getDataDist(2).elementAt(1);
            Double fitq = (Double)nlepower.getDataDist(0).elementAt(2);
            Double fitc = (Double)nlepower.getDataDist(1).elementAt(2);
            Double fitd = (Double)nlepower.getDataDist(2).elementAt(2);
            double nleconfthresh = (Double)this.NleConfThresh.obj;
            if (sigq >= nleconfthresh) {
                adaptq /= powq.doubleValue();
                this.log.log("qualitychange significant at conf=" + sigq + " fit=" + fitq, 5, this.FAC_LEARN);
            }
            if (sigc >= nleconfthresh) {
                adaptc /= powc.doubleValue();
            }
            if (!(sigd >= nleconfthresh)) continue;
            adaptd /= powd.doubleValue();
        }
        this.log.log(toname + " before adaption: q=" + entry.getQuality() + " c=" + entry.getCost() + " d=" + entry.getDuration(), 5);
        this.log.log(toname + " AFTER adaption: q=" + adaptq + " c=" + adaptc + " d=" + adaptd, 5, this.FAC_LEARN);
        LDist olddist = (LDist)this.affectdist_DB.get(toname);
        if (olddist == null) {
            this.affectdist_DB.put(toname, new LDist(toname, this.winsize, new Double(adaptq), new Double(adaptc), new Double(adaptd)));
        } else {
            olddist.addElement(new Double(adaptq), new Double(adaptc), new Double(adaptd));
        }
        this.log.log("Put values for " + toname + " into adapted distribution", 5, this.FAC_LEARN);
    }
}

