/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.GammaFunct;
import agent.learn.LDist;
import java.util.Enumeration;
import java.util.Hashtable;
import taems.Outcome;
import utilities.Distribution;

public class ChiSquare {
    protected int df;
    protected double chisquareval = 0.0;
    protected double significance = 1.0;
    protected Hashtable coldist = new Hashtable();
    protected double sumrows;

    public ChiSquare(LDist[] dists, int type) {
        Double tmpkey;
        Enumeration e;
        int i = 0;
        while (i < dists.length) {
            if (dists[i] != null) {
                e = dists[i].getCountDist(type).keys();
                while (e.hasMoreElements()) {
                    tmpkey = (Double)e.nextElement();
                    Integer tmpval = (Integer)dists[i].getCountDist(type).get(tmpkey);
                    if (this.coldist.containsKey(tmpkey)) {
                        this.coldist.put(tmpkey, new Integer((Integer)this.coldist.get(tmpkey) + tmpval));
                    } else {
                        this.coldist.put(tmpkey, tmpval);
                    }
                    this.sumrows += tmpval.doubleValue();
                }
            }
            ++i;
        }
        this.df = (this.coldist.size() - 1) * 1;
        e = this.coldist.keys();
        while (e.hasMoreElements()) {
            tmpkey = (Double)e.nextElement();
            int i2 = 0;
            while (i2 < dists.length) {
                if (dists[i2] != null) {
                    Integer tmpobj = (Integer)dists[i2].getCountDist(type).get(tmpkey);
                    double observ = tmpobj != null ? tmpobj.doubleValue() : 0.0;
                    double expect = (double)dists[i2].getStatNum() * ((Integer)this.coldist.get(tmpkey)).doubleValue() / this.sumrows;
                    this.chisquareval += Math.pow(observ - expect, 2.0) / expect;
                }
                ++i2;
            }
        }
        this.significance = GammaFunct.getGammaQ((double)this.df / 2.0, this.chisquareval / 2.0);
    }

    public ChiSquare(LDist dist1, Outcome dist2, int type) {
        int num = dist1.getStatNum();
        Hashtable<Double, Double> outcometable = new Hashtable<Double, Double>();
        if (dist1 != null) {
            Enumeration e = dist1.getCountDist(type).keys();
            while (e.hasMoreElements()) {
                Double tmpkey = (Double)e.nextElement();
                Integer tmpval = (Integer)dist1.getCountDist(type).get(tmpkey);
                if (this.coldist.containsKey(tmpkey)) {
                    this.coldist.put(tmpkey, new Double((Double)this.coldist.get(tmpkey) + tmpval.doubleValue()));
                } else {
                    this.coldist.put(tmpkey, new Double(tmpval.doubleValue()));
                }
                this.sumrows += tmpval.doubleValue();
            }
        }
        Distribution vec2 = null;
        if (dist2 != null) {
            if (type == 0) {
                vec2 = dist2.getQuality();
            } else if (type == 1) {
                vec2 = dist2.getCost();
            } else if (type == 2) {
                vec2 = dist2.getDuration();
            }
            int i = 0;
            while (i < vec2.size()) {
                Float tmpelem = (Float)vec2.elementAt(i);
                Float tmpprob = (Float)vec2.elementAt(i + 1);
                Double tmpelem2 = new Double(tmpelem.doubleValue());
                Double tmpprob2 = new Double(tmpprob.doubleValue() * (double)num);
                outcometable.put(tmpelem2, tmpprob2);
                if (this.coldist.containsKey(tmpelem2)) {
                    this.coldist.put(tmpelem2, new Double((Double)this.coldist.get(tmpelem2) + tmpprob2));
                } else {
                    this.coldist.put(tmpelem2, tmpprob2);
                }
                this.sumrows += tmpprob2.doubleValue();
                i += 2;
            }
        }
        this.df = (this.coldist.size() - 1) * 1;
        Enumeration e = this.coldist.keys();
        while (e.hasMoreElements()) {
            Double tmpkey = (Double)e.nextElement();
            Integer tmpobj = (Integer)dist1.getCountDist(type).get(tmpkey);
            double observ = tmpobj != null ? tmpobj.doubleValue() : 0.0;
            double expect = (double)num * (Double)this.coldist.get(tmpkey) / this.sumrows;
            this.chisquareval += Math.pow(observ - expect, 2.0) / expect;
            Double tmpval = (Double)outcometable.get(tmpkey);
            observ = tmpobj != null ? tmpobj.doubleValue() : 0.0;
            expect = (double)num * (Double)this.coldist.get(tmpkey) / this.sumrows;
            this.chisquareval += Math.pow(observ - expect, 2.0) / expect;
        }
        this.significance = GammaFunct.getGammaQ((double)this.df / 2.0, this.chisquareval / 2.0);
    }

    public int getDf() {
        return this.df;
    }

    public double getValue() {
        return this.chisquareval;
    }

    public double getProb() {
        return this.significance;
    }

    public String toString() {
        return "[ChiSquare:  val= " + this.chisquareval + " df=" + this.df + " sign=" + this.significance + " ]";
    }
}

