/*
 * Decompiled with CFR 0.152.
 */
package agent.learn;

import agent.learn.GammaFunct;

public class BetaFunct {
    static final int MAXIT = 100;
    static final double EPS = 3.0E-20;
    static final double FPMIN = 1.0E-30;

    public static Double betai(double a, double b, double x) {
        if (x < 0.0 || x > 1.0) {
            System.err.println("Error: Bad x in routine betai");
            return null;
        }
        double bt = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(GammaFunct.gammaln(a + b) - GammaFunct.gammaln(a) - GammaFunct.gammaln(b) + a * Math.log(x) + b * Math.log(1.0 - x));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return new Double(bt * BetaFunct.betacf(a, b, x) / a);
        }
        return new Double(1.0 - bt * BetaFunct.betacf(b, a, 1.0 - x) / b);
    }

    public static Double betacf(double a, double b, double x) {
        double qab = a + b;
        double qap = a + 1.0;
        double qam = a - 1.0;
        double c = 1.0;
        double d = 1.0 - qab * x / qap;
        if (Math.abs(d) < 1.0E-30) {
            d = 1.0E-30;
        }
        double h = d = 1.0 / d;
        int m = 1;
        while (m <= 100) {
            int m2 = 2 * m;
            double aa = (double)m * (b - (double)m) * x / ((qam + (double)m2) * (a + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-30) {
                d = 1.0E-30;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-30) {
                c = 1.0E-30;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(a + (double)m) * (qab + (double)m) * x / ((a + (double)m2) * (qap + (double)m2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-30) {
                d = 1.0E-30;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-30) {
                c = 1.0E-30;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < 3.0E-20) break;
            ++m;
        }
        if (m > 100) {
            System.err.println("Error: a or b to big, or MAXIT too small in betacf");
            return null;
        }
        return new Double(h);
    }

    public static Double Student(double t, double v) {
        Double retval = BetaFunct.betai(v / 2.0, 0.5, v / (v + t * t));
        if (retval != null) {
            return new Double(retval);
        }
        return null;
    }

    public static Double InverseStudent(double pvalue, double xtolerance, double ytolerance, double v) {
        double xlow = 0.0;
        double xhigh = 1.0;
        double xlowp = BetaFunct.Student(xlow, v);
        double xhighp = BetaFunct.Student(xhigh, v);
        double pabortlow = pvalue - pvalue * (ytolerance / 2.0);
        double paborthigh = pvalue + pvalue * (ytolerance / 2.0);
        while (xhighp > pvalue) {
            xlow = xhigh;
            xlowp = xhighp;
            xhighp = BetaFunct.Student(xhigh *= 10.0, v);
        }
        double xdiff = Math.abs(xhigh - xlow);
        double xmid = (xhigh + xlow) / 2.0;
        double xmidp = BetaFunct.Student(xmid, v);
        while (!(!(xdiff > xtolerance) || xmidp < paborthigh && xmidp > pabortlow)) {
            xmid = (xhigh + xlow) / 2.0;
            xmidp = BetaFunct.Student(xmid, v);
            xdiff = Math.abs(xhigh - xlow);
            if (pvalue < xmidp) {
                xlow = xmid;
                xlowp = xmidp;
                continue;
            }
            xhigh = xmid;
            xhighp = xmidp;
        }
        return new Double(xmid);
    }
}

