/*
 * Decompiled with CFR 0.152.
 */
package agent.home;

import agent.base.AgentComponent;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Communicate;
import agent.simplest.Execute;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import utilities.KQMLMessage;

public class SimpleProblemSolver
extends AgentComponent
implements MessageEventListener,
PropertyEventListener,
ActionEventListener {
    static final long serialVersionUID = 1234567890L;
    protected Communicate communicate;
    protected State state;
    protected Log log;
    protected Execute execute;
    protected int FAC_PS;

    public SimpleProblemSolver() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Execute");
        State.addParameterInfo((String)"Example", (String)"String", (String)"An example parameter addition.  Customize this to add a real parameter.");
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.execute = (Execute)State.findComponent((String)"Execute");
        this.FAC_PS = this.log.getFacilityID("ProblemSolver");
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.execute.addActionEventListener((ActionEventListener)this);
        this.log.log("Problem solver initialized", 3, this.FAC_PS);
    }

    public void begin() {
        this.log.log("Problem solver beginning", 3, this.FAC_PS);
    }

    public void pulse() {
        this.log.log("Problem solver got pulse", 4, this.FAC_PS);
    }

    public void end() {
        this.log.log("Problem solver ending", 3, this.FAC_PS);
    }

    public void reset() {
        this.log.log("Problem solver reset", 3, this.FAC_PS);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("tell")) {
            String cw = m.contentWord();
            String cd = m.contentData();
            if (cw.equals("ExampleMessage")) {
                // empty if block
            }
        }
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals("ExampleProperty")) {
            Object object = e.getProperty();
        }
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        Action action = e.getAction();
    }
}

