/*
 * Decompiled with CFR 0.152.
 */
package agent.home;

import agent.home.BasicProblemSolver;
import agent.mass.SimpleTaemsReader;
import agent.mass.TaemsAction;
import agent.simplest.ActionEvent;
import agent.simplest.PropertyEvent;
import agent.simplest.State;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Method;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;

public class RandomProblemSolver
extends BasicProblemSolver {
    protected FileWriter datafile;
    protected SimpleTaemsReader reader;

    public void begin() {
        this.reader = (SimpleTaemsReader)State.findComponent((String)"Reader");
        String filename = (String)this.state.getProperty((Object)"Name");
        if (filename == null) {
            filename = "default";
        }
        this.log.log("Using " + filename + ".dat ", 1);
        try {
            this.datafile = new FileWriter(filename + ".dat");
        }
        catch (IOException e) {
            this.log.log("error can't open this file " + filename + ".dat ", 1);
        }
    }

    public void end() {
        if (this.datafile != null) {
            try {
                this.datafile.close();
            }
            catch (IOException e) {
                this.log.log("error can't close this file ", 1);
            }
        }
    }

    public void pulse() {
        String print;
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (this.coordinateQueue != null && this.coordinateQueue.size() != 0) {
            this.callFSMCoordinate(this.coordinateQueue);
            this.coordinateQueue.removeAllElements();
        }
        if (this.schedule != null && this.schedule.size() > 0) {
            Enumeration e = this.conditioned.getFirstSchedule().getElements();
            print = "";
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                print = print + "[" + schElement.getStart() + " - " + schElement.getLabel();
                print = this.checkCoordinationOk(schElement) ? print + " (GREEN)" : print + " (NOT GOOD)";
                print = print + " - " + schElement.getFinish() + "] ";
            }
            this.log.log(print, 2, this.FAC_PS);
            ScheduleElement se = this.conditioned.getFirstSchedule().getNextTask(time);
            this.log.log("Next task : " + se, 2, this.FAC_PS);
            if (se != null && time == se.getStart() - 1 && !this.checkCoordinationOk(se)) {
                this.log.log("Coordination not finished, I couldn't delay the task", 0, this.FAC_PS);
            }
        }
        if (this.schedule == null && !this.execute.isExecuting() || this.reset) {
            this.reset = false;
            this.invokeScheduler(false);
        }
        if (this.schedule != null && this.schedule.size() == 0) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            print = " Q Total\t";
            String result = "  " + this.conditioned.getNode().getCurrentQuality() + "\t";
            Enumeration e = this.conditioned.getFirstSchedule().getElements();
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                print = print + schElement.getLabel() + "\t";
                result = result + schElement.getMethod().getCurrentQuality() + "\t";
            }
            try {
                this.datafile.write(print + "\n");
                this.datafile.write(result + "\n");
                this.datafile.flush();
            }
            catch (IOException ie) {
                // empty catch block
            }
            this.reader.makeAllStructures();
        }
    }

    public boolean invokeScheduler(boolean rescheduling) {
        this.conditioned = (Taems)this.state.getProperty((Object)"ConTaemsTask");
        Vector scheduleList = this.scheduler.scheduleTaems(this.conditioned, rescheduling);
        if (scheduleList != null) {
            this.scheduleNumber = 0;
            this.conditioned.setScheduleVector(scheduleList);
            int time = (Integer)this.state.getProperty((Object)"Time") + 2 * this.TIMEOUT + 1;
            this.schedule = null;
            Schedule s = this.conditioned.getFirstSchedule();
            this.log.log("Setting schedule start time to " + time, 2, this.FAC_PS);
            s.setStartTime(time);
            this.schedule = new Vector();
            String print = "invokeScheduler: ";
            Enumeration e = this.conditioned.getFirstSchedule().getElements();
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                this.schedule.addElement(schElement.getLabel());
                print = print + "[" + schElement.getStart() + " - " + schElement.getLabel() + " - " + schElement.getFinish() + "] ";
            }
            this.log.log(print, 2, this.FAC_PS);
            this.coordinationOverSchedule = new Hashtable();
            this.callFSMCoordinate(this.generateCommitment(this.conditioned));
            this.log.log("Coordination Done", 2, this.FAC_PS);
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("ConTaemsTask")) {
            this.log.log("Argh! NEW  Task structure received", 2, this.FAC_PS);
            this.reset();
        }
    }

    public void actionCompleted(ActionEvent e) {
        TaemsAction a = (TaemsAction)e.getAction();
        Method m = a.getMethod();
        if (m.getCurrentQuality() == 0.0f) {
            this.log.log("Argh! The method " + m.getLabel() + " didnt get enough quality :(.  I must reschedule.", 0, this.FAC_PS);
            if (!this.reset && this.schedule != null) {
                this.schedule.removeElementAt(0);
            }
        } else if (!this.reset && this.schedule != null) {
            this.schedule.removeElementAt(0);
        }
    }
}

