/*
 * Decompiled with CFR 0.152.
 */
package agent.home;

import agent.mass.PreprocessTaemsReader;
import agent.mass.State;
import agent.simplest.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Commitment;
import taems.Node;
import taems.Taems;
import taems.Task;

public class Planner {
    protected PreprocessTaemsReader ppTaemsReader;
    protected Log log;
    protected State state;
    protected Hashtable preConditions;
    int FAC_PS;
    protected int ID_number = 0;

    public Planner(Log localLog, int localFAC_PS, State localState, PreprocessTaemsReader localPpTaemsReader) {
        this.log = localLog;
        this.state = localState;
        this.FAC_PS = localFAC_PS;
        this.ppTaemsReader = localPpTaemsReader;
    }

    public void setPreConditions(Hashtable pre) {
        this.preConditions = pre;
    }

    public boolean testCommitmentCompliance(Task plan, Commitment commit) {
        boolean isPlanValid = true;
        Enumeration planPreConditions = plan.getAttributes();
        while (planPreConditions.hasMoreElements() && isPlanValid) {
            Object preCondName = planPreConditions.nextElement();
            if (!((String)preCondName).substring(0, 4).equalsIgnoreCase("COM_")) continue;
            String param = ((String)preCondName).substring(4);
            this.log.log("....Testing commitment requirement : " + param, 0, this.FAC_PS);
            if (param.equals("minimum_qual")) {
                float requiredFValue = commit.getMinimumQuality();
                float actualFValue = ((Float)plan.getAttribute(preCondName)).floatValue();
                if (actualFValue < requiredFValue) {
                    this.log.log("-----> invalid : quality " + actualFValue + " (needed " + requiredFValue + ")", 0, this.FAC_PS);
                    isPlanValid = false;
                }
            }
            if (!param.equals("duration")) continue;
            int requiredValue = commit.getDeadline();
            int actualValue = (Integer)plan.getAttribute(preCondName);
            if (actualValue <= requiredValue) continue;
            this.log.log("-----> invalid : duration " + actualValue + " (needed " + requiredValue + ")", 0, this.FAC_PS);
            isPlanValid = false;
        }
        if (isPlanValid) {
            this.log.log("-----> valid", 0, this.FAC_PS);
        } else {
            this.log.log("-----> invalid", 0, this.FAC_PS);
        }
        return isPlanValid;
    }

    public boolean testPreConditionCompliance(Task plan) {
        boolean isPlanValid = true;
        Enumeration planPreConditions = plan.getAttributes();
        while (planPreConditions.hasMoreElements() && isPlanValid) {
            Object preCondName = planPreConditions.nextElement();
            if (((String)preCondName).substring(0, 4).equalsIgnoreCase("COM_")) continue;
            this.log.log("....Testing precond : " + (String)preCondName, 0, this.FAC_PS);
            if (!this.preConditions.containsKey(preCondName)) {
                isPlanValid = false;
            }
            if (!this.preConditions.containsKey(preCondName)) continue;
            int requiredValue = (Integer)plan.getAttribute(preCondName);
            int actualValue = (Integer)this.preConditions.get(preCondName);
            if (actualValue >= requiredValue) continue;
            isPlanValid = false;
            this.log.log("-----> invalid : " + preCondName + " " + actualValue + " (needed " + requiredValue + ")", 0, this.FAC_PS);
        }
        if (isPlanValid) {
            this.log.log("-----> valid", 0, this.FAC_PS);
        } else {
            this.log.log("-----> invalid", 0, this.FAC_PS);
        }
        return isPlanValid;
    }

    public Vector getValidPlans(Taems planStructure) {
        Vector<Task> listValidPlans = new Vector<Task>();
        Enumeration possiblePlans = planStructure.findNodes((Node)new Task());
        Enumeration commitments = planStructure.getCommitments();
        if (!commitments.hasMoreElements()) {
            this.log.log("Error in call of getValidPlans : no commitment specified", 0, this.FAC_PS);
            return listValidPlans;
        }
        Commitment commit = (Commitment)commitments.nextElement();
        while (possiblePlans.hasMoreElements()) {
            boolean isPlanValid = true;
            Task plan = (Task)possiblePlans.nextElement();
            this.log.log("Testing validity of plan : " + plan.getLabel(), 0, this.FAC_PS);
            if (plan.hasSubtasks()) {
                isPlanValid = false;
            }
            if (!this.testCommitmentCompliance(plan, commit)) {
                isPlanValid = false;
            }
            if (!this.testPreConditionCompliance(plan)) {
                isPlanValid = false;
            }
            if (isPlanValid) {
                this.log.log("Plan " + plan.getLabel() + " is valid", 3, this.FAC_PS);
                listValidPlans.addElement(plan);
                continue;
            }
            this.log.log("Plan " + plan.getLabel() + " is not valid", 3, this.FAC_PS);
        }
        return listValidPlans;
    }

    public Vector getBestPlans(Vector listPlans) {
        Task bestPlan = new Task();
        Vector<Task> listBestPlans = new Vector<Task>();
        boolean isNewBestPlan = false;
        float quality = 0.0f;
        int cost = 1000;
        int duration = 1000;
        float best_quality = 0.0f;
        int best_cost = 1000;
        int best_duration = 1000;
        this.log.log("Sorting plans", 4, this.FAC_PS);
        Enumeration validPlans = listPlans.elements();
        while (validPlans.hasMoreElements()) {
            isNewBestPlan = false;
            Task plan = (Task)validPlans.nextElement();
            if (plan.hasAttribute((Object)"COM_minimum_qual")) {
                quality = ((Float)plan.getAttribute((Object)"COM_minimum_qual")).intValue();
            }
            if (plan.hasAttribute((Object)"COM_cost")) {
                cost = (Integer)plan.getAttribute((Object)"COM_cost");
            }
            if (plan.hasAttribute((Object)"COM_duration")) {
                duration = (Integer)plan.getAttribute((Object)"COM_duration");
            }
            if (quality > best_quality) {
                isNewBestPlan = true;
            }
            if (!isNewBestPlan) continue;
            this.log.log("Plan " + plan.getLabel() + " is new Best Plan", 5, this.FAC_PS);
            bestPlan = plan;
            best_quality = quality;
            best_cost = cost;
            best_duration = duration;
        }
        this.log.log("Best Plan : " + bestPlan.getLabel(), 4, this.FAC_PS);
        listBestPlans.addElement(bestPlan);
        return listBestPlans;
    }

    public void idTaems(Taems plan, int ID) {
        Enumeration allNodes = plan.getAllNodes();
        while (allNodes.hasMoreElements()) {
            Node element = (Node)allNodes.nextElement();
            element.setLabel(element.getLabel() + "_" + ID);
        }
    }

    public Taems planTaems(Taems planStructure) {
        Taems result = new Taems();
        ++this.ID_number;
        Vector listValidPlans = this.getValidPlans(planStructure);
        Vector listBestPlans = this.getBestPlans(listValidPlans);
        String Label = ((Task)listBestPlans.firstElement()).getLabel();
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("Label", Label);
        ht.put("View", "Conditional");
        result = this.ppTaemsReader.makeTaemsStructure(ht);
        this.idTaems(result, this.ID_number);
        this.log.log("Planner returning TAEMS structure : " + result.toString(), 3, this.FAC_PS);
        return result;
    }
}

