/*
 * Decompiled with CFR 0.152.
 */
package agent.home;

import agent.mass.Communicate;
import agent.mass.Execute;
import agent.mass.ProblemSolver;
import agent.mass.State;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.Sensor;
import java.io.OutputStream;
import taems.Taems;
import taems.parser.ReadTTaems;
import utilities.KQMLMessage;
import utilities.Message;

public class LocaleTestProblemSolver
extends ProblemSolver {
    static final long serialVersionUID = 1234567890L;
    Sensor sensor;
    protected int FAC_PS;
    Action some_action = new Action("Some-Action");

    public LocaleTestProblemSolver() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Execute");
    }

    public void init() {
        this.log = (Log)agent.simplest.State.findComponent((String)"Log");
        this.state = (State)agent.simplest.State.findComponent((String)"State");
        this.communicate = (Communicate)agent.simplest.State.findComponent((String)"Communicate");
        this.execute = (Execute)agent.simplest.State.findComponent((String)"Execute");
        this.sensor = (Sensor)agent.simplest.State.findComponent((String)"Sensor");
        this.FAC_PS = this.log.getFacilityID("ProblemSolver");
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.execute.addActionEventListener((ActionEventListener)this);
        this.log.log("Problem solver initialized", 3, this.FAC_PS);
    }

    public void begin() {
        this.log.log("Problem solver beginning", 3, this.FAC_PS);
        Taems t = new ReadTTaems(new utilities.Log((OutputStream)System.out)).readTTaems("localetest.ttaems");
        KQMLMessage m = new KQMLMessage("tell", (Object)("(TextualTaems " + t.toString() + ")"), "simulator");
        this.communicate.sendMessage((Message)m);
    }

    public void pulse() {
        this.log.log("Problem solver got pulse", 4, this.FAC_PS);
        this.log.log("Problem solver did action, now doing sensing...", 4, this.FAC_PS);
        this.log.log("Getting temperature for the current locale: " + (String)this.sensor.readSensorData("Temp", "String"), 4, this.FAC_PS);
    }

    public void end() {
        this.log.log("Problem solver ending", 3, this.FAC_PS);
    }

    public void reset() {
        this.log.log("Problem solver reset", 3, this.FAC_PS);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("tell")) {
            String cw = m.contentWord();
            String cd = m.contentData();
            if (cw.equals("ExampleMessage")) {
                // empty if block
            }
        }
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals("ExampleProperty")) {
            Object object = e.getProperty();
        }
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        Action action = e.getAction();
    }
}

