/*
 * Decompiled with CFR 0.152.
 */
package agent.home;

import agent.mass.Communicate;
import agent.mass.Execute;
import agent.mass.ProblemSolver;
import agent.mass.SimpleTaemsReader;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.ActionEventListener;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.Sensor;
import agent.simplest.State;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Taems;
import utilities.Distribution;
import utilities.KQMLMessage;

public class FanProblemSolver
extends ProblemSolver {
    static final long serialVersionUID = 1234567890L;
    protected int FAC_PS;
    protected Sensor sensor;
    boolean fan_start = false;
    int downshift = 0;
    SimpleTaemsReader str;
    Action speed_low = new Action("Fan-Speed-Low");
    Action speed_medium = new Action("Fan-Speed-Medium");
    Action speed_high = new Action("Fan-Speed-High");

    public FanProblemSolver() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        this.addDependency("Execute");
        this.addDependency("Sensor");
        this.addDependency("SimpleTaemsReader");
        State.addParameterInfo((String)"Example", (String)"String", (String)"An example parameter addition.  Customize this to add a real parameter.");
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (agent.mass.State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.execute = (Execute)State.findComponent((String)"Execute");
        this.str = (SimpleTaemsReader)State.findComponent((String)"SimpleTaemsReader");
        super.init();
        this.FAC_PS = this.log.getFacilityID("ProblemSolver");
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
        this.execute.addActionEventListener((ActionEventListener)this);
        this.log.log("Problem solver initialized", 3, this.FAC_PS);
        this.sensor = (Sensor)State.findComponent((String)"Sensor");
    }

    public void begin() {
        this.log.log("Problem solver beginning", 3, this.FAC_PS);
    }

    public void pulse() {
        float Temp = this.getTempStatus();
        this.log.log("fan_start: " + new Boolean(this.fan_start).toString(), 0);
        if (!this.fan_start) {
            if (Temp > 70.0f && this.downshift == 0) {
                this.fan_start = true;
                Taems mo = this.str.makeObjectiveStructure(false);
                Method e = (Method)mo.findNode((Node)new Method("Fan-Speed-High", null));
                e.removeAllOutcomes();
                e.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 70.0f) / 1.2 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
                this.str.handleNewObjectiveStructure(mo, true);
                mo = this.str.makeSubjectiveStructure(false);
                e = (Method)mo.findNode((Node)new Method("Fan-Speed-High", null));
                e.removeAllOutcomes();
                e.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 70.0f) / 1.2 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
                this.execute.executeAction(new Action("Fan-Speed-High"));
            } else if (Temp > 60.0f && this.downshift < 2) {
                this.fan_start = true;
                Taems mo = this.str.makeObjectiveStructure(false);
                Method e = (Method)mo.findNode((Node)new Method("Fan-Speed-Medium", null));
                e.removeAllOutcomes();
                e.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 60.0f) / 0.6 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
                this.str.handleNewObjectiveStructure(mo, true);
                mo = this.str.makeSubjectiveStructure(false);
                e = (Method)mo.findNode((Node)new Method("Fan-Speed-Medium", null));
                e.removeAllOutcomes();
                e.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 60.0f) / 0.6 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
                this.execute.executeAction(new Action("Fan-Speed-Medium"));
            } else if (Temp > 50.0f && this.downshift < 3) {
                this.fan_start = true;
                Taems mo = this.str.makeObjectiveStructure(false);
                Method e = (Method)mo.findNode((Node)new Method("Fan-Speed-Low", null));
                e.removeAllOutcomes();
                e.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 50.0f) / 0.3 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
                this.str.handleNewObjectiveStructure(mo, true);
                mo = this.str.makeSubjectiveStructure(false);
                e = (Method)mo.findNode((Node)new Method("Fan-Speed-Low", null));
                e.removeAllOutcomes();
                e.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 50.0f) / 0.3 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
                this.execute.executeAction(new Action("Fan-Speed-Low"));
            }
        }
    }

    public void end() {
        this.log.log("Problem solver ending", 3, this.FAC_PS);
    }

    public void reset() {
        this.log.log("Problem solver reset", 3, this.FAC_PS);
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        if (e.getConnection().getType() != 1) {
            return;
        }
        KQMLMessage m = (KQMLMessage)e.getMessage();
        String perf = m.getPerformative();
        if (perf.equalsIgnoreCase("tell")) {
            String cw = m.contentWord();
            String cd = m.contentData();
            if (cw.equals("ExampleMessage")) {
                // empty if block
            }
        }
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals("ExampleProperty")) {
            Object object = e.getProperty();
        }
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
    }

    public void actionCompleted(ActionEvent e) {
        Action a = e.getAction();
        float Temp = this.getTempStatus();
        this.log.log("Action quality " + Float.toString(a.getQuality()), 0);
        if ((double)a.getQuality() == 0.0) {
            ++this.downshift;
        }
        this.log.log("Downshift " + Integer.toString(this.downshift), 0);
        if (Temp > 70.0f && this.downshift == 0) {
            this.fan_start = true;
            Taems mo = this.str.makeObjectiveStructure(false);
            Method m = (Method)mo.findNode((Node)new Method("Fan-Speed-High", null));
            m.removeAllOutcomes();
            m.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 70.0f) / 1.2 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
            this.str.handleNewObjectiveStructure(mo, true);
            mo = this.str.makeSubjectiveStructure(false);
            m = (Method)mo.findNode((Node)new Method("Fan-Speed-High", null));
            m.removeAllOutcomes();
            m.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 70.0f) / 1.2 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
            this.execute.executeAction(new Action("Fan-Speed-High"));
        } else if (Temp > 60.0f && this.downshift < 3) {
            this.fan_start = true;
            Taems mo = this.str.makeObjectiveStructure(false);
            Method m = (Method)mo.findNode((Node)new Method("Fan-Speed-Medium", null));
            m.removeAllOutcomes();
            m.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 60.0f) / 0.6 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
            this.str.handleNewObjectiveStructure(mo, true);
            mo = this.str.makeSubjectiveStructure(true);
            m = (Method)mo.findNode((Node)new Method("Fan-Speed-Medium", null));
            m.removeAllOutcomes();
            m.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 60.0f) / 0.6 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
            this.execute.executeAction(new Action("Fan-Speed-Medium"));
        } else if (Temp > 50.0f && this.downshift < 5) {
            this.fan_start = true;
            Taems mo = this.str.makeObjectiveStructure(false);
            Method m = (Method)mo.findNode((Node)new Method("Fan-Speed-Low", null));
            m.removeAllOutcomes();
            m.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 50.0f) / 0.3 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
            this.str.handleNewObjectiveStructure(mo, true);
            mo = this.str.makeSubjectiveStructure(false);
            m = (Method)mo.findNode((Node)new Method("Fan-Speed-Low", null));
            m.removeAllOutcomes();
            m.addOutcome(new Outcome("o1", new Distribution(10.0, 1.0), new Distribution((double)(Temp - 50.0f) / 0.3 + 1.0, 1.0), new Distribution(0.0, 1.0), 1.0f));
            this.execute.executeAction(new Action("Fan-Speed-Low"));
        } else {
            this.fan_start = false;
            --this.downshift;
        }
    }

    private float getTempStatus() {
        if (this.sensor != null) {
            Float result = (Float)this.sensor.readSensorData("Temp", "Float");
            if (result != null) {
                return result.floatValue();
            }
            this.log.log("Error: Error reading room temperature sensor data", 0);
        } else {
            this.log.log("Error: Cannot read temp level sensor; Sensor component not available", 0);
        }
        return -1.0f;
    }

    private float getElectricityStatus() {
        if (this.sensor != null) {
            Float result = (Float)this.sensor.readSensorData("Electricity", "Float");
            if (result != null) {
                return result.floatValue();
            }
            this.log.log("Error: Error reading electricity sensor data", 0);
        } else {
            this.log.log("Error: Cannot read Electricity level sensor; Sensor component not available", 0);
        }
        return -1.0f;
    }
}

