/*
 * Decompiled with CFR 0.152.
 */
package agent.home;

import agent.mass.ProblemSolver;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.MessageEvent;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.ConsumableResource;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.ProducesInterrelationship;
import taems.Taems;
import utilities.KQMLMessage;
import utilities.Message;
import utilities.SafeEnumeration;

public class CoordinateProblemSolver
extends ProblemSolver {
    protected String waterheater = null;
    protected static final int TIMEOUT = 5;
    protected static final int MAXELECT = 15;
    protected static final int MAXNOISE = 120;
    private Taems subjective;
    protected boolean alreadyRequested = false;
    protected boolean hasMethodToRun = false;
    protected Random r;
    private Vector commitments;
    private Vector requested;
    protected Boolean coordinate = new Boolean(true);
    protected int numberOfMethods = 0;

    public CoordinateProblemSolver() {
        State.addParameterInfo((String)"MaxNoise", (String)"Float", (String)"The maximum level of Noise");
        State.addParameterInfo((String)"MaxElectricity", (String)"Float", (String)"The maximum level of Electricity");
        State.addParameterInfo((String)"Coordinate", (String)"Boolean", (String)"To coordinate or not");
    }

    public void init() {
        super.init();
        this.commitments = new Vector(20);
        this.requested = new Vector(20);
        this.subjective = null;
        System.err.println("Coordination agent Version 2.0");
        if (this.state != null) {
            this.state.setProperty((Object)"MaxNoise", (Object)new Float(120.0f));
        }
        if (this.state != null) {
            this.state.setProperty((Object)"MaxElectricity", (Object)new Float(15.0f));
        }
        if (this.state != null) {
            this.state.setProperty((Object)"SetTaemsName", (Object)new Boolean(true));
            this.state.setProperty((Object)"UpdateDist", (Object)new Boolean(false));
            this.state.setProperty((Object)"AutoExecute", (Object)new Boolean(false));
        }
    }

    public void actionAborted(ActionEvent e) {
        Action a = e.getAction();
        long ID = a.getID();
        Execution E = this.findbyID(this.commitments, "" + ID);
        this.log.log("Cancellation/Abort for this method " + ID, 2, this.FAC_PS);
        if (E != null && E != null) {
            this.log.log("Removing this execution  " + ID, 2, this.FAC_PS);
            this.commitments.removeElement(E);
        }
    }

    public void pulse() {
        Enumeration e;
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (this.r == null) {
            long seed = (Long)this.state.getProperty((Object)"RandomSeed");
            this.log.log("Seeding the Random Generator with " + seed, 5, this.FAC_PS);
            this.r = new Random(seed);
        }
        this.alreadyRequested = this.commitments.size() + this.requested.size() < 5;
        this.log.log("Do I need to request something (" + this.alreadyRequested + ")", 5, this.FAC_PS);
        if (!this.hasMethodToRun && this.state.getProperty((Object)"ConTaemsTask") != null) {
            this.subjective = (Taems)this.state.getProperty((Object)"ConTaemsTask");
            this.numberOfMethods = 0;
            e = this.subjective.findNodes((Node)new Method());
            while (e.hasMoreElements()) {
                ++this.numberOfMethods;
                e.nextElement();
            }
            if (this.numberOfMethods != 0) {
                this.hasMethodToRun = true;
            }
        }
        this.log.log("Found " + this.numberOfMethods + " methods in the TAEMS Structure", 5, this.FAC_PS);
        if (this.requested.size() > 0) {
            e = new SafeEnumeration(this.requested.elements());
            while (e.hasMoreElements()) {
                Execution E = (Execution)e.nextElement();
                if (E.checkTimeout(time)) {
                    this.log.log("Still Waiting an answer to this request " + E.getMethod().getLabel(), 5, this.FAC_PS);
                    continue;
                }
                this.log.log("Timeout expired check Conflict for  " + E.getMethod().getLabel(), 5, this.FAC_PS);
                Enumeration e1 = E.getCommitments();
                while (e1.hasMoreElements()) {
                    Commitment com = (Commitment)e1.nextElement();
                    if (com.getResource().equals("HotWater")) {
                        if (this.waterheater != null) {
                            this.waterheater = null;
                        }
                        this.log.log("No answer, we assume centralized protocol for Hotwater, broadcasting next time", 5, this.FAC_PS);
                        this.requested.removeElement(E);
                        continue;
                    }
                    this.checkConflict(E);
                    this.requested.removeElement(E);
                }
            }
        }
        if (this.commitments.size() > 0) {
            e = this.commitments.elements();
            while (e.hasMoreElements()) {
                Execution E = (Execution)e.nextElement();
                if (time == E.getCommitment().getEarliestStartTime()) {
                    Method m = E.getMethod();
                    TaemsAction a = new TaemsAction(m);
                    a = new TaemsAction(m);
                    a.setID(E.getCommitment().getID());
                    this.log.log("I should run " + m.getLabel() + " (" + a.getID() + ")", 5, this.FAC_PS);
                    this.log.log((Object)a, 2, this.FAC_PS);
                    E.setAction((Action)a);
                    this.execute.executeAction(E.a);
                }
                if (time > E.getCommitment().getEarliestStartTime() && time < E.getCommitment().getTimeSatisfied()) {
                    this.execute.statusAction(E.getAction());
                    this.log.log("Status Report: Quality=" + E.getAction().getData((Object)"Quality") + " Cost=" + E.getAction().getData((Object)"Cost") + " Time=" + E.getAction().getData((Object)"Time"), 2, this.FAC_PS);
                }
                if (time >= E.getCommitment().getTimeSatisfied()) {
                    this.log.log("Heee, this commitment  " + E.getAction().getID() + " takes too much time", 2, this.FAC_PS);
                }
                if (time >= E.getCommitment().getEarliestStartTime()) continue;
                this.log.log("Waiting my time window for  this commitment " + E.getCommitment().getID() + " at time : " + E.getCommitment().getEarliestStartTime() + " for " + E.getCommitment().getType(), 2, this.FAC_PS);
            }
        }
        if (this.hasMethodToRun && this.alreadyRequested) {
            this.requestSomething();
        }
    }

    public void kill(String agent) {
        String name = (String)this.state.getProperty((Object)"Name");
        this.state.setProperty((Object)"Name", (Object)"simulator");
        KQMLMessage msg = new KQMLMessage("ask", (Object)"(disconnect)", agent);
        this.communicate.sendMessage((Message)msg);
        this.state.setProperty((Object)"Name", (Object)name);
    }

    public boolean processMsg(KQMLMessage m) {
        StringTokenizer s;
        String perf = m.getPerformative();
        this.log.log((Object)m, 5, this.FAC_PS);
        if (m.contentWord().equalsIgnoreCase("Need")) {
            StringTokenizer s2 = new StringTokenizer(m.contentData());
            String resource = s2.nextToken();
            int priority = Integer.parseInt(s2.nextToken());
            float quantity = Float.valueOf(s2.nextToken()).floatValue();
            s2.nextToken();
            int start = Integer.parseInt(s2.nextToken());
            int duration = Integer.parseInt(s2.nextToken());
            long id = Long.parseLong(s2.nextToken());
            Commitment c = new Commitment("Coordination", resource, new Agent(m.getSourceAddr()), new Agent((String)this.state.getProperty((Object)"Name")), null, priority, 0.0f, start, start + duration, 0);
            c.setID(id);
            c.setQuantity(quantity);
            c.setResource(resource);
            if (resource.equalsIgnoreCase("HotWater")) {
                this.log.log(m.getSourceAddr() + " is requesting water ..", 5, this.FAC_PS);
                this.detectingConflict(c);
            } else if (resource.equalsIgnoreCase("Electricity")) {
                this.log.log(m.getSourceAddr() + " is requesting Electricity ..", 5, this.FAC_PS);
                this.detectingConflict(c);
            } else if (resource.equalsIgnoreCase("Noise")) {
                this.log.log(m.getSourceAddr() + " is requesting Noise ..", 5, this.FAC_PS);
                this.detectingConflict(c);
            }
            return true;
        }
        if (m.contentWord().equalsIgnoreCase("Cancel") || m.contentWord().equalsIgnoreCase("Nullify")) {
            String ID;
            this.log.log("Cancellation received !", 5, this.FAC_PS);
            s = new StringTokenizer(m.contentData());
            String resource = s.nextToken();
            if (m.getField("in-reply-to") != null) {
                ID = m.getField("in-reply-to");
            } else if (m.contentWord().equalsIgnoreCase("Cancel")) {
                ID = s.nextToken();
            } else {
                s.nextToken();
                ID = s.nextToken();
            }
            if (ID != null) {
                Execution E = this.findbyID(this.commitments, ID);
                this.log.log("Yeahh, I try to cancelling " + resource + " (" + ID + ") ...", 5, this.FAC_PS);
                if (E != null && E.c != null) {
                    this.commitments.removeElement(E);
                    this.log.log("Removing my commitment, Grrr", 5, this.FAC_PS);
                    return true;
                }
                this.log.log("This is not my commitment !", 5, this.FAC_PS);
            }
        }
        if (m.contentWord().equalsIgnoreCase("Results")) {
            s = new StringTokenizer(m.contentData());
            String ID = s.nextToken();
            float cost = Float.valueOf(s.nextToken()).floatValue();
            float quality = Float.valueOf(s.nextToken()).floatValue();
            int duration = Integer.parseInt(s.nextToken());
            Execution E = this.findbyID(this.commitments, ID);
            this.log.log("Result from " + m.getSourceAddr() + " for " + ID + "[" + cost + "$, " + quality + ", " + duration + " Clicks]", 5, this.FAC_PS);
            if (E != null && E != null) {
                this.log.log("All done with  " + ID, 2, this.FAC_PS);
                this.commitments.removeElement(E);
                return true;
            }
            this.log.log("What is this ID ? : " + ID, 2, this.FAC_PS);
        }
        if (perf.equalsIgnoreCase("reply") && m.getField("in-reply-to") != null) {
            if (m.getField("in-reply-to").equalsIgnoreCase("Agent")) {
                s = new StringTokenizer(m.contentData());
                while (s.hasMoreTokens()) {
                    String agent = s.nextToken();
                    this.log.log("I know that " + agent + " exists ....", 5, this.FAC_PS);
                    if (!agent.equalsIgnoreCase("WaterHeater")) continue;
                    this.waterheater = agent;
                }
            } else {
                Execution E;
                String ID = m.getField("in-reply-to");
                if (m.contentWord().equalsIgnoreCase("Accept")) {
                    this.log.log("Accept !", 5, this.FAC_PS);
                    E = this.findbyID(this.requested, ID);
                    if (E != null && E.c != null) {
                        this.log.log("Great !! This commitment was accepted " + E.c, 5, this.FAC_PS);
                        this.requested.removeElement(E);
                        this.commitments.addElement(E);
                        if (this.waterheater == null) {
                            this.waterheater = m.getSourceAddr();
                        }
                    }
                } else if (m.contentWord().equalsIgnoreCase("NotAccept")) {
                    this.log.log("NotAccept ", 5, this.FAC_PS);
                    E = this.findbyID(this.requested, ID);
                    if (E != null && E.c != null) {
                        this.log.log("Bad news, this commitment was not accepted " + E.c, 5, this.FAC_PS);
                        this.requested.removeElement(E);
                    }
                } else if (m.contentWord().equalsIgnoreCase("Conflict")) {
                    E = this.findbyID(this.requested, ID);
                    if (E != null && E.c != null) {
                        this.log.log("Conflict, let's check that out " + E.c, 5, this.FAC_PS);
                        StringTokenizer s3 = new StringTokenizer(m.contentData());
                        String resource = s3.nextToken();
                        int priority = Integer.parseInt(s3.nextToken());
                        float quantity = Float.valueOf(s3.nextToken()).floatValue();
                        s3.nextToken();
                        int start = Integer.parseInt(s3.nextToken());
                        int duration = Integer.parseInt(s3.nextToken());
                        long yourID = Long.parseLong(s3.nextToken());
                        Commitment c = new Commitment("Coordination", resource, new Agent(m.getSourceAddr()), new Agent((String)this.state.getProperty((Object)"Name")), null, priority, 0.0f, start, start + duration, 0);
                        c.setQuantity(quantity);
                        c.setResource(resource);
                        c.setID(yourID);
                        E.addConflict(c, ID);
                        return true;
                    }
                } else {
                    if (m.contentWord().equalsIgnoreCase("ExecuteEnd")) {
                        E = this.findbyID(this.commitments, ID);
                        this.log.log("Done with this Execution ", 5, this.FAC_PS);
                        if (E != null && E != null) {
                            this.log.log("All done with  " + ID, 2, this.FAC_PS);
                            this.commitments.removeElement(E);
                            return true;
                        }
                        this.log.log("What is this ID ? : " + ID, 2, this.FAC_PS);
                        return false;
                    }
                    this.log.log("Error, what is this message : " + m, 5, this.FAC_PS);
                    return false;
                }
            }
        }
        return true;
    }

    public void checkConflict(Execution E) {
        Commitment conflict;
        boolean couldRun = true;
        Vector<Commitment> commitmentToBeNullifyed = new Vector<Commitment>();
        Enumeration enumeration = E.getCommitments();
        while (enumeration.hasMoreElements() && couldRun) {
            Commitment C = (Commitment)enumeration.nextElement();
            float myUse = C.getQuantity();
            float totalInUse = 0.0f;
            String resource = C.getResource();
            float maxResource = ((Float)this.state.getProperty((Object)("Max" + resource))).floatValue();
            Vector newList = E.getConflicted(C.getID());
            newList.addElement(C);
            int i = 0;
            while (i < newList.size() - 1) {
                int n = i;
                conflict = (Commitment)newList.elementAt(n);
                int j = i;
                while (j < newList.size()) {
                    if (((Commitment)newList.elementAt(j)).getImportance() < conflict.getImportance()) {
                        n = j;
                        conflict = (Commitment)newList.elementAt(n);
                    }
                    ++j;
                }
                if (i != n) {
                    newList.setElementAt(newList.elementAt(i), n);
                    newList.setElementAt(conflict, i);
                }
                ++i;
            }
            boolean commitmentAccepted = false;
            boolean noConflictDetected = true;
            int numberToDelete = 0;
            Enumeration e = newList.elements();
            while (e.hasMoreElements()) {
                conflict = (Commitment)e.nextElement();
                if (totalInUse + conflict.getQuantity() <= maxResource) {
                    totalInUse += conflict.getQuantity();
                    ++numberToDelete;
                    if (conflict.getID() != C.getID()) continue;
                    commitmentAccepted = true;
                    continue;
                }
                this.log.log("Conflict detected, nullifying lower priorities", 5, this.FAC_PS);
                noConflictDetected = false;
                break;
            }
            if (noConflictDetected) {
                this.log.log("NO Conflict detected, all can run !!", 5, this.FAC_PS);
                this.log.log("Maximum usage resources used: " + totalInUse + " with " + newList.size() + " conflicting checked", 5, this.FAC_PS);
                continue;
            }
            int i2 = numberToDelete;
            while (i2 < newList.size()) {
                conflict = (Commitment)newList.elementAt(i2);
                if (!commitmentAccepted && conflict.getID() == C.getID()) {
                    couldRun = false;
                } else {
                    conflict.setImportance(((Commitment)newList.elementAt(numberToDelete - 1)).getImportance());
                    commitmentToBeNullifyed.addElement(conflict);
                }
                ++i2;
            }
        }
        if (couldRun) {
            this.commitments.addElement(E);
            Enumeration e = commitmentToBeNullifyed.elements();
            while (e.hasMoreElements()) {
                conflict = (Commitment)e.nextElement();
                KQMLMessage reply = new KQMLMessage("ask", (Object)("( Nullify " + conflict.getResource() + " " + conflict.getImportance() + " " + E.getCommitment().getID() + " " + conflict.getID() + ")"), conflict.getToAgent().getLabel());
                this.communicate.sendMessage((Message)reply);
            }
        }
    }

    public void detectingConflict(Commitment C) {
        int Cstart = C.getEarliestStartTime();
        int Cend = C.getTimeSatisfied();
        this.log.log(" Looking for Conflict..", 5, this.FAC_PS);
        Enumeration e = this.commitments.elements();
        while (e.hasMoreElements()) {
            int Estart;
            int Eend;
            Execution E = (Execution)e.nextElement();
            if (E.c == null || !E.getCommitment().getResource().equals(C.getResource()) || Cstart >= (Eend = (Estart = E.getCommitment().getEarliestStartTime()) + E.getCommitment().getTimeSatisfied()) || Cend <= Estart) continue;
            this.log.log(" -----------> Detecting Conflict..", 5, this.FAC_PS);
            KQMLMessage reply = new KQMLMessage("reply", (Object)("( Conflict " + E.getCommitment().getResource() + " " + E.getCommitment().getImportance() + " " + E.getCommitment().getQuantity() + " -1 " + E.getCommitment().getEarliestStartTime() + " " + E.getCommitment().getTimeSatisfied() + " " + E.getCommitment().getID() + " " + C.getID() + ")"), C.getToAgent().getLabel());
            reply.addField("reply-with", String.valueOf(C.getID()));
            this.communicate.sendMessage((Message)reply);
        }
    }

    public Execution findbyID(Vector v, String ID) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Execution E = (Execution)e.nextElement();
            if (E.a != null && ID.equals(String.valueOf(E.getAction().getID()))) {
                return E;
            }
            Enumeration e1 = E.getCommitments();
            while (e1.hasMoreElements()) {
                Commitment c = (Commitment)e1.nextElement();
                if (!ID.equals(String.valueOf(c.getID()))) continue;
                return E;
            }
        }
        return null;
    }

    public void requestSomething() {
        Integer time = (Integer)this.state.getProperty((Object)"Time");
        Vector resourceToCoordinate = new Vector();
        this.log.log("Requesting something .... ", 5, this.FAC_PS);
        String dest = "*";
        Float f = new Float((float)this.numberOfMethods * this.r.nextFloat());
        int REQUESTED = f.intValue();
        Enumeration e = this.subjective.findNodes((Node)new Method());
        int i = 0;
        while (i < REQUESTED) {
            ++i;
            e.nextElement();
        }
        Method m = (Method)e.nextElement();
        int timeout = 5;
        int request = -1;
        int starttime = time + timeout * 2;
        Outcome outcome = m.getGlobalOutcome();
        int dur = (int)outcome.getDuration().calculateAvg();
        this.log.log(" Requesting  " + m.getLabel() + " for  " + dur + " clicks ", 5, this.FAC_PS);
        f = new Float(20.0f * this.r.nextFloat());
        int prio = f.intValue();
        if (m.isNonLocal()) {
            Vector<Method> v = new Vector<Method>();
            v.addElement(m);
            Commitment cm = new Commitment("ContractNet", m.getLabel(), new Agent("*"), m.getAgent(), v, prio, outcome.getQuality().calculateAvg(), starttime, time + timeout, dur + starttime);
            cm.setResource("NonLocal");
            cm.setID(State.getRandom().nextLong());
        } else {
            Commitment cm;
            e = m.getAffectedInterrelationships();
            Execution exec = new Execution(m);
            boolean atLeastOneNLE = false;
            while (e.hasMoreElements()) {
                Interrelationship rel = (Interrelationship)e.nextElement();
                if (!(rel instanceof ProducesInterrelationship) && !(rel instanceof ConsumesInterrelationship) || rel instanceof ProducesInterrelationship && rel.getTo() instanceof ConsumableResource) continue;
                Vector<Method> v = new Vector<Method>();
                v.addElement(m);
                cm = new Commitment("Resource", m.getLabel(), new Agent(rel.getFrom().getLabel()), new Agent(rel.getTo().getLabel()), v, prio, 0.0f, starttime, time + timeout, starttime + dur);
                cm.setResource(rel.getTo().getLabel());
                cm.setQuantity(rel.getCost().calculateAvg());
                cm.setID(State.getRandom().nextLong());
                exec.addCommitment(cm);
                atLeastOneNLE = true;
                this.coordinate = (Boolean)this.state.getProperty((Object)"Coordinate");
                if (this.coordinate != null && !this.coordinate.booleanValue()) continue;
                KQMLMessage reply = new KQMLMessage("ask", (Object)("( Need " + rel.getTo().getLabel() + " " + prio + " " + rel.getCost().calculateAvg() + " -1 " + starttime + " " + dur + " " + String.valueOf(cm.getID()) + ")"), dest);
                reply.addField("reply-with", String.valueOf(cm.getID()));
                this.communicate.sendMessage((Message)reply);
            }
            if (atLeastOneNLE) {
                this.requested.addElement(exec);
            } else {
                Vector<Method> v = new Vector<Method>();
                v.addElement(m);
                cm = new Commitment("NOP", m.getLabel(), m.getAgent(), m.getAgent(), v, prio, 0.0f, starttime, time + timeout, starttime + dur);
                cm.setResource("none");
                cm.setQuantity(0.0f);
                cm.setID(State.getRandom().nextLong());
                exec.addCommitment(cm);
                this.commitments.addElement(exec);
            }
        }
    }

    public void messageReceived(MessageEvent me) {
        if (me.getConnection().getType() != 1) {
            super.messageReceived(me);
            return;
        }
        KQMLMessage m = (KQMLMessage)me.getMessage();
        if (m.getDestAddr().equalsIgnoreCase((String)this.state.getProperty((Object)"Name")) || m.getDestAddr().equalsIgnoreCase("*")) {
            if (!this.processMsg(m)) {
                super.messageReceived(me);
            } else {
                super.messageReceived(me);
            }
        }
    }

    class Execution {
        public Vector c;
        public Action a;
        public Hashtable conflicted = new Hashtable();
        public Method m;

        public Execution() {
            this.c = new Vector(20);
        }

        public Execution(Method method) {
            this();
            this.m = method;
        }

        public Execution(Method method, Commitment com) {
            this(method);
            this.c.addElement(com);
            this.conflicted.put(String.valueOf(com.getID()), new Vector());
        }

        public void addCommitment(Commitment com) {
            this.c.addElement(com);
            this.conflicted.put(String.valueOf(com.getID()), new Vector());
        }

        public Enumeration getCommitments() {
            return this.c.elements();
        }

        public Commitment getCommitment() {
            return (Commitment)this.c.firstElement();
        }

        public int getNumberOfCommitment() {
            return this.c.size();
        }

        public void setAction(Action act) {
            this.a = act;
        }

        public Action getAction() {
            return this.a;
        }

        public void setMethod(Method method) {
            this.m = method;
        }

        public Method getMethod() {
            return this.m;
        }

        public void addConflict(Commitment com) {
            this.addConflict(com, this.getCommitment().getID());
        }

        public void removeConflict(Commitment com) {
            this.removeConflict(com, String.valueOf(this.getCommitment().getID()));
        }

        public void addConflict(Commitment c, String ID) {
            Vector v = this.conflicted.containsKey(ID) ? (Vector)this.conflicted.get(ID) : new Vector();
            v.addElement(c);
            this.conflicted.put(ID, v);
        }

        public Vector getConflicted(String ID) {
            return (Vector)this.conflicted.get(ID);
        }

        public Vector getConflicted(long ID) {
            return this.getConflicted(String.valueOf(ID));
        }

        public void removeConflict(Commitment c, String ID) {
            if (this.conflicted.containsKey(ID)) {
                Vector v = (Vector)this.conflicted.get(ID);
                v.removeElement(c);
                this.conflicted.put(ID, v);
            }
        }

        public void addConflict(Commitment c, long ID) {
            this.addConflict(c, String.valueOf(ID));
        }

        public Commitment findConflictbyID(String ID) {
            Enumeration e1 = this.conflicted.keys();
            while (true) {
                Vector v = (Vector)this.conflicted.get((String)e1.nextElement());
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    Commitment C = (Commitment)e.nextElement();
                    if (C == null || !ID.equals(String.valueOf(C.getID()))) continue;
                    return C;
                }
                e1.hasMoreElements();
            }
        }

        public boolean checkTimeout(int time) {
            if (this.c != null) {
                return ((Commitment)this.c.firstElement()).getDeadline() > time;
            }
            return false;
        }
    }
}

