/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2X;

import agent.gpgp2.GPGPEvent;
import agent.mass.SimpleTaemsReader;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import taems.MLCSchedule;
import taems.Method;
import taems.Taems;
import taems.TaskBase;

public class GPGPController
extends agent.gpgp2.GPGPController {
    protected boolean loadNew = false;
    FileWriter resultsFile = null;

    public void pulse() {
        MLCSchedule mlcs;
        if (this.loadNew) {
            this.loadNew = false;
            this.log.log("GPGPController.pulse: loading new struc", 2, this.FAC_PS);
        }
        if ((mlcs = (MLCSchedule)this.getCurSchedule()) == null) {
            this.log.log("GPGPController.pulse: Schedule in state is null !", 1, this.FAC_PS);
        }
        Enumeration negActions = this.negMechActions.elements();
        while (negActions.hasMoreElements()) {
            TaemsAction a = (TaemsAction)negActions.nextElement();
            int elapsed = a.getTime();
            a.setTime(++elapsed);
        }
        this.nlmActions.clear();
    }

    private void cleanUp(TaemsAction a) {
        Taems cond = this.getCondTaemsOf((TaskBase)new Method(a.getMethod().getLabel(), a.getMethod().getAgent()));
        if (cond == null) {
            this.log.log("GPGPController.cleanUp: struc of method " + a.getMethod().getLabel() + " not found", 1, this.FAC_PS);
            return;
        }
        Enumeration curActionsEnum = this.execute.actions();
        while (curActionsEnum.hasMoreElements()) {
            TaemsAction act = (TaemsAction)curActionsEnum.nextElement();
            this.execute.completeAction((Action)act);
        }
        Hashtable ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
        ht.remove(cond.getLabel());
        this.state.setProperty((Object)SimpleTaemsReader.CONTAEMS, (Object)ht, (Object)"rescheduling");
        MLCSchedule mlcs = (MLCSchedule)this.getCurSchedule();
        if (mlcs != null) {
            this.log.log("GPGPController.cleanUp: sched after cleanup " + mlcs.toString(), 2, this.FAC_PS);
        }
        this.loadNew = true;
    }

    private void writeResults(GPGPEvent ge) {
        String resultsString = ge.getResults();
        if (resultsString != null) {
            try {
                this.resultsFile = new FileWriter("NegResults", true);
                this.resultsFile.write(resultsString + "\n");
                this.resultsFile.close();
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_PS);
            }
        }
    }

    protected void processNegAborted(GPGPEvent ge) {
        String negMethName = ge.getSourceName();
        TaemsAction a = (TaemsAction)this.negMechActions.get(negMethName);
        if (a != null) {
            this.negMechActions.remove(a.getName());
            Long CID = (Long)this.negMechActionCIDs.get(a.getName());
            this.negMechActionCIDs.remove(a.getName());
            this.negMechCIDActions.remove(CID);
            a.setQuality(0.0f);
            this.execute.completeAction((Action)a);
            this.cleanUp(a);
            this.writeResults(ge);
            ge = null;
            System.gc();
            this.log.log("GPGPController.processNegAborted: GPGP mech " + negMethName + " aborted", 2, this.FAC_PS);
        } else {
            this.log.log("GPGPController.processNegAborted: negMethName " + negMethName + " unknown !", 1, this.FAC_PS);
        }
    }

    protected void processNegRejected(GPGPEvent ge) {
        String negMethName = ge.getSourceName();
        TaemsAction a = (TaemsAction)this.negMechActions.get(negMethName);
        if (a == null) {
            this.log.log("GPGPController.processNegRejected: negMethName " + negMethName + " unknown !", 1, this.FAC_PS);
            return;
        }
        this.negMechActions.remove(a.getName());
        Long CID = (Long)this.negMechActionCIDs.get(a.getName());
        this.negMechActionCIDs.remove(a.getName());
        this.negMechCIDActions.remove(CID);
        a.setQuality(0.0f);
        this.execute.completeAction((Action)a);
        this.cleanUp(a);
        this.writeResults(ge);
        ge = null;
        System.gc();
        this.log.log("GPGPController.processMechAborted: negotiation by GPGP mech " + negMethName + " failed", 2, this.FAC_PS);
    }
}

