/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.coordinate.CoordinateEvent;
import agent.home.BasicProblemSolver;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.Criteria;
import taems.EnablesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.QAF;
import taems.Schedule;
import taems.ScheduleElement;
import taems.SeqMaxQAF;
import taems.SeqMinQAF;
import taems.SeqSumQAF;
import taems.Taems;
import taems.Task;
import taems.TaskBase;
import utilities.Distribution;

public class TEnableProblemSolver
extends BasicProblemSolver {
    public void init() {
        super.init();
    }

    public Vector generateCommitment(Taems t) {
        Vector<CoordinateEvent> commitments = new Vector<CoordinateEvent>();
        Schedule s = t.getFirstSchedule();
        Enumeration enumOfNLE = t.findNodes((Node)new EnablesInterrelationship());
        float constraintValue = 0.0f;
        while (enumOfNLE.hasMoreElements()) {
            EnablesInterrelationship NLE = (EnablesInterrelationship)enumOfNLE.nextElement();
            Enumeration e = s.getElements();
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                Method m = schElement.getMethod();
                if (!NLE.getTo().getLabel().equals(m.getLabel())) continue;
                String typeOfProtocol = "";
                Taems ta = new Taems();
                Vector<Node> v = new Vector<Node>();
                int intDL = schElement.getStart();
                float expectedQuality = this.getSimpleQuality(s);
                Criteria crit = t.getScheduleCriteria();
                float qualityGain = (expectedQuality - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
                float costGain = (crit.getCostThreshold().floatValue() - s.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
                float durationGain = (crit.getDurationThreshold().floatValue() - s.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
                float utility = expectedQuality;
                this.log.log("generateCommitment: utility is " + utility, 2, this.FAC_PS);
                Task taskM = m.firstSupertask();
                QAF qafTaskM = taskM.getQAF();
                if (qafTaskM instanceof SeqMaxQAF || qafTaskM instanceof SeqMinQAF || qafTaskM instanceof SeqSumQAF) {
                    constraintValue = 0.0f;
                } else {
                    ScheduleElement schedEl2;
                    int time = (Integer)this.state.getProperty((Object)"Time");
                    int dlTaskM = taskM.getDeadline();
                    int durationTaskM = dlTaskM - time;
                    this.log.log("generateCommitment: current time is " + time, 2, this.FAC_PS);
                    this.log.log("generateCommitment: deadline of Task " + taskM.getLabel() + " is " + dlTaskM, 2, this.FAC_PS);
                    this.log.log("generateCommitment: duration of Task " + taskM.getLabel() + " is " + durationTaskM, 2, this.FAC_PS);
                    Enumeration subtasks = taskM.getSubtasks();
                    Vector<ScheduleElement> subtaskSchedEls = new Vector<ScheduleElement>();
                    while (subtasks.hasMoreElements()) {
                        Node node = (Node)subtasks.nextElement();
                        if (!(node instanceof Method)) continue;
                        Enumeration enumSchEl = s.getElements();
                        while (enumSchEl.hasMoreElements()) {
                            ScheduleElement schEl = (ScheduleElement)enumSchEl.nextElement();
                            Method schedMeth = schEl.getMethod();
                            if (!schedMeth.getLabel().equals(node.getLabel())) continue;
                            subtaskSchedEls.addElement(schEl);
                        }
                    }
                    Enumeration affectingIRs = m.getAffectingInterrelationships();
                    Vector<ScheduleElement> subtaskSchedElBefore = new Vector<ScheduleElement>();
                    while (affectingIRs.hasMoreElements()) {
                        Interrelationship inter = (Interrelationship)affectingIRs.nextElement();
                        if (!(inter instanceof EnablesInterrelationship)) continue;
                        Enumeration enumSubSchedEls = subtaskSchedEls.elements();
                        while (enumSubSchedEls.hasMoreElements()) {
                            String methIRName;
                            ScheduleElement schedEl = (ScheduleElement)enumSubSchedEls.nextElement();
                            String methName = schedEl.getMethod().getLabel();
                            if (inter.getFrom() == null) {
                                this.log.log("TEnableProblemSolver.generateComm: no from node specified in enables !!", 0, this.FAC_PS);
                                System.exit(0);
                            }
                            if (!methName.equals(methIRName = inter.getFrom().getLabel())) continue;
                            subtaskSchedElBefore.addElement(schedEl);
                        }
                    }
                    Enumeration affectedIRs = m.getAffectedInterrelationships();
                    Vector<ScheduleElement> subtaskSchedElAfter = new Vector<ScheduleElement>();
                    while (affectedIRs.hasMoreElements()) {
                        Interrelationship inter = (Interrelationship)affectedIRs.nextElement();
                        if (!(inter instanceof EnablesInterrelationship)) continue;
                        Enumeration enumSubSchedEls = subtaskSchedEls.elements();
                        while (enumSubSchedEls.hasMoreElements()) {
                            String methIRName;
                            ScheduleElement schedEl1 = (ScheduleElement)enumSubSchedEls.nextElement();
                            String methName = schedEl1.getMethod().getLabel();
                            if (inter.getTo() == null) {
                                this.log.log("TEnableProblemSolver.generateComm: no from node specified in enables !!", 0, this.FAC_PS);
                                System.exit(0);
                            }
                            if (!methName.equals(methIRName = inter.getTo().getLabel())) continue;
                            subtaskSchedElAfter.addElement(schedEl1);
                        }
                    }
                    Enumeration enumBefore = subtaskSchedElBefore.elements();
                    Enumeration enumAfter = subtaskSchedElAfter.elements();
                    while (enumBefore.hasMoreElements()) {
                        schedEl2 = (ScheduleElement)enumBefore.nextElement();
                        constraintValue += (float)schedEl2.getDuration();
                    }
                    while (enumAfter.hasMoreElements()) {
                        schedEl2 = (ScheduleElement)enumAfter.nextElement();
                        constraintValue += (float)schedEl2.getDuration();
                    }
                    this.log.log("generateCommitment: duration of affected and affecting methods is " + constraintValue, 2, this.FAC_PS);
                    this.log.log("generateCommitment: duration of method " + m.getLabel() + " is " + schElement.getDuration(), 2, this.FAC_PS);
                    constraintValue = (float)durationTaskM - constraintValue - (float)schElement.getDuration();
                    this.log.log("generateCommitment: constraint Value = " + constraintValue, 2, this.FAC_PS);
                }
                long CID = State.getRandom().nextLong();
                v.addElement(NLE.getFrom());
                this.log.log("About to create commitment", 0, this.FAC_PS);
                Commitment com = new Commitment("TSE", "deadline", NLE.getAgent(), NLE.getTo().getAgent(), v, 1, expectedQuality, -1, intDL, -1);
                this.log.log("Commitment created", 0, this.FAC_PS);
                if (NLE.getCost() == null) {
                    this.log.log("NLE Cost is null!", 0, this.FAC_PS);
                } else {
                    com.setQuantity(NLE.getCost().calculateMax());
                }
                com.setID(CID);
                com.setAttribute((Object)"constraintValue", (Object)new Float(constraintValue));
                com.setAttribute((Object)"sourceMethodName", (Object)NLE.getFrom().getLabel());
                com.setAttribute((Object)"destMethodName", (Object)NLE.getTo().getLabel());
                com.setAttribute((Object)"utility", (Object)new Float(utility));
                ta.addCommitment(com);
                if (NLE.getTo().getAgent() != null) {
                    this.log.log("Creating TSEnablesIni evt", 0, this.FAC_PS);
                    typeOfProtocol = "TSEnablesIni";
                    this.log.log("Using Three Shot Enables for " + NLE.getTo().getLabel() + " (" + NLE.getTo().getAgent().getLabel() + ")", 2, this.FAC_PS);
                    CoordinateEvent ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                    commitments.addElement(ce);
                    ce.setCoordinateID(CID);
                    this.addCoordinateEvent(schElement, ce);
                    this.log.log("Single Shot Comm created", 0, this.FAC_PS);
                    continue;
                }
                typeOfProtocol = "new_dsharp_request";
                this.log.log("Using DSharp for " + NLE.getTo().getLabel(), 2, this.FAC_PS);
            }
        }
        this.log.log("Coordinating over " + commitments.size() + " NLEs", 2, this.FAC_PS);
        return commitments;
    }

    public void processAccepted(CoordinateEvent ce) {
        Taems t = ce.getTaems();
        this.log.log("processAccepted: taems struc created", 2, this.FAC_PS);
        Commitment com = t.getCommitment();
        this.log.log("processAccepted: comm created", 2, this.FAC_PS);
        if (this.conditioned == null) {
            this.log.log("processAccepted: conditioned is null!!", 0, this.FAC_PS);
        } else {
            this.conditioned.addCommitment(com);
        }
    }

    public void processRejectedFrmResp(CoordinateEvent ce) {
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        Taems taemsAux = (Taems)this.conditioned.clone();
        taemsAux.setScheduleVector(new Vector());
        Method dummy = new Method();
        dummy.setLabel((String)com.getAttribute((Object)"destMethodName"));
        Method destMeth = (Method)taemsAux.findNode((Node)dummy);
        Enumeration affectingIRs = destMeth.getAffectingInterrelationships();
        while (affectingIRs.hasMoreElements()) {
            Interrelationship inter = (Interrelationship)affectingIRs.nextElement();
            inter.excise();
        }
        Enumeration affectedIRs = destMeth.getAffectedInterrelationships();
        while (affectedIRs.hasMoreElements()) {
            Interrelationship inter = (Interrelationship)affectedIRs.nextElement();
            inter.excise();
        }
        Task taskM = destMeth.firstSupertask();
        taskM.removeSubtask((TaskBase)destMeth);
        taemsAux.removeNode((Node)destMeth);
        Taems tSx = this.evaluateTaems(taemsAux, true);
        if (tSx == null) {
            this.log.log("processRejectedFrmResp: tSx is null!!", 0, this.FAC_PS);
        } else {
            this.conditioned = tSx;
        }
    }

    public void processAcceptedFrmIni(CoordinateEvent ce) {
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        Taems taemsAux2 = null;
        Schedule s = null;
        String sourceMethodName = (String)com.getAttribute((Object)"sourceMethodName");
        Vector schedules = this.conditioned.getScheduleVector();
        if (schedules == null) {
            this.log.log("processEvalTSE: conditioned schedule vector null !", 0, this.FAC_PS);
            System.exit(0);
        }
        boolean found = false;
        ScheduleElement schElement = null;
        int i = 0;
        while (i < schedules.size()) {
            s = (Schedule)schedules.elementAt(i);
            Enumeration schedEls = s.getElements();
            while (schedEls.hasMoreElements()) {
                ScheduleElement schEl = (ScheduleElement)schedEls.nextElement();
                if (schEl.getMethod().getLabel().equals(sourceMethodName)) {
                    schElement = schEl;
                    found = true;
                }
                if (found) break;
            }
            if (found) break;
            ++i;
        }
        if (!found) {
            Taems taemsAux = (Taems)this.conditioned.clone();
            taemsAux.addCommitment(com);
            taemsAux.setScheduleVector(new Vector());
            Method commMeth = new Method();
            commMeth.setLabel("CommMeth" + com.getLabel());
            Outcome outc = new Outcome("outc" + com.getLabel());
            outc.setDuration(new Distribution(0.0f, 1.0f));
            outc.setQuality(new Distribution(com.getMinimumQuality(), 1.0f));
            outc.setCost(new Distribution(0.0f, 1.0f));
            commMeth.addOutcome(outc);
            Method dummy2 = new Method();
            dummy2.setLabel(sourceMethodName);
            Method sourceMeth = (Method)taemsAux.findNode((Node)dummy2);
            Task taskM = sourceMeth.firstSupertask();
            taskM.addSubtask((TaskBase)commMeth);
            EnablesInterrelationship enables = new EnablesInterrelationship();
            enables.setLabel("enable" + com.getLabel());
            enables.setCost(new Distribution(0.0f, 1.0f));
            enables.setDelay(new Distribution(0.0f, 1.0f));
            enables.setDuration(new Distribution(0.0f, 1.0f));
            sourceMeth.addInterrelationship((Interrelationship)enables, (Node)commMeth);
            taemsAux2 = this.evaluateTaems(taemsAux, true);
            if (taemsAux2 == null) {
                this.log.log("processAcceptedFrmIni: taemsAux2 is null!!", 0, this.FAC_PS);
            } else {
                this.conditioned = taemsAux2;
            }
        } else {
            schedules.insertElementAt(s, 0);
            this.conditioned.setScheduleVector(schedules);
        }
    }

    public void processEvalTSE(CoordinateEvent ce) {
        Vector schedules;
        boolean accept = false;
        this.log.log("Processing the " + ce.getType() + " event.", 3);
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        Taems taemsAux2 = null;
        Method m = null;
        Schedule s = null;
        if (!com.hasAttribute((Object)"sourceMethodName")) {
            this.log.log("processEvalTSE: no sourceMethodName attribute!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Reject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        if (!com.hasAttribute((Object)"constraintValue")) {
            this.log.log("processEvalTSE: no constraintValue attribute!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Reject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        if (!com.hasAttribute((Object)"utility")) {
            this.log.log("processEvalTSE: no utility attribute!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Reject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        String sourceMethodName = (String)com.getAttribute((Object)"sourceMethodName");
        float constraintValueIni = ((Float)com.getAttribute((Object)"constraintValue")).floatValue();
        this.log.log("processEvalTSE: constraint value of initiator = " + constraintValueIni, 2, this.FAC_PS);
        this.log.log("processEvalTSE: source method name is " + sourceMethodName, 2, this.FAC_PS);
        Method dummy = new Method();
        dummy.setLabel(sourceMethodName);
        m = (Method)this.conditioned.findNode((Node)dummy);
        if (m == null) {
            this.log.log("processEvalTSE: method with name " + sourceMethodName + " not found in taems structure !", 0, this.FAC_PS);
            System.exit(0);
        }
        if ((schedules = this.conditioned.getScheduleVector()) == null) {
            this.log.log("processEvalTSE: conditioned schedule vector null !", 0, this.FAC_PS);
            System.exit(0);
        }
        boolean found = false;
        ScheduleElement schElement = null;
        if (!found) {
            Taems taemsAux = (Taems)this.conditioned.clone();
            taemsAux.setScheduleVector(new Vector());
            Method commMeth = new Method();
            commMeth.setLabel("CommMeth" + com.getLabel());
            Outcome outc = new Outcome("outc" + com.getLabel());
            outc.setDuration(new Distribution(0.0f, 1.0f));
            outc.setQuality(new Distribution(com.getMinimumQuality(), 1.0f));
            outc.setCost(new Distribution(0.0f, 1.0f));
            commMeth.addOutcome(outc);
            Method dummy2 = new Method();
            dummy2.setLabel(sourceMethodName);
            Method sourceMeth = (Method)taemsAux.findNode((Node)dummy2);
            Task taskM = taemsAux.getNode();
            this.log.log("processEvalTSE: root task is " + taskM.getLabel(), 2, this.FAC_PS);
            taskM.addSubtask((TaskBase)commMeth);
            EnablesInterrelationship enables = new EnablesInterrelationship();
            enables.setLabel("enable" + com.getLabel());
            enables.setCost(new Distribution(0.0f, 1.0f));
            enables.setDelay(new Distribution(0.0f, 1.0f));
            enables.setDuration(new Distribution(0.0f, 1.0f));
            enables.setAgent(taskM.getAgent());
            sourceMeth.addInterrelationship((Interrelationship)enables, (Node)commMeth);
            taemsAux2 = this.evaluateTaems(taemsAux, true);
            s = taemsAux2.getFirstSchedule();
            if (s == null) {
                this.log.log("processEvalTSE: commitment rejected - no schedule possible", 2, this.FAC_PS);
                ce.setType("Rejected");
                ce.setID(4096);
                ce.setCoordinateID(com.getID());
                this.startFireEvent(ce);
                return;
            }
            boolean found2 = false;
            Enumeration schedEls = s.getElements();
            while (schedEls.hasMoreElements()) {
                ScheduleElement schEl = (ScheduleElement)schedEls.nextElement();
                if (schEl.getMethod().getLabel().equals(sourceMethodName)) {
                    schElement = schEl;
                    found2 = true;
                }
                if (found2) break;
            }
            if (!found2) {
                this.log.log("processEvalTSE: commitment rejected - best schedule does not have enabler method " + sourceMethodName, 2, this.FAC_PS);
                ce.setType("Rejected");
                ce.setID(4096);
                ce.setCoordinateID(com.getID());
                this.startFireEvent(ce);
                return;
            }
        }
        if (found) {
            this.log.log("processEvalTSE: source method " + schElement.getMethod().getLabel() + " found in a precalculated schedule, its finish time is " + schElement.getFinish(), 2, this.FAC_PS);
        } else {
            this.log.log("processEvalTSE: source method " + schElement.getMethod().getLabel() + " not found in a precalculated schedule, its finish time is " + schElement.getFinish(), 2, this.FAC_PS);
        }
        float constraintValueResp = 0.0f;
        Task taskM = m.firstSupertask();
        QAF qafTaskM = taskM.getQAF();
        if (qafTaskM instanceof SeqMaxQAF || qafTaskM instanceof SeqMinQAF || qafTaskM instanceof SeqSumQAF) {
            constraintValueResp = 1.0f;
        } else {
            ScheduleElement schedEl2;
            int estTaskM = (Integer)this.state.getProperty((Object)"Time");
            int dlTaskM = taskM.getDeadline();
            int durationTaskM = dlTaskM - estTaskM;
            Enumeration subtasks = taskM.getSubtasks();
            Vector<ScheduleElement> subtaskSchedEls = new Vector<ScheduleElement>();
            while (subtasks.hasMoreElements()) {
                Node node = (Node)subtasks.nextElement();
                if (!(node instanceof Method)) continue;
                Enumeration enumSchEl = s.getElements();
                while (enumSchEl.hasMoreElements()) {
                    ScheduleElement schEl = (ScheduleElement)enumSchEl.nextElement();
                    Method schedMeth = schEl.getMethod();
                    if (!schedMeth.getLabel().equals(node.getLabel())) continue;
                    subtaskSchedEls.addElement(schEl);
                }
            }
            Enumeration affectingIRs = m.getAffectingInterrelationships();
            Vector<ScheduleElement> subtaskSchedElBefore = new Vector<ScheduleElement>();
            while (affectingIRs.hasMoreElements()) {
                Interrelationship inter = (Interrelationship)affectingIRs.nextElement();
                if (!(inter instanceof EnablesInterrelationship)) continue;
                Enumeration enumSubSchedEls = subtaskSchedEls.elements();
                while (enumSubSchedEls.hasMoreElements()) {
                    String methIRName;
                    ScheduleElement schedEl = (ScheduleElement)enumSubSchedEls.nextElement();
                    String methName = schedEl.getMethod().getLabel();
                    if (inter.getFrom() == null) {
                        this.log.log("TEnableProblemSolver.generateComm: no from node specified in enables !!", 0, this.FAC_PS);
                        System.exit(0);
                    }
                    if (!methName.equals(methIRName = inter.getFrom().getLabel())) continue;
                    subtaskSchedElBefore.addElement(schedEl);
                }
            }
            Enumeration affectedIRs = m.getAffectedInterrelationships();
            Vector<ScheduleElement> subtaskSchedElAfter = new Vector<ScheduleElement>();
            while (affectedIRs.hasMoreElements()) {
                Interrelationship inter = (Interrelationship)affectedIRs.nextElement();
                if (!(inter instanceof EnablesInterrelationship)) continue;
                Enumeration enumSubSchedEls = subtaskSchedEls.elements();
                while (enumSubSchedEls.hasMoreElements()) {
                    String methIRName;
                    ScheduleElement schedEl1 = (ScheduleElement)enumSubSchedEls.nextElement();
                    String methName = schedEl1.getMethod().getLabel();
                    if (inter.getTo() == null) {
                        this.log.log("TEnableProblemSolver.generateComm: no from node specified in enables !!", 0, this.FAC_PS);
                        System.exit(0);
                    }
                    if (!methName.equals(methIRName = inter.getTo().getLabel())) continue;
                    subtaskSchedElAfter.addElement(schedEl1);
                }
            }
            Enumeration enumBefore = subtaskSchedElBefore.elements();
            Enumeration enumAfter = subtaskSchedElAfter.elements();
            while (enumBefore.hasMoreElements()) {
                schedEl2 = (ScheduleElement)enumBefore.nextElement();
                constraintValueResp += (float)schedEl2.getDuration();
            }
            while (enumAfter.hasMoreElements()) {
                schedEl2 = (ScheduleElement)enumAfter.nextElement();
                constraintValueResp += (float)schedEl2.getDuration();
            }
            this.log.log("processEvalTSE: duration of Task " + taskM.getLabel() + " is " + durationTaskM, 2, this.FAC_PS);
            this.log.log("processEvalTSE: duration of affected and affecting methods is " + constraintValueResp, 2, this.FAC_PS);
            this.log.log("processEvalTSE: duration of method " + m.getLabel() + " is " + schElement.getDuration(), 2, this.FAC_PS);
            constraintValueResp = (float)durationTaskM - constraintValueResp - (float)schElement.getDuration();
            this.log.log("processEvalTSE: constraint value of responder = " + constraintValueResp, 2, this.FAC_PS);
        }
        if (constraintValueResp < constraintValueIni) {
            this.log.log("processEvalTSE: responder is more constrained and hence, leader", 2, this.FAC_PS);
            float expectedQualityComm = this.getSimpleQuality(s);
            this.log.log("processEvalTSE: expectedQualityComm = " + expectedQualityComm, 2, this.FAC_PS);
            Criteria crit = this.conditioned.getScheduleCriteria();
            float qualityGain = (expectedQualityComm - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
            float costGain = (crit.getCostThreshold().floatValue() - s.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
            float durationGain = (crit.getDurationThreshold().floatValue() - s.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
            float utilityComm = expectedQualityComm;
            com.setAttribute((Object)"utility", (Object)new Float(utilityComm));
            com.setDeadline(schElement.getFinish());
            com.setAttribute((Object)"constraintValue", (Object)new Float(constraintValueResp));
            Taems ta = new Taems();
            ta.addCommitment(com);
            ce.setType("Lead");
            ce.setTaems(ta);
            ce.setID(0);
            ce.setCoordinateID(com.getID());
            this.startFireEvent(ce);
        } else {
            Schedule schedS = this.conditioned.getFirstSchedule();
            float expectedQualityNoComm = this.getSimpleQuality(schedS);
            this.log.log("processTSEComm: expectedQualityNoComm = " + expectedQualityNoComm, 2, this.FAC_PS);
            Criteria crit = this.conditioned.getScheduleCriteria();
            float qualityGain = (expectedQualityNoComm - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
            float costGain = (crit.getCostThreshold().floatValue() - schedS.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
            float durationGain = (crit.getDurationThreshold().floatValue() - schedS.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
            float utilityNoComm = expectedQualityNoComm;
            float expectedQualityComm = this.getSimpleQuality(s);
            this.log.log("processEvalTSE: expectedQualityComm = " + expectedQualityComm, 2, this.FAC_PS);
            qualityGain = (expectedQualityComm - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
            costGain = (crit.getCostThreshold().floatValue() - s.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
            durationGain = (crit.getDurationThreshold().floatValue() - s.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
            float utilityComm = expectedQualityComm;
            float otherUtility = ((Float)com.getAttribute((Object)"utility")).floatValue();
            this.log.log("processEvalTSE: other agent's utility = " + otherUtility, 2, this.FAC_PS);
            this.log.log("processEvalTSE: this agent's utility with comm = " + utilityComm, 2, this.FAC_PS);
            this.log.log("processEvalTSE: this agent's utility without comm = " + utilityNoComm, 2, this.FAC_PS);
            if (utilityComm > utilityNoComm) {
                this.log.log("processEvalTSE: commitment accepted", 2, this.FAC_PS);
                if (found) {
                    schedules.insertElementAt(s, 0);
                } else if (taemsAux2 == null) {
                    this.log.log("processEvalTSE: taemsAux2 is null!!", 0, this.FAC_PS);
                } else {
                    this.conditioned = taemsAux2;
                }
                ce.setType("Accepted");
                ce.setID(1);
                this.handleAcceptation(ce);
            } else {
                this.log.log("processEvalTSE: commitment rejected", 2, this.FAC_PS);
                ce.setType("Rejected");
                ce.setID(4096);
            }
            ce.setCoordinateID(com.getID());
            this.startFireEvent(ce);
        }
    }

    public void processEvalTSE2(CoordinateEvent ce) {
        this.log.log("Processing the " + ce.getType() + " event.", 3);
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        if (!com.hasAttribute((Object)"destMethodName")) {
            this.log.log("processEvalTSE2: no sourceMethodName attribute!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Reject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        if (!com.hasAttribute((Object)"utility")) {
            this.log.log("processEvalTSE2: no utility attribute!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Reject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        Taems taemsAux2 = (Taems)this.conditioned.clone();
        taemsAux2.setScheduleVector(new Vector());
        Method dummy = new Method();
        dummy.setLabel((String)com.getAttribute((Object)"destMethodName"));
        Method destMeth2 = (Method)taemsAux2.findNode((Node)dummy);
        this.log.log("processEvalTSE2: method " + destMeth2.getLabel() + " about to be removed", 2, this.FAC_PS);
        Enumeration affectingIRs = destMeth2.getAffectingInterrelationships();
        while (affectingIRs.hasMoreElements()) {
            Interrelationship inter = (Interrelationship)affectingIRs.nextElement();
            inter.excise();
            this.log.log("processEvalTSE2: removing interrelationship " + inter.getLabel(), 2, this.FAC_PS);
            taemsAux2.removeNode((Node)inter);
        }
        Enumeration affectedIRs = destMeth2.getAffectedInterrelationships();
        while (affectedIRs.hasMoreElements()) {
            Interrelationship inter = (Interrelationship)affectedIRs.nextElement();
            inter.excise();
            this.log.log("processEvalTSE2: removing interrelationship " + inter.getLabel(), 2, this.FAC_PS);
            taemsAux2.removeNode((Node)inter);
        }
        Task taskM = destMeth2.firstSupertask();
        taskM.removeSubtask((TaskBase)destMeth2);
        taemsAux2.removeNode((Node)destMeth2);
        this.log.log("processEvalTSE2: about to evaluate struc without commitment", 2, this.FAC_PS);
        Taems tSx = this.evaluateTaems(taemsAux2, true);
        Schedule schedS = tSx.getFirstSchedule();
        if (schedS == null) {
            this.log.log("processEvalTSE2: no schedule returned !", 2, this.FAC_PS);
            System.exit(0);
        }
        float expectedQualityNoComm = this.getSimpleQuality(schedS);
        this.log.log("processEvalTSE2: expectedQualityNoComm = " + expectedQualityNoComm, 2, this.FAC_PS);
        Criteria crit = this.conditioned.getScheduleCriteria();
        float qualityGain = (expectedQualityNoComm - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
        float costGain = (crit.getCostThreshold().floatValue() - schedS.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
        float durationGain = (crit.getDurationThreshold().floatValue() - schedS.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
        float utilityNoComm = expectedQualityNoComm;
        Taems taemsAux = (Taems)this.conditioned.clone();
        taemsAux.setScheduleVector(new Vector());
        Method destMeth = (Method)taemsAux.findNode((Node)dummy);
        this.log.log("processEvalTSE2: EST of " + destMeth.getLabel() + " is set to " + com.getDeadline(), 2, this.FAC_PS);
        destMeth.setEarliestStartTime(com.getDeadline());
        this.log.log("processEvalTSE2: about to evaluate struc with commitment", 2, this.FAC_PS);
        Taems tSy = this.evaluateTaems(taemsAux, true);
        Schedule schedSy = tSy.getFirstSchedule();
        float expectedQualityComm = 0.0f;
        if (schedSy == null) {
            this.log.log("processEvalTSE2: no schedule possible", 2, this.FAC_PS);
            ce.setType("Rejected");
            ce.setID(4096);
            ce.setCoordinateID(com.getID());
            this.startFireEvent(ce);
            return;
        }
        Distribution dSy = schedSy.getQuality();
        this.log.log("processEvalTSE2: quality distribution w/ comm = " + dSy, 2, this.FAC_PS);
        if (dSy == null) {
            this.log.log("processEvalTSE2: no quality distribution!", 0, this.FAC_PS);
            this.log.log("processEvalTSE2: no schedule possible", 2, this.FAC_PS);
            ce.setType("Rejected");
            ce.setID(4096);
            ce.setCoordinateID(com.getID());
            this.startFireEvent(ce);
            return;
        }
        expectedQualityComm = this.getSimpleQuality(schedSy);
        this.log.log("processEvalTSE2: evaluated struc with commitment", 2, this.FAC_PS);
        this.log.log("processEvalTSE2: expectedQualityComm = " + expectedQualityComm, 2, this.FAC_PS);
        qualityGain = (expectedQualityComm - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
        costGain = (crit.getCostThreshold().floatValue() - schedSy.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
        durationGain = (crit.getDurationThreshold().floatValue() - schedSy.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
        float utilityComm = expectedQualityComm;
        float otherUtility = ((Float)com.getAttribute((Object)"utility")).floatValue();
        this.log.log("processEvalTSE2: other agent's utility = " + otherUtility, 2, this.FAC_PS);
        this.log.log("processEvalTSE2: this agent's utility with comm = " + utilityComm, 2, this.FAC_PS);
        this.log.log("processEvalTSE2: this agent's utility without comm = " + utilityNoComm, 2, this.FAC_PS);
        if (utilityComm > utilityNoComm) {
            this.log.log("processEvalTSE2: commitment accepted", 2, this.FAC_PS);
            if (tSy == null) {
                this.log.log("processEvalTSE2: tSy is null!", 0, this.FAC_PS);
            } else {
                this.conditioned = tSy;
            }
            ce.setType("Accepted");
            ce.setID(1);
            this.handleAcceptation(ce);
        } else {
            this.log.log("processEvalTSE2: commitment rejected", 2, this.FAC_PS);
            if (tSx == null) {
                this.log.log("processEvalTSE2: tSx is null!", 0, this.FAC_PS);
            } else {
                this.conditioned = tSx;
            }
            ce.setType("Rejected");
            ce.setID(4096);
        }
        ce.setCoordinateID(com.getID());
        this.startFireEvent(ce);
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 2, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                this.handleRejection(e);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                this.handleAcceptation(e);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
        boolean typeFound = false;
        if (e.getType().equals("EvalTSE")) {
            this.log.log("commitmentEventReceived type EvalTSE" + e.getID(), 2, this.FAC_PS);
            this.processEvalTSE(e);
            typeFound = true;
        }
        if (e.getType().equals("EvalTSE2")) {
            this.log.log("commitmentEventReceived type EvalTSE2" + e.getID(), 2, this.FAC_PS);
            this.processEvalTSE2(e);
            typeFound = true;
        }
        if (e.getType().equals("Accepted")) {
            this.log.log("commitmentEventReceived type Accepted" + e.getID(), 2, this.FAC_PS);
            this.processAccepted(e);
            typeFound = true;
        }
        if (e.getType().equals("RejectedFrmResp")) {
            this.log.log("commitmentEventReceived type RejectedFrmResp" + e.getID(), 2, this.FAC_PS);
            this.processRejectedFrmResp(e);
            typeFound = true;
        }
        if (e.getType().equals("AcceptedFrmIni")) {
            this.log.log("commitmentEventReceived type AcceptedFrmIni" + e.getID(), 2, this.FAC_PS);
            this.processAcceptedFrmIni(e);
            typeFound = true;
        }
        if (!typeFound) {
            this.log.log("commitmentEventReceived type Unknown: " + e.getID(), 2, this.FAC_PS);
        }
    }

    private float getSimpleQuality(Schedule s) {
        float quality = 0.0f;
        Enumeration e = s.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement schElement = (ScheduleElement)e.nextElement();
            Method m = schElement.getMethod();
            Outcome outc = (Outcome)m.getOutcomes().nextElement();
            Distribution qual = outc.getQuality();
            quality += qual.calculateAvg();
        }
        return quality;
    }
}

