/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.coordinate.CoordinateEvent;
import agent.home.BasicProblemSolver;
import agent.simplest.State;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.Method;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;

public class TA1ProblemSolver
extends BasicProblemSolver {
    public void init() {
        super.init();
    }

    public Vector generateCommitment(Taems t) {
        long CID;
        Commitment c;
        Vector<CoordinateEvent> commitments = new Vector<CoordinateEvent>();
        Schedule s = t.getFirstSchedule();
        Method m = null;
        Enumeration e = s.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement schElement = (ScheduleElement)e.nextElement();
            m = schElement.getMethod();
            if (m.isNonLocal()) break;
        }
        Vector<String> possible_agents = new Vector<String>();
        Vector<Method> v = new Vector<Method>();
        v.addElement(m);
        if (((String)this.state.getProperty((Object)"Name")).equals("TA1_Agent") && (Integer)this.state.getProperty((Object)"Time") == 2) {
            this.log.log(((Component)((Object)this)).getName() + " sending Need message", 1, this.FAC_PS);
            possible_agents.addElement("TA2_Agent");
            c = new Commitment("NiceJob", "TA", t.getAgent(), m.getAgent(), v, 0, 0.0f, 0, 0, -1);
            c.setAttribute((Object)"timeout", (Object)new Integer(0));
            c.setAttribute((Object)"cost", (Object)new Float(0.0f));
            c.setAttribute((Object)"nonlocal", (Object)"NiceJob");
            c.setAttribute((Object)"workgroup", possible_agents);
            CID = State.getRandom().nextLong();
            c.setID(CID);
            CoordinateEvent ce = new CoordinateEvent(this, "TaskAssignRequest", 16, t);
            ce.setCoordinateID(CID);
            ce.setType("TaskAssignRequest");
            commitments.addElement(ce);
        }
        if (((String)this.state.getProperty((Object)"Name")).equals("TA2_Agent") && (Integer)this.state.getProperty((Object)"Time") == 3) {
            this.log.log(((Component)((Object)this)).getName() + " sending Need message", 1, this.FAC_PS);
            possible_agents.removeAllElements();
            possible_agents.addElement("TA1_Agent");
            c = new Commitment("GoodJob", "TA", t.getAgent(), m.getAgent(), v, 3, 0.8f, 15, 20, -1);
            c.setAttribute((Object)"timeout", (Object)new Integer(4));
            c.setAttribute((Object)"cost", (Object)new Float(50.0f));
            CID = State.getRandom().nextLong();
            c.setID(CID);
            Taems ta = new Taems();
            ta.addCommitment(c);
            CoordinateEvent ce = new CoordinateEvent(this, "TaskAssignRequest", 16, ta);
            ce.setType("TaskAssignRequest");
            ce.setCoordinateID(CID);
            commitments.addElement(ce);
        }
        this.log.log("Coordinating over " + commitments.size() + " NLEs", 2, this.FAC_PS);
        return commitments;
    }

    public void commitmentAccepted(CoordinateEvent e) {
        this.log.log("Commitment Accepted: " + (Object)((Object)e), 0, this.FAC_PS);
    }

    public void commitmentRejected(CoordinateEvent e) {
        this.log.log("Commitment Rejected: " + (Object)((Object)e), 0, this.FAC_PS);
    }

    public void commitmentCanceled(CoordinateEvent e) {
        this.log.log("Commitment Canceled: " + (Object)((Object)e), 0, this.FAC_PS);
    }

    public void commitmentReceived(CoordinateEvent e) {
        this.log.log("Commitment Recceived: " + (Object)((Object)e), 0, this.FAC_PS);
        Taems t = e.getTaems();
        Commitment c = t.getCommitment();
        CoordinateEvent evt = new CoordinateEvent(this, 16, t);
        evt.setCoordinateID(c.getID());
        if (((String)this.state.getProperty((Object)"Name")).equals("TA1_Agent")) {
            c.setAttribute((Object)"cost", (Object)new Integer(59));
            if (c.getLabel().equalsIgnoreCase("GoodJob")) {
                evt.setType("AcceptContract");
            } else {
                evt.setType("RejectContract");
            }
        } else if (((String)this.state.getProperty((Object)"Name")).equals("TA2_Agent")) {
            c.setAttribute((Object)"cost", (Object)new Integer(19));
            if (c.getLabel().equalsIgnoreCase("NiceJob")) {
                evt.setType("AcceptContract");
            } else {
                evt.setType("RejectContract");
            }
        }
        this.startFireEvent(evt);
    }

    public void commitmentConfirmed(CoordinateEvent e) {
        this.log.log("Commitment Confirmed: " + (Object)((Object)e), 3, this.FAC_PS);
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 2, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
        if (e.getType().equalsIgnoreCase("TaskAssignSuccess")) {
            this.commitmentAccepted(e);
        } else if (e.getType().equalsIgnoreCase("TaskAssignFail")) {
            this.commitmentRejected(e);
        } else if (e.getType().equalsIgnoreCase("GetContract")) {
            this.commitmentReceived(e);
        } else if (e.getType().equalsIgnoreCase("ConfirmBid")) {
            this.commitmentConfirmed(e);
        }
    }
}

