/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.coordinate.CoordinateEvent;
import agent.gpgp2.BasicProblemSolver;
import agent.simplest.State;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.Criteria;
import taems.EnablesInterrelationship;
import taems.FacilitatesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import taems.Task;
import taems.TaskBase;
import utilities.Distribution;

public class SFacilProblemSolver
extends BasicProblemSolver {
    float noCommIniUtility;
    float commIniUtility;
    float origRespUtility;
    float commRespUtility;
    boolean imIni = false;
    int negStartTime = 0;
    FileWriter result;

    public void init() {
        super.init();
    }

    public Vector generateCommitment(Taems t) {
        Vector<CoordinateEvent> commitments = new Vector<CoordinateEvent>();
        Schedule s = t.getFirstSchedule();
        Enumeration enumOfNLE = t.findNodes((Node)new FacilitatesInterrelationship());
        while (enumOfNLE.hasMoreElements()) {
            FacilitatesInterrelationship NLE = (FacilitatesInterrelationship)enumOfNLE.nextElement();
            Enumeration e = s.getElements();
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                Method m = schElement.getMethod();
                if (!NLE.getTo().getLabel().equals(m.getLabel())) continue;
                String typeOfProtocol = "";
                Taems ta = new Taems();
                Vector<Object> v = new Vector<Object>();
                int intDL = schElement.getStart();
                Taems taemsAux = (Taems)this.conditioned.clone();
                taemsAux.setScheduleVector(new Vector());
                Method destMeth = (Method)taemsAux.findNode((Node)m);
                Enumeration affectingIRs = destMeth.getAffectingInterrelationships();
                while (affectingIRs.hasMoreElements()) {
                    Interrelationship inter = (Interrelationship)affectingIRs.nextElement();
                    inter.excise();
                }
                Enumeration affectedIRs = destMeth.getAffectedInterrelationships();
                while (affectedIRs.hasMoreElements()) {
                    Interrelationship inter = (Interrelationship)affectedIRs.nextElement();
                    inter.excise();
                }
                Task taskM = destMeth.firstSupertask();
                taskM.removeSubtask((TaskBase)destMeth);
                taemsAux.removeNode((Node)destMeth);
                Taems tSx = this.evaluateTaems(taemsAux, true);
                float noCommQuality = this.getSimpleQuality(tSx.getFirstSchedule());
                this.noCommIniUtility = this.calcUtility(noCommQuality, tSx.getFirstSchedule());
                this.log.log("generateCommitment: no comm ini quality = " + noCommQuality + " no comm ini utility = " + this.noCommIniUtility, 2, this.FAC_PS);
                float commQuality = this.getSimpleQuality(s);
                this.commIniUtility = this.calcUtility(commQuality, s);
                this.log.log("generateCommitment: comm ini quality = " + commQuality + " comm ini utility = " + this.commIniUtility, 2, this.FAC_PS);
                float marginalQuality = commQuality;
                if (marginalQuality < 0.0f) {
                    this.log.log("generateCommitment: marginal quality is " + marginalQuality + " !", 0, this.FAC_PS);
                    System.exit(0);
                }
                long CID = State.getRandom().nextLong();
                v.addElement(m.clone());
                this.log.log("About to create commitment", 0, this.FAC_PS);
                Commitment com = new Commitment("SSE", "deadline", NLE.getAgent(), NLE.getTo().getAgent(), v, 1, marginalQuality, -1, intDL, -1);
                com.setAttribute((Object)"sourceMethodName", (Object)NLE.getFrom().getLabel());
                com.setAttribute((Object)"destMethodName", (Object)NLE.getTo().getLabel());
                this.imIni = true;
                this.negStartTime = (Integer)this.state.getProperty((Object)"Time");
                this.log.log("Commitment created", 0, this.FAC_PS);
                if (NLE.getCost() == null) {
                    this.log.log("NLE Cost is null!", 0, this.FAC_PS);
                } else {
                    com.setQuantity(NLE.getCost().calculateMax());
                }
                com.setID(CID);
                ta.addCommitment(com);
                if (NLE.getTo().getAgent() != null) {
                    this.log.log("Creating SSEnablesIni evt", 0, this.FAC_PS);
                    typeOfProtocol = "SSEnablesIni";
                    this.log.log("Using Single Shot Enables for " + NLE.getTo().getLabel() + " (" + NLE.getTo().getAgent().getLabel() + ")", 2, this.FAC_PS);
                    CoordinateEvent ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                    commitments.addElement(ce);
                    ce.setCoordinateID(CID);
                    this.addCoordinateEvent(schElement, ce);
                    this.log.log("Single Shot Comm created", 0, this.FAC_PS);
                    continue;
                }
                typeOfProtocol = "new_dsharp_request";
                this.log.log("Using DSharp for " + NLE.getTo().getLabel(), 2, this.FAC_PS);
            }
        }
        this.log.log("Coordinating over " + commitments.size() + " NLEs", 2, this.FAC_PS);
        return commitments;
    }

    public void processAccepted(CoordinateEvent ce) {
        Taems t = ce.getTaems();
        this.log.log("processAccepted: taems struc created", 2, this.FAC_PS);
        Commitment com = t.getCommitment();
        this.origRespUtility = ((Float)com.getAttribute((Object)"origRespUtility")).floatValue();
        this.commRespUtility = ((Float)com.getAttribute((Object)"commRespUtility")).floatValue();
        float combOrigUtility = this.origRespUtility + this.noCommIniUtility;
        float combCommUtility = this.commRespUtility + this.commIniUtility;
        float combMargUtility = combCommUtility - combOrigUtility;
        int negEndTime = (Integer)this.state.getProperty((Object)"Time");
        int negDuration = negEndTime - this.negStartTime;
        this.log.log("processAccepted: combOrigUtility = " + combOrigUtility, 2, this.FAC_PS);
        this.log.log("processAccepted: combCommUtility = " + combCommUtility, 2, this.FAC_PS);
        if (this.imIni) {
            try {
                this.result = new FileWriter("SEresults", true);
                this.result.write(this.iters + " " + this.roundA + " " + this.roundB + " Acc " + combOrigUtility + " " + combCommUtility + " " + combMargUtility + " " + negDuration + "\n");
                this.result.close();
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_PS);
            }
        }
        this.log.log("processAccepted: comm created", 2, this.FAC_PS);
        if (this.conditioned == null) {
            this.log.log("processAccepted: conditioned is null!!", 0, this.FAC_PS);
        } else {
            this.conditioned.addCommitment(com);
        }
    }

    public void processRejectedFrmResp(CoordinateEvent ce) {
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        this.origRespUtility = ((Float)com.getAttribute((Object)"origRespUtility")).floatValue();
        this.commRespUtility = ((Float)com.getAttribute((Object)"commRespUtility")).floatValue();
        float combOrigUtility = this.origRespUtility + this.noCommIniUtility;
        float combCommUtility = 0.0f;
        float combMargUtility = 0.0f;
        if (this.commRespUtility == -1.0f) {
            combCommUtility = combOrigUtility;
        } else {
            combCommUtility = this.commRespUtility + this.commIniUtility;
            combMargUtility = combCommUtility - combOrigUtility;
        }
        int negEndTime = (Integer)this.state.getProperty((Object)"Time");
        int negDuration = negEndTime - this.negStartTime;
        this.log.log("processRejected: combOrigUtility = " + combOrigUtility, 2, this.FAC_PS);
        this.log.log("processRejected: combCommUtility = " + combCommUtility, 2, this.FAC_PS);
        if (this.imIni) {
            try {
                this.result = new FileWriter("SFresults", true);
                this.result.write(this.iters + " " + this.roundA + " " + this.roundB + " Rej " + combOrigUtility + " " + combCommUtility + " " + combMargUtility + " " + negDuration + "\n");
                this.result.close();
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_PS);
            }
        }
        Taems taemsAux = (Taems)this.conditioned.clone();
        taemsAux.setScheduleVector(new Vector());
        Taems tSx = this.evaluateTaems(taemsAux, true);
        if (tSx == null) {
            this.log.log("processRejectedFrmResp: tSx is null!!", 0, this.FAC_PS);
        } else {
            this.conditioned = tSx;
            float utility = this.getSimpleQuality(tSx.getFirstSchedule());
            this.log.log("processRejectedFrmResp: utility of sched without comm: " + utility, 2, this.FAC_PS);
        }
    }

    public void processEvalComm(CoordinateEvent ce) {
        Taems infoTaems;
        boolean accept = false;
        boolean found = false;
        ScheduleElement schElement = null;
        Method m = null;
        Schedule s = null;
        Taems taemsAux2 = null;
        this.log.log("Processing the " + ce.getType() + " event.", 3);
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        if (!com.hasAttribute((Object)"sourceMethodName")) {
            this.log.log("processEvalTSE: no sourceMethodName attribute!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Reject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            this.isNegotiating = false;
            return;
        }
        String sourceMethodName = (String)com.getAttribute((Object)"sourceMethodName");
        Method dummy = new Method();
        dummy.setLabel(sourceMethodName);
        m = (Method)this.conditioned.findNode((Node)dummy);
        if (m == null) {
            this.log.log("processEvalTSE: method with name " + sourceMethodName + " not found in taems structure !", 0, this.FAC_PS);
            System.exit(0);
        }
        float expectedQualityNoComm = this.getSimpleQuality(this.conditioned.getFirstSchedule());
        this.origRespUtility = this.calcUtility(expectedQualityNoComm, this.conditioned.getFirstSchedule());
        this.log.log("processEvalComm: expectedQualityNoComm = " + expectedQualityNoComm, 2, this.FAC_PS);
        if (!found) {
            Taems taemsAux = (Taems)this.conditioned.clone();
            taemsAux.setScheduleVector(new Vector());
            Method commMeth = new Method();
            commMeth.setLabel("CommMeth" + com.getLabel());
            Outcome outc = new Outcome("outc" + com.getLabel());
            outc.setDuration(new Distribution(0.0f, 1.0f));
            outc.setQuality(new Distribution(com.getMinimumQuality(), 1.0f));
            outc.setCost(new Distribution(0.0f, 1.0f));
            commMeth.addOutcome(outc);
            Method dummy2 = new Method();
            dummy2.setLabel(sourceMethodName);
            Method sourceMeth = (Method)taemsAux.findNode((Node)dummy2);
            Task taskM = taemsAux.getNode();
            this.log.log("processEvalTSE: root task is " + taskM.getLabel(), 2, this.FAC_PS);
            taskM.addSubtask((TaskBase)commMeth);
            EnablesInterrelationship enables = new EnablesInterrelationship();
            enables.setLabel("enable" + com.getLabel());
            enables.setCost(new Distribution(0.0f, 1.0f));
            enables.setDelay(new Distribution(0.0f, 1.0f));
            enables.setDuration(new Distribution(0.0f, 1.0f));
            enables.setAgent(taskM.getAgent());
            sourceMeth.addInterrelationship((Interrelationship)enables, (Node)commMeth);
            sourceMeth.setDeadline(com.getDeadline());
            taemsAux2 = this.evaluateTaems(taemsAux, true);
            s = taemsAux2.getFirstSchedule();
            if (s == null) {
                this.log.log("processEvalTSE: commitment rejected - no schedule possible", 2, this.FAC_PS);
                com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
                com.setAttribute((Object)"commRespUtility", (Object)new Float(-1.0f));
                Taems infoTaems2 = new Taems();
                infoTaems2.addCommitment(com);
                ce.setType("Rejected");
                ce.setTaems(infoTaems2);
                ce.setID(4096);
                ce.setCoordinateID(com.getID());
                this.startFireEvent(ce);
                this.isNegotiating = false;
                return;
            }
            boolean found2 = false;
            Enumeration schedEls = s.getElements();
            while (schedEls.hasMoreElements()) {
                ScheduleElement schEl = (ScheduleElement)schedEls.nextElement();
                if (schEl.getMethod().getLabel().equals(sourceMethodName)) {
                    schElement = schEl;
                    found2 = true;
                }
                if (found2) break;
            }
            if (!found2) {
                this.log.log("processEvalTSE: commitment rejected - best schedule does not have enabler method " + sourceMethodName, 2, this.FAC_PS);
                com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
                com.setAttribute((Object)"commRespUtility", (Object)new Float(-1.0f));
                Taems infoTaems3 = new Taems();
                infoTaems3.addCommitment(com);
                ce.setTaems(infoTaems3);
                ce.setType("Rejected");
                ce.setID(4096);
                ce.setCoordinateID(com.getID());
                this.startFireEvent(ce);
                this.isNegotiating = false;
                return;
            }
        }
        if (found) {
            this.log.log("processEvalTSE: source method " + schElement.getMethod().getLabel() + " found in a precalculated schedule, its finish time is " + schElement.getFinish(), 2, this.FAC_PS);
        } else {
            this.log.log("processEvalTSE: source method " + schElement.getMethod().getLabel() + " not found in a precalculated schedule, its finish time is " + schElement.getFinish(), 2, this.FAC_PS);
        }
        float expectedQualityComm = this.getSimpleQuality(s);
        this.log.log("processEvalComm: expectedQualityComm with comm qual = " + expectedQualityComm, 2, this.FAC_PS);
        this.log.log("processEvalComm: expectedQualityComm without comm qual = " + (expectedQualityComm -= com.getMinimumQuality()), 2, this.FAC_PS);
        this.commRespUtility = this.calcUtility(expectedQualityComm, s);
        this.log.log("processEvalComm: commRespUtility = " + this.commRespUtility, 2, this.FAC_PS);
        this.log.log("processEvalComm: origRespUtility = " + this.origRespUtility, 2, this.FAC_PS);
        if (this.commRespUtility >= this.origRespUtility) {
            accept = true;
        }
        if (accept) {
            this.log.log("processEvalComm: commitment accepted", 2, this.FAC_PS);
            if (taemsAux2 != null) {
                this.conditioned = taemsAux2;
            }
            this.conditioned.addCommitment(com);
            com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
            com.setAttribute((Object)"commRespUtility", (Object)new Float(this.commRespUtility));
            infoTaems = new Taems();
            infoTaems.addCommitment(com);
            ce.setTaems(infoTaems);
            ce.setType("Accepted");
        } else {
            com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
            com.setAttribute((Object)"commRespUtility", (Object)new Float(this.commRespUtility));
            infoTaems = new Taems();
            infoTaems.addCommitment(com);
            ce.setTaems(infoTaems);
            this.log.log("processEvalComm: commitment rejected", 2, this.FAC_PS);
            ce.setType("Rejected");
        }
        ce.setID(0);
        ce.setCoordinateID(com.getID());
        this.startFireEvent(ce);
        this.isNegotiating = false;
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 2, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
        boolean typeFound = false;
        if (e.getType().equals("EvalComm")) {
            this.log.log("commitmentEventReceived type EvalComm" + e.getID(), 2, this.FAC_PS);
            this.processEvalComm(e);
            typeFound = true;
        }
        if (e.getType().equals("Accepted")) {
            this.log.log("commitmentEventReceived type Accepted" + e.getID(), 2, this.FAC_PS);
            this.processAccepted(e);
            this.isNegotiating = false;
            typeFound = true;
        }
        if (e.getType().equals("RejectedFrmResp")) {
            this.log.log("commitmentEventReceived type RejectedFrmResp" + e.getID(), 2, this.FAC_PS);
            this.processRejectedFrmResp(e);
            this.isNegotiating = false;
            typeFound = true;
        }
        if (!typeFound) {
            this.log.log("commitmentEventReceived type Unknown: " + e.getID(), 2, this.FAC_PS);
        }
    }

    private float getSimpleQuality(Schedule s) {
        float quality = 0.0f;
        Enumeration e = s.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement schElement = (ScheduleElement)e.nextElement();
            Method m = schElement.getMethod();
            Outcome outc = (Outcome)m.getOutcomes().nextElement();
            Distribution qual = outc.getQuality();
            quality += qual.calculateAvg();
        }
        return quality;
    }

    private float calcUtility(float quality, Schedule s) {
        if (s == null || s.getCost() == null || s.getDuration() == null) {
            return 0.0f;
        }
        Criteria crit = this.conditioned.getScheduleCriteria();
        float qualityGain = quality / crit.getQualityThreshold().floatValue();
        float costGain = (crit.getCostThreshold().floatValue() - s.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
        float durationGain = (crit.getDurationThreshold().floatValue() - s.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
        float utility = qualityGain * crit.getGoodnessQuality().floatValue() + costGain * crit.getGoodnessCost().floatValue() + durationGain * crit.getGoodnessDuration().floatValue();
        return utility;
    }
}

