/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.coordinate.CoordinateEvent;
import agent.gpgp2.GPGPController;
import agent.gpgp2.GPGPMech;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.EnablesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import taems.Task;
import taems.TaskBase;
import utilities.Distribution;

public class SEGPGPMech
extends GPGPMech {
    private static final String protocolName = "SSEnablesIni";

    public SEGPGPMech(GPGPController gpgpController, Method nlm, CoordinateEvent ce, String condKey) {
        super(gpgpController, (TaskBase)nlm, ce, condKey);
    }

    protected void assignName() {
        this.name = "SEGPGPMech";
    }

    private void excludeChildrenMeths(Task task) {
        Enumeration childrenEnum = task.getSubtasks();
        while (childrenEnum.hasMoreElements()) {
            TaskBase tbase = (TaskBase)childrenEnum.nextElement();
            if (tbase instanceof Task) {
                this.excludeChildrenMeths((Task)tbase);
                continue;
            }
            if (!(tbase instanceof Method)) continue;
            Method meth = (Method)tbase;
            Outcome outc = meth.getMostLikelyOutcome();
            outc.setQuality(new Distribution(0.0f, 1.0f));
            outc.setDuration(new Distribution(0.0f, 1.0f));
        }
    }

    protected GPGPMech.UtilQualPair getUtilQualWoComm(Taems ta, Method nlm) {
        this.log.log("SEGPGPMech.getUtilQualWoComm: for method " + nlm.getLabel(), 2, this.FAC_GPGPMECH);
        if (ta == null) {
            this.log.log("SEGPGPMech.getUtilQualWoComm: internal error - input struc is null", 0, this.FAC_GPGPMECH);
            return null;
        }
        Taems taemsAux = (Taems)ta.clone();
        taemsAux.setScheduleVector(new Vector());
        Method nlmAux = (Method)taemsAux.findNode((Node)nlm);
        if (nlmAux == null) {
            this.log.log("SEGPGPMech.getUtilQualWoComm: internal error - nlmAux is null", 0, this.FAC_GPGPMECH);
        }
        if (this.imLeader) {
            Outcome outc2;
            Method meth;
            TaskBase dest;
            Interrelationship inter;
            if (nlmAux.getMostLikelyOutcome() == null) {
                this.log.log("SEGPGPMech.getUtilQualWoComm: internal error - nlmAux.getMostLikelyOutcome() is null", 0, this.FAC_GPGPMECH);
            }
            Enumeration outcEnum = nlmAux.getOutcomes();
            while (outcEnum.hasMoreElements()) {
                Outcome outc = (Outcome)outcEnum.nextElement();
                outc.setQuality(new Distribution(0.0f, 1.0f));
                outc.setDuration(new Distribution(0.0f, 1.0f));
            }
            Task nlmTask = (Task)nlmAux.getSupertasks().nextElement();
            Enumeration affectedIRs = nlmAux.getAffectedInterrelationships();
            while (affectedIRs.hasMoreElements()) {
                inter = (Interrelationship)affectedIRs.nextElement();
                dest = (TaskBase)inter.getTo();
                if (dest instanceof Method) {
                    meth = (Method)dest;
                    Enumeration outcEnum2 = meth.getOutcomes();
                    while (outcEnum2.hasMoreElements()) {
                        outc2 = (Outcome)outcEnum2.nextElement();
                        outc2.setQuality(new Distribution(0.0f, 1.0f));
                        outc2.setDuration(new Distribution(0.0f, 1.0f));
                    }
                    continue;
                }
                if (!(dest instanceof Task)) continue;
                this.excludeChildrenMeths((Task)dest);
            }
            if (nlmTask != null) {
                this.log.log("SEGPGPMech.getUtilQualWoComm: excluding methods under task " + nlmTask.getLabel(), 2, this.FAC_GPGPMECH);
                affectedIRs = nlmTask.getAffectedInterrelationships();
                while (affectedIRs.hasMoreElements()) {
                    inter = (Interrelationship)affectedIRs.nextElement();
                    dest = (TaskBase)inter.getTo();
                    if (dest instanceof Method) {
                        meth = (Method)dest;
                        Outcome outc22 = meth.getMostLikelyOutcome();
                        outc22.setQuality(new Distribution(0.0f, 1.0f));
                        outc22.setDuration(new Distribution(0.0f, 1.0f));
                        continue;
                    }
                    if (!(dest instanceof Task)) continue;
                    this.excludeChildrenMeths((Task)dest);
                }
                Task nlmTask2 = (Task)nlmTask.getSupertasks().nextElement();
                if (nlmTask2 != null) {
                    this.log.log("SEGPGPMech.getUtilQualWoComm: excluding methods under task " + nlmTask2.getLabel(), 2, this.FAC_GPGPMECH);
                    affectedIRs = nlmTask2.getAffectedInterrelationships();
                    while (affectedIRs.hasMoreElements()) {
                        Interrelationship inter2 = (Interrelationship)affectedIRs.nextElement();
                        TaskBase dest2 = (TaskBase)inter2.getTo();
                        if (dest2 instanceof Method) {
                            Method meth2 = (Method)dest2;
                            outc2 = meth2.getMostLikelyOutcome();
                            outc2.setQuality(new Distribution(0.0f, 1.0f));
                            outc2.setDuration(new Distribution(0.0f, 1.0f));
                            continue;
                        }
                        if (!(dest2 instanceof Task)) continue;
                        this.excludeChildrenMeths((Task)dest2);
                    }
                }
            }
        }
        Enumeration affectingIRs = nlmAux.getAffectingInterrelationships();
        while (affectingIRs.hasMoreElements()) {
            Method meth;
            Interrelationship inter = (Interrelationship)affectingIRs.nextElement();
            TaskBase dest = (TaskBase)inter.getTo();
            if (!(dest instanceof Method) || !(meth = (Method)dest).getLabel().startsWith("GPGPReqNeg")) continue;
            Outcome outc2 = meth.getMostLikelyOutcome();
            outc2.setQuality(new Distribution(0.0f, 1.0f));
            outc2.setDuration(new Distribution(0.0f, 1.0f));
        }
        Taems tSx = this.evaluateTaems(taemsAux, true);
        if (tSx == null) {
            this.log.log("SEGPGPMech.getUtilQualWoComm: no comm ini quality = 0.0 no comm ini utility = 0.0", 2, this.FAC_GPGPMECH);
            return new GPGPMech.UtilQualPair(0.0f, 0.0f, null);
        }
        float resQuality = this.getSimpleQuality(tSx.getFirstSchedule());
        float resUtility = this.calcUtility(resQuality, tSx.getFirstSchedule());
        this.condWoComm = new GPGPMech.UtilQualPair(resUtility, resQuality, tSx);
        return this.condWoComm;
    }

    private Taems getTaemsWithMargQual(Taems taemsAux, Commitment com, Method nlmeth) {
        Method commMeth = new Method();
        commMeth.setLabel("CommMeth" + com.getLabel());
        Outcome outc = new Outcome("outc" + com.getLabel());
        outc.setDuration(new Distribution(0.0f, 1.0f));
        outc.setQuality(new Distribution(com.getMinimumQuality(), 1.0f));
        outc.setCost(new Distribution(0.0f, 1.0f));
        commMeth.addOutcome(outc);
        Method dummy2 = new Method();
        dummy2.setLabel(nlmeth.getLabel());
        Method sourceMeth = (Method)taemsAux.findNode((Node)dummy2);
        Task taskM = taemsAux.getNode();
        this.log.log("SEGPGPMech.getTaemsWithMargQual: root task is " + taskM.getLabel(), 2, this.FAC_GPGPMECH);
        taskM.addSubtask((TaskBase)commMeth);
        EnablesInterrelationship enables = new EnablesInterrelationship();
        enables.setLabel("enable" + com.getLabel());
        enables.setCost(new Distribution(0.0f, 1.0f));
        enables.setDelay(new Distribution(0.0f, 1.0f));
        enables.setDuration(new Distribution(0.0f, 1.0f));
        enables.setAgent(taskM.getAgent());
        sourceMeth.addInterrelationship((Interrelationship)enables, (Node)commMeth);
        sourceMeth.setDeadline(com.getDeadline());
        return taemsAux;
    }

    protected CoordinateEvent getInitCoordEvt() {
        CoordinateEvent ce = null;
        if (this.currSchedule == null) {
            this.log.log("getInitCoordEvt: internal error - current schedule is null", 0, this.FAC_GPGPMECH);
            return null;
        }
        Schedule s = this.currSchedule;
        ScheduleElement schElement = this.findSchedEl((Method)this.nlm, s);
        Taems ta = new Taems();
        Vector<TaskBase> v = new Vector<TaskBase>();
        int intDL = schElement.getStart();
        GPGPMech.UtilQualPair utilQualPair = this.getUtilQualWoComm(this.conditional, (Method)this.nlm);
        this.noCommIniUtility = utilQualPair.getUtility();
        this.noCommIniQuality = utilQualPair.getQuality();
        this.log.log("SEGPGPMech.getInitCoordEvt: no comm ini quality = " + this.noCommIniQuality + " no comm ini utility = " + this.noCommIniUtility, 2, this.FAC_GPGPMECH);
        this.commIniQuality = this.getSimpleQuality(s);
        this.commIniUtility = this.calcUtility(this.commIniQuality, s);
        this.log.log("generateCommitment: comm ini quality = " + this.commIniQuality + " comm ini utility = " + this.commIniUtility, 2, this.FAC_GPGPMECH);
        float marginalQuality = this.commIniQuality;
        if (marginalQuality < 0.0f) {
            this.log.log("SEGPGPMech.getInitCoordEvt: quality with commitment is negative: " + marginalQuality + " !", 0, this.FAC_GPGPMECH);
            return null;
        }
        v.addElement(this.nlm);
        if (this.localAgent == null) {
            this.log.log("SEGPGPMech: localAgent() is null !", 0, this.FAC_GPGPMECH);
            return null;
        }
        this.log.log("SEGPGPMech: local agent is " + this.localAgent.getLabel(), 0, this.FAC_GPGPMECH);
        this.log.log("About to create commitment", 0, this.FAC_GPGPMECH);
        Commitment com = new Commitment("SSE", "deadline", this.nlm.getAgent(), this.localAgent, v, 1, marginalQuality, -1, intDL, -1);
        if (com == null) {
            this.log.log("SEGPGPMech: com is null !", 0, this.FAC_GPGPMECH);
        }
        com.setAttribute((Object)"sourceMethodName", (Object)this.nlm.getLabel());
        this.imLeader = true;
        this.log.log("Commitment created", 0, this.FAC_GPGPMECH);
        com.setID(this.cid);
        ta.addCommitment(com);
        this.log.log("Creating SSEnablesIni evt", 0, this.FAC_GPGPMECH);
        this.log.log("Using Single Shot Enables for " + this.nlm.getLabel(), 2, this.FAC_GPGPMECH);
        ce = new CoordinateEvent(this, protocolName, 16, ta);
        ce.setCoordinateID(this.CID);
        return ce;
    }

    protected void processAccepted(CoordinateEvent ce) {
        Taems t = ce.getTaems();
        this.log.log("processAccepted: taems struc created", 2, this.FAC_GPGPMECH);
        Commitment com = t.getCommitment();
        this.origRespUtility = ((Float)com.getAttribute((Object)"origRespUtility")).floatValue();
        this.commRespUtility = ((Float)com.getAttribute((Object)"commRespUtility")).floatValue();
        String status = (String)com.getAttribute((Object)"Status");
        if (status != null && status.equals("Completed")) {
            Outcome outc = ((Method)this.nlm).getMostLikelyOutcome();
            outc.setDuration(new Distribution(0.0f, 1.0f));
        }
        this.combOrigUtility = this.origRespUtility + this.noCommIniUtility;
        this.combCommUtility = this.commRespUtility + this.commIniUtility;
        this.combMargUtility = this.combCommUtility - this.combOrigUtility;
        int negEndTime = (Integer)this.state.getProperty((Object)"Time");
        this.negDuration = negEndTime - this.negStartTime;
        this.log.log("processAccepted: combOrigUtility = " + this.combOrigUtility, 2, this.FAC_GPGPMECH);
        this.log.log("processAccepted: combCommUtility = " + this.combCommUtility, 2, this.FAC_GPGPMECH);
        String resultsString = null;
        if (this.imLeader) {
            resultsString = this.getName() + ",Accept, iters = " + String.valueOf(this.iters) + ", combined util w/o commitment =" + String.valueOf(this.combOrigUtility) + ", combined util w/ commitment = " + String.valueOf(this.combCommUtility) + ", combined marginal util = " + String.valueOf(this.combMargUtility) + ", negotiation duration = " + String.valueOf(this.negDuration);
        }
        this.log.log("processAccepted: comm created", 2, this.FAC_GPGPMECH);
        this.negAccept(ce, true, resultsString);
    }

    protected void processRejectedFrmResp(CoordinateEvent ce) {
        this.log.log("processRejectedFrmResp: starting", 2, this.FAC_GPGPMECH);
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        this.origRespUtility = ((Float)com.getAttribute((Object)"origRespUtility")).floatValue();
        this.commRespUtility = ((Float)com.getAttribute((Object)"commRespUtility")).floatValue();
        this.combOrigUtility = this.origRespUtility + this.noCommIniUtility;
        this.combCommUtility = 0.0f;
        this.combMargUtility = 0.0f;
        if (this.commRespUtility == -1.0f) {
            this.combCommUtility = this.combOrigUtility;
        } else {
            this.combCommUtility = this.commRespUtility + this.commIniUtility;
            this.combMargUtility = this.combCommUtility - this.combOrigUtility;
        }
        int negEndTime = (Integer)this.state.getProperty((Object)"Time");
        this.negDuration = negEndTime - this.negStartTime;
        this.log.log("processRejected: combOrigUtility = " + this.combOrigUtility, 2, this.FAC_GPGPMECH);
        this.log.log("processRejected: combCommUtility = " + this.combCommUtility, 2, this.FAC_GPGPMECH);
        GPGPMech.UtilQualPair woCommUtilQualPair = this.getUtilQualWoComm(this.getCondTaems(this.condKey), (Method)this.nlm);
        float utility = woCommUtilQualPair.getUtility();
        this.log.log("processRejectedFrmResp: utility of sched without comm: " + utility, 2, this.FAC_GPGPMECH);
        if (woCommUtilQualPair.getTaems() != null) {
            this.conditional = woCommUtilQualPair.getTaems();
        }
        String resultsString = null;
        if (this.imLeader) {
            resultsString = this.getName() + ", Reject, iters = " + String.valueOf(this.iters) + ", combined util w/o commitment =" + String.valueOf(this.combOrigUtility) + ", combined util w/ commitment = " + String.valueOf(this.combCommUtility) + ", combined marginal util = " + String.valueOf(this.combMargUtility) + ", negotiation duration = " + String.valueOf(this.negDuration);
        }
        this.negReject(ce, true, resultsString);
    }

    public Taems enforceModAccept(Taems newCond) {
        if (!this.imLeader && this.finalComm != null) {
            newCond.addCommitment(this.finalComm);
        }
        return newCond;
    }

    protected void processEvalComm(CoordinateEvent ce) {
        boolean accept = false;
        boolean found = false;
        Schedule s = null;
        Taems taemsAux2 = null;
        this.log.log("Processing the " + ce.getType() + " event.", 3);
        Taems t = ce.getTaems();
        if (t == null) {
            this.log.log("SEGPGPMech.processEvalComm: taems is null in coord event !", 0, this.FAC_GPGPMECH);
            return;
        }
        Commitment com = t.getCommitment();
        if (this.nlm == null) {
            this.log.log("SEGPGPMech.processEvalComm: nlm is null !" + com, 0, this.FAC_GPGPMECH);
            CoordinateEvent evt = new CoordinateEvent(this, "Reject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        String sourceMethodName = this.nlm.getLabel();
        s = this.getCurrSchedule();
        float expectedQualityNoComm = this.getSimpleQuality(s);
        this.origRespUtility = this.calcUtility(expectedQualityNoComm, s);
        this.log.log("processEvalComm: expectedQualityNoComm = " + expectedQualityNoComm, 2, this.FAC_GPGPMECH);
        ScheduleElement mschedEl = this.findSchedEl((Method)this.nlm, s);
        if (mschedEl != null) {
            int leftB = mschedEl.getEarliestStartTime();
            int rightB = mschedEl.getLatestFinishTime();
            Outcome outc = mschedEl.getMethod().getMostLikelyOutcome();
            int dur = (int)outc.getDuration().calculateAvg();
            int earliestCompletionTime = leftB + dur;
            int dl = com.getDeadline();
            if (dl <= earliestCompletionTime) {
                Taems cond = this.getCondTaemsOf(this.nlm);
                cond.addCommitment(com);
                com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
                com.setAttribute((Object)"commRespUtility", (Object)new Float(this.commRespUtility));
                Taems infoTaems = new Taems();
                infoTaems.addCommitment(com);
                ce.setTaems(infoTaems);
                ce.setType("Accepted");
                found = true;
                this.log.log("processEvalTSE: source method " + this.nlm.getLabel() + " found in a precalculated schedule, its finish time is " + mschedEl.getFinish(), 2, this.FAC_GPGPMECH);
                this.startFireEvent(ce);
                this.negReject(ce, false, null);
                return;
            }
        }
        if (!found) {
            String status = (String)this.nlm.getAttribute((Object)"Status");
            if (status != null && status.equals("Completed")) {
                float expectedQualityComm1 = this.getSimpleQuality(s);
                this.log.log("SEGPGPMech.processEvalComm: expectedQualityComm without comm qual = " + expectedQualityComm1, 2, this.FAC_GPGPMECH);
                float expectedQualityComm2 = expectedQualityComm1 + com.getMinimumQuality();
                this.log.log("SEGPGPMech.processEvalComm: combined expectedQualityComm with comm qual = " + expectedQualityComm2, 2, this.FAC_GPGPMECH);
                this.commRespUtility = this.calcUtility(expectedQualityComm1, s);
                com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
                com.setAttribute((Object)"commRespUtility", (Object)new Float(this.commRespUtility));
                com.setAttribute((Object)"Status", (Object)"Completed");
                Taems infoTaems = new Taems();
                infoTaems.addCommitment(com);
                this.finalComm = com;
                ce.setTaems(infoTaems);
                ce.setType("Accepted");
                this.negAccept(ce, true, null);
                ce.setID(0);
                ce.setCoordinateID(com.getID());
                this.startFireEvent(ce);
                return;
            }
            Taems taemsAux = (Taems)this.getCondTaemsOf(this.nlm).clone();
            taemsAux.setScheduleVector(new Vector());
            taemsAux = this.getTaemsWithMargQual(taemsAux, com, (Method)this.nlm);
            taemsAux2 = this.evaluateTaems(taemsAux, true);
            s = taemsAux2.getFirstSchedule();
            if (s == null) {
                this.log.log("processEvalTSE: commitment rejected - no schedule with " + this.nlm.getLabel() + " possible", 2, this.FAC_GPGPMECH);
                com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
                com.setAttribute((Object)"commRespUtility", (Object)new Float(-1.0f));
                Taems infoTaems = new Taems();
                infoTaems.addCommitment(com);
                ce.setType("Rejected");
                ce.setTaems(infoTaems);
                ce.setID(4096);
                ce.setCoordinateID(com.getID());
                this.startFireEvent(ce);
                this.negReject(ce, false, null);
                return;
            }
            ScheduleElement m1schedEl = this.findSchedEl((Method)this.nlm, s);
            if (m1schedEl == null) {
                this.log.log("processEvalTSE: commitment rejected - best schedule does not have enabler method " + sourceMethodName, 2, this.FAC_GPGPMECH);
                com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
                com.setAttribute((Object)"commRespUtility", (Object)new Float(-1.0f));
                Taems infoTaems = new Taems();
                infoTaems.addCommitment(com);
                ce.setTaems(infoTaems);
                ce.setType("Rejected");
                ce.setID(4096);
                ce.setCoordinateID(com.getID());
                this.startFireEvent(ce);
                this.negReject(ce, false, null);
                return;
            }
        }
        float expectedQualityComm = this.getSimpleQuality(s);
        this.log.log("processEvalComm: expectedQualityComm with comm qual = " + expectedQualityComm, 2, this.FAC_GPGPMECH);
        this.log.log("processEvalComm: expectedQualityComm without comm qual = " + (expectedQualityComm -= com.getMinimumQuality()), 2, this.FAC_GPGPMECH);
        this.commRespUtility = this.calcUtility(expectedQualityComm, s);
        this.log.log("SEGPGPMech.processEvalComm: commRespUtility = " + this.commRespUtility, 2, this.FAC_GPGPMECH);
        this.log.log("SEGPGPMech.processEvalComm: origRespUtility = " + this.origRespUtility, 2, this.FAC_GPGPMECH);
        if (this.commRespUtility >= this.origRespUtility) {
            accept = true;
        }
        if (accept) {
            this.log.log("processEvalComm: commitment accepted", 2, this.FAC_GPGPMECH);
            com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
            com.setAttribute((Object)"commRespUtility", (Object)new Float(this.origRespUtility));
            Taems infoTaems = new Taems();
            infoTaems.addCommitment(com);
            this.finalComm = com;
            ce.setTaems(infoTaems);
            ce.setType("Accepted");
            this.negAccept(ce, true, null);
        } else {
            com.setAttribute((Object)"origRespUtility", (Object)new Float(this.origRespUtility));
            com.setAttribute((Object)"commRespUtility", (Object)new Float(this.commRespUtility));
            Taems infoTaems = new Taems();
            infoTaems.addCommitment(com);
            ce.setTaems(infoTaems);
            this.log.log("SEGPGPMech.processEvalComm: commitment rejected", 2, this.FAC_GPGPMECH);
            ce.setType("Rejected");
            this.negReject(ce, false, null);
        }
        ce.setID(0);
        ce.setCoordinateID(com.getID());
        this.startFireEvent(ce);
    }

    protected void processEventReceived(CoordinateEvent e) {
        boolean typeFound = false;
        if (e.getType().equals("EvalComm")) {
            this.log.log("SEGPGPMech.processEventReceived type EvalComm" + e.getID(), 2, this.FAC_GPGPMECH);
            this.processEvalComm(e);
            typeFound = true;
            this.stopOperation();
        }
        if (!typeFound) {
            this.log.log("SEGPGPMech.processEventReceived type Unknown: " + e.getID(), 2, this.FAC_GPGPMECH);
        }
    }
}

