/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.coordinate.CoordinateEvent;
import agent.gpgp2.BasicProblemSolver;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;
import taems.Commitment;
import taems.EnablesInterrelationship;
import taems.Method;
import taems.Node;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;

public class MLEnableProblemSolver
extends BasicProblemSolver {
    public void init() {
        super.init();
    }

    public Vector generateCommitment(Taems t) {
        Vector<CoordinateEvent> commitments = new Vector<CoordinateEvent>();
        Schedule s = t.getFirstSchedule();
        Enumeration enumOfNLE = t.findNodes((Node)new EnablesInterrelationship());
        while (enumOfNLE.hasMoreElements()) {
            EnablesInterrelationship NLE = (EnablesInterrelationship)enumOfNLE.nextElement();
            Enumeration e = s.getElements();
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                Method m = schElement.getMethod();
                if (!NLE.getFrom().getLabel().equals(m.getLabel())) continue;
                String typeOfProtocol = "";
                Taems ta = new Taems();
                Vector<Object> v = new Vector<Object>();
                long CID = State.getRandom().nextLong();
                v.addElement(m.clone());
                this.log.log("About to create commitment", 0, this.FAC_PS);
                Commitment com = new Commitment("Enables", NLE.getTo().getLabel(), m.getAgent(), null, v, 0, 1.0f, schElement.getStart(), this.TIMEOUT, schElement.getStart() + schElement.getDuration());
                this.log.log("Commitment created", 0, this.FAC_PS);
                if (NLE.getCost() == null) {
                    this.log.log("NLE Cost is null!", 0, this.FAC_PS);
                } else {
                    com.setQuantity(NLE.getCost().calculateMax());
                }
                if (NLE.getTo() == null) {
                    this.log.log("NLE getToNode is null!", 0, this.FAC_PS);
                } else {
                    com.setResource(NLE.getTo().getLabel());
                }
                com.setID(CID);
                com.setAttribute((Object)"initLeader", (Object)new Integer(1));
                ta.addCommitment(com);
                if (NLE.getTo().getAgent() != null) {
                    this.log.log("Creating HandleHPCR evt", 0, this.FAC_PS);
                    typeOfProtocol = "HandleHPCR";
                    this.log.log("Using GPGP_Mech4 for " + NLE.getTo().getLabel() + " (" + NLE.getTo().getAgent().getLabel() + ")", 2, this.FAC_PS);
                    com.setToAgent(NLE.getTo().getAgent());
                    CoordinateEvent ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                    commitments.addElement(ce);
                    ce.setCoordinateID(CID);
                    this.addCoordinateEvent(schElement, ce);
                    this.log.log("HandleHPCR created", 0, this.FAC_PS);
                    continue;
                }
                typeOfProtocol = "new_dsharp_request";
                this.log.log("Using DSharp for " + NLE.getTo().getLabel(), 2, this.FAC_PS);
            }
        }
        this.log.log("Coordinating over " + commitments.size() + " NLEs", 2, this.FAC_PS);
        return commitments;
    }

    public void processAccepted(CoordinateEvent ce) {
    }

    public void processGetSched(CoordinateEvent ce) {
        this.log.log("Processing the " + ce.getType() + " event.", 3);
        Taems t = ce.getTaems();
        Commitment com = t.getCommitment();
        this.log.log("Scheduling... ", 2, this.FAC_PS);
        if (this.conditioned != null) {
            this.conditioned.setScheduleVector(null);
            this.scheduleNumber = 0;
            this.scheduleList = this.scheduler.evaluateTaems(this.conditioned);
            int time = (Integer)this.state.getProperty((Object)"Time") + this.TIMEOUT + 1;
            this.conditioned.setScheduleVector(this.scheduleList);
            if (this.scheduleList != null) {
                Schedule s = this.conditioned.getFirstSchedule();
                this.log.log("Setting schedule start time to " + time, 2, this.FAC_PS);
                s.setStartTime(time);
                ++this.scheduleNumber;
                this.schedule = new Vector();
                String print = "";
                Enumeration e = this.conditioned.getFirstSchedule().getElements();
                while (e.hasMoreElements()) {
                    ScheduleElement schElement = (ScheduleElement)e.nextElement();
                    this.schedule.addElement(schElement.getLabel());
                    print = print + "[" + schElement.getStart() + " - " + schElement.getLabel() + " - " + schElement.getFinish() + "] ";
                }
                this.log.log(print, 2, this.FAC_PS);
                ce.setType("SchedFound");
            } else {
                ce.setType("SchedNotFound");
            }
            ce.setID(0);
            ce.setCoordinateID(com.getID());
            this.startFireEvent(ce);
        }
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 2, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
        boolean typeFound = false;
        if (e.getType().equals("GetSched")) {
            this.log.log("commitmentEventReceived type GetSched" + e.getID(), 2, this.FAC_PS);
            this.processGetSched(e);
            typeFound = true;
        }
        if (e.getType().equals("GetDoSched")) {
            this.log.log("commitmentEventReceived type GetDoSched" + e.getID(), 2, this.FAC_PS);
            this.processGetSched(e);
            typeFound = true;
        }
        if (e.getType().equals("Accepted")) {
            this.log.log("commitmentEventReceived type Accepted" + e.getID(), 2, this.FAC_PS);
            typeFound = true;
        }
        if (!typeFound) {
            this.log.log("commitmentEventReceived type Unknown: " + e.getID(), 2, this.FAC_PS);
        }
    }
}

