/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.coordinate.CoordinateEvent;
import agent.gpgp2.BasicProblemSolver;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Criteria;
import taems.EnablesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.QAF;
import taems.Schedule;
import taems.ScheduleElement;
import taems.SeqMaxQAF;
import taems.SeqMinQAF;
import taems.SeqSumQAF;
import taems.SumQAF;
import taems.Taems;
import taems.Task;
import taems.TaskBase;
import utilities.Distribution;

public class M4TestProblemSolver
extends BasicProblemSolver {
    int n = 0;
    boolean firstPCofferIter = true;
    private Schedule schedTb;
    private Schedule schedNoMx;
    private int negTimeDL = 100;

    public void init() {
        super.init();
    }

    public void reset() {
        this.schedule = null;
        this.scheduleList = null;
        if (this.execute.isExecuting() && this.schedule != null) {
            Method m = (Method)this.conditioned.findNode((Node)new Method((String)this.schedule.elementAt(0), null));
            this.execute.cancelAction((Action)new TaemsAction(m), "reset Tasks");
        }
        this.negTimeDL = (Integer)this.state.getProperty((Object)"Time") + 100;
        this.reset = true;
    }

    public Vector generateCommitment(Taems t) {
        Method m;
        ScheduleElement schElement;
        Vector<CoordinateEvent> commitments = new Vector<CoordinateEvent>();
        Schedule s = null;
        int time = (Integer)this.state.getProperty((Object)"Time");
        Taems newCond = (Taems)this.conditioned.clone();
        newCond.setScheduleVector(new Vector());
        Taems tS = this.evaluateTaems(newCond, true);
        this.log.log("generateCommitment: scheduler finished", 2, this.FAC_PS);
        if (tS != null) {
            this.log.log("generateCommitment: tS is not null", 2, this.FAC_PS);
            s = tS.getFirstSchedule();
        } else {
            this.log.log("generateCommitment: no taems returned by evaluateTaems !", 0, this.FAC_PS);
            System.exit(0);
        }
        ScheduleElement se = null;
        if (s != null) {
            this.log.log("generateCommitment: schedule is not null", 2, this.FAC_PS);
            se = s.getNextTask(time);
        } else {
            this.log.log("generateCommitment: no schedule !", 0, this.FAC_PS);
            System.exit(0);
        }
        int auxInt2 = this.negTimeDL - time;
        this.log.log("generateCommitment: about to delay start time by " + auxInt2, 2, this.FAC_PS);
        s.delayStartTime(se, this.negTimeDL - time);
        this.schedTb = s;
        this.log.log("generateCommitment: schedTb start time delayed by " + auxInt2 + " : " + this.schedTb.toString(), 2, this.FAC_PS);
        Enumeration enumSchedEl = s.getElements();
        Vector<ScheduleElement> auxScheds = new Vector<ScheduleElement>();
        this.log.log("Starting generate commitment", 2, this.FAC_PS);
        while (enumSchedEl.hasMoreElements()) {
            schElement = (ScheduleElement)enumSchedEl.nextElement();
            m = schElement.getMethod();
            this.log.log(m.getLabel() + " nonlocal field = " + m.isNonLocal(), 2, this.FAC_PS);
            if (!m.isNonLocal()) continue;
            this.log.log("Found nonlocal:  " + m.getLabel(), 2, this.FAC_PS);
            auxScheds.addElement(schElement);
        }
        Enumeration enumSchedEl2 = auxScheds.elements();
        if (!enumSchedEl2.hasMoreElements()) {
            this.log.log("No nonlocal methods found !", 0, this.FAC_PS);
        }
        while (enumSchedEl2.hasMoreElements()) {
            schElement = (ScheduleElement)enumSchedEl2.nextElement();
            m = schElement.getMethod();
            String typeOfProtocol = new String("TaskAssignRequest");
            Taems ta = new Taems();
            Vector<Method> v = new Vector<Method>();
            long CID = State.getRandom().nextLong();
            Method m2 = (Method)t.findNode((Node)m);
            this.log.log("generateCommitment: putting into v: " + m2.toString(), 0, this.FAC_PS);
            Method m3 = (Method)m2.clone();
            Enumeration affectedInters = m3.getAffectedInterrelationships();
            while (affectedInters.hasMoreElements()) {
                m3.removeInterrelationship((Interrelationship)affectedInters.nextElement());
            }
            Enumeration affectingInters = m3.getAffectingInterrelationships();
            while (affectingInters.hasMoreElements()) {
                m3.removeInterrelationship((Interrelationship)affectingInters.nextElement());
            }
            Taems taemsAux = (Taems)t.clone();
            taemsAux.setScheduleVector(new Vector());
            Method auxM = (Method)taemsAux.findNode((Node)m);
            Outcome outc = (Outcome)auxM.getOutcomes().nextElement();
            outc.setDuration(new Distribution(100.0f, 1.0f));
            try {
                File outputFile2 = new File("auxT_taems.txt");
                FileWriter out2 = new FileWriter(outputFile2);
                out2.write(taemsAux.toTTaems(1.0f));
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_PS);
            }
            Taems tSy = this.evaluateTaems(taemsAux, true);
            Schedule schedSy = tSy.getFirstSchedule();
            time = (Integer)this.state.getProperty((Object)"Time");
            ScheduleElement se2 = schedSy.getNextTask(time);
            schedSy.delayStartTime(se2, this.negTimeDL - time);
            this.schedNoMx = schedSy;
            Distribution dSy = schedSy.getQuality();
            float expectedQualitySy = dSy.calculateAvg();
            Method auxM2 = (Method)t.findNode((Node)m);
            Outcome outc2 = (Outcome)auxM2.getOutcomes().nextElement();
            outc2.setDuration(new Distribution(0.0f, 1.0f));
            outc2.setCost(new Distribution(0.0f, 1.0f));
            try {
                File outputFile = new File("t_taems.txt");
                FileWriter out = new FileWriter(outputFile);
                out.write(t.toTTaems(1.0f));
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_PS);
            }
            Taems t2 = (Taems)t.clone();
            t2.setScheduleVector(new Vector());
            Taems tSx = this.evaluateTaems(t2, true);
            Schedule schedSx = tSx.getFirstSchedule();
            time = (Integer)this.state.getProperty((Object)"Time");
            se = schedSx.getNextTask(time);
            schedSx.delayStartTime(se, this.negTimeDL - time);
            try {
                File outputFile2 = new File("tclone_taems.txt");
                FileWriter out2 = new FileWriter(outputFile2);
                out2.write(tSx.toTTaems(1.0f));
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_PS);
            }
            this.schedTb = schedSx;
            Distribution dSx = schedSx.getQuality();
            float expectedQualitySx = dSx.calculateAvg();
            float marginalQuality = expectedQualitySx - expectedQualitySy;
            Outcome outcm3 = (Outcome)m3.getOutcomes().nextElement();
            outcm3.setQuality(new Distribution(marginalQuality, 1.0f));
            Criteria crit = t.getScheduleCriteria();
            float qualityGain = (expectedQualitySx - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
            float costGain = (crit.getCostThreshold().floatValue() - schedSx.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
            float durationGain = (crit.getDurationThreshold().floatValue() - schedSx.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
            float utilitySx = qualityGain * crit.getGoodnessQuality().floatValue() + costGain * crit.getGoodnessCost().floatValue() + durationGain * crit.getGoodnessDuration().floatValue();
            float qualityGain1 = (expectedQualitySy - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
            float costGain1 = (crit.getCostThreshold().floatValue() - schedSy.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
            float durationGain1 = (crit.getDurationThreshold().floatValue() - schedSy.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
            float utilitySy = qualityGain1 * crit.getGoodnessQuality().floatValue() + costGain1 * crit.getGoodnessCost().floatValue() + durationGain1 * crit.getGoodnessDuration().floatValue();
            float negotiationCost = 0.0f;
            this.log.log("Utility(Sx) = " + utilitySx, 2, this.FAC_PS);
            this.log.log("Utility(Sy) = " + utilitySy, 2, this.FAC_PS);
            float marginalUtilityGain = utilitySx - utilitySy;
            this.log.log("marginalUtilityGain = " + marginalUtilityGain, 2, this.FAC_PS);
            this.log.log("negotiationCost = " + negotiationCost, 2, this.FAC_PS);
            if (marginalUtilityGain <= negotiationCost) {
                this.log.log("marginalUtilityGain <= negotiation_cost", 2, this.FAC_PS);
                Enumeration inters = auxM.getAffectedInterrelationships();
                Object interAux = null;
                while (inters.hasMoreElements()) {
                    auxM.removeInterrelationship((Interrelationship)inters.nextElement());
                }
                auxM.excise();
                taemsAux.removeNode((Node)auxM);
                this.state.setProperty((Object)"ConTaemsTask", (Object)taemsAux);
                return commitments;
            }
            this.log.log("marginalUtilityGain > negotiation_cost", 2, this.FAC_PS);
            Enumeration inInters = m.getAffectingInterrelationships();
            Interrelationship inter = null;
            Method mAux = null;
            Vector<Integer> vecESTs = new Vector<Integer>();
            while (inInters.hasMoreElements()) {
                inter = (Interrelationship)inInters.nextElement();
                if (!(inter instanceof EnablesInterrelationship)) continue;
                mAux = (Method)inter.getFrom();
                Method mAux3 = null;
                ScheduleElement schEl = null;
                Enumeration enumSch = schedSx.getElements();
                while (enumSch.hasMoreElements()) {
                    schEl = (ScheduleElement)enumSch.nextElement();
                    mAux3 = schEl.getMethod();
                    if (mAux.getLabel().equals(mAux3.getLabel())) break;
                }
                vecESTs.addElement(new Integer(schEl.getFinish()));
                this.log.log("Adding EST from enables " + mAux3.getLabel() + "  " + schEl.getFinish(), 2, this.FAC_PS);
            }
            Enumeration outInters = m.getAffectedInterrelationships();
            inter = null;
            mAux = null;
            Vector<Integer> vecDLs = new Vector<Integer>();
            while (outInters.hasMoreElements()) {
                inter = (Interrelationship)outInters.nextElement();
                if (!(inter instanceof EnablesInterrelationship)) continue;
                mAux = (Method)inter.getTo();
                Method mAux3 = null;
                ScheduleElement schEl = null;
                Enumeration enumSch = schedSx.getElements();
                while (enumSch.hasMoreElements()) {
                    schEl = (ScheduleElement)enumSch.nextElement();
                    mAux3 = schEl.getMethod();
                    if (mAux.getLabel().equals(mAux3.getLabel())) break;
                }
                vecDLs.addElement(new Integer(schEl.getStart()));
                this.log.log("Adding DL from enables " + mAux3.getLabel() + "  " + schEl.getStart(), 2, this.FAC_PS);
            }
            Enumeration superTasks = m.getSupertasks();
            Task auxTask = null;
            QAF auxQAF = null;
            Vector<Method> seqBefore = new Vector<Method>();
            Vector<Method> seqAfter = new Vector<Method>();
            while (superTasks.hasMoreElements()) {
                auxTask = (Task)superTasks.nextElement();
                auxQAF = auxTask.getQAF();
                if (!(auxQAF instanceof SeqMaxQAF) && !(auxQAF instanceof SeqMinQAF) && !(auxQAF instanceof SeqSumQAF)) continue;
                Enumeration subtasks = auxTask.getSubtasks();
                boolean before = true;
                while (subtasks.hasMoreElements()) {
                    Method mAux2 = (Method)subtasks.nextElement();
                    if (mAux2.getLabel().equals(m.getLabel())) {
                        before = false;
                        continue;
                    }
                    if (before) {
                        seqBefore.addElement(mAux2);
                        continue;
                    }
                    seqAfter.addElement(mAux2);
                }
            }
            Enumeration enumSeqBefore = seqBefore.elements();
            block17: while (enumSeqBefore.hasMoreElements()) {
                mAux = (Method)enumSeqBefore.nextElement();
                Method mAux3 = null;
                ScheduleElement schEl = null;
                Enumeration enumSch = schedSx.getElements();
                while (enumSch.hasMoreElements()) {
                    schEl = (ScheduleElement)enumSch.nextElement();
                    mAux3 = schEl.getMethod();
                    if (!mAux.getLabel().equals(mAux3.getLabel())) continue;
                    vecESTs.addElement(new Integer(schEl.getFinish()));
                    this.log.log("Adding EST from seq before " + mAux.getLabel() + "  " + schEl.getFinish(), 2, this.FAC_PS);
                    continue block17;
                }
            }
            Enumeration enumSeqAfter = seqAfter.elements();
            while (enumSeqAfter.hasMoreElements()) {
                mAux = (Method)enumSeqAfter.nextElement();
                Method mAux3 = null;
                ScheduleElement schEl = null;
                Enumeration enumSch = schedSx.getElements();
                while (enumSch.hasMoreElements()) {
                    schEl = (ScheduleElement)enumSch.nextElement();
                    mAux3 = schEl.getMethod();
                    if (mAux.getLabel().equals(mAux3.getLabel())) break;
                }
                vecDLs.addElement(new Integer(schEl.getStart()));
                this.log.log("Adding DL from seq after " + mAux.getLabel() + "  " + schEl.getStart(), 2, this.FAC_PS);
            }
            int auxInt = 0;
            Enumeration enumESTs = vecESTs.elements();
            int intEST = this.negTimeDL;
            if (enumESTs.hasMoreElements()) {
                intEST = (Integer)enumESTs.nextElement();
            }
            while (enumESTs.hasMoreElements()) {
                auxInt = (Integer)enumESTs.nextElement();
                if (auxInt <= intEST) continue;
                intEST = auxInt;
            }
            int intDL = this.negTimeDL;
            Enumeration enumDLs = vecDLs.elements();
            if (enumDLs.hasMoreElements()) {
                intDL = (Integer)enumDLs.nextElement();
            }
            while (enumDLs.hasMoreElements()) {
                auxInt = (Integer)enumDLs.nextElement();
                if (auxInt >= intDL) continue;
                intDL = auxInt;
            }
            this.log.log("About to create commitment", 2, this.FAC_PS);
            v.addElement(m3);
            Commitment com = new Commitment(m.getLabel(), new String("est_and_dl_and_do"), t.getAgent(), new Agent("TA2_Agent"), v, 1, marginalQuality, intEST, intDL, -1);
            com.setID(CID);
            com.setAttribute((Object)"marginalUtilityGain", (Object)new Float(marginalUtilityGain));
            this.log.log("Commitment created: " + com, 2, this.FAC_PS);
            Method meth3 = (Method)com.getTask();
            this.log.log("Created commitment contains: " + meth3.toString(), 2, this.FAC_PS);
            ta.addCommitment(com);
            TaskBase meth4 = com.getTask();
            this.log.log("Added commitment to ta, it contains: " + meth4.toString(), 2, this.FAC_PS);
            CoordinateEvent ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
            ce.setCoordinateID(CID);
            commitments.addElement(ce);
            this.addCoordinateEvent(schElement, ce);
            this.log.log("TaskAssign created", 0, this.FAC_PS);
        }
        this.log.log("Coordinating over " + commitments.size() + " NLEs", 2, this.FAC_PS);
        return commitments;
    }

    public void processEvalCounteroffer(CoordinateEvent e) {
        int idtype;
        String evtType;
        this.log.log("agent controller: evaluating counteroffer", 2, this.FAC_PS);
        Taems t = e.getTaems();
        Commitment com = t.getCommitment();
        Method m = (Method)com.getTask();
        if (!com.hasAttribute((Object)"ItersOver")) {
            this.log.log("processEvalCounteroffer: no ItersOver attribute!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "PCReject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        if (!com.hasAttribute((Object)"marginalUtilityCost")) {
            this.log.log("processEvalCounteroffer: no marginalUtilityGain in commitment!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "PCReject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        float marginalUtilityCost = ((Float)com.getAttribute((Object)"marginalUtilityCost")).floatValue();
        this.log.log("processEvalCounteroffer: marginalUtilityCost = " + marginalUtilityCost, 0, this.FAC_PS);
        boolean over = (Boolean)com.getAttribute((Object)"ItersOver");
        float negCost = 0.0f;
        Schedule schedSy = this.schedNoMx;
        Distribution dSy = schedSy.getQuality();
        float expectedQualitySy = dSy.calculateAvg();
        Taems auxTaemsMx = (Taems)this.conditioned.clone();
        auxTaemsMx.setScheduleVector(new Vector());
        Method auxM2 = (Method)auxTaemsMx.findNode((Node)m);
        Outcome outc2 = (Outcome)auxM2.getOutcomes().nextElement();
        outc2.setDuration(new Distribution(0.0f, 1.0f));
        outc2.setCost(new Distribution(0.0f, 1.0f));
        int time = (Integer)this.state.getProperty((Object)"Time");
        int comDL = com.getDeadline();
        int comEST = com.getEarliestStartTime();
        int shift = this.negTimeDL - time;
        com.setDeadline(comDL - shift);
        com.setEarliestStartTime(comEST - shift);
        auxTaemsMx.addCommitment(com);
        Taems tSx = this.evaluateTaems(auxTaemsMx, true);
        comDL = com.getDeadline();
        comEST = com.getEarliestStartTime();
        com.setDeadline(comDL + shift);
        com.setEarliestStartTime(comEST + shift);
        Schedule schedSx = tSx.getFirstSchedule();
        ScheduleElement se = schedSx.getNextTask(time);
        schedSx.delayStartTime(se, shift);
        this.schedTb = schedSx;
        Distribution dSx = schedSx.getQuality();
        float expectedQualitySx = dSx.calculateAvg();
        float marginalQuality = expectedQualitySx - expectedQualitySy;
        Outcome outcm = (Outcome)m.getOutcomes().nextElement();
        outcm.setQuality(new Distribution(marginalQuality, 1.0f));
        this.log.log("processImprovePC: changed marginal quality of " + m.getLabel() + " to " + marginalQuality + " new method = " + m.toString(), 2, this.FAC_PS);
        Criteria crit = auxTaemsMx.getScheduleCriteria();
        float qualityGain = (expectedQualitySx - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
        float costGain = (crit.getCostThreshold().floatValue() - schedSx.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
        float durationGain = (crit.getDurationThreshold().floatValue() - schedSx.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
        float utilitySx = qualityGain * crit.getGoodnessQuality().floatValue() + costGain * crit.getGoodnessCost().floatValue() + durationGain * crit.getGoodnessDuration().floatValue();
        float qualityGain1 = (expectedQualitySy - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
        float costGain1 = (crit.getCostThreshold().floatValue() - schedSy.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
        float durationGain1 = (crit.getDurationThreshold().floatValue() - schedSy.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
        float utilitySy = qualityGain1 * crit.getGoodnessQuality().floatValue() + costGain1 * crit.getGoodnessCost().floatValue() + durationGain1 * crit.getGoodnessDuration().floatValue();
        float negotiationCost = 0.0f;
        this.log.log("Utility(Sx) = " + utilitySx, 2, this.FAC_PS);
        this.log.log("Utility(Sy) = " + utilitySy, 2, this.FAC_PS);
        float marginalUtilityGain = utilitySx - utilitySy;
        com.setAttribute((Object)"marginalUtilityGain", (Object)new Float(marginalUtilityGain));
        boolean found = false;
        if (marginalUtilityGain > marginalUtilityCost + negCost) {
            found = true;
        }
        ++this.n;
        if (over && found) {
            evtType = "PCAccept";
            idtype = 1;
        } else {
            evtType = "PCReject";
            idtype = 4096;
        }
        com.setAttribute((Object)"AddACS", (Object)new Boolean(found));
        if (this.n > 10) {
            this.log.log("processEvalCounteroffer: internal counter overflowed, ending negotiation", 0, this.FAC_PS);
            this.log.log("processEvalCounteroffer: ItersOver = " + over + ", found sched = " + found, 0, this.FAC_PS);
            evtType = "PCAccept";
            idtype = 4096;
        }
        Taems ta = new Taems();
        ta.addCommitment(com);
        CoordinateEvent evt = new CoordinateEvent(this, evtType, idtype, ta);
        evt.setCoordinateID(com.getID());
        this.startFireEvent(evt);
    }

    public void processImprovePC(CoordinateEvent e) {
        Taems t = e.getTaems();
        Commitment com = t.getCommitment();
        this.log.log("processImprovePC: improving proposal", 2, this.FAC_PS);
        float negCost = 0.0f;
        if (!com.hasAttribute((Object)"marginalUtilityCost")) {
            this.log.log("processImprovePC: no marginalUtilityCost in commitment!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Redo", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        float marginalUtilityCost = ((Float)com.getAttribute((Object)"marginalUtilityCost")).floatValue();
        Method m = (Method)com.getTask();
        Schedule schedSy = this.schedNoMx;
        Distribution dSy = schedSy.getQuality();
        float expectedQualitySy = dSy.calculateAvg();
        Taems auxTaemsMx = (Taems)this.conditioned.clone();
        auxTaemsMx.setScheduleVector(new Vector());
        Method auxM2 = (Method)auxTaemsMx.findNode((Node)m);
        Outcome outc2 = (Outcome)auxM2.getOutcomes().nextElement();
        outc2.setDuration(new Distribution(0.0f, 1.0f));
        outc2.setCost(new Distribution(0.0f, 1.0f));
        int time = (Integer)this.state.getProperty((Object)"Time");
        int comDL = com.getDeadline();
        int comEST = com.getEarliestStartTime();
        int shift = this.negTimeDL - time;
        com.setDeadline(comDL - shift);
        com.setEarliestStartTime(comEST - shift);
        auxTaemsMx.addCommitment(com);
        Taems tSx = this.evaluateTaems(auxTaemsMx, true);
        comDL = com.getDeadline();
        comEST = com.getEarliestStartTime();
        com.setDeadline(comDL + shift);
        com.setEarliestStartTime(comEST + shift);
        Schedule schedSx = tSx.getFirstSchedule();
        ScheduleElement se = schedSx.getNextTask(time);
        schedSx.delayStartTime(se, shift);
        this.schedTb = schedSx;
        Distribution dSx = schedSx.getQuality();
        float expectedQualitySx = dSx.calculateAvg();
        float marginalQuality = expectedQualitySx - expectedQualitySy;
        Outcome outcm = (Outcome)m.getOutcomes().nextElement();
        outcm.setQuality(new Distribution(marginalQuality, 1.0f));
        this.log.log("processImprovePC: changed marginal quality of " + m.getLabel() + " to " + marginalQuality + " new method = " + m.toString(), 2, this.FAC_PS);
        Criteria crit = auxTaemsMx.getScheduleCriteria();
        float qualityGain = (expectedQualitySx - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
        float costGain = (crit.getCostThreshold().floatValue() - schedSx.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
        float durationGain = (crit.getDurationThreshold().floatValue() - schedSx.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
        float utilitySx = qualityGain * crit.getGoodnessQuality().floatValue() + costGain * crit.getGoodnessCost().floatValue() + durationGain * crit.getGoodnessDuration().floatValue();
        float qualityGain1 = (expectedQualitySy - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
        float costGain1 = (crit.getCostThreshold().floatValue() - schedSy.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
        float durationGain1 = (crit.getDurationThreshold().floatValue() - schedSy.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
        float utilitySy = qualityGain1 * crit.getGoodnessQuality().floatValue() + costGain1 * crit.getGoodnessCost().floatValue() + durationGain1 * crit.getGoodnessDuration().floatValue();
        float negotiationCost = 0.0f;
        this.log.log("Utility(Sx) = " + utilitySx, 2, this.FAC_PS);
        this.log.log("Utility(Sy) = " + utilitySy, 2, this.FAC_PS);
        float marginalUtilityGain = utilitySx - utilitySy;
        com.setAttribute((Object)"marginalUtilityGain", (Object)new Float(marginalUtilityGain));
        if (marginalUtilityGain <= marginalUtilityCost + negCost) {
            Taems ta = new Taems();
            ta.addCommitment(com);
            CoordinateEvent evt = new CoordinateEvent(this, "Redo", 4096, ta);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
        } else {
            Taems ta = new Taems();
            ta.addCommitment(com);
            CoordinateEvent evt = new CoordinateEvent(this, "NextPC", 16, ta);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
        }
    }

    private ScheduleElement findSched(Commitment com, Enumeration scheds, float negCost) {
        this.log.log("findSched: starting", 2, this.FAC_PS);
        if (!scheds.hasMoreElements()) {
            this.log.log("findSched: no schedules passed!", 0, this.FAC_PS);
            return null;
        }
        TaskBase tb = (TaskBase)com.getTaskVector().elementAt(0);
        this.log.log("findSched: got taskbase " + tb.getLabel(), 2, this.FAC_PS);
        Method m = null;
        if (tb instanceof Method) {
            m = (Method)com.getTaskVector().elementAt(0);
        } else {
            this.log.log("findSched: this taskbase is not a method: " + tb.toString(), 0, this.FAC_PS);
            System.exit(0);
        }
        Outcome outcM = (Outcome)m.getOutcomes().nextElement();
        float marginalQualityM = outcM.getQuality().calculateAvg();
        this.log.log("findSched: got " + m.getLabel(), 2, this.FAC_PS);
        this.log.log("findSched: marginal quality of " + m.getLabel() + " is " + marginalQualityM, 2, this.FAC_PS);
        float marginalUtilityGain = ((Float)com.getAttribute((Object)"marginalUtilityGain")).floatValue();
        ScheduleElement schedEl = null;
        ScheduleElement minSchedEl = null;
        int ii = 0;
        float minMarginalUtilityCost = 0.0f;
        boolean minSet = true;
        while (scheds.hasMoreElements()) {
            this.log.log("findSched: checking schedule " + ii, 2, this.FAC_PS);
            Schedule sched = (Schedule)scheds.nextElement();
            String schedName = "sched" + ++ii;
            try {
                File outputFile2 = new File(schedName);
                FileWriter out2 = new FileWriter(outputFile2);
                out2.write(sched.toString());
            }
            catch (IOException e) {
                this.log.log("IOException", 2, this.FAC_PS);
            }
            int time = (Integer)this.state.getProperty((Object)"Time");
            ScheduleElement se = sched.getNextTask(time);
            sched.delayStartTime(se, this.negTimeDL - time);
            Enumeration schedEls = sched.getElements();
            boolean mNotFound = true;
            while (schedEls.hasMoreElements() && mNotFound) {
                schedEl = (ScheduleElement)schedEls.nextElement();
                Method auxM = schedEl.getMethod();
                if (!m.getLabel().equals(auxM.getLabel())) continue;
                this.log.log("findSched: found a nonlocal " + auxM.getLabel(), 2, this.FAC_PS);
                mNotFound = false;
                break;
            }
            if (mNotFound) continue;
            Distribution dTbs = sched.getQuality();
            float expectedQualitySv = dTbs.calculateAvg();
            this.log.log("findSched: expectedQualitySv = " + expectedQualitySv, 2, this.FAC_PS);
            this.log.log("findSched: Starting new iteration", 2, this.FAC_PS);
            float qualitySvMx = expectedQualitySv - marginalQualityM;
            Criteria crit = this.conditioned.getScheduleCriteria();
            float qualityGain = (qualitySvMx - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
            float costGain = (crit.getCostThreshold().floatValue() - sched.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
            float durationGain = (crit.getDurationThreshold().floatValue() - sched.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
            float utilitySvMx = qualityGain * crit.getGoodnessQuality().floatValue() + costGain * crit.getGoodnessCost().floatValue() + durationGain * crit.getGoodnessDuration().floatValue();
            Distribution dTb = this.schedTb.getQuality();
            float expectedQualityTb = dTb.calculateAvg();
            float qualityGain1 = (expectedQualityTb - crit.getQualityThreshold().floatValue()) / crit.getQualityThreshold().floatValue();
            float costGain1 = (crit.getCostThreshold().floatValue() - this.schedTb.getCost().calculateAvg()) / crit.getCostThreshold().floatValue();
            float durationGain1 = (crit.getDurationThreshold().floatValue() - this.schedTb.getDuration().calculateAvg()) / crit.getDurationThreshold().floatValue();
            float utilityTb = qualityGain1 * crit.getGoodnessQuality().floatValue() + costGain1 * crit.getGoodnessCost().floatValue() + durationGain1 * crit.getGoodnessDuration().floatValue();
            float marginalUtilityCost = utilityTb - utilitySvMx;
            if (minSet) {
                minSet = false;
                minMarginalUtilityCost = marginalUtilityCost;
                minSchedEl = schedEl;
                com.setAttribute((Object)"marginalUtilityCost", (Object)new Float(marginalUtilityCost));
            } else if (marginalUtilityCost < minMarginalUtilityCost) {
                minMarginalUtilityCost = marginalUtilityCost;
                this.log.log("findSched: new minMarginalUtilityCost = " + minMarginalUtilityCost, 2, this.FAC_PS);
                minSchedEl = schedEl;
                com.setAttribute((Object)"marginalUtilityCost", (Object)new Float(marginalUtilityCost));
            }
            this.log.log("findSched: goodness quality = " + crit.getGoodnessQuality().floatValue(), 2, this.FAC_PS);
            this.log.log("findSched: goodness cost = " + crit.getGoodnessCost().floatValue(), 2, this.FAC_PS);
            this.log.log("findSched: goodness duration = " + crit.getGoodnessDuration().floatValue(), 2, this.FAC_PS);
            this.log.log("findSched: quality threshold = " + crit.getQualityThreshold().floatValue(), 2, this.FAC_PS);
            this.log.log("findSched: cost limit = " + crit.getCostThreshold().floatValue(), 2, this.FAC_PS);
            this.log.log("findSched: duration limit = " + crit.getDurationThreshold().floatValue(), 2, this.FAC_PS);
            this.log.log("findSched: utilitySvMx = " + utilitySvMx, 2, this.FAC_PS);
            this.log.log("findSched: utilityTb = " + utilityTb, 2, this.FAC_PS);
            this.log.log("findSched: marginalUtilityCost = " + marginalUtilityCost, 2, this.FAC_PS);
        }
        this.log.log("findSched: minMarginalUtilityCost = " + minMarginalUtilityCost, 2, this.FAC_PS);
        this.log.log("findSched: marginalUtilityGain = " + marginalUtilityGain, 2, this.FAC_PS);
        if (minMarginalUtilityCost + negCost < marginalUtilityGain) {
            this.log.log("findSched: marginalUtilityCost < marginalUtilityGain", 2, this.FAC_PS);
            this.log.log("findSched: minSchedEl is " + minSchedEl.toString(), 2, this.FAC_PS);
        } else {
            this.log.log("findSched: setting minSchedEl to null", 2, this.FAC_PS);
            minSchedEl = null;
        }
        return minSchedEl;
    }

    public void processEvalPCoffer(CoordinateEvent e) {
        int idtype;
        String evtType;
        this.log.log("processEvalPCoffer: starting", 2, this.FAC_PS);
        Taems t = e.getTaems();
        Commitment com = t.getCommitment();
        float marginalUtilityGain = 0.0f;
        if (!com.hasAttribute((Object)"marginalUtilityGain")) {
            this.log.log("processEvalPCoffer: no marginalUtilityGain in commitment!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "PCReject", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        marginalUtilityGain = ((Float)com.getAttribute((Object)"marginalUtilityGain")).floatValue();
        this.log.log("processEvalPCoffer: marginalUtilityGain = " + marginalUtilityGain, 0, this.FAC_PS);
        boolean satPC = true;
        Method m = (Method)com.getTask();
        Taems tBs = (Taems)this.conditioned.clone();
        Task oldRoot = tBs.getNode();
        if (!oldRoot.getLabel().equals("TbS")) {
            Task newRoot = new Task();
            newRoot.setLabel("TbS");
            tBs.removeNode((Node)oldRoot);
            tBs.addNode((Node)newRoot);
            SumQAF qaf = new SumQAF();
            newRoot.setQAF((QAF)qaf);
            newRoot.addSubtask((TaskBase)oldRoot);
            newRoot.addSubtask((TaskBase)((Method)m.clone()));
            Task root = this.conditioned.getNode();
            if (root.getLabel().equals("TbS")) {
                this.log.log("processEvalPCoffer: conditioned got TbS !", 0, this.FAC_PS);
            }
        } else {
            this.log.log("processEvalPCoffer: conditioned.clone already has TbS !", 0, this.FAC_PS);
            Method auxM = (Method)tBs.findNode((Node)m);
            auxM = m;
        }
        int time = (Integer)this.state.getProperty((Object)"Time");
        int comDL = com.getDeadline();
        int comEST = com.getEarliestStartTime();
        int shift = this.negTimeDL - time;
        com.setDeadline(comDL - shift);
        com.setEarliestStartTime(comEST - shift);
        tBs.addCommitment(com);
        tBs.setScheduleVector(new Vector());
        Taems tBsSch = this.evaluateTaems(tBs, true);
        Enumeration scheds = tBsSch.getSchedules();
        ScheduleElement schedEl = null;
        comDL = com.getDeadline();
        comEST = com.getEarliestStartTime();
        com.setDeadline(comDL + shift);
        com.setEarliestStartTime(comEST + shift);
        if (scheds.hasMoreElements()) {
            schedEl = this.findSched(com, scheds, 0.0f);
        }
        if (schedEl != null) {
            satPC = false;
        }
        if (satPC) {
            evtType = "PCReject";
            idtype = 4096;
        } else {
            evtType = "PCAccept";
            idtype = 1;
        }
        Taems ta = new Taems();
        ta.addCommitment(com);
        CoordinateEvent evt = new CoordinateEvent(this, evtType, idtype, ta);
        evt.setCoordinateID(com.getID());
        this.startFireEvent(evt);
    }

    public void processRefinePC(CoordinateEvent e) {
        Taems t = e.getTaems();
        Commitment com = t.getCommitment();
        this.log.log("processRefinePC: creating counteroffer", 2, this.FAC_PS);
        if (!com.hasAttribute((Object)"marginalUtilityGain")) {
            this.log.log("processRefinePC: no marginalUtilityGain in commitment!" + com, 0, this.FAC_PS);
            CoordinateEvent evt = new CoordinateEvent(this, "Redo", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
            return;
        }
        Method m = (Method)com.getTask();
        this.log.log("processRefinePC: m from com " + m.toString(), 2, this.FAC_PS);
        Taems tBs = (Taems)this.conditioned.clone();
        Task oldRoot = tBs.getNode();
        if (!oldRoot.getLabel().equals("TbS")) {
            Task newRoot = new Task();
            newRoot.setLabel("TbS");
            tBs.removeNode((Node)oldRoot);
            tBs.addNode((Node)newRoot);
            SumQAF qaf = new SumQAF();
            newRoot.setQAF((QAF)qaf);
            newRoot.addSubtask((TaskBase)oldRoot);
            newRoot.addSubtask((TaskBase)((Method)m.clone()));
            Task root = this.conditioned.getNode();
            if (root.getLabel().equals("TbS")) {
                this.log.log("processRefinePC: conditioned got TbS !", 0, this.FAC_PS);
            }
        } else {
            this.log.log("processRefinePC: conditioned.clone already has TbS !", 0, this.FAC_PS);
        }
        int time = (Integer)this.state.getProperty((Object)"Time");
        int comDL = com.getDeadline();
        int comEST = com.getEarliestStartTime();
        int shift = this.negTimeDL - time;
        com.setDeadline(comDL - shift);
        com.setEarliestStartTime(comEST - shift);
        tBs.addCommitment(com);
        this.log.log("processRefinePC: m from tBs " + ((Method)tBs.findNode((Node)m)).toString(), 0, this.FAC_PS);
        tBs.setScheduleVector(new Vector());
        Taems tBsSch = this.evaluateTaems(tBs, true);
        Enumeration scheds = tBsSch.getSchedules();
        ScheduleElement schedEl = null;
        comDL = com.getDeadline();
        comEST = com.getEarliestStartTime();
        com.setDeadline(comDL + shift);
        com.setEarliestStartTime(comEST + shift);
        if (scheds.hasMoreElements()) {
            schedEl = this.findSched(com, scheds, 0.0f);
        }
        if (schedEl == null) {
            CoordinateEvent evt = new CoordinateEvent(this, "Redo", 4096, t);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
        } else {
            Vector<Method> v = new Vector<Method>();
            v.addElement(schedEl.getMethod());
            com.setTaskVector(v);
            com.setEarliestStartTime(schedEl.getStart());
            com.setDeadline(schedEl.getFinish());
            Taems ta = new Taems();
            ta.addCommitment(com);
            CoordinateEvent evt = new CoordinateEvent(this, "Counter", 16, ta);
            evt.setCoordinateID(com.getID());
            this.startFireEvent(evt);
        }
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 2, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
        boolean typeFound = false;
        if (e.getType().equals("EvalCounteroffer")) {
            this.log.log("commitmentEventReceived type EvalCounteroffer" + e.getID(), 2, this.FAC_PS);
            this.processEvalCounteroffer(e);
            typeFound = true;
        }
        if (e.getType().equals("ImprovePC")) {
            this.log.log("commitmentEventReceived type ImprovePC" + e.getID(), 2, this.FAC_PS);
            this.processImprovePC(e);
            typeFound = true;
        }
        if (e.getType().equals("EvalPCoffer")) {
            this.log.log("commitmentEventReceived type EvalPCoffer" + e.getID(), 2, this.FAC_PS);
            this.processEvalPCoffer(e);
            typeFound = true;
        }
        if (e.getType().equals("RefinePC")) {
            this.log.log("commitmentEventReceived type RefinePC" + e.getID(), 2, this.FAC_PS);
            this.processRefinePC(e);
            typeFound = true;
        }
        if (e.getType().equals("Accepted")) {
            this.log.log("commitmentEventReceived type Accepted" + e.getID(), 2, this.FAC_PS);
            typeFound = true;
        }
        if (!typeFound) {
            this.log.log("commitmentEventReceived type Unknown: " + e.getID(), 2, this.FAC_PS);
        }
    }
}

