/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.FSMCoordination;
import agent.gpgp2.GPGPController;
import agent.gpgp2.GPGPEvent;
import agent.gpgp2.GPGPEventListener;
import agent.gpgp2.GPGPEventProducer;
import agent.mass.SimpleTaemsReader;
import agent.simplest.Log;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Criteria;
import taems.MLCSchedule;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import taems.TaskBase;
import utilities.Distribution;

public abstract class GPGPMech
implements CoordinateEventListener,
CoordinateEventProducer,
GPGPEventProducer {
    int negStartTime = 0;
    float noCommIniUtility = 0.0f;
    float commIniUtility = 0.0f;
    float origRespUtility = 0.0f;
    float commRespUtility = 0.0f;
    float noCommIniQuality = 0.0f;
    float commIniQuality = 0.0f;
    float combOrigUtility = 0.0f;
    float combCommUtility = 0.0f;
    float combMargUtility = 0.0f;
    int negDuration = 0;
    boolean imLeader = false;
    protected Schedule currSchedule = null;
    protected Taems conditional = null;
    protected UtilQualPair condWoComm = null;
    protected String condKey;
    protected Agent localAgent = null;
    protected Criteria crit = null;
    protected int FAC_GPGPMECH;
    protected State state;
    protected Log log;
    public String name = new String("Generic GPGPMech");
    protected String negMethName;
    protected CoordinateEvent initCoordEvent = null;
    protected Commitment initComm = null;
    protected Commitment finalComm = null;
    protected TaskBase nlm = null;
    protected long cid = 0L;
    protected Long CID = null;
    protected int iters = 0;
    protected ListenerVector listeners = new ListenerVector();
    protected ListenerVector gpgpListeners = new ListenerVector();
    protected FSMCoordination fsmCoordinate;
    boolean conditionalUpdate = false;
    GPGPController gpgpController;
    private boolean ev_firing = false;
    private Vector ev_queue = new Vector();
    private Integer ev_lock = new Integer(0);
    private boolean gpgpFiring = false;
    private Vector gpgpQueue = new Vector();
    private Integer gpgpLock = new Integer(0);

    public GPGPMech(GPGPController gpgpController, TaskBase nlm, CoordinateEvent ce, String condKey) {
        this.assignName();
        this.nlm = nlm;
        this.condKey = condKey;
        this.gpgpController = gpgpController;
        if (gpgpController == null) {
            System.err.println("GPGPMech constructor: No GPGP controller found ! Quitting");
            return;
        }
        this.state = gpgpController.getState();
        this.log = gpgpController.getLog();
        this.FAC_GPGPMECH = gpgpController.getFAC_ID();
        this.addGPGPEventListener(gpgpController);
        if (nlm == null) {
            this.log.log("GPGPMech.constructor: no nonlocal method passed !", 0, this.FAC_GPGPMECH);
            this.log.log("GPGPMech.constructor: " + this.name + " GPGP mechanism quits !", 0, this.FAC_GPGPMECH);
            return;
        }
        if (ce == null) {
            this.log.log("GPGPMech.constructor: no coord evt passed !", 0, this.FAC_GPGPMECH);
            this.log.log("GPGPMech.constructor: " + this.name + " GPGP mechanism quits !", 0, this.FAC_GPGPMECH);
            return;
        }
        this.negMethName = ce.getTaems().getLabel();
        this.conditional = this.getCondTaems(condKey);
        if (this.conditional == null) {
            this.log.log("GPGPMech.constructor: no taems struc in CONTAEMS ht with key " + condKey + " !", 0, this.FAC_GPGPMECH);
            this.log.log("GPGPMech.constructor: " + this.name + " GPGP mechanism quits !", 0, this.FAC_GPGPMECH);
            return;
        }
        this.nlm = (TaskBase)this.conditional.findNode((Node)new TaskBase(nlm.getLabel(), nlm.getAgent()));
        this.currSchedule = this.conditional.getFirstSchedule();
        this.crit = this.conditional.getScheduleCriteria();
        this.localAgent = this.conditional.getAgent();
        if (this.currSchedule == null) {
            this.log.log("GPGPMech.constructor: taems struc with no schedules passed in coord event", 0, this.FAC_GPGPMECH);
            this.log.log("GPGPMech.constructor: " + this.name + " GPGP mechanism quits !", 0, this.FAC_GPGPMECH);
            return;
        }
        if (this.crit == null) {
            this.log.log("GPGPMech.constructor: no scheduler criteria passed !", 0, this.FAC_GPGPMECH);
            this.log.log("GPGPMech.constructor: " + this.name + " GPGP mechanism quits !", 0, this.FAC_GPGPMECH);
            return;
        }
        this.fsmCoordinate = gpgpController.getFSMCoordination();
        this.log.log("GPGPMech.constructor: about to bind fsmCoordinate", 1, this.FAC_GPGPMECH);
        if (this.fsmCoordinate != null) {
            this.fsmCoordinate.addCoordinateEventListener(this);
            this.log.log("Using FSMCoordination bean", 0, this.FAC_GPGPMECH);
        } else {
            this.log.log("Not using the default FSMCoordination bean", 0, this.FAC_GPGPMECH);
        }
        if (ce != null) {
            this.cid = ce.getCoordinateID();
            this.CID = new Long(this.cid);
            if (ce.getType().startsWith("StartInit")) {
                this.imLeader = true;
                this.log.log("GPGPMech.constructor: about to run getInitCoordEvt", 1, this.FAC_GPGPMECH);
                CoordinateEvent ce2 = this.getInitCoordEvt();
                if (ce2 == null) {
                    this.log.log("GPGPMech.constructor: no init coord evt formed !", 0, this.FAC_GPGPMECH);
                    this.log.log("GPGPMech.constructor: " + this.name + " GPGP mechanism quits !", 0, this.FAC_GPGPMECH);
                    this.stopOperation();
                    return;
                }
                this.startFireEvent(ce2);
            } else if (ce.getType().startsWith("StartResp")) {
                this.imLeader = false;
                ce.setType("StartedResp");
                ce.setID(0);
                if (this.fsmCoordinate != null) {
                    this.startFireEvent(ce);
                }
            }
        } else {
            this.log.log("GPGPMech.constructor: no coord evt passed !", 0, this.FAC_GPGPMECH);
            this.log.log("GPGPMech.constructor: " + this.name + " GPGP mechanism quits !", 0, this.FAC_GPGPMECH);
            this.stopOperation();
        }
    }

    protected abstract void assignName();

    public abstract Taems enforceModAccept(Taems var1);

    protected Taems evaluateTaems(Taems t, boolean rescheduling) {
        Taems ta = null;
        if (this.gpgpController != null) {
            ta = this.gpgpController.evaluateTaems(t, rescheduling);
            Schedule s = ta.getFirstSchedule();
            Enumeration e = s.getElements();
        } else {
            System.out.println("No GPGP controller found !");
            ta = new Taems();
        }
        return ta;
    }

    protected abstract CoordinateEvent getInitCoordEvt();

    protected abstract UtilQualPair getUtilQualWoComm(Taems var1, Method var2);

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    public void coordinateEventSent(CoordinateEvent e) {
    }

    protected abstract void processAccepted(CoordinateEvent var1);

    protected abstract void processRejectedFrmResp(CoordinateEvent var1);

    public void coordinateEventReceived(CoordinateEvent e) {
        if (e.getCoordinateID() == null) {
            this.log.log("commitmentEventReceived: no coordinate ID in " + (Object)((Object)e), 0, this.FAC_GPGPMECH);
            return;
        }
        if (e.getCoordinateID() != this.cid) {
            this.log.log("commitmentEventReceived: coordinate ID of " + (Object)((Object)e) + " does not match " + this.cid, 1, this.FAC_GPGPMECH);
            return;
        }
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 2, this.FAC_GPGPMECH);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_GPGPMECH);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_GPGPMECH);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_GPGPMECH);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_GPGPMECH);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_GPGPMECH);
            }
        }
        if (e.getType().equals("AbortGPGPMechFrmContr")) {
            this.log.log("commitmentEventReceived type AbortGPGPMechFrmContr" + e.getID(), 2, this.FAC_GPGPMECH);
            this.processAbortGPGPMechFrmContr(e);
            this.stopOperation();
            return;
        }
        if (e.getType().equals("AbortGPGPMechFrmFSM")) {
            this.log.log("commitmentEventReceived type AbortGPGPMechFrmFSM" + e.getID(), 2, this.FAC_GPGPMECH);
            this.processAbortGPGPMechFrmFSM(e);
            this.stopOperation();
            return;
        }
        if (e.getType().equals("Accepted") && this.imLeader) {
            this.log.log("commitmentEventReceived type Accepted" + e.getID(), 2, this.FAC_GPGPMECH);
            this.processAccepted(e);
            this.stopOperation();
        }
        if (e.getType().equals("RejectedFrmResp") && this.imLeader) {
            this.log.log("commitmentEventReceived type RejectedFrmResp" + e.getID(), 2, this.FAC_GPGPMECH);
            this.processRejectedFrmResp(e);
            this.stopOperation();
        }
        this.processEventReceived(e);
    }

    protected void processAbortGPGPMechFrmContr(CoordinateEvent ce) {
        if (this.imLeader) {
            Taems woComm = this.getUtilQualWoComm(this.conditional, (Method)this.nlm).getTaems();
            if (woComm == null) {
                woComm = this.getCondTaems(this.condKey);
            }
            GPGPEvent ge = new GPGPEvent(this, this.negMethName, "NegAborted", 0, woComm, this.imLeader);
            ge.setCoordinateID(this.cid);
            this.gpgpEventSent(ge);
        } else {
            Taems infoTaems = new Taems();
            infoTaems.addCommitment(this.initComm);
            ce.setTaems(infoTaems);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
        }
    }

    protected void processAbortGPGPMechFrmFSM(CoordinateEvent ce) {
        Taems condWo;
        Taems cond = this.getCondTaems(this.condKey);
        if (this.imLeader && (condWo = this.getUtilQualWoComm(cond, (Method)this.nlm).getTaems()) != null) {
            cond = condWo;
        }
        GPGPEvent ge = new GPGPEvent(this, this.negMethName, "NegAborted", 0, cond, this.imLeader);
        ge.setCoordinateID(this.cid);
        if (this.imLeader) {
            String resultsString = this.getName() + ",Abort, iters = " + String.valueOf(this.iters) + ", combined util w/o commitment =" + String.valueOf(this.combOrigUtility) + ", combined util w/ commitment = " + String.valueOf(this.combCommUtility) + ", combined marginal util = " + String.valueOf(this.combMargUtility) + ", negotiation duration = " + String.valueOf(this.negDuration);
            ge.setResults(resultsString);
        }
        this.gpgpEventSent(ge);
    }

    protected void negAccept(CoordinateEvent ce, boolean modified, String resultsString) {
        GPGPEvent ge = new GPGPEvent(this, this.negMethName, "NegAccepted", 0, this.getCondTaems(this.condKey), modified);
        ge.setCoordinateID(this.cid);
        ge.setResults(resultsString);
        this.gpgpEventSent(ge);
    }

    protected void negReject(CoordinateEvent ce, boolean modified, String resultsString) {
        Taems condWo;
        Taems cond = this.getCondTaems(this.condKey);
        if (this.imLeader && (condWo = this.getUtilQualWoComm(cond, (Method)this.nlm).getTaems()) != null) {
            cond = condWo;
        }
        GPGPEvent ge = new GPGPEvent(this, this.negMethName, "NegRejected", 0, cond, modified);
        ge.setCoordinateID(this.cid);
        ge.setResults(resultsString);
        this.gpgpEventSent(ge);
    }

    protected abstract void processEventReceived(CoordinateEvent var1);

    public String getName() {
        return this.name;
    }

    protected void startFireEvent(AgentEvent event) {
        this.ev_queue.addElement(event);
        if (this.ev_firing) {
            return;
        }
        Integer n = this.ev_lock;
        synchronized (n) {
            int time = (Integer)this.state.getProperty((Object)"Time");
            event.setTime(time);
            this.ev_firing = true;
            while (!this.ev_queue.isEmpty()) {
                AgentEvent ev = (AgentEvent)this.ev_queue.firstElement();
                this.ev_queue.removeElement(ev);
                this.fireEvent(ev);
            }
            this.ev_firing = false;
        }
    }

    private void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Enumeration enumeration = this.listeners.elements();
        this.log.log("GPGPMech component firing a coordinate event", 0, this.FAC_GPGPMECH);
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            if (e.wasReceived()) {
                l.coordinateEventReceived(e);
                break;
            }
            if (!e.wasSent()) continue;
            l.coordinateEventSent(e);
            break;
        }
        this.log.log("GPGPMech component fired a coordinate event", 0, this.FAC_GPGPMECH);
    }

    protected void stopOperation() {
        Enumeration listenersEnum = this.listeners.elements();
        while (listenersEnum.hasMoreElements()) {
            Object listEl = listenersEnum.nextElement();
            if (!(listEl instanceof CoordinateEventProducer)) continue;
            ((CoordinateEventProducer)listEl).removeCoordinateEventListener(this);
        }
    }

    public Taems getCondTaemsOf(TaskBase m) {
        Hashtable ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
        Taems t1 = (Taems)ht.get(this.condKey);
        if (t1 == null) {
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Taems t = (Taems)ht.get(key);
                if (t.findNode((Node)m) == null) continue;
                this.condKey = key;
                this.conditional = (Taems)t.clone();
                return this.conditional;
            }
            return null;
        }
        this.conditional = (Taems)t1.clone();
        return t1;
    }

    protected Schedule getCurrSchedule() {
        this.currSchedule = (Schedule)this.state.getProperty((Object)"Schedule");
        return this.currSchedule;
    }

    protected Taems getCondTaems(String key) {
        Hashtable ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
        Taems origCond = (Taems)ht.get(key);
        this.conditional = (Taems)origCond.clone();
        return this.conditional;
    }

    protected float getSimpleQuality(Schedule s) {
        if (s == null) {
            this.log.log("GPGPMech.getSimpleQuality: null schedule passed", 1, this.FAC_GPGPMECH);
            return 0.0f;
        }
        float quality = 0.0f;
        Enumeration e = s.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement schElement = (ScheduleElement)e.nextElement();
            Method m = schElement.getMethod();
            if (m == null) {
                this.log.log("GPGPMech.getSimpleQuality: null method in a schedule element " + schElement.getLabel(), 1, this.FAC_GPGPMECH);
                continue;
            }
            Outcome outc = m.getMostLikelyOutcome();
            if (outc == null) {
                this.log.log("GPGPMech.getSimpleQuality: null outcome in method " + m.getLabel(), 1, this.FAC_GPGPMECH);
                continue;
            }
            Distribution qual = outc.getQuality();
            quality += qual.calculateAvg();
        }
        return quality;
    }

    protected float calcUtility(float quality, Schedule s) {
        if (s == null || s.getCost() == null || s.getDuration() == null) {
            return 0.0f;
        }
        float qualThresh = 1.0f;
        if (this.crit.getQualityThreshold().floatValue() != 0.0f) {
            qualThresh = this.crit.getQualityThreshold().floatValue();
        } else {
            this.log.log("GPGPMech.calcUtility: crit.getQualityThreshold().floatValue() is 0, dividing by 1 instead", 1, this.FAC_GPGPMECH);
        }
        float costThresh = 1.0f;
        if (this.crit.getCostThreshold().floatValue() != 0.0f) {
            costThresh = this.crit.getCostThreshold().floatValue();
        } else {
            this.log.log("GPGPMech.calcUtility: crit.getCostThreshold().floatValue() is 0, dividing by 1 instead", 1, this.FAC_GPGPMECH);
        }
        float durThresh = 1.0f;
        if (this.crit.getDurationThreshold().floatValue() != 0.0f) {
            durThresh = this.crit.getDurationThreshold().floatValue();
        } else {
            this.log.log("GPGPMech.calcUtility: crit.getDurationThreshold().floatValue() is 0, dividing by 1 instead", 1, this.FAC_GPGPMECH);
        }
        float qualityGain = quality / qualThresh;
        float costGain = (this.crit.getCostThreshold().floatValue() - s.getCost().calculateAvg()) / costThresh;
        float durationGain = (this.crit.getDurationThreshold().floatValue() - s.getDuration().calculateAvg()) / durThresh;
        float utility = qualityGain * this.crit.getGoodnessQuality().floatValue() + costGain * this.crit.getGoodnessCost().floatValue() + durationGain * this.crit.getGoodnessDuration().floatValue();
        return utility;
    }

    protected ScheduleElement findSchedEl(Method m, Schedule s) {
        if (s instanceof MLCSchedule) {
            return ((MLCSchedule)s).getScheduleElement(m.getLabel());
        }
        Vector schedEls = s.getScheduleElements();
        int i = 0;
        while (i < schedEls.size()) {
            ScheduleElement schedEl = (ScheduleElement)schedEls.elementAt(i);
            if (schedEl.getMethod().getLabel().equals(m.getLabel())) {
                return schedEl;
            }
            ++i;
        }
        return null;
    }

    private int getTime() {
        return (Integer)this.state.getProperty((Object)"Time");
    }

    public void addGPGPEventListener(GPGPEventListener l) {
        this.gpgpListeners.add((AgentListener)l);
    }

    public void removeGPGPEventListener(GPGPEventListener l) {
        this.gpgpListeners.remove((AgentListener)l);
    }

    public void gpgpEventSent(GPGPEvent e) {
        this.gpgpQueue.addElement(e);
        if (this.gpgpFiring) {
            return;
        }
        Integer n = this.gpgpLock;
        synchronized (n) {
            int time = this.getTime();
            e.setTime(time);
            this.gpgpFiring = true;
            while (!this.gpgpQueue.isEmpty()) {
                GPGPEvent ev = (GPGPEvent)((Object)this.gpgpQueue.firstElement());
                this.gpgpQueue.removeElement((Object)ev);
                Enumeration gpgpListenersEnum = this.gpgpListeners.elements();
                while (gpgpListenersEnum.hasMoreElements()) {
                    GPGPEventListener listener = (GPGPEventListener)gpgpListenersEnum.nextElement();
                    listener.gpgpEventReceived(ev);
                }
            }
            this.gpgpFiring = false;
        }
    }

    class UtilQualPair {
        private float utility;
        private float quality;
        private Taems taems;

        public UtilQualPair(float utility, float quality, Taems taems) {
            this.utility = utility;
            this.quality = quality;
            this.taems = taems;
        }

        public float getUtility() {
            return this.utility;
        }

        public float getQuality() {
            return this.quality;
        }

        public Taems getTaems() {
            return this.taems;
        }
    }
}

