/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.base.AgentEvent;
import taems.Taems;

public class GPGPEvent
extends AgentEvent {
    public static final int RECEIVED = 0x100000;
    public static final int SENT = 0;
    public static final int RMASK = 69905;
    public static final int ACCEPTED = 1;
    public static final int POSED = 16;
    public static final int CANCELED = 256;
    public static final int REJECTED = 4096;
    public static final int TIMEOUT = 65536;
    protected Long coordinateID;
    protected Taems data;
    protected String type;
    protected String sourceName;
    protected String results = null;
    protected boolean strucModified = false;

    public GPGPEvent(Object source, int id) {
        super(source, id);
    }

    public GPGPEvent(Object source, int id, Taems taems) {
        this(source, id);
        this.setTaems(taems);
    }

    public GPGPEvent(Object source, String sourceName, String t, int id, Taems taems, boolean modified) {
        this(source, id, taems);
        this.setType(t);
        this.sourceName = sourceName;
        this.strucModified = modified;
    }

    public Taems getTaems() {
        return this.data;
    }

    public boolean isTaemsModified() {
        return this.strucModified;
    }

    public void setTaems(Taems t) {
        this.data = t;
    }

    public void setResults(String r) {
        this.results = r;
    }

    public Long getCoordinateID() {
        return this.coordinateID;
    }

    public void setCoordinateID(long l) {
        this.coordinateID = new Long(l);
    }

    public void setCoordinateID(Long l) {
        this.coordinateID = l;
    }

    public String getType() {
        return this.type;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getResults() {
        return this.results;
    }

    public void setType(String s) {
        this.type = s;
    }

    public int getID() {
        return super.getID() & 0x11111;
    }

    public boolean wasReceived() {
        return (super.getID() & 0x100000) != 0;
    }

    public boolean wasSent() {
        return !this.wasReceived();
    }

    public String toString() {
        return "(CoordinateEvent) " + this.getID() + ":" + this.getType() + ":" + this.getCoordinateID() + " " + this.data.toString();
    }
}

