/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.FSMCoordination;
import agent.gpgp2.GPGPEvent;
import agent.gpgp2.GPGPEventListener;
import agent.gpgp2.GPGPMech;
import agent.gpgp2.SEGPGPMech;
import agent.mass.Execute;
import agent.mass.ProblemSolver;
import agent.mass.Scheduler;
import agent.mass.SimpleTaemsReader;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.Log;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Criteria;
import taems.EnablesInterrelationship;
import taems.ExactlyOneQAF;
import taems.FacilitatesInterrelationship;
import taems.Interrelationship;
import taems.MLCSchedule;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.QAF;
import taems.Schedule;
import taems.ScheduleElement;
import taems.SeqMinQAF;
import taems.SumAllQAF;
import taems.Taems;
import taems.Task;
import taems.TaskBase;
import taems.VirtualTaskBase;
import utilities.Distribution;

public class GPGPController
extends ProblemSolver
implements PropertyEventListener,
CoordinateEventListener,
CoordinateEventProducer,
GPGPEventListener {
    protected Scheduler scheduler;
    protected Vector schedule;
    protected Vector scheduleList;
    protected int TIMEOUT = 5;
    protected FSMCoordination fsmCoordinate;
    protected Execute execute;
    protected ListenerVector listeners = new ListenerVector();
    protected float singleShotQualFactor = 0.01f;
    protected float twoShotQualFactor = 0.011f;
    protected float multShotQualFactor = 0.013f;
    protected float singleShotProb = 0.5f;
    protected float twoShotProb = 0.6f;
    protected float multShotProb = 0.7f;
    protected String metaRootSuffix = "_Metalevel";
    protected static final String metaNegNamePrefix = "GPGPMetaNeg";
    protected static final String reqNegNamePrefix = "GPGPReqNeg";
    protected static final String negTaskNamePrefix = "GPGPNegFor";
    protected static final String enableTaskNamePrefix = "Enable";
    protected static final String facilitateTaskNamePrefix = "Facilitate";
    protected static final String taTaskNamePrefix = "TA";
    protected static final String singleShotNamePrefix = "SingleShot";
    protected static final String twoShotNamePrefix = "TwoShot";
    protected static final String multShotNamePrefix = "MultipleShot";
    protected Hashtable negMechActions = new Hashtable(10);
    protected Hashtable negMechActionCIDs = new Hashtable(10);
    protected Hashtable negMechCIDActions = new Hashtable(10);
    protected Hashtable respNegMethCEs = new Hashtable(10);
    protected Hashtable nlmActions = new Hashtable(10);
    protected Hashtable nlmKnownNames = new Hashtable(10);
    protected Hashtable gpgpContrActions = new Hashtable(10);
    protected SimpleTaemsReader simpleTaemsReader = null;
    FileWriter debugFile;

    public GPGPController() {
        State.addParameterInfo((String)"TIMEOUT", (String)"Integer", (String)"Delay before considering any request timed out", (Object)new Integer(5));
        this.addDependency("Scheduler");
    }

    public void init() {
        super.init();
        this.scheduler = (Scheduler)State.findComponent((String)"Scheduler");
        this.execute = (Execute)State.findComponent((String)"Execute");
        this.schedule = null;
        this.scheduleList = null;
        this.log.log("GPGP Controller", 2, this.FAC_PS);
        if (this.state != null) {
            this.state.setProperty((Object)"SetTaemsName", (Object)new Boolean(true));
            this.state.setProperty((Object)"UpdateDist", (Object)new Boolean(true));
            this.state.setProperty((Object)"AutoExecute", (Object)new Boolean(true));
            this.TIMEOUT = (Integer)this.state.getProperty((Object)"TIMEOUT");
        }
        this.fsmCoordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        if (this.fsmCoordinate != null) {
            this.fsmCoordinate.addCoordinateEventListener(this);
            this.log.log("Using FSMCoordination bean", 2, this.FAC_PS);
        } else {
            this.log.log("Not using the default FSMCoordination bean.", 2, this.FAC_PS);
        }
        this.simpleTaemsReader = (SimpleTaemsReader)State.findComponent((String)"SimpleTaemsReader");
        if (this.simpleTaemsReader == null) {
            this.log.log("SimpleTaemsReader is null !", 2, this.FAC_PS);
            return;
        }
    }

    public void pulse() {
        MLCSchedule mlcs = (MLCSchedule)this.getCurSchedule();
        if (mlcs == null) {
            this.log.log("GPGPController.pulse: Schedule in state is null !", 1, this.FAC_PS);
        }
        Enumeration negActions = this.negMechActions.elements();
        while (negActions.hasMoreElements()) {
            TaemsAction a = (TaemsAction)negActions.nextElement();
            int elapsed = a.getTime();
            if (++elapsed > a.getDuration()) {
                this.negMechActions.remove(a.getName());
                this.log.log("GPGPController.pulse: terminating neg action " + a.getName(), 1, this.FAC_PS);
                Node nlmN = (Node)a.getData((Object)"NonLocalMethod");
                Long CID = (Long)this.negMechActionCIDs.get(a.getName());
                Taems ta = new Taems();
                Task rt = new Task("Root", nlmN.getAgent(), (QAF)new ExactlyOneQAF());
                ta.addNode((Node)rt);
                if (nlmN != null && nlmN instanceof Method) {
                    Method nlm = (Method)nlmN;
                    this.nlmKnownNames.put(nlm.getLabel(), nlm);
                    rt.addSubtask((TaskBase)((Method)nlmN));
                }
                CoordinateEvent ce = new CoordinateEvent(this, "AbortGPGPMechFrmContr", 0, ta);
                ce.setCoordinateID(CID);
                this.startFireEvent(ce);
                continue;
            }
            a.setTime(elapsed);
        }
        Enumeration nlmActionsEnum = this.nlmActions.elements();
        while (nlmActionsEnum.hasMoreElements()) {
            TaemsAction a = (TaemsAction)nlmActionsEnum.nextElement();
            int elapsed = a.getTime();
            if (++elapsed > a.getDuration()) {
                this.nlmActions.remove(a.getName());
                a.setQuality(1.0f);
                this.log.log("GPGPController.pulse: Nonlocal action " + a.getMethod().getLabel() + " completing", 2, this.FAC_PS);
                this.execute.completeAction((Action)a);
                continue;
            }
            this.log.log("GPGPController.pulse: Nonlocal action " + a.getMethod().getLabel() + " executed for " + elapsed + " out of " + a.getDuration(), 2, this.FAC_PS);
            a.setTime(elapsed);
        }
    }

    public FSMCoordination getFSMCoordination() {
        return this.fsmCoordinate;
    }

    public State getState() {
        return this.state;
    }

    public Log getLog() {
        return this.log;
    }

    public int getFAC_ID() {
        return this.FAC_PS;
    }

    public synchronized void setConditioned(Taems t) {
        if (this.fsmCoordinate != null) {
            CoordinateEvent ce = new CoordinateEvent(this, "NewGPGPSched", 0, t);
            this.startFireEvent(ce);
        }
    }

    private int getTime() {
        return (Integer)this.state.getProperty((Object)"Time");
    }

    public Taems evaluateTaems(Taems t, boolean rescheduling) {
        if (t != null) {
            int time = (Integer)this.state.getProperty((Object)"Time") + 2 * this.TIMEOUT + 1;
            if (!rescheduling) {
                t.getNode().setDeadline(t.getNode().getDeadline() - (2 * this.TIMEOUT + 1));
            } else {
                t.getNode().setDeadline(time + t.getNode().getDeadline());
            }
            Vector sl = this.scheduler.evaluateTaems(t, rescheduling);
            if (sl != null) {
                t.setScheduleVector(sl);
                Schedule s = t.getFirstSchedule();
                if (s != null) {
                    this.log.log("Setting schedule start time to " + time, 2, this.FAC_PS);
                    s.setStartTime(time);
                } else {
                    this.log.log("GPGPController.evaluateTaems: Warning, no schedules produced.", 1, this.FAC_PS);
                }
            } else {
                t.setScheduleVector(new Vector());
                this.log.log("GPGPController.evaluateTaems: Warning, no schedule returned.", 0, this.FAC_PS);
            }
            if (t.getFirstSchedule() != null) {
                Enumeration e = t.getFirstSchedule().getElements();
                String print = "GPGPController.evaluateTaems: ";
                while (e.hasMoreElements()) {
                    ScheduleElement schElement = (ScheduleElement)e.nextElement();
                    print = print + "[" + schElement.getStart() + " - " + schElement.getLabel() + " - " + schElement.getFinish() + "] ";
                }
                this.log.log(print, 2, this.FAC_PS);
            } else {
                this.log.log("GPGPController.evaluateTaems: Warning, current schedule is empty, adding dummy", 1, this.FAC_PS);
                t.addSchedule(new Schedule());
            }
        }
        return t;
    }

    public synchronized Taems getGPGPTaemsStruc(Taems ti, Method nlMeth, String metaNegMethName) {
        Task taskM = ti.getNode();
        Agent thisStrucAg = taskM.getAgent();
        this.log.log("GPGPController.getGPGPTaemsStruc: old root task is " + taskM.getLabel(), 2, this.FAC_PS);
        if (nlMeth.isNonLocal()) {
            this.log.log("GPGPController.getGPGPTaemsStruc: replacing method " + nlMeth.getLabel() + " with corresponding task", 2, this.FAC_PS);
            String name = nlMeth.getLabel() + "_task";
            Agent ag = nlMeth.getAgent();
            Task nlTask = new Task(name, ag, (QAF)new ExactlyOneQAF(), nlMeth.getArrivalTime(), nlMeth.getEarliestStartTime(), nlMeth.getDeadline());
            if (nlMeth.numSupertasks() != 0) {
                Enumeration parents = nlMeth.getSupertasks();
                while (parents.hasMoreElements()) {
                    Task parent = (Task)parents.nextElement();
                    parent.replaceSubtask((TaskBase)nlMeth, (TaskBase)nlTask);
                }
            }
            nlMeth.transferInterrelationships((Node)nlTask);
            nlMeth.excise();
            Enumeration altMethods = this.discoverAlternatives(nlMeth);
            while (altMethods.hasMoreElements()) {
                Method meth = (Method)altMethods.nextElement();
                nlTask.addSubtask((TaskBase)meth);
            }
            this.log.log("GPGPController.getGPGPTaemsStruc: processing task " + nlTask.getLabel(), 2, this.FAC_PS);
            Enumeration affectedIRs = nlTask.getAffectedInterrelationships();
            boolean noIRs = true;
            Interrelationship interNeeded = null;
            TaskBase destNeeded = null;
            String mechTaskNamePrefix = "";
            while (affectedIRs.hasMoreElements()) {
                Interrelationship inter = (Interrelationship)affectedIRs.nextElement();
                TaskBase dest = (TaskBase)inter.getTo();
                if (!(dest instanceof Task) && (!(dest instanceof Method) || dest.isNonLocal())) continue;
                if (inter instanceof EnablesInterrelationship) {
                    interNeeded = inter;
                    destNeeded = dest;
                    noIRs = false;
                    mechTaskNamePrefix = enableTaskNamePrefix;
                    break;
                }
                if (!(inter instanceof FacilitatesInterrelationship)) continue;
                interNeeded = inter;
                destNeeded = dest;
                noIRs = false;
                mechTaskNamePrefix = facilitateTaskNamePrefix;
                break;
            }
            if (noIRs) {
                if (nlTask.numSupertasks() == 0) {
                    this.log.log("GPGPController.getGPGPTaemsStruc: nonlocal " + nlMeth.getLabel() + " has neither parents nor affecting IRs !", 1, this.FAC_PS);
                    return null;
                }
                mechTaskNamePrefix = taTaskNamePrefix;
            } else if (nlTask.numSupertasks() == 0) {
                TaskBase dest = (TaskBase)interNeeded.getTo();
                if (dest.isNonLocal()) {
                    this.log.log("GPGPController.getGPGPTaemsStruc: IR " + interNeeded.getLabel() + " is from nonlocal " + nlMeth.getLabel() + " to nonlocal " + dest.getLabel() + " !", 1, this.FAC_PS);
                    return null;
                }
                if (dest.numSupertasks() != 0) {
                    Task destMod = new Task(dest.getLabel() + "_Mod", thisStrucAg, (QAF)new SumAllQAF());
                    Enumeration parents = dest.getSupertasks();
                    while (parents.hasMoreElements()) {
                        Task parent = (Task)parents.nextElement();
                        parent.replaceSubtask(dest, (TaskBase)destMod);
                    }
                    destMod.addSubtask(dest);
                    destMod.insertSubtask((TaskBase)nlTask, 0);
                } else {
                    this.log.log("GPGPController.getGPGPTaemsStruc:  destination of " + interNeeded.getLabel() + " is local taskbase " + dest.getLabel() + " without a parent ! ", 1, this.FAC_PS);
                    return null;
                }
            }
            float qual = this.getChildrenAvgQual(nlTask);
            Enumeration nlChildren = nlTask.getSubtasks();
            while (nlChildren.hasMoreElements()) {
                TaskBase tbch = (TaskBase)nlChildren.nextElement();
                if (!(tbch instanceof Method)) continue;
                Method nlm = (Method)tbch;
                String nlmAgName = "";
                nlmAgName = nlm.getAgent() == null ? "agentA" : nlm.getAgent().getLabel();
                String taskName = nlTask.getLabel() + "_by_" + nlmAgName;
                Task nlt = new Task(taskName, thisStrucAg, (QAF)new SeqMinQAF());
                nlTask.replaceSubtask((TaskBase)nlm, (TaskBase)nlt);
                nlt.addSubtask((TaskBase)nlm);
                String negName = negTaskNamePrefix + mechTaskNamePrefix + nlm.getLabel();
                Task negTask = new Task(negName, thisStrucAg, (QAF)new ExactlyOneQAF());
                nlt.insertSubtask((TaskBase)negTask, 0);
                EnablesInterrelationship enables = new EnablesInterrelationship();
                enables.setLabel("negotiateFor" + nlm.getLabel());
                enables.setAgent(thisStrucAg);
                enables.setCost(new Distribution(0.0f, 1.0f));
                enables.setDelay(new Distribution(0.0f, 1.0f));
                enables.setDuration(new Distribution(0.0f, 1.0f));
                negTask.addInterrelationship((Interrelationship)enables, (Node)nlm);
                Enumeration negMechMeths = this.getMechMeths(mechTaskNamePrefix, nlm, thisStrucAg, qual);
                while (negMechMeths.hasMoreElements()) {
                    Method negMeth = (Method)negMechMeths.nextElement();
                    negTask.addSubtask((TaskBase)negMeth);
                }
            }
        }
        try {
            this.debugFile = new FileWriter("getGPGPTaemsStruc" + thisStrucAg.getLabel() + ".ttaems", false);
            this.debugFile.write(ti.toString());
            this.debugFile.close();
        }
        catch (IOException e) {
            this.log.log("IOException", 0, this.FAC_PS);
        }
        return ti;
    }

    private float getChildrenAvgQual(Task tsk) {
        Enumeration children = tsk.getSubtasks();
        float avg = 0.0f;
        float num = 0.0f;
        while (children.hasMoreElements()) {
            TaskBase child = (TaskBase)children.nextElement();
            if (!(child instanceof Method)) continue;
            Method childMeth = (Method)child;
            Outcome outc = childMeth.getMostLikelyOutcome();
            Distribution qualDs = outc.getQuality();
            float qual = qualDs.calculateAvg();
            avg += qual;
            num += 1.0f;
        }
        return avg /= num;
    }

    private Enumeration discoverAlternatives(Method nlm) {
        Agent ag = new Agent("agentA");
        Vector<Method> v = new Vector<Method>();
        nlm.setNonLocal(true);
        nlm.setAgent(ag);
        v.addElement(nlm);
        return v.elements();
    }

    private Method getNegMethod(String negNamePrefix, String mechName, String shotsNamePrefix, TaskBase meth, Agent ag, float qual, float negSuccessProb, float qualFactor, float duration) {
        String methName = meth.getLabel();
        String negMethName = negNamePrefix + shotsNamePrefix + mechName + methName;
        Method mechMeth = new Method(negMethName, ag);
        mechMeth.setAttribute((Object)"Shots", (Object)shotsNamePrefix);
        mechMeth.setAttribute((Object)"MechName", (Object)mechName);
        mechMeth.setAttribute((Object)"NonLocalMethod", (Object)meth);
        mechMeth.setAttribute((Object)"Local", (Object)new Boolean(true));
        String outcName = negMethName + "_o0";
        float methQual = qualFactor * qual;
        Distribution methQualDist = new Distribution(methQual, negSuccessProb);
        methQualDist.appendTerm(0.0f, 1.0f - negSuccessProb);
        float methCost = 0.0f;
        float methDens = 1.0f;
        Outcome methOutc = new Outcome(outcName, methQualDist, new Distribution(duration, 1.0f), new Distribution(methCost, 1.0f), methDens);
        mechMeth.addOutcome(methOutc);
        return mechMeth;
    }

    private Enumeration getMechMeths(String mechName, Method meth, Agent ag, float qual) {
        float singleDuration = 8.0f;
        Method seMechMeth = this.getNegMethod(negTaskNamePrefix, mechName, singleShotNamePrefix, (TaskBase)meth, ag, qual, this.singleShotProb, this.singleShotQualFactor, singleDuration);
        float twoDuration = 3.0f * singleDuration;
        Method teMechMeth = this.getNegMethod(negTaskNamePrefix, mechName, twoShotNamePrefix, (TaskBase)meth, ag, qual, this.twoShotProb, this.twoShotQualFactor, twoDuration);
        float multDuration = 5.0f * singleDuration;
        Method meMechMeth = this.getNegMethod(negTaskNamePrefix, mechName, multShotNamePrefix, (TaskBase)meth, ag, qual, this.multShotProb, this.multShotQualFactor, multDuration);
        Vector<Method> v = new Vector<Method>();
        v.addElement(seMechMeth);
        v.addElement(teMechMeth);
        v.addElement(meMechMeth);
        return v.elements();
    }

    protected void fireEvent(AgentEvent ev) {
        if (ev instanceof CoordinateEvent) {
            CoordinateEvent e = (CoordinateEvent)ev;
            Enumeration enumeration = this.listeners.elements();
            this.log.log("GPGPController: Firing a coord event", 2, this.FAC_PS);
            while (enumeration.hasMoreElements()) {
                CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
                if (!e.isActive()) break;
                if (e.wasReceived()) {
                    l.coordinateEventReceived(e);
                }
                if (!e.wasSent()) continue;
                l.coordinateEventSent(e);
            }
        }
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    public void coordinateEventSent(CoordinateEvent e) {
    }

    public void actionStarted(ActionEvent e) {
        Action somea = e.getAction();
        if (somea instanceof TaemsAction) {
            TaemsAction a = (TaemsAction)somea;
            if (a.getName().startsWith(metaNegNamePrefix)) {
                Node nlmN = (Node)a.getData((Object)"NonLocalMethod");
                if (!(nlmN instanceof Method)) {
                    this.log.log("GPGPController.actionStarted: " + a.getName() + " is not a method", 1, this.FAC_PS);
                    a.setQuality(0.0f);
                    this.execute.completeAction((Action)a);
                    return;
                }
                Method nlm = (Method)nlmN;
                if (nlm == null) {
                    this.log.log("GPGPController.actionStarted: " + a.getName() + " could not find NonLocalMethod attribute pointing to method to negotiate over", 1, this.FAC_PS);
                    a.setQuality(0.0f);
                    this.execute.completeAction((Action)a);
                    return;
                }
                if (!nlm.isNonLocal()) {
                    this.log.log("GPGPController.actionStarted: " + a.getName() + " has NonLocalMethod attribute pointing to local method", 1, this.FAC_PS);
                    a.setQuality(0.0f);
                    this.execute.completeAction((Action)a);
                    return;
                }
                return;
            }
            if (somea.getData((Object)"Local") != null) {
                if (this.nlmKnownNames.containsKey(a.getMethod().getLabel())) {
                    this.nlmActions.put(a.getName(), a);
                    this.nlmKnownNames.remove(a.getMethod().getLabel());
                    return;
                }
                if (a.getName().startsWith(negTaskNamePrefix) || a.getName().startsWith(reqNegNamePrefix)) {
                    String mechName = (String)a.getData((Object)"MechName");
                    String shots = (String)a.getData((Object)"Shots");
                    Method nlm = (Method)a.getData((Object)"NonLocalMethod");
                    if (mechName != null && shots != null && nlm != null) {
                        SEGPGPMech mech = null;
                        long CID = 0L;
                        Taems cond = null;
                        String condKey = "";
                        Hashtable ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
                        Enumeration e1 = ht.keys();
                        while (e1.hasMoreElements()) {
                            String key = (String)e1.nextElement();
                            Taems tstruc = (Taems)ht.get(key);
                            if (tstruc.findNode((Node)nlm) == null) continue;
                            cond = tstruc;
                            condKey = key;
                            break;
                        }
                        if (cond == null) {
                            this.log.log("GPGPController.actionStarted: " + a.getName() + " cannot find taems struc containing it", 1, this.FAC_PS);
                            a.setQuality(0.0f);
                            this.execute.completeAction((Action)a);
                            return;
                        }
                        Criteria crit = cond.getScheduleCriteria();
                        if (crit == null) {
                            this.log.log("GPGPController.actionStarted: " + a.getName() + " is in a taems struc without scheduler criteria", 1, this.FAC_PS);
                            a.setQuality(0.0f);
                            this.execute.completeAction((Action)a);
                            return;
                        }
                        Vector schedVec = cond.getScheduleVector();
                        if (schedVec == null) {
                            this.log.log("GPGPController.actionStarted: " + a.getName() + " is in a taems struc without schedules", 1, this.FAC_PS);
                            a.setQuality(0.0f);
                            this.execute.completeAction((Action)a);
                            return;
                        }
                        CoordinateEvent ce = null;
                        if (a.getName().startsWith(reqNegNamePrefix)) {
                            ce = (CoordinateEvent)((Object)this.respNegMethCEs.get(nlm.getLabel()));
                            if (ce == null) {
                                this.log.log("GPGPController.actionStarted: " + a.getName() + " is a responder instantiation missing the initial coord event from the initiator", 1, this.FAC_PS);
                                a.setQuality(0.0f);
                                this.execute.completeAction((Action)a);
                                return;
                            }
                            this.respNegMethCEs.remove(nlm.getLabel());
                            ce.setType("StartResp");
                            Taems commT = ce.getTaems();
                            if (commT == null) {
                                this.log.log("GPGPController.actionStarted: " + a.getName() + " is a responder instantiation missing a taems struc with commitment in the initial coord event from the initiator", 1, this.FAC_PS);
                                a.setQuality(0.0f);
                                this.execute.completeAction((Action)a);
                                return;
                            }
                            commT.setLabel(a.getMethod().getLabel());
                        } else {
                            CID = State.getRandom().nextLong();
                            Taems t3 = new Taems();
                            t3.setLabel(a.getMethod().getLabel());
                            ce = new CoordinateEvent(this, "StartInit", 0, t3);
                            ce.setCoordinateID(CID);
                        }
                        if (mechName.startsWith(enableTaskNamePrefix)) {
                            if (shots.startsWith(singleShotNamePrefix)) {
                                mech = new SEGPGPMech(this, nlm, ce, condKey);
                            } else if (shots.startsWith(twoShotNamePrefix)) {
                                mech = new SEGPGPMech(this, nlm, ce, condKey);
                            } else if (shots.startsWith(multShotNamePrefix)) {
                                mech = new SEGPGPMech(this, nlm, ce, condKey);
                            }
                        } else if (mechName.startsWith(facilitateTaskNamePrefix) ? !shots.startsWith(singleShotNamePrefix) && !shots.startsWith(twoShotNamePrefix) && shots.startsWith(multShotNamePrefix) : !mechName.startsWith(taTaskNamePrefix) || shots.startsWith(singleShotNamePrefix) || shots.startsWith(twoShotNamePrefix) || shots.startsWith(multShotNamePrefix)) {
                            // empty if block
                        }
                        if (mech == null) {
                            this.log.log("GPGPController.actionStarted: no negotiation mechanism was found for " + a.getName(), 1, this.FAC_PS);
                            a.setQuality(0.0f);
                            this.execute.completeAction((Action)a);
                            return;
                        }
                        a.setTime(0);
                        this.negMechActions.put(a.getName(), a);
                        this.log.log("GPGPController.actionStarted: putting " + a.getName() + " into ht", 1, this.FAC_PS);
                        this.negMechActionCIDs.put(a.getName(), new Long(CID));
                        this.negMechCIDActions.put(new Long(CID), a);
                        return;
                    }
                    this.log.log("GPGPController.actionStarted: " + a.getName() + " does not have all the necessary attributes specified (MechName,Shots,NonLocalMethod)", 1, this.FAC_PS);
                    a.setQuality(0.0f);
                    this.execute.completeAction((Action)a);
                    return;
                }
            }
        }
    }

    public void actionCompleted(ActionEvent e) {
        TaemsAction a;
        Action somea = e.getAction();
        if (somea instanceof TaemsAction && (a = (TaemsAction)somea).getName().startsWith(metaNegNamePrefix)) {
            Node nlmN = (Node)a.getData((Object)"NonLocalMethod");
            if (!(nlmN instanceof Method)) {
                this.log.log("GPGPController.actionStarted: " + a.getName() + " is not a method", 1, this.FAC_PS);
                a.setQuality(0.0f);
                this.execute.completeAction((Action)a);
                return;
            }
            Method nlm = (Method)nlmN;
            Taems conditional = this.getCondTaemsOf((TaskBase)a.getMethod());
            if ((conditional = this.getGPGPTaemsStruc(conditional, nlm, a.getMethod().getLabel())) == null) {
                this.log.log("GPGPController.actionStarted: " + a.getName() + " created a problem in GPGPController.getGPGPTaemsStruc", 1, this.FAC_PS);
                a.setQuality(0.0f);
                this.execute.completeAction((Action)a);
                return;
            }
            conditional.setScheduleVector(null);
            a.setQuality(1.0f);
            Hashtable ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
            ht.put(conditional.getLabel(), conditional);
            this.state.setProperty((Object)SimpleTaemsReader.CONTAEMS, (Object)ht, (Object)"rescheduling");
            this.log.log("GPGPController.actionCompleted: completing " + a.getName(), 1, this.FAC_PS);
        }
    }

    public Taems getCondTaemsOf(TaskBase m) {
        Taems conditional = null;
        Object obj2 = this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
        if (obj2 instanceof Hashtable) {
            Hashtable ht = (Hashtable)obj2;
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object objt = ht.get(key);
                if (objt instanceof Taems) {
                    Taems t = (Taems)ht.get(key);
                    if (t.findNode((Node)m) == null) continue;
                    conditional = t;
                    break;
                }
                this.log.log("GPGPController.getCondTaemsOf: taems hashtable in STATE contains a non-Taems object !", 1, this.FAC_PS);
            }
            return conditional;
        }
        this.log.log("GPGPController.getCondTaemsOf: CONTAEMS is not a hashtable !", 1, this.FAC_PS);
        return null;
    }

    protected void processStartSSEResp(CoordinateEvent ce) {
        this.log.log("GPGPController.processStartSSEResp: Scheduling SEGPGPMech in response to StartSSEResp event", 2, this.FAC_PS);
        Taems comT = ce.getTaems();
        if (comT == null) {
            this.log.log("GPGPController.processStartSSEResp: no taems in coord event " + ce.getID(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        Enumeration comms = comT.getCommitments();
        Commitment comm = (Commitment)comms.nextElement();
        if (comm == null) {
            this.log.log("GPGPController.processStartSSEResp: no commitment in coord event " + ce.getID(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        Vector v = comm.getTaskVector();
        if (v == null) {
            this.log.log("GPGPController.processStartSSEResp: no task vector in coord event " + ce.getID(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        if (v.size() < 1) {
            this.log.log("GPGPController.processStartSSEResp: task vector has no elements " + ce.getID(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        TaskBase nlm = null;
        if (v.elementAt(0) instanceof VirtualTaskBase) {
            VirtualTaskBase vtb = (VirtualTaskBase)v.elementAt(0);
            nlm = vtb.getAgent() == null ? new TaskBase(vtb.getLabel(), comm.getFromAgent()) : new TaskBase(vtb.getLabel(), vtb.getAgent());
        } else {
            this.log.log("GPGPController.processStartSSEResp: no task base in task vector " + ce.getID(), 1, this.FAC_PS);
            this.log.log("GPGPController.processStartSSEResp: it's an instance of " + v.elementAt(0).getClass().getName(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        Taems t = this.getCondTaemsOf(nlm);
        if (t == null) {
            this.log.log("GPGPController.processStartSSEResp: method " + nlm.getLabel() + " not found in taems strucs of agent " + nlm.getAgent().getLabel(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        Agent localAgent = t.getAgent();
        if (nlm.getAgent() != null && !localAgent.getLabel().equals(nlm.getAgent().getLabel())) {
            this.log.log("GPGPController.processStartSSEResp: agent " + localAgent.getLabel() + " received nonlocal method of agent " + nlm.getAgent().getLabel(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        TaskBase localnlm = (TaskBase)t.findNode((Node)nlm);
        if (localnlm == null) {
            this.log.log("GPGPController.processStartSSEResp: taskbase " + nlm.getLabel() + " not found in task " + t.getNode().getLabel() + " by agent " + nlm.getAgent().getLabel(), 1, this.FAC_PS);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
            return;
        }
        Taems ta = new Taems();
        ta.setAgent(localAgent);
        Task rt = new Task("RootFor" + ce.getCoordinateID().toString(), localAgent, (QAF)new ExactlyOneQAF());
        ta.addNode((Node)rt);
        Method negMeth = this.getNegMethod(reqNegNamePrefix, enableTaskNamePrefix, singleShotNamePrefix, localnlm, localAgent, 1.0f, this.singleShotProb, this.singleShotQualFactor, 8.0f);
        ta.setLabel(t.getLabel());
        rt.addSubtask((TaskBase)negMeth);
        this.respNegMethCEs.put(nlm.getLabel(), ce);
        t.unionTaems(ta);
        t.setScheduleVector(null);
        Hashtable<String, Taems> ht = (Hashtable<String, Taems>)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
        if (ht == null) {
            this.log.log("GPGPController.processStartSSEResp: ht is null !!", 2, this.FAC_PS);
            ht = new Hashtable<String, Taems>();
        }
        ht.put(t.getLabel(), t);
        this.state.setProperty((Object)SimpleTaemsReader.CONTAEMS, ht, (Object)"rescheduling");
        this.log.log("GPGPController.processStartSSEResp: updated CONTAEMS ht with task " + negMeth.getLabel(), 1, this.FAC_PS);
        MLCSchedule mlcs2 = (MLCSchedule)this.getCurSchedule();
        ScheduleElement schedEl = this.findSchedEl(negMeth, (Schedule)mlcs2);
        if (schedEl == null) {
            this.log.log("GPGPController.processStartSSEResp: resp neg method " + negMeth.getLabel() + " not scheduled at all, aborting negotiation", 1, this.FAC_PS);
            this.zeroQualDur(negMeth);
            ce.setType("AbortFSM");
            ce.setID(4096);
            this.startFireEvent(ce);
        }
    }

    private void zeroQualDur(Method meth) {
        Enumeration outcEnum = meth.getOutcomes();
        while (outcEnum.hasMoreElements()) {
            Outcome outc = (Outcome)outcEnum.nextElement();
            outc.setQuality(new Distribution(0.0f, 1.0f));
            outc.setDuration(new Distribution(0.0f, 1.0f));
        }
    }

    protected void updateSchedule(Schedule s) {
        Schedule curSched = (Schedule)this.state.getProperty((Object)"Schedule");
        Enumeration schedElsEnum = s.getScheduleElements().elements();
        while (schedElsEnum.hasMoreElements()) {
            ScheduleElement schedEl = (ScheduleElement)schedElsEnum.nextElement();
            ScheduleElement schedEl2 = this.findSchedEl(schedEl.getMethod(), curSched);
            if (schedEl2 != null || !schedEl.getMethod().hasFinished()) continue;
            s.removeScheduleElement(schedEl);
        }
    }

    protected ScheduleElement findSchedEl(Method m, Schedule s) {
        if (s instanceof MLCSchedule) {
            return ((MLCSchedule)s).getScheduleElement(m.getLabel());
        }
        Vector schedEls = s.getScheduleElements();
        int i = 0;
        while (i < schedEls.size()) {
            ScheduleElement schedEl = (ScheduleElement)schedEls.elementAt(i);
            if (schedEl.getMethod().getLabel().equals(m.getLabel())) {
                return schedEl;
            }
            ++i;
        }
        return null;
    }

    protected void processStartSSFResp(CoordinateEvent ce) {
        this.log.log("Starting SF_GPGPMech in response to StartSSFResp", 2, this.FAC_PS);
    }

    protected void processNegAborted(GPGPEvent ge) {
        String negMethName = ge.getSourceName();
        TaemsAction a = (TaemsAction)this.negMechActions.get(negMethName);
        if (a != null) {
            this.negMechActions.remove(a.getName());
            Long CID = (Long)this.negMechActionCIDs.get(a.getName());
            this.negMechActionCIDs.remove(a.getName());
            this.negMechCIDActions.remove(CID);
            a.setQuality(0.0f);
            this.execute.completeAction((Action)a);
            ge = null;
            System.gc();
            this.log.log("GPGPController.processNegAborted: GPGP mech " + negMethName + " aborted", 2, this.FAC_PS);
        } else {
            this.log.log("GPGPController.processNegAborted: negMethName " + negMethName + " unknown !", 1, this.FAC_PS);
        }
    }

    protected void processNegAccepted(GPGPEvent ge) {
        GPGPMech mech;
        String negMethName = ge.getSourceName();
        TaemsAction a = (TaemsAction)this.negMechActions.get(negMethName);
        if (a == null) {
            this.log.log("GPGPController.processNegAccepted: negMethName " + negMethName + " unknown !", 1, this.FAC_PS);
            return;
        }
        this.negMechActions.remove(a.getName());
        Long CID = (Long)this.negMechActionCIDs.get(a.getName());
        this.negMechActionCIDs.remove(a.getName());
        this.negMechCIDActions.remove(CID);
        a.setQuality(1.0f);
        this.execute.completeAction((Action)a);
        if (ge.isTaemsModified() && (mech = (GPGPMech)((EventObject)((Object)ge)).getSource()) != null) {
            Method origNegMeth = a.getMethod();
            Taems cond = this.getCondTaemsOf((TaskBase)origNegMeth);
            cond = (Taems)cond.clone();
            String oldCondName = (cond = mech.enforceModAccept(cond)).getLabel();
            if (oldCondName != null) {
                this.log.log("GPGPController.processMechAccepted: oldCondName " + oldCondName, 1, this.FAC_PS);
            } else {
                this.log.log("GPGPController.processMechAccepted: no oldCondName", 1, this.FAC_PS);
            }
            Hashtable ht = (Hashtable)this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
            ht.remove(oldCondName);
            this.state.setProperty((Object)SimpleTaemsReader.CONTAEMS, (Object)ht, (Object)"rescheduling");
            cond.setLabel(oldCondName + "compl" + origNegMeth.getLabel());
            cond.setScheduleVector(null);
            MLCSchedule mlcs = (MLCSchedule)this.getCurSchedule();
            if (mlcs != null) {
                this.log.log("GPGPController.processMechAccepted: sched before update " + mlcs.toString(), 2, this.FAC_PS);
            }
            Vector<Object> methodsToReexecute = new Vector<Object>();
            Enumeration curActionsEnum = this.execute.actions();
            while (curActionsEnum.hasMoreElements()) {
                TaemsAction act = (TaemsAction)curActionsEnum.nextElement();
                methodsToReexecute.addElement(act.getMethod().clone());
                this.execute.completeAction((Action)act);
            }
            mlcs = (MLCSchedule)this.getCurSchedule();
            if (mlcs != null) {
                this.log.log("GPGPController.processMechAccepted: sched after cleanup " + mlcs.toString(), 2, this.FAC_PS);
            }
            int i = 0;
            while (i < methodsToReexecute.size()) {
                Method methToReexecuteClone = (Method)methodsToReexecute.elementAt(i);
                Method methToReexecute = (Method)cond.findNode((Node)new Method(methToReexecuteClone.getLabel(), methToReexecuteClone.getAgent()));
                methToReexecute.setFinishTime(Integer.MIN_VALUE);
                methToReexecute.removeAttribute((Object)"Status");
                methToReexecute.removeAllOutcomes();
                Enumeration outcEnum = methToReexecuteClone.getOutcomes();
                boolean found = false;
                while (outcEnum.hasMoreElements()) {
                    found = true;
                    Outcome outc = (Outcome)outcEnum.nextElement();
                    methToReexecute.addOutcome(outc);
                }
                if (!found) {
                    this.log.log("GPGPController.processMechAccepted: no outcomes found in " + methToReexecuteClone.getLabel(), 1, this.FAC_PS);
                }
                ++i;
            }
            ht.put(cond.getLabel(), cond);
            this.state.setProperty((Object)SimpleTaemsReader.CONTAEMS, (Object)ht, (Object)"rescheduling");
            mlcs = (MLCSchedule)this.getCurSchedule();
            if (mlcs != null) {
                this.log.log("GPGPController.processMechAccepted: sched after update " + mlcs.toString(), 2, this.FAC_PS);
            }
        }
        this.log.log("GPGPController.processMechAccepted: action " + a.getMethod().getLabel() + " completed at " + a.getFinish(), 2, this.FAC_PS);
        ge = null;
        System.gc();
        this.log.log("GPGPController.processMechAccepted: negotiation by GPGP mech " + negMethName + " succeeded", 2, this.FAC_PS);
    }

    protected Schedule getCurSchedule() {
        return (Schedule)this.state.getProperty((Object)"Schedule");
    }

    protected void processNegRejected(GPGPEvent ge) {
        String negMethName = ge.getSourceName();
        TaemsAction a = (TaemsAction)this.negMechActions.get(negMethName);
        if (a == null) {
            this.log.log("GPGPController.processNegRejected: negMethName " + negMethName + " unknown !", 1, this.FAC_PS);
            return;
        }
        this.negMechActions.remove(a.getName());
        Long CID = (Long)this.negMechActionCIDs.get(a.getName());
        this.negMechActionCIDs.remove(a.getName());
        this.negMechCIDActions.remove(CID);
        a.setQuality(0.0f);
        this.execute.completeAction((Action)a);
        ge = null;
        System.gc();
        this.log.log("GPGPController.processMechAborted: negotiation by GPGP mech " + negMethName + " failed", 2, this.FAC_PS);
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 2, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
        if (e.getType().equals("StartSSEResp")) {
            this.log.log("GPGPController: commitmentEventReceived type StartSSEResp" + e.getID(), 2, this.FAC_PS);
            this.processStartSSEResp(e);
        }
        if (e.getType().equals("StartSSFResp")) {
            this.log.log("GPGPController: commitmentEventReceived type StartSSFResp" + e.getID(), 2, this.FAC_PS);
            this.processStartSSFResp(e);
        }
    }

    public synchronized void gpgpEventReceived(GPGPEvent e) {
        if (e.getType() == null) {
            this.log.log("GPGPController.gpgpEventReceived: event with null type received " + (Object)((Object)e), 0, this.FAC_PS);
            return;
        }
        if (e.getSourceName() == null) {
            this.log.log("GPGPController.gpgpEventReceived: event with null source name received " + (Object)((Object)e), 0, this.FAC_PS);
            return;
        }
        if (e.getType().equals("NegAborted")) {
            this.log.log("GPGPController: gpgpEventReceived type NegAborted" + e.getID(), 2, this.FAC_PS);
            this.processNegAborted(e);
        }
        if (e.getType().equals("NegAccepted")) {
            this.log.log("GPGPController: gpgpEventReceived type NegAccepted" + e.getID(), 2, this.FAC_PS);
            this.processNegAccepted(e);
        }
        if (e.getType().equals("NegRejected")) {
            this.log.log("GPGPController: gpgpEventReceived type NegRejected" + e.getID(), 2, this.FAC_PS);
            this.processNegRejected(e);
        }
    }
}

