/*
 * Decompiled with CFR 0.152.
 */
package agent.gpgp2;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CSharpInitiator;
import agent.coordinate.CSharpResponder;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.DSharpInitiator;
import agent.coordinate.DSharpResponder;
import agent.coordinate.FSMCoordination;
import agent.diagnose.symptom.CommitmentSent;
import agent.mass.ProblemSolver;
import agent.mass.Scheduler;
import agent.mass.SimpleTaemsReader;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.ActionEvent;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.ConsumesInterrelationship;
import taems.Method;
import taems.Node;
import taems.ProducesInterrelationship;
import taems.Resource;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;

public class BasicProblemSolver
extends ProblemSolver
implements PropertyEventListener,
CoordinateEventListener,
CoordinateEventProducer {
    protected Taems conditioned;
    protected Scheduler scheduler;
    protected Vector schedule;
    protected Hashtable coordinationOverSchedule;
    protected int scheduleNumber = 0;
    protected Vector scheduleList;
    protected boolean reset = false;
    protected int TIMEOUT = 5;
    protected int DEFAULT_WINDOW = 15;
    protected FSMCoordination fsmCoordinate;
    protected ListenerVector listeners = new ListenerVector();
    protected Vector coordinateQueue = new Vector();
    protected SimpleTaemsReader taemsreader;
    int roundB;
    int roundA;
    int iters;
    int maxIters;
    int WORKLOAD = 1;
    boolean isNegotiating = false;

    public BasicProblemSolver() {
        State.addParameterInfo((String)"TIMEOUT", (String)"Integer", (String)"Delay before considering any request timed out", (Object)new Integer(5));
        this.addDependency("Scheduler");
    }

    public void init() {
        super.init();
        this.scheduler = (Scheduler)State.findComponent((String)"Scheduler");
        this.conditioned = null;
        this.schedule = null;
        this.scheduleList = null;
        this.log.log("Basic agent Version 1.3", 2, this.FAC_PS);
        if (this.state != null) {
            this.state.setProperty((Object)"SetTaemsName", (Object)new Boolean(true));
            this.state.setProperty((Object)"UpdateDist", (Object)new Boolean(true));
            this.state.setProperty((Object)"AutoExecute", (Object)new Boolean(true));
            this.TIMEOUT = (Integer)this.state.getProperty((Object)"TIMEOUT");
        }
        this.fsmCoordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        if (this.fsmCoordinate != null) {
            this.fsmCoordinate.addCoordinateEventListener(this);
            this.log.log("Using FSMCoordination bean", 2, this.FAC_PS);
        } else {
            this.log.log("Not using the default FSMCoordination bean.", 2, this.FAC_PS);
        }
    }

    public void reset() {
        if (this.execute.isExecuting() && this.schedule != null) {
            Method m = (Method)this.conditioned.findNode((Node)new Method((String)this.schedule.elementAt(0), null));
            this.execute.cancelAction((Action)new TaemsAction(m), "reset Tasks");
        }
        this.schedule = null;
        this.scheduleList = null;
        this.conditioned = null;
        this.reset = true;
    }

    public void pulse() {
        ScheduleElement schElement;
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (this.coordinateQueue != null && this.coordinateQueue.size() != 0) {
            this.callFSMCoordinate(this.coordinateQueue);
            this.coordinateQueue.removeAllElements();
        }
        if (this.schedule != null && this.schedule.size() > 0) {
            Enumeration e = this.conditioned.getFirstSchedule().getElements();
            String print = "";
            while (e.hasMoreElements()) {
                schElement = (ScheduleElement)e.nextElement();
                print = print + "[" + schElement.getStart() + " - " + schElement.getLabel();
                print = this.checkCoordinationOk(schElement) ? print + " (GREEN)" : print + " (NOT GOOD)";
                print = print + " - " + schElement.getFinish() + "] ";
            }
            this.log.log(print, 2, this.FAC_PS);
            ScheduleElement se = this.conditioned.getFirstSchedule().getNextTask(time);
            this.log.log("Next task : " + se, 2, this.FAC_PS);
            if (se != null && time == se.getStart() - 1 && !this.checkCoordinationOk(se)) {
                this.log.log("Coordination not finished, I couldn't delay the task", 0, this.FAC_PS);
            }
        }
        if (this.schedule == null && !this.execute.isExecuting() || this.reset) {
            this.reset = false;
            this.invokeScheduler(false);
            if (this.schedule == null) {
                this.log.log("Oups, DTC fails, running evaluateTaems as a backup solution", 2, this.FAC_PS);
                Taems t = this.evaluateTaems((Taems)this.state.getProperty((Object)"ConTaemsTask"), false);
                if (t.getScheduleVector() != null) {
                    this.schedule = new Vector();
                    if (t.getFirstSchedule() != null) {
                        Enumeration e = this.conditioned.getFirstSchedule().getElements();
                        while (e.hasMoreElements()) {
                            schElement = (ScheduleElement)e.nextElement();
                            this.schedule.addElement(schElement.getLabel());
                        }
                    }
                    this.coordinationOverSchedule = new Hashtable();
                    this.callFSMCoordinate(this.generateCommitment(this.conditioned));
                    this.log.log("Coordination Done", 2, this.FAC_PS);
                } else {
                    this.log.log("Backup solution also fail, dumb ass check your TAEMS structure", 0, this.FAC_PS);
                }
            }
        }
    }

    public boolean invokeScheduler(boolean rescheduling) {
        this.log.log("Scheduling... ", 2, this.FAC_PS);
        this.conditioned = (Taems)this.state.getProperty((Object)"ConTaemsTask");
        if (this.conditioned != null) {
            int time = (Integer)this.state.getProperty((Object)"Time") + 2 * this.TIMEOUT + 1;
            if (!rescheduling) {
                this.conditioned.getNode().setDeadline(this.conditioned.getNode().getDeadline() - (2 * this.TIMEOUT + 1));
            }
            this.scheduleList = this.scheduler.scheduleTaems(this.conditioned, rescheduling);
            if (this.scheduleList != null) {
                this.scheduleNumber = 0;
                this.conditioned.setScheduleVector(this.scheduleList);
                this.schedule = null;
                Schedule s = this.conditioned.getFirstSchedule();
                this.log.log("Setting schedule start time to " + time, 2, this.FAC_PS);
                s.setStartTime(time);
                ++this.scheduleNumber;
                this.schedule = new Vector();
                String print = "invokeScheduler: ";
                Enumeration e = this.conditioned.getFirstSchedule().getElements();
                while (e.hasMoreElements()) {
                    ScheduleElement schElement = (ScheduleElement)e.nextElement();
                    this.schedule.addElement(schElement.getLabel());
                    print = print + "[" + schElement.getStart() + " - " + schElement.getLabel() + " - " + schElement.getFinish() + "] ";
                }
                this.log.log(print, 2, this.FAC_PS);
                this.coordinationOverSchedule = new Hashtable();
                this.callFSMCoordinate(this.generateCommitment(this.conditioned));
                this.log.log("Coordination Done", 2, this.FAC_PS);
                return true;
            }
        }
        return false;
    }

    public void addCoordinateEvent(ScheduleElement schElement, CoordinateEvent ce) {
        Vector vectorCE = new Vector();
        if (this.coordinationOverSchedule.containsKey(schElement)) {
            vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
            this.coordinationOverSchedule.remove(schElement);
        }
        Enumeration e = vectorCE.elements();
        while (e.hasMoreElements()) {
            if (ce != (CoordinateEvent)((Object)e.nextElement())) continue;
            this.coordinationOverSchedule.put(schElement, vectorCE);
            return;
        }
        vectorCE.addElement(ce);
        this.coordinationOverSchedule.put(schElement, vectorCE);
    }

    public ScheduleElement FindScheduleElement(CoordinateEvent ce) {
        if (ce.getCoordinateID() != null) {
            Enumeration e = this.coordinationOverSchedule.keys();
            while (e.hasMoreElements()) {
                ScheduleElement schElement = (ScheduleElement)e.nextElement();
                Vector vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
                if (vectorCE == null) continue;
                Enumeration e1 = vectorCE.elements();
                while (e1.hasMoreElements()) {
                    CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
                    if (!ce.getCoordinateID().equals(ce1.getCoordinateID())) continue;
                    return schElement;
                }
            }
        }
        return null;
    }

    public boolean checkCoordinationOk(ScheduleElement schElement) {
        Vector vectorCE = new Vector();
        if (this.coordinationOverSchedule.containsKey(schElement)) {
            vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
            Enumeration e = vectorCE.elements();
            while (e.hasMoreElements()) {
                CoordinateEvent ce1 = (CoordinateEvent)((Object)e.nextElement());
                if (ce1.getID() == 1) continue;
                return false;
            }
        }
        return true;
    }

    public void setCoordinateEvent(CoordinateEvent ce, int ID) {
        ScheduleElement schElement = this.FindScheduleElement(ce);
        if (schElement != null) {
            Vector vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
            this.coordinationOverSchedule.remove(schElement);
            Enumeration e1 = vectorCE.elements();
            while (e1.hasMoreElements()) {
                CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
                if (!ce.getCoordinateID().equals(ce1.getCoordinateID())) continue;
                ce1.setID(ID);
                break;
            }
            this.coordinationOverSchedule.put(schElement, vectorCE);
        }
    }

    public void replaceCoordinateEvent(CoordinateEvent ce) {
        ScheduleElement schElement = this.FindScheduleElement(ce);
        Vector vectorCE = (Vector)this.coordinationOverSchedule.get(schElement);
        this.coordinationOverSchedule.remove(schElement);
        Enumeration e1 = vectorCE.elements();
        while (e1.hasMoreElements()) {
            CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
            if (!ce.getCoordinateID().equals(ce1.getCoordinateID())) continue;
            vectorCE.removeElement((Object)ce1);
            vectorCE.addElement(ce);
            break;
        }
        this.coordinationOverSchedule.put(schElement, vectorCE);
    }

    public Taems evaluateTaems(Taems t, boolean rescheduling) {
        if (t != null) {
            int time = (Integer)this.state.getProperty((Object)"Time") + 2 * this.TIMEOUT + 1;
            if (!rescheduling) {
                t.getNode().setDeadline(t.getNode().getDeadline() - (2 * this.TIMEOUT + 1));
            } else {
                t.getNode().setDeadline(time + t.getNode().getDeadline());
            }
            Vector sl = this.scheduler.evaluateTaems(t, rescheduling);
            if (sl != null) {
                t.setScheduleVector(sl);
                Schedule s = t.getFirstSchedule();
                if (s != null) {
                    this.log.log("Setting schedule start time to " + time, 2, this.FAC_PS);
                    s.setStartTime(time);
                } else {
                    this.log.log("Warning, no schedules produced.", 1, this.FAC_PS);
                }
            } else {
                t.setScheduleVector(new Vector());
                this.log.log("Warning, no schedule returned.", 0, this.FAC_PS);
            }
            if (t.getFirstSchedule() != null) {
                Enumeration e = t.getFirstSchedule().getElements();
                String print = "EvaluateTaems: ";
                while (e.hasMoreElements()) {
                    ScheduleElement schElement = (ScheduleElement)e.nextElement();
                    print = print + "[" + schElement.getStart() + " - " + schElement.getLabel() + " - " + schElement.getFinish() + "] ";
                }
                this.log.log(print, 2, this.FAC_PS);
            } else {
                this.log.log("Warning, current schedule is empty, adding dummy", 1, this.FAC_PS);
                t.addSchedule(new Schedule());
            }
        }
        return t;
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase("ConTaemsTask")) {
            this.log.log("Argh! NEW  Task structure received", 2, this.FAC_PS);
            this.reset();
        }
    }

    public void propertyRemoved(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void actionStarted(ActionEvent e) {
    }

    public void actionAborted(ActionEvent e) {
        this.actionCompleted(e);
    }

    public void actionCompleted(ActionEvent e) {
        TaemsAction a = (TaemsAction)e.getAction();
        Method m = a.getMethod();
        if (m.getCurrentQuality() == 0.0f) {
            this.log.log("Argh! The method " + m.getLabel() + " didnt get enough quality :(.  I must reschedule.", 1, this.FAC_PS);
            if (!this.reset && this.schedule != null) {
                if (this.schedule.size() > 0) {
                    this.schedule.removeElementAt(0);
                    boolean answer = this.invokeScheduler(true);
                    if (!answer) {
                        this.log.log("Oups, DTC fails, running evaluateTaems as a backup solution", 2, this.FAC_PS);
                        Taems t = (Taems)this.state.getProperty((Object)"ConTaemsTask");
                        this.evaluateTaems(t, true);
                        this.schedule = new Vector();
                        Enumeration e1 = t.getFirstSchedule().getElements();
                        while (e1.hasMoreElements()) {
                            ScheduleElement schElement = (ScheduleElement)e1.nextElement();
                            this.schedule.addElement(schElement.getLabel());
                        }
                    }
                } else {
                    this.log.log("Whoops, I went to go remove the completed action from the schedule and the schedule was empty", 1, this.FAC_PS);
                }
            }
        } else if (!this.reset && this.schedule != null) {
            if (this.schedule.size() > 0) {
                this.schedule.removeElementAt(0);
            } else {
                this.log.log("Whoops, I went to go remove the completed action from the schedule and the schedule was empty", 1, this.FAC_PS);
            }
        }
    }

    public boolean isDefaultCommitment(Commitment c) {
        return c.hasAttribute((Object)"Default");
    }

    public Enumeration getRawCommitments() {
        Taems tasks = (Taems)this.state.getProperty((Object)"ConTaemsTask");
        return tasks.getCommitments();
    }

    public boolean checkForDefaultCommitment(Commitment c) {
        Vector v = this.getCommitmentsVector();
        this.log.log("Looking at " + v.size() + " Commitment in Conditional View ", 3, this.FAC_PS);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Commitment com = (Commitment)e.nextElement();
            if (!com.getType().equals(c.getType()) || com.getEarliestStartTime() != c.getEarliestStartTime() || com.getQuantity() != c.getQuantity() || com.getTimeSatisfied() != c.getTimeSatisfied()) continue;
            if (com.getTimeDistribution() == null || c.getTimeDistribution() == null) {
                return com.getTimeDistribution() == c.getTimeDistribution();
            }
            if (com.getTimeDistribution().calculateMax() != c.getTimeDistribution().calculateMax()) continue;
            return true;
        }
        return false;
    }

    public Vector getCommitmentsVector() {
        Enumeration e = this.getRawCommitments();
        Vector<Commitment> v = new Vector<Commitment>();
        int time = (Integer)this.state.getProperty((Object)"Time");
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            if (this.isDefaultCommitment(c)) {
                int period = (Integer)c.getAttribute((Object)"Period");
                int start = c.getEarliestStartTime();
                CommitmentSent cr = (CommitmentSent)c.getAttribute((Object)"Pose");
                Commitment pc = cr.getTaems().getCommitment();
                int duration = pc.getTimeSatisfied() - pc.getEarliestStartTime();
                int i = time - duration;
                while (i <= time + this.DEFAULT_WINDOW) {
                    if (i >= start && (i - start) % period == 0) {
                        Commitment nc = (Commitment)pc.clone();
                        nc.setAttribute((Object)"DefaultCommitment", (Object)c);
                        nc.setAttribute((Object)"Default", (Object)new Boolean(true));
                        nc.setID(0L);
                        nc.setEarliestStartTime(i);
                        this.log.log("Adding default spawn for " + c.getID() + " starting at time " + nc.getEarliestStartTime(), 3, this.FAC_PS);
                        v.addElement(nc);
                    }
                    ++i;
                }
                continue;
            }
            v.addElement(c);
        }
        return v;
    }

    public Vector generateCommitment(Taems t) {
        CoordinateEvent ce;
        Commitment com;
        long CID;
        Vector<Object> v;
        Taems ta;
        String typeOfProtocol;
        Method m;
        ScheduleElement schElement;
        Enumeration e;
        ConsumesInterrelationship NLE;
        Vector<CoordinateEvent> commitments = new Vector<CoordinateEvent>();
        Schedule s = t.getFirstSchedule();
        Enumeration enumOfNLE = t.findNodes((Node)new ConsumesInterrelationship());
        while (enumOfNLE.hasMoreElements()) {
            NLE = (ConsumesInterrelationship)enumOfNLE.nextElement();
            e = s.getElements();
            while (e.hasMoreElements()) {
                schElement = (ScheduleElement)e.nextElement();
                m = schElement.getMethod();
                if (!NLE.getFrom().getLabel().equals(m.getLabel())) continue;
                typeOfProtocol = "";
                ta = new Taems();
                v = new Vector<Object>();
                CID = State.getRandom().nextLong();
                v.addElement(m.clone());
                com = new Commitment("Resource", NLE.getTo().getLabel(), m.getAgent(), null, v, 0, 1.0f, schElement.getStart(), this.TIMEOUT + 1, schElement.getStart() + schElement.getDuration());
                com.setQuantity(0.0f - NLE.getCost().calculateMax());
                com.setResource(NLE.getTo().getLabel());
                com.setID(CID);
                ta.addCommitment(com);
                if (NLE.getTo().getAgent() != null) {
                    typeOfProtocol = "CSharp";
                    this.log.log("Using CSharp for " + NLE.getTo().getLabel() + " (" + NLE.getTo().getAgent().getLabel() + ")", 2, this.FAC_PS);
                    com.setToAgent(NLE.getTo().getAgent());
                    ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                    ce.setCoordinateID(CID);
                    if (this.checkForDefaultCommitment(com)) {
                        ce.setID(17);
                    } else {
                        commitments.addElement(ce);
                    }
                    this.addCoordinateEvent(schElement, ce);
                    continue;
                }
                typeOfProtocol = "DSharp";
                this.log.log("Using DSharp ...", 2, this.FAC_PS);
                com.setToAgent(new Agent("*"));
                ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                ce.setCoordinateID(CID);
                if (this.checkForDefaultCommitment(com)) {
                    ce.setID(17);
                } else {
                    commitments.addElement(ce);
                }
                this.addCoordinateEvent(schElement, ce);
            }
        }
        enumOfNLE = t.findNodes((Node)new ProducesInterrelationship());
        while (enumOfNLE.hasMoreElements()) {
            NLE = (ProducesInterrelationship)enumOfNLE.nextElement();
            e = s.getElements();
            while (e.hasMoreElements()) {
                schElement = (ScheduleElement)e.nextElement();
                m = schElement.getMethod();
                if (!NLE.getFrom().getLabel().equals(m.getLabel())) continue;
                typeOfProtocol = "";
                ta = new Taems();
                v = new Vector();
                CID = State.getRandom().nextLong();
                v.addElement(m.clone());
                com = new Commitment("Resource", NLE.getTo().getLabel(), m.getAgent(), null, v, 0, 1.0f, schElement.getStart(), this.TIMEOUT + 1, schElement.getStart() + schElement.getDuration());
                com.setQuantity(NLE.getCost().calculateMax());
                com.setResource(NLE.getTo().getLabel());
                com.setID(CID);
                ta.addCommitment(com);
                if (NLE.getTo().getAgent() != null) {
                    typeOfProtocol = "CSharp";
                    this.log.log("Using CSharp for " + NLE.getTo().getLabel() + " (" + NLE.getTo().getAgent().getLabel() + ")", 2, this.FAC_PS);
                    com.setToAgent(NLE.getTo().getAgent());
                    ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                    ce.setCoordinateID(CID);
                    if (this.checkForDefaultCommitment(com)) {
                        ce.setID(17);
                    } else {
                        commitments.addElement(ce);
                    }
                    this.addCoordinateEvent(schElement, ce);
                    continue;
                }
                typeOfProtocol = "DSharp";
                this.log.log("Using DSharp ...", 2, this.FAC_PS);
                com.setToAgent(new Agent("*"));
                ce = new CoordinateEvent(this, typeOfProtocol, 16, ta);
                ce.setCoordinateID(CID);
                if (this.checkForDefaultCommitment(com)) {
                    ce.setID(17);
                } else {
                    commitments.addElement(ce);
                }
                this.addCoordinateEvent(schElement, ce);
            }
        }
        this.log.log("Coordinating over " + commitments.size() + " Commitments", 2, this.FAC_PS);
        return commitments;
    }

    public void callFSMCoordinate(Vector v) {
        Enumeration enumOfCoordinateEvent = v.elements();
        if (this.fsmCoordinate != null) {
            while (enumOfCoordinateEvent.hasMoreElements()) {
                CoordinateEvent ce = (CoordinateEvent)((Object)enumOfCoordinateEvent.nextElement());
                this.startFireEvent(ce);
            }
        }
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Enumeration enumeration = this.listeners.elements();
        this.log.log("Firing a coordinate event", 4, this.FAC_PS);
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            if (e.wasReceived()) {
                l.coordinateEventReceived(e);
                break;
            }
            if (!e.wasSent()) continue;
            l.coordinateEventSent(e);
            break;
        }
        if (this.log != null) {
            this.log.log((AgentEvent)e, 2, this.FAC_PS);
        }
        this.log.log("Fired a coordinate event", 5, this.FAC_PS);
    }

    public void handleAcceptation(CoordinateEvent e) {
        this.setCoordinateEvent(e, 1);
    }

    public void handleTimeout(CoordinateEvent e) {
        if (e.getFsmID() == CSharpInitiator.getFsmID() || e.getFsmID() == CSharpResponder.getFsmID()) {
            this.replaceCoordinateEvent(e);
        } else if (e.getFsmID() == DSharpInitiator.getFsmID() || e.getFsmID() == DSharpResponder.getFsmID()) {
            this.evaluateDSharpConflict(e);
        }
    }

    public void handleRejection(CoordinateEvent e) {
        this.replaceCoordinateEvent(e);
    }

    public void handlePosed(CoordinateEvent e) {
        if (e.getFsmID() == DSharpInitiator.getFsmID() || e.getFsmID() == DSharpResponder.getFsmID()) {
            this.checkForDSharpConflict(e);
        }
    }

    protected void checkForDSharpConflict(CoordinateEvent ce) {
        Enumeration e = ce.getTaems().getCommitments();
        Commitment com = (Commitment)e.nextElement();
        Commitment conflicting = this.findConflictingResource(com.getEarliestStartTime(), com.getTimeSatisfied(), com.getType());
        if (conflicting != null) {
            Taems ta = new Taems();
            ta.addCommitment(conflicting);
            CoordinateEvent ce1 = new CoordinateEvent(this, "Conflict", 16, ta);
            ce1.setCoordinateID(ce.getCoordinateID());
            this.coordinateQueue.addElement(ce1);
        }
    }

    public void evaluateDSharpConflict(CoordinateEvent ce) {
        Resource r;
        Commitment c;
        double totalInUse = 0.0;
        String resource = "";
        Vector<Commitment> newList = new Vector<Commitment>();
        Enumeration e = ce.getTaems().getCommitments();
        while (e.hasMoreElements()) {
            c = (Commitment)e.nextElement();
            newList.addElement(c);
            totalInUse = (double)c.getQuantity() + totalInUse;
            resource = c.getType();
        }
        if (newList.size() > 1 && ((totalInUse += (r = (Resource)this.conditioned.findNode(new Node(resource))).getState()) > r.getOverloadedAt() || totalInUse < r.getDepletedAt())) {
            this.log.log(" -----------> CONFLICT !!!..", 0, this.FAC_PS);
            System.err.println("totalInUse = " + totalInUse);
            System.err.println(" ressource String = " + resource);
            System.err.println(" resource r = " + r);
            System.err.println(" OverloadedAt = " + r.getOverloadedAt());
            System.err.println(" DepletedAt = " + r.getDepletedAt());
            System.err.println("totalInUse = " + totalInUse);
            e = newList.elements();
            while (e.hasMoreElements()) {
                c = (Commitment)e.nextElement();
                this.log.log("Agent : " + c.getFromAgent().getLabel() + "[" + c.getEarliestStartTime() + " - " + c.getTimeSatisfied() + "]" + " Importance = " + c.getImportance(), 0, this.FAC_PS);
            }
        }
        this.setCoordinateEvent(ce, 1);
    }

    public Commitment findConflictingResource(int start, int finish, String resource) {
        this.log.log(" Starting Conflict Detection", 2, this.FAC_PS);
        Enumeration e = this.coordinationOverSchedule.keys();
        while (e.hasMoreElements()) {
            Vector vectorCE;
            ScheduleElement schElement = (ScheduleElement)e.nextElement();
            if (start >= schElement.getFinish() || finish <= schElement.getStart() || (vectorCE = (Vector)this.coordinationOverSchedule.get(schElement)) == null) continue;
            Enumeration e1 = vectorCE.elements();
            while (e1.hasMoreElements()) {
                Enumeration e2;
                Commitment com;
                CoordinateEvent ce1 = (CoordinateEvent)((Object)e1.nextElement());
                this.log.log(" -----------> Detecting Conflict..", 2, this.FAC_PS);
                if (!ce1.getType().equals("DSharp") || !(com = (Commitment)(e2 = ce1.getTaems().getCommitments()).nextElement()).getType().equals(resource)) continue;
                return com;
            }
        }
        return null;
    }

    public void coordinateEventSent(CoordinateEvent e) {
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        this.log.log("commitmentEventReceived: " + (Object)((Object)e), 3, this.FAC_PS);
        switch (e.getID()) {
            case 4096: {
                this.log.log("commitmentEventReceived REJECTED", 2, this.FAC_PS);
                this.handleRejection(e);
                break;
            }
            case 65536: {
                this.log.log("commitmentEventReceived TIMED OUT", 2, this.FAC_PS);
                this.handleTimeout(e);
                break;
            }
            case 1: {
                this.log.log("commitmentEventReceived ACCEPTED", 2, this.FAC_PS);
                this.handleAcceptation(e);
                break;
            }
            case 16: {
                this.log.log("commitmentEventReceived POSED", 2, this.FAC_PS);
                this.handlePosed(e);
                break;
            }
            case 256: {
                this.log.log("commitmentEventReceived CANCELED", 2, this.FAC_PS);
                break;
            }
            default: {
                this.log.log("commitmentEventReceived Unknown: " + e.getID(), 2, this.FAC_PS);
            }
        }
    }
}

