/*
 * Decompiled with CFR 0.152.
 */
package agent.directory;

import agent.directory.Entry;
import agent.directory.EntryBase;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import utilities.Expression;

public class EntryDescription
extends EntryBase {
    public static final String ENTRYDESCRIPTION = "D";

    public EntryDescription(String a) {
        super(ENTRYDESCRIPTION, a);
    }

    public EntryDescription(String a, String s) throws ParseException {
        super(ENTRYDESCRIPTION, a);
        EntryBase e = EntryBase.fromString(s);
        if (e == null) {
            throw new ParseException("Error parsing EntryDescription: " + s, 0);
        }
        this.setLabel(e.getLabel());
        this.setAgent(e.getAgent());
        if (!this.getType().equals(e.getType())) {
            throw new ParseException("Incorrect type", 0);
        }
        Enumeration en = e.getFieldNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String data = e.getField(key);
            Expression ex = new Expression(data);
            this.addField(key, data);
        }
    }

    public EntryDescription(String a, Hashtable h) {
        super(ENTRYDESCRIPTION, a, h);
    }

    public void addField(String key, String data) {
        try {
            Expression e = new Expression(data);
            if (data == null) {
                this.removeField(key);
            } else {
                this.table.put(key, e);
            }
        }
        catch (ParseException ex) {
            System.err.println("Error parsing expression: " + ex.toString());
            ex.printStackTrace();
        }
    }

    public void addField(String key, Expression data) {
        if (data == null) {
            this.removeField(key);
        } else {
            this.table.put(key, data);
        }
    }

    public boolean checkEntry(Entry entry) {
        Enumeration e = this.getTable().elements();
        while (e.hasMoreElements()) {
            Expression ex = (Expression)e.nextElement();
            if (!ex.isFalse(entry.getTable())) continue;
            return false;
        }
        return true;
    }
}

