/*
 * Decompiled with CFR 0.152.
 */
package agent.directory;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class EntryBase {
    protected Hashtable table = new Hashtable();
    protected static int NUM = 0;
    protected String type;
    protected String label;
    protected String agent;

    public EntryBase(String t, String a) {
        this.setType(t);
        this.setLabel("" + NUM++);
        this.setAgent(a);
    }

    public EntryBase(String t, String a, Hashtable h) {
        this(t, a);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            String key = k.toString();
            String data = h.get(k).toString();
            this.addField(key, data);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String a) {
        this.agent = a;
    }

    protected String getType() {
        return this.type;
    }

    protected void setType(String t) {
        this.type = t;
    }

    public void addField(String key, String data) {
        if (data == null) {
            this.removeField(key);
        } else {
            this.table.put(key, data);
        }
    }

    public void removeField(String key) {
        this.table.remove(key);
    }

    public String getField(String key) {
        Object o = this.table.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public boolean hasField(String key) {
        return this.getField(key) != null;
    }

    public Enumeration getFieldNames() {
        return this.table.keys();
    }

    protected Hashtable getTable() {
        return this.table;
    }

    public boolean equals(EntryBase b) {
        if (b == this) {
            return true;
        }
        if (!this.matches(b)) {
            return false;
        }
        Enumeration e = this.getFieldNames();
        while (e.hasMoreElements()) {
            String you;
            String key = (String)e.nextElement();
            String me = this.getField(key);
            if (me.equals(you = b.getField(key))) continue;
            return false;
        }
        return true;
    }

    public boolean matches(EntryBase b) {
        if (b == this) {
            return true;
        }
        if (!this.getLabel().equals(b.getLabel())) {
            return false;
        }
        if (!this.getAgent().equals(b.getAgent())) {
            return false;
        }
        if (this.getTable().size() != b.getTable().size()) {
            return false;
        }
        Enumeration e = this.getFieldNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (b.hasField(key)) continue;
            return false;
        }
        return true;
    }

    protected static EntryBase fromString(String s) {
        StringTokenizer tok = new StringTokenizer(s, "[]|: \t\n\r", true);
        EntryBase eb = null;
        block0: while (tok.hasMoreElements()) {
            String t = tok.nextToken();
            if (!t.equals("[")) continue;
            t = tok.nextToken();
            tok.nextToken();
            eb = new EntryBase(t, tok.nextToken());
            tok.nextToken();
            eb.setLabel(tok.nextToken());
            while (tok.hasMoreElements()) {
                if (!t.equals("|")) {
                    t = tok.nextToken();
                }
                if (t.equals("[") || t.equals("|")) {
                    String key = "";
                    String data = "";
                    while (tok.hasMoreElements()) {
                        t = tok.nextToken();
                        if (t.equals(":")) {
                            key = key.trim();
                            break;
                        }
                        key = key + t;
                    }
                    int count = 0;
                    while (tok.hasMoreElements()) {
                        t = tok.nextToken();
                        if (t.equals("[")) {
                            ++count;
                        } else if (t.equals("]") || t.equals("|")) {
                            if (count == 0) break;
                            --count;
                        }
                        data = data + t;
                    }
                    data = data.trim();
                    eb.addField(key, data);
                    continue;
                }
                if (t.equals("]")) continue block0;
            }
        }
        return eb;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[" + this.getType() + " " + this.getAgent() + " " + this.getLabel());
        Enumeration e = this.getFieldNames();
        b.append("[");
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            b.append(k + ":" + this.getField(k).toString());
            if (!e.hasMoreElements()) continue;
            b.append("|");
        }
        b.append("]]");
        return b.toString();
    }
}

