/*
 * Decompiled with CFR 0.152.
 */
package agent.directory;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.directory.DirectoryEvent;
import agent.directory.DirectoryEventListener;
import agent.directory.DirectorySearch;
import agent.directory.Entry;
import agent.directory.EntryDescription;
import agent.simplest.Communicate;
import agent.simplest.Log;
import agent.simplest.MessageEvent;
import agent.simplest.MessageEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.EnumerationEnumeration;
import utilities.KQMLMessage;
import utilities.Message;

public class DirectoryService
extends AgentComponent
implements MessageEventListener,
PropertyEventListener,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected static String DIR_ADD = "DrA";
    protected static String DIR_REMOVE = "DrK";
    protected static String DIR_QUERY = "DrQ";
    protected static String DIR_REPLY = "DrR";
    protected static String DIR_NONE = "DrN";
    protected Log log;
    protected State state;
    protected Communicate communicate;
    protected ListenerVector listeners = new ListenerVector();
    protected Vector searches = new Vector();
    protected Vector descriptions = new Vector();
    protected Hashtable entries = new Hashtable();
    protected Hashtable queries = new Hashtable();
    protected int FAC_DIR;
    private PopupMenu menu = new PopupMenu("Directories");
    protected boolean maintainqueries = true;
    public static final String DIRECTORYENTRIES = "DirectoryEntries";
    public static final String MAINTAINDIRECTORYQUERIES = "MaintainDirectoryQueries";

    public DirectoryService() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Communicate");
        State.addParameterInfo((String)DIRECTORYENTRIES, (String)"String", (String)"Name of the file containing default directory entries");
        State.addParameterInfo((String)MAINTAINDIRECTORYQUERIES, (String)"Boolean", (String)"Past remote queries are automatically notified if result data has changed.", (Object)Boolean.TRUE);
        ((Component)((Object)this)).add(this.menu);
        ((Component)((Object)this)).addMouseListener(this);
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (State)State.findComponent((String)"State");
        this.communicate = (Communicate)State.findComponent((String)"Communicate");
        this.FAC_DIR = this.log.getFacilityID((AgentComponent)this);
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.communicate.addMessageEventListener((MessageEventListener)this);
    }

    /*
     * Unable to fully structure code
     */
    public void readDefaultEntries() {
        filename = (String)this.state.getProperty((Object)"DirectoryEntries");
        if (filename == null) {
            this.log.log("Hmm...no DirectoryEntries filename found - is that ok?", 1, this.FAC_DIR);
            return;
        }
        this.log.log("Reading default directory entries", 2, this.FAC_DIR);
        try {
            file = this.state.getExtendedEntryReader(filename);
            if (file != null) ** GOTO lbl45
            this.log.log("Error reading from directory file: " + filename, 0, this.FAC_DIR);
            return;
lbl-1000:
            // 1 sources

            {
                str = file.readLine().trim();
                if (str.startsWith("#") || str.equals("")) continue;
                if (str.startsWith("[")) {
                    buf = new StringBuffer(str);
                    while (file.ready()) {
                        str = file.readLine().trim();
                        if (str.startsWith("#") || str.equals("")) continue;
                        if (str.startsWith("[")) {
                            buf.append(str);
                            continue;
                        }
                        if (str.startsWith("]")) {
                            buf.append(str);
                            break;
                        }
                        this.log.log("Unknown line in directory file: " + str, 1, this.FAC_DIR);
                    }
                    str = buf.toString();
                    try {
                        if (str.startsWith("[D")) {
                            ed = new EntryDescription((String)this.state.getProperty((Object)"Name"), str);
                            ed.setAgent((String)this.state.getProperty((Object)"Name"));
                            this.addDescription(ed);
                            continue;
                        }
                        if (str.startsWith("[E")) {
                            en = new Entry((String)this.state.getProperty((Object)"Name"), str);
                            this.addEntry(en);
                            continue;
                        }
                        this.log.log("Unknown entry in directory file: " + str, 1, this.FAC_DIR);
                    }
                    catch (ParseException ex) {
                        this.log.log("Bad entry in directory file: " + str, 1, this.FAC_DIR);
                    }
                    continue;
                }
                this.log.log("Unknown line in directory file: " + str, 1, this.FAC_DIR);
lbl45:
                // 7 sources

                ** while (file.ready())
            }
lbl46:
            // 1 sources

            file.close();
        }
        catch (IOException e) {
            this.log.log("Error: Default directory file error: " + e, 0, this.FAC_DIR);
        }
    }

    public void begin() {
        super.begin();
    }

    public void pulse() {
        int time = (Integer)this.state.getProperty((Object)"Time");
        Iterator i = ((AbstractList)this.searches).iterator();
        while (i.hasNext()) {
            DirectorySearch search = (DirectorySearch)i.next();
            if (search.hasCompleted(time)) continue;
            this.continueSearch(search);
        }
    }

    public void reset() {
        this.searches.clear();
    }

    public void addDirectoryEventListener(DirectoryEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeDirectoryEventListener(DirectoryEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        DirectoryEvent e = (DirectoryEvent)event;
        this.log.log("Firing a directory event", 4, this.FAC_DIR);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DirectoryEventListener l = (DirectoryEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.entryAdded(e);
                    break;
                }
                case 1: {
                    l.entryRemoved(e);
                    break;
                }
                case 2: {
                    l.descriptionAdded(e);
                    break;
                }
                case 3: {
                    l.descriptionRemoved(e);
                    break;
                }
                case 4: {
                    l.queryReceived(e);
                    break;
                }
                case 5: {
                    l.responseReceived(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((AgentEvent)e, 2, this.FAC_DIR);
        }
        this.log.log("Fired a directory event", 5, this.FAC_DIR);
    }

    public void addDescription(EntryDescription d) {
        this.descriptions.addElement(d);
        this.entries.put(d, new Vector());
        this.startFireEvent(new DirectoryEvent((Object)this, d, d.getAgent(), 2));
        this.log.log("Added description to directory service: " + d.toString(), 2, this.FAC_DIR);
        this.generateMenu();
    }

    public void removeDescription(EntryDescription d) {
        Enumeration e = this.getDescriptions();
        while (e.hasMoreElements()) {
            EntryDescription td = (EntryDescription)e.nextElement();
            if (td != d && !td.equals(d)) continue;
            this.descriptions.removeElement(td);
            this.entries.remove(td);
            this.startFireEvent(new DirectoryEvent((Object)this, td, td.getAgent(), 3));
            this.log.log("Removed description from directory service: " + d.toString(), 2, this.FAC_DIR);
            break;
        }
        this.generateMenu();
    }

    public EntryDescription getDescription(String l) {
        Enumeration e = this.getDescriptions();
        while (e.hasMoreElements()) {
            EntryDescription des = (EntryDescription)e.nextElement();
            if (!des.getLabel().equals(l)) continue;
            return des;
        }
        return null;
    }

    public Enumeration getDescriptions() {
        return this.descriptions.elements();
    }

    public Iterator getSearches() {
        return ((AbstractList)this.searches).iterator();
    }

    public void addSearch(DirectorySearch search) {
        this.log.log("Adding directory search: " + search, 3, this.FAC_DIR);
        this.searches.addElement(search);
    }

    public void removeSearch(DirectorySearch search) {
        this.log.log("Removing directory search: " + search, 3, this.FAC_DIR);
        this.searches.removeElement(search);
    }

    public DirectorySearch findSearch(String id) {
        Iterator i = this.getSearches();
        while (i.hasNext()) {
            DirectorySearch search = (DirectorySearch)i.next();
            if (!search.getQueryID().equals(id)) continue;
            return search;
        }
        return null;
    }

    public DirectorySearch searchForEntries(EntryDescription e, int d, int h) {
        try {
            String id = String.valueOf(State.getRandom().nextInt());
            int time = (Integer)this.state.getProperty((Object)"Time");
            DirectorySearch search = new DirectorySearch(new EntryDescription(e.getAgent(), e.toString()), time, d, h, id);
            this.addSearch(search);
            search.setQueryHostFinished("Local", false);
            Enumeration en = this.findEntries(search.description);
            while (en.hasMoreElements()) {
                Entry entry = (Entry)en.nextElement();
                if (!search.hasEntry(entry)) {
                    this.startFireEvent(new DirectoryEvent((Object)this, entry, search.getQueryID(), 5));
                    search.addEntry(entry);
                }
                if (search.hasCompleted(time)) break;
            }
            search.setQueryHostFinished("Local", true);
            return search;
        }
        catch (ParseException ex) {
            this.log.log("Error: Problem generating DirectorySearch\n" + ex.toString(), 0, this.FAC_DIR);
            return null;
        }
    }

    protected boolean continueSearch(DirectorySearch search) {
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (search.hasCompleted(time)) {
            return true;
        }
        this.log.log("continueSearch isn't implemented yet: " + search, 1, this.FAC_DIR);
        return search.hasCompleted(time);
    }

    public void sendQuery(String agent, DirectorySearch search) {
        this.log.log("Sending query to " + agent + ": " + search.toString(), 2, this.FAC_DIR);
        KQMLMessage m = new KQMLMessage("ask", (Object)("(" + DIR_QUERY + " " + search.getFinish() + " " + search.getHits() + " " + search.getDescription().toString() + ")"), agent);
        m.addField("reply-with", search.getQueryID());
        m.addField("sequence", "-1");
        this.communicate.sendMessage((Message)m);
        search.setQueryHostFinished(agent, false);
    }

    public DirectorySearch sendQuery(String agent, EntryDescription e, int d, int h) {
        String id = String.valueOf(State.getRandom().nextInt());
        int time = (Integer)this.state.getProperty((Object)"Time");
        try {
            DirectorySearch search = new DirectorySearch(new EntryDescription(e.getAgent(), e.toString()), time, d, h, id);
            this.sendQuery(agent, search);
            return search;
        }
        catch (ParseException ex) {
            this.log.log("Error: Problem generating DirectorySearch\n" + ex.toString(), 0, this.FAC_DIR);
            return null;
        }
    }

    public Enumeration findEntries(EntryDescription d) {
        Vector<Entry> v = new Vector<Entry>();
        Enumeration e = this.getEntries();
        this.log.log("Searching for entries matching " + d.toString(), 3, this.FAC_DIR);
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            if (!d.checkEntry(entry)) continue;
            v.addElement(entry);
        }
        this.log.log("Found " + v.size() + " results", 3, this.FAC_DIR);
        return v.elements();
    }

    public void addEntry(Entry e) {
        Enumeration en = this.getDescriptions();
        boolean added = false;
        Vector<Entry> removed = new Vector<Entry>();
        this.log.log("Attempting to add entry " + e.toString(), 2, this.FAC_DIR);
        while (en.hasMoreElements()) {
            EntryDescription d = (EntryDescription)en.nextElement();
            if (!d.checkEntry(e)) continue;
            Vector v = (Vector)this.entries.get(d);
            boolean already = false;
            Iterator it = ((AbstractList)v).iterator();
            while (it.hasNext()) {
                Entry te = (Entry)it.next();
                this.log.log("Comparing to entry: " + te, 5, this.FAC_DIR);
                if (te.equals(e)) {
                    this.log.log("Equal entry is already present", 3, this.FAC_DIR);
                    already = true;
                    break;
                }
                if (!te.matches(e)) continue;
                this.log.log("Removing existing matching entry: " + te, 3, this.FAC_DIR);
                if (!removed.contains(te)) {
                    removed.add(te);
                }
                it.remove();
                break;
            }
            if (already) continue;
            v.addElement(e);
            if (!added) {
                this.startFireEvent(new DirectoryEvent((Object)this, e, e.getAgent(), 0));
            }
            added = true;
        }
        if (added && this.maintainqueries) {
            en = this.queries.keys();
            while (en.hasMoreElements()) {
                EntryDescription ed = (EntryDescription)en.nextElement();
                Vector results = (Vector)this.queries.get(ed);
                Enumeration ren = removed.elements();
                while (ren.hasMoreElements()) {
                    Entry re = (Entry)ren.nextElement();
                    if (!results.contains(re)) continue;
                    results.remove(re);
                    if (!results.contains(e)) {
                        results.add(e);
                    }
                    this.addEntry(ed.getAgent(), e);
                    break;
                }
                if (results.contains(e) || !ed.checkEntry(e)) continue;
                results.add(e);
                this.addEntry(ed.getAgent(), e);
            }
        }
        if (!added) {
            this.log.log("Entry " + e.getLabel() + " was not added", 3, this.FAC_DIR);
        }
    }

    public void addEntry(String agent, Entry e) {
        this.log.log("Sending new entry to " + agent + ": " + e, 2, this.FAC_DIR);
        KQMLMessage m = new KQMLMessage("tell", (Object)("(" + DIR_ADD + " " + e.toString() + ")"), agent);
        m.addField("sequence", "-1");
        this.communicate.sendMessage((Message)m);
    }

    public void removeEntry(Entry e) {
        Enumeration en = this.getDescriptions();
        boolean removed = false;
        this.log.log("Attempting to remove entry " + e.toString(), 2, this.FAC_DIR);
        while (en.hasMoreElements()) {
            EntryDescription d = (EntryDescription)en.nextElement();
            if (!d.checkEntry(e)) continue;
            Vector v = (Vector)this.entries.get(d);
            Enumeration ev = v.elements();
            while (ev.hasMoreElements()) {
                Entry te = (Entry)ev.nextElement();
                if (!te.equals(e)) continue;
                v.removeElement(te);
                if (!removed) {
                    this.startFireEvent(new DirectoryEvent((Object)this, e, e.getAgent(), 1));
                }
                removed = true;
            }
        }
        if (this.maintainqueries) {
            en = this.queries.keys();
            while (en.hasMoreElements()) {
                EntryDescription ed = (EntryDescription)en.nextElement();
                Vector results = (Vector)this.queries.get(ed);
                if (!results.contains(e)) continue;
                results.remove(e);
                this.removeEntry(ed.getAgent(), e);
            }
        }
    }

    public void removeEntry(String agent, Entry e) {
        this.log.log("Sending entry remove request to " + agent + ": " + e, 2, this.FAC_DIR);
        KQMLMessage m = new KQMLMessage("tell", (Object)("(" + DIR_REMOVE + " " + e.toString() + ")"), agent);
        m.addField("sequence", "-1");
        this.communicate.sendMessage((Message)m);
    }

    public Enumeration getEntries() {
        Vector v = new Vector();
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            v.addElement(((Vector)e.nextElement()).elements());
        }
        return new EnumerationEnumeration(v, true);
    }

    public Enumeration getDirectories() {
        EntryDescription des = new EntryDescription((String)this.state.getProperty((Object)"Name"));
        des.addField("Service", "(_Dir != null)");
        return this.findEntries(des);
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase(MAINTAINDIRECTORYQUERIES)) {
            this.maintainqueries = (Boolean)e.getProperty();
        }
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equalsIgnoreCase(DIRECTORYENTRIES)) {
            this.readDefaultEntries();
        } else {
            this.propertyChanged(e);
        }
    }

    public void messageSent(MessageEvent e) {
    }

    public void messageReceived(MessageEvent e) {
        block31: {
            if (e.getConnection().getType() != 1) {
                return;
            }
            KQMLMessage m = (KQMLMessage)e.getMessage();
            String perf = m.getPerformative();
            String word = m.contentWord();
            if (perf.equalsIgnoreCase("tell")) {
                if (word.equals(DIR_ADD)) {
                    String data = m.contentData();
                    try {
                        Entry en = new Entry(m.getSourceAddr(), data);
                        this.addEntry(en);
                    }
                    catch (ParseException ex) {
                        this.log.log("Error parsing directory add: " + data, 0, this.FAC_DIR);
                    }
                } else if (word.equals(DIR_REMOVE)) {
                    String data = m.contentData();
                    try {
                        Entry en = new Entry(m.getSourceAddr(), data);
                        this.removeEntry(en);
                    }
                    catch (ParseException ex) {
                        this.log.log("Error parsing directory remove: " + data, 0, this.FAC_DIR);
                    }
                }
            } else if (perf.equalsIgnoreCase("reply")) {
                if (word.equals(DIR_REPLY)) {
                    String data = m.contentData();
                    String id = m.getField("in-reply-to");
                    DirectorySearch search = this.findSearch(id);
                    int time = (Integer)this.state.getProperty((Object)"Time");
                    try {
                        Entry en = new Entry(m.getSourceAddr(), data);
                        this.addEntry(en);
                        if (search != null) {
                            if (!search.hasCompleted(time)) {
                                if (!search.hasEntry(en)) {
                                    this.log.log("Got DirReply for search " + search.getQueryID(), 2, this.FAC_DIR);
                                    search.addEntry(en);
                                    this.startFireEvent(new DirectoryEvent(this, en, m.getSourceAddr(), id, search, 5));
                                } else {
                                    this.log.log("Ignorning duplicate DirReply for search " + search.getQueryID(), 3, this.FAC_DIR);
                                }
                            } else {
                                this.log.log("Ignoring DirReply for completed search " + search.getQueryID(), 3, this.FAC_DIR);
                            }
                            break block31;
                        }
                        this.log.log("Received a DirReply that has no corresponding local search description", 3, this.FAC_DIR);
                        this.startFireEvent(new DirectoryEvent(this, en, m.getSourceAddr(), id, null, 5));
                    }
                    catch (ParseException ex) {
                        this.log.log("Error parsing directory reply: " + data, 0, this.FAC_DIR);
                    }
                } else if (word.equals(DIR_NONE)) {
                    String id = m.getField("in-reply-to");
                    DirectorySearch search = this.findSearch(id);
                    if (search != null) {
                        this.log.log("Got DirNone for search " + search.getQueryID(), 2, this.FAC_DIR);
                        search.setQueryHostFinished(m.getSourceAddr(), true);
                    } else {
                        this.log.log("Received a DirNone that has no corresponding local search description", 3, this.FAC_DIR);
                    }
                    this.startFireEvent(new DirectoryEvent(this, null, m.getSourceAddr(), id, search, 5));
                }
            } else if (perf.equalsIgnoreCase("ask") && word.equals(DIR_QUERY)) {
                String id = m.getField("reply-with");
                StringTokenizer tok = new StringTokenizer(m.contentData(), " ");
                int finish = Integer.parseInt(tok.nextToken());
                int hits = Integer.parseInt(tok.nextToken());
                StringBuffer data = new StringBuffer("");
                while (tok.hasMoreTokens()) {
                    data.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    data.append(" ");
                }
                try {
                    KQMLMessage reply;
                    EntryDescription ed = new EntryDescription(m.getSourceAddr(), data.toString());
                    this.log.log("Working on query " + id + " from " + m.getSourceAddr(), 2, this.FAC_DIR);
                    ed.setLabel(id);
                    this.startFireEvent(new DirectoryEvent(this, ed, id, m.getSourceAddr(), 4));
                    Enumeration en = this.findEntries(ed);
                    Vector<Entry> results = new Vector<Entry>();
                    while (en.hasMoreElements()) {
                        if (hits-- == 0) {
                            this.log.log("Reached hits limit on query " + id, 3, this.FAC_DIR);
                            break;
                        }
                        Entry entry = (Entry)en.nextElement();
                        reply = new KQMLMessage("reply", (Object)("(" + DIR_REPLY + " " + entry.toString() + ")"), m.getSourceAddr());
                        reply.addField("in-reply-to", id);
                        reply.addField("sequence", "-1");
                        this.communicate.sendMessage((Message)reply);
                        results.addElement(entry);
                    }
                    if (this.maintainqueries) {
                        this.queries.put(ed, results);
                    }
                    reply = new KQMLMessage("reply", (Object)("(" + DIR_NONE + ")"), m.getSourceAddr());
                    reply.addField("in-reply-to", id);
                    reply.addField("sequence", "-1");
                    this.communicate.sendMessage((Message)reply);
                }
                catch (ParseException ex) {
                    this.log.log("Error parsing directory query: " + data, 0, this.FAC_DIR);
                }
            }
        }
    }

    private void generateMenu() {
        this.menu.removeAll();
        Enumeration e = this.getDescriptions();
        while (e.hasMoreElements()) {
            EntryDescription d = (EntryDescription)e.nextElement();
            MenuItem item = new MenuItem(d.getLabel() + " Description");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String s = e.getActionCommand();
                    s = s.substring(0, s.indexOf(" Description"));
                    EntryDescription ent = DirectoryService.this.getDescription(s);
                    System.err.println(s + ": " + ent.toString());
                }
            });
            this.menu.add(item);
            item = new MenuItem(d.getLabel() + " Entries");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String s = e.getActionCommand();
                    s = s.substring(0, s.indexOf(" Entries"));
                    EntryDescription ent = DirectoryService.this.getDescription(s);
                    Enumeration en = DirectoryService.this.findEntries(ent);
                    while (en.hasMoreElements()) {
                        Entry entry = (Entry)en.nextElement();
                        System.err.println(entry.toString());
                    }
                }
            });
            this.menu.add(item);
            if (!e.hasMoreElements()) continue;
            this.menu.addSeparator();
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            this.menu.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

