/*
 * Decompiled with CFR 0.152.
 */
package agent.directory;

import agent.directory.Entry;
import agent.directory.EntryDescription;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DirectorySearch {
    protected EntryDescription description;
    protected int start;
    protected int duration;
    protected int hits;
    protected String id;
    protected Vector entries = new Vector();
    protected Hashtable hosts = new Hashtable();

    public DirectorySearch(EntryDescription e, int s, int d, int h, String i) {
        this.description = e;
        this.start = s;
        this.duration = d;
        this.hits = h;
        this.id = i;
    }

    public DirectorySearch(EntryDescription e, int s, String i) {
        this(e, s, -1, -1, i);
    }

    public String getQueryID() {
        return this.id;
    }

    public int getStart() {
        return this.start;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getFinish() {
        return this.getStart() + this.getDuration();
    }

    public int getHits() {
        return this.hits;
    }

    public EntryDescription getDescription() {
        return this.description;
    }

    public void addEntry(Entry e) {
        if (e == null) {
            return;
        }
        this.entries.addElement(e);
    }

    public boolean hasEntry(Entry e) {
        if (e == null) {
            return false;
        }
        Enumeration en = this.entries.elements();
        while (en.hasMoreElements()) {
            Entry te = (Entry)en.nextElement();
            if (!te.equals(e)) continue;
            return true;
        }
        return false;
    }

    public void setQueryHostFinished(String h, boolean b) {
        this.hosts.put(h, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isQueryHostFinished(String h) {
        if (this.hosts.containsKey(h)) {
            return (Boolean)this.hosts.get(h);
        }
        return true;
    }

    public Enumeration getQueryHosts() {
        return this.hosts.keys();
    }

    public boolean areQueryHostsFinished() {
        Enumeration e = this.getQueryHosts();
        while (e.hasMoreElements()) {
            if (this.isQueryHostFinished((String)e.nextElement())) continue;
            return false;
        }
        return true;
    }

    public boolean hasCompleted(int time) {
        return this.duration >= 0 && time >= this.start + this.duration || this.hits >= 0 && this.numResponses() > this.hits;
    }

    public int numResponses() {
        return this.entries.size();
    }

    public boolean hasResponses() {
        return this.numResponses() > 0;
    }

    public Enumeration getResponses() {
        return this.entries.elements();
    }

    public String toString() {
        return "DirectorySearch (" + this.getQueryID() + "): " + this.numResponses() + " responses";
    }
}

