/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.reactor;

import agent.diagnose.DiagnosticsBoard;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.diagnosis.DiagnosisEvent;
import agent.diagnose.diagnosis.DiagnosisEventListener;
import agent.diagnose.reaction.MakeCommitmentDefault;
import agent.diagnose.reaction.Reaction;
import taems.Commitment;

class ReactionMonitor
implements DiagnosisEventListener {
    DiagnosticsBoard board;
    Diagnosis diagnosis;
    Reaction reaction;
    long id;

    public ReactionMonitor(DiagnosticsBoard b, Diagnosis d) {
        this.diagnosis = d;
        this.board = b;
        this.reaction = this.produceReaction(this.diagnosis);
        if (this.reaction != null) {
            this.board.addReaction(this.reaction);
            this.board.addDiagnosisEventListener(this);
        }
    }

    public Reaction produceReaction(Diagnosis d) {
        MakeCommitmentDefault r = null;
        if (d.getConfidence() <= 0.0) {
            return r;
        }
        if (d.getName().equals("PeriodicCoordination")) {
            Commitment commit = (Commitment)d.getData("Commitment");
            int start = (Integer)d.getData("Start");
            int period = (Integer)d.getData("Period");
            r = new MakeCommitmentDefault(this, commit, start, period, d.getConfidence());
        }
        return r;
    }

    public void diagnosisRemoved(DiagnosisEvent e) {
        if (this.diagnosis.getID() == e.getDiagnosis().getID()) {
            this.board.removeReaction(this.reaction);
            this.board.removeDiagnosisEventListener(this);
        }
    }

    public void diagnosisChanged(DiagnosisEvent e) {
        if (this.diagnosis.getID() == e.getDiagnosis().getID() && this.reaction.getConfidence() != e.getDiagnosis().getConfidence()) {
            this.reaction.setConfidence(e.getDiagnosis().getConfidence());
            this.board.addReaction(this.reaction);
        }
    }

    public void diagnosisAdded(DiagnosisEvent e) {
        this.diagnosisChanged(e);
    }
}

