/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.observe;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.coordinate.CoordinateEvent;
import agent.diagnose.DiagnosticsBoard;
import agent.diagnose.model.ResourceModelEvent;
import agent.diagnose.observe.SymptomObserver;
import agent.diagnose.symptom.ActionAborted;
import agent.diagnose.symptom.ActionEnded;
import agent.diagnose.symptom.ActionStarted;
import agent.diagnose.symptom.CommitmentReceived;
import agent.diagnose.symptom.CommitmentSent;
import agent.diagnose.symptom.ResourceModelPredictionFailure;
import agent.diagnose.symptom.SensorData;
import agent.simplest.ActionEvent;
import agent.simplest.Log;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.Sensor;
import agent.simplest.SensorEvent;
import agent.simplest.SensorEventListener;
import agent.simplest.State;

public class Symptomatic
extends AgentComponent
implements SensorEventListener {
    protected int FAC_SYMP;
    protected Log log;
    protected Observe observe;
    protected DiagnosticsBoard board;
    protected Sensor sensor;

    public Symptomatic() {
        this.addDependency("Log");
        this.addDependency("Observe");
        this.addDependency("DiagnosticsBoard");
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.observe = (Observe)State.findComponent((String)"Observe");
        this.board = (DiagnosticsBoard)State.findComponent((String)"DiagnosticsBoard");
        this.sensor = (Sensor)State.findComponent((String)"Sensor");
        if (this.sensor != null) {
            this.sensor.addSensorEventListener((SensorEventListener)this);
        }
        this.FAC_SYMP = this.log.getFacilityID((AgentComponent)this);
        super.init();
    }

    public void begin() {
        this.observe.addObserver((Observer)new SymptomObserver("Action Started", this.board){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof ActionEvent && e.getID() == 0;
            }

            public void addEvent(AgentEvent e) {
                if (this.checkEvent(e)) {
                    this.addSymptom(new ActionStarted((Object)this, ((ActionEvent)e).getAction()));
                }
            }
        });
        this.observe.addObserver((Observer)new SymptomObserver("Action Ended", this.board){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof ActionEvent && e.getID() == 1;
            }

            public void addEvent(AgentEvent e) {
                if (this.checkEvent(e)) {
                    this.addSymptom(new ActionEnded((Object)this, ((ActionEvent)e).getAction()));
                }
            }
        });
        this.observe.addObserver((Observer)new SymptomObserver("Action Aborted", this.board){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof ActionEvent && e.getID() == 2;
            }

            public void addEvent(AgentEvent e) {
                if (this.checkEvent(e)) {
                    this.addSymptom(new ActionAborted((Object)this, ((ActionEvent)e).getAction()));
                }
            }
        });
        this.observe.addObserver((Observer)new SymptomObserver("Commitment Received", this.board){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof CoordinateEvent && ((CoordinateEvent)e).wasReceived();
            }

            public void addEvent(AgentEvent e) {
                if (this.checkEvent(e)) {
                    this.getBoard().addSymptom(new CommitmentReceived((Object)this, ((CoordinateEvent)e).getTaems(), e.getID(), ((CoordinateEvent)e).getType(), ((CoordinateEvent)e).getFsmID()));
                }
            }
        });
        this.observe.addObserver((Observer)new SymptomObserver("Commitment Sent", this.board){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof CoordinateEvent && ((CoordinateEvent)e).wasSent();
            }

            public void addEvent(AgentEvent e) {
                if (this.checkEvent(e)) {
                    this.getBoard().addSymptom(new CommitmentSent((Object)this, ((CoordinateEvent)e).getTaems(), e.getID(), ((CoordinateEvent)e).getType(), ((CoordinateEvent)e).getFsmID()));
                }
            }
        });
        this.observe.addObserver((Observer)new SymptomObserver("Resource Model Prediction Failure", this.board){

            public boolean checkEvent(AgentEvent e) {
                return e instanceof ResourceModelEvent && e.getID() == 2;
            }

            public void addEvent(AgentEvent e) {
                if (this.checkEvent(e)) {
                    ResourceModelEvent re = (ResourceModelEvent)e;
                    this.getBoard().addSymptom(new ResourceModelPredictionFailure((Object)this, re.getModel().getResource().getLabel(), re.getExpected(), re.getActual()));
                }
            }
        });
    }

    public void sensorAdded(SensorEvent e) {
        if (e.getID() == 0) {
            SymptomObserver s = new SymptomObserver(e.getSensor() + " Sensor Monitor", this.board){
                Sensor sensor = null;
                String query = null;

                public boolean checkEvent(AgentEvent e) {
                    return false;
                }

                public void newTime(int time) {
                    super.newTime(time);
                    if (this.sensor == null) {
                        this.sensor = (Sensor)this.getData().get("Sensor");
                        this.query = (String)this.getData().get("SensorQuery");
                    }
                    String sensordata = (String)this.sensor.readSensorData(this.query, "String");
                    this.addSymptom(new SensorData((Object)this, this.query, sensordata));
                }
            };
            s.getData().put("Sensor", this.sensor);
            s.getData().put("SensorQuery", e.getSensor());
            this.observe.addObserver((Observer)s);
        }
    }
}

