/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.model;

import java.util.Enumeration;
import java.util.Hashtable;
import utilities.Distribution;

public class ResourceUsage
implements Cloneable {
    protected Distribution start;
    protected Distribution duration;
    protected Distribution usage;
    protected String label;
    protected String resource;
    protected String type;
    protected boolean consume;
    protected Hashtable uses;

    public ResourceUsage(String l, String r, boolean c, String t, Distribution s, Distribution d, Distribution u) {
        this.label = l;
        this.resource = r;
        this.consume = c;
        this.type = t;
        this.start = s;
        this.duration = d;
        this.usage = u;
        this.generateUses();
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public boolean isProduce() {
        return !this.isConsume();
    }

    public String getResource() {
        return this.resource;
    }

    public Distribution getStart() {
        return this.start;
    }

    public Distribution getDuration() {
        return this.duration;
    }

    public Distribution getUsage() {
        return this.usage;
    }

    public Hashtable getUses() {
        return this.uses;
    }

    public Distribution getUse(int i) {
        return (Distribution)this.getUses().get(new Integer(i));
    }

    public Object clone() {
        return new ResourceUsage(this.getLabel(), this.getResource(), this.isConsume(), this.getType(), this.getStart(), this.getDuration(), this.getUsage());
    }

    protected void generateUses() {
        Hashtable<Integer, Distribution> u = new Hashtable<Integer, Distribution>();
        Enumeration se = this.getStart().elements();
        while (se.hasMoreElements()) {
            Float sv = (Float)se.nextElement();
            Float sd = (Float)se.nextElement();
            Distribution nd = this.getDuration().applyDensity(sd.floatValue());
            Enumeration de = nd.elements();
            block1: while (de.hasMoreElements()) {
                Float dv = (Float)de.nextElement();
                Float dd = (Float)de.nextElement();
                int start = (int)sv.floatValue();
                int finish = (int)sv.floatValue() + (int)dv.floatValue() - 1;
                int time = start;
                while (time <= finish) {
                    block14: {
                        block12: {
                            block13: {
                                if (this.getType() != "duration_independent") break block12;
                                if (!this.isConsume()) break block13;
                                if (time != start) {
                                    continue block1;
                                }
                                break block12;
                            }
                            if (time != finish) break block14;
                        }
                        Distribution nu = this.getUsage().applyDensity(dd.floatValue());
                        Enumeration ue = nu.elements();
                        while (ue.hasMoreElements()) {
                            Float uv = (Float)ue.nextElement();
                            Float ud = (Float)ue.nextElement();
                            Distribution slot = (Distribution)u.get(new Integer(time));
                            if (slot == null) {
                                slot = new Distribution();
                                u.put(new Integer(time), slot);
                            }
                            if (this.isProduce()) {
                                slot.appendTerm(uv, ud);
                                continue;
                            }
                            slot.appendTerm(new Float(-1.0f * uv.floatValue()), ud);
                        }
                    }
                    ++time;
                }
            }
        }
        Enumeration ue = u.elements();
        while (ue.hasMoreElements()) {
            Distribution slot = (Distribution)ue.nextElement();
            ResourceUsage.normalizeDistribution(slot);
        }
        this.uses = u;
    }

    protected static Distribution normalizeDistribution(Distribution d) {
        float density = d.calculateTotalDensity();
        if (density < 1.0f) {
            d.appendTerm(0.0f, 1.0f - density);
        }
        return d;
    }

    public String toString() {
        return "\"" + this.getLabel() + "\" " + this.resource + " [" + this.getType() + "] - " + "Start: " + this.getStart() + " Duration: " + this.getDuration() + " Usage: " + this.getUsage() + " -> " + this.getUses();
    }
}

