/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.model;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.diagnose.model.ResourceModel;
import agent.diagnose.model.ResourceModelEvent;
import agent.diagnose.model.ResourceModelEventListener;
import agent.diagnose.model.ResourceUsage;
import agent.mass.SimpleTaemsReader;
import agent.simplest.Control;
import agent.simplest.Log;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.Sensor;
import agent.simplest.SensorEvent;
import agent.simplest.SensorEventListener;
import agent.simplest.State;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JOptionPane;
import taems.Commitment;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.ProducesInterrelationship;
import taems.Resource;
import taems.Schedule;
import taems.ScheduleElement;
import taems.Taems;
import utilities.Distribution;
import utilities.SafeEnumeration;

public class ResourceModeler
extends AgentComponent
implements PropertyEventListener,
SensorEventListener,
MouseListener {
    static final long serialVersionUID = 1234567890L;
    protected int FAC_RM;
    protected ListenerVector listeners = new ListenerVector();
    protected Log log;
    protected State state;
    protected Sensor sensor;
    protected Observe observe;
    protected Hashtable models = new Hashtable();
    protected boolean sensedmodels;
    protected boolean automodel;
    protected boolean autoscan;
    protected boolean updatetaems;
    protected Vector commitments = new Vector();
    protected Vector schedules = new Vector();
    protected Hashtable schedule_usages = new Hashtable();
    private PopupMenu menu = new PopupMenu("Resource Models");
    private int lasttime = -1;

    public ResourceModeler() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("Sensor");
        this.addDependency("Observe");
        State.addParameterInfo((String)"SensedModels", (String)"Boolean", (String)"If true, only resources with sensors will be modeled", (Object)new Boolean(false));
        State.addParameterInfo((String)"AutoModel", (String)"Boolean", (String)"If true, ResourceModeler will attempt to automatically maintain the resource models", (Object)new Boolean(true));
        State.addParameterInfo((String)"AutoScan", (String)"Boolean", (String)"If true, ResourceModeler will automatically scan subjective task structures for resources", (Object)new Boolean(true));
        State.addParameterInfo((String)"UpdateTaemsResources", (String)"Boolean", (String)"If true, ResourceModeler will attempt to automatically update resource objects in Taems models", (Object)new Boolean(true));
        State.addParameterInfo((String)"PauseOnResourceFailure", (String)"Boolean", (String)"Automatically pause when a resource has been exceeeded", (Object)new Boolean(true));
        MenuItem item = new MenuItem("Reprocess " + SimpleTaemsReader.SUBTAEMS);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String key = SimpleTaemsReader.SUBTAEMS;
                Object tasks = ResourceModeler.this.state.getProperty((Object)key);
                if (tasks != null) {
                    PropertyEvent fake = new PropertyEvent((Object)this, (Object)key, tasks, 2);
                    ResourceModeler.this.propertyChanged(fake);
                } else {
                    ResourceModeler.this.log.log("Whoops, couldn't find " + key, 1, ResourceModeler.this.FAC_RM);
                }
            }
        });
        this.menu.add(item);
        item = new MenuItem("Reprocess " + SimpleTaemsReader.CONTAEMS);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String key = SimpleTaemsReader.CONTAEMS;
                Object tasks = ResourceModeler.this.state.getProperty((Object)key);
                if (tasks != null) {
                    PropertyEvent fake = new PropertyEvent((Object)this, (Object)key, tasks, 2);
                    ResourceModeler.this.propertyChanged(fake);
                } else {
                    ResourceModeler.this.log.log("Whoops, couldn't find " + key, 1, ResourceModeler.this.FAC_RM);
                }
            }
        });
        this.menu.add(item);
        ((Component)((Object)this)).add(this.menu);
        ((Component)((Object)this)).addMouseListener(this);
    }

    public void addResourceModelEventListener(ResourceModelEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeResourceModelEventListener(ResourceModelEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        ResourceModelEvent e = (ResourceModelEvent)event;
        Enumeration enumeration = this.listeners.elements();
        this.log.log("Firing resource model event", 4, this.FAC_RM);
        while (enumeration.hasMoreElements()) {
            ResourceModelEventListener l = (ResourceModelEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.modelAdded(e);
                    break;
                }
                case 1: {
                    l.modelUpdated(e);
                    break;
                }
                case 2: {
                    l.modelPredictionFailed(e);
                    break;
                }
            }
        }
        this.log.log("Fired a resource modeler event", 5, this.FAC_RM);
    }

    public void init() {
        super.init();
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (State)State.findComponent((String)"State");
        this.sensor = (Sensor)State.findComponent((String)"Sensor");
        this.observe = (Observe)State.findComponent((String)"Observe");
        ResourceModel.FAC_RM = this.FAC_RM = this.log.getFacilityID((AgentComponent)this);
        this.state.addPropertyEventListener((PropertyEventListener)this);
        this.sensor.addSensorEventListener((SensorEventListener)this);
    }

    public void begin() {
    }

    public void reset() {
        super.reset();
        this.models.clear();
    }

    public void pulse() {
        this.checkPredictions();
    }

    public synchronized void checkPredictions() {
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (time == this.lasttime) {
            return;
        }
        this.lasttime = time;
        Enumeration e = this.models.elements();
        while (e.hasMoreElements()) {
            ResourceModel m = (ResourceModel)e.nextElement();
            if (m.getSensorQuery() == null) continue;
            Float a = (Float)this.sensor.readSensorData(m.getSensorQuery(), "Float");
            if (a != null) {
                Distribution p = m.predictActual(time);
                if (p != null) {
                    this.log.log(m.getResource().getLabel() + " - Predicted value: " + p + ", Actual value: " + a, 3, this.FAC_RM);
                    if (!p.containsValue(a.floatValue(), 0.0f)) {
                        this.log.log(m.getResource().getLabel() + " prediction failed, expected " + m.getExpectations(time - 1) + " (previous is " + m.getActual(time - 1) + ")", 1, this.FAC_RM);
                        this.startFireEvent(new ResourceModelEvent(this, m, p, a, 2));
                    }
                } else {
                    this.log.log("No prediction possible for " + m.getResource().getLabel(), 2, this.FAC_RM);
                }
                if (a == null) continue;
                this.setActual(m.getResource().getLabel(), time, a.floatValue());
                continue;
            }
            m.setSensorQuery(null);
            this.log.log("Sorry, no sensor found for " + m.getResource().getLabel(), 1, this.FAC_RM);
        }
    }

    protected Enumeration getTaems() {
        Enumeration e;
        Object o;
        Vector<Object> v = new Vector<Object>();
        if (this.state.hasProperty((Object)SimpleTaemsReader.CONTAEMS)) {
            o = this.state.getProperty((Object)SimpleTaemsReader.CONTAEMS);
            if (o instanceof Taems) {
                v.addElement(o);
            } else if (o instanceof Hashtable) {
                e = ((Hashtable)o).elements();
                while (e.hasMoreElements()) {
                    v.addElement(e.nextElement());
                }
            }
        }
        if (this.state.hasProperty((Object)SimpleTaemsReader.SUBTAEMS)) {
            o = this.state.getProperty((Object)SimpleTaemsReader.SUBTAEMS);
            if (o instanceof Taems) {
                v.addElement(o);
            } else if (o instanceof Hashtable) {
                e = ((Hashtable)o).elements();
                while (e.hasMoreElements()) {
                    v.addElement(e.nextElement());
                }
            }
        }
        return v.elements();
    }

    public synchronized int findAvailability(int est, int lst, Vector usages, float prob) {
        ResourceModel m;
        Vector<ResourceModel> ms = new Vector<ResourceModel>();
        Enumeration e = usages.elements();
        while (e.hasMoreElements()) {
            ResourceUsage usage = (ResourceUsage)e.nextElement();
            m = this.getModel(usage.getResource());
            if (m == null) {
                this.log.log("Error: Could not find resource model for " + usage.getResource(), 0, this.FAC_RM);
                return -1;
            }
            if (ms.contains(m)) continue;
            ms.addElement(m);
        }
        e = ms.elements();
        int lat = 0;
        while (e.hasMoreElements()) {
            m = (ResourceModel)e.nextElement();
            int l = m.getLastActualTime();
            if (l <= lat) continue;
            lat = l;
        }
        if (lat >= est && (est = lat + 1) > lst) {
            lst = est;
        }
        e = ms.elements();
        int let = 0;
        while (e.hasMoreElements()) {
            m = (ResourceModel)e.nextElement();
            int l = m.getLastExpectationTime();
            if (l <= let) continue;
            let = l;
        }
        if (lst > let && est > (lst = let + 1)) {
            lst = est;
        }
        this.log.log("Searching for availability for " + usages.size() + " usage(s) starting at time " + est + " to time " + lst + " with minimum probability " + prob, 4, this.FAC_RM);
        boolean interest = true;
        int t = est;
        float p = 0.0f;
        while (true) {
            if (interest) {
                p = this.checkAvailability(t, usages);
            }
            if (p >= prob) {
                return t;
            }
            if (t >= lst) {
                return -1;
            }
            int next = -1;
            e = ms.elements();
            while (e.hasMoreElements()) {
                m = (ResourceModel)e.nextElement();
                int tmp = m.getNextInterestingTime(t);
                if (tmp < 0) continue;
                if (next == -1) {
                    next = tmp;
                    continue;
                }
                if (tmp >= next) continue;
                next = tmp;
            }
            if (next == -1) {
                t = lst;
                continue;
            }
            t = next;
        }
    }

    public synchronized float checkAvailability(int time, Vector usages) {
        ResourceModel m;
        ResourceUsage usage;
        Vector<ResourceUsage> removes = new Vector<ResourceUsage>();
        float success = 1.0f;
        Distribution start = new Distribution((float)time, 1.0f);
        this.log.log("Checking availability for " + usages.size() + " usages at time " + time, 3, this.FAC_RM);
        Enumeration e = usages.elements();
        while (e.hasMoreElements()) {
            usage = (ResourceUsage)e.nextElement();
            m = this.getModel(usage.getResource());
            if (m == null) {
                this.log.log("Error: Could not find resource model for " + usage.getResource(), 0, this.FAC_RM);
                return 0.0f;
            }
            if (!usage.start.equals(start)) {
                usage = (ResourceUsage)usage.clone();
                usage.start = start;
                usage.generateUses();
            }
            float s = m.checkAvailability(time, usage);
            m.addUsage(usage);
            removes.addElement(usage);
            if (s < success) {
                success = s;
            }
            if (!(success <= 0.0f) || !e.hasMoreElements()) continue;
            this.log.log("Zero probability hit, stopping availability check", 4, this.FAC_RM);
            break;
        }
        e = removes.elements();
        while (e.hasMoreElements()) {
            usage = (ResourceUsage)e.nextElement();
            m = this.getModel(usage.getResource());
            m.removeUsage(usage);
        }
        return success;
    }

    public synchronized int getNextInterestingTime(Vector v, int t) {
        int next = -1;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ResourceUsage usage = (ResourceUsage)e.nextElement();
            ResourceModel m = this.getModel(usage.getResource());
            int tmp = m.getNextInterestingTime(t);
            if (tmp < 0) continue;
            if (next == -1) {
                next = tmp;
                continue;
            }
            if (tmp >= next) continue;
            next = tmp;
        }
        return next;
    }

    public synchronized float checkUsage(ResourceUsage usage) {
        ResourceModel m = this.getModel(usage.getResource());
        if (m != null) {
            return m.checkUsage(usage);
        }
        this.log.log("Warning: Could not check resource usage because model for " + usage.getResource() + " does not seem to exist", 1, this.FAC_RM);
        return 0.0f;
    }

    public synchronized void addUsage(ResourceUsage usage) {
        ResourceModel m = this.getModel(usage.getResource());
        if (m != null) {
            this.checkPredictions();
            m.addUsage(usage);
            this.startFireEvent(new ResourceModelEvent(this, m, 1));
        } else {
            this.log.log("Warning: Could not add resource usage because model for " + usage.getResource() + " does not seem to exist", 1, this.FAC_RM);
        }
    }

    public synchronized void removeUsage(ResourceUsage usage) {
        ResourceModel m = this.getModel(usage.getResource());
        if (m != null) {
            this.checkPredictions();
            m.removeUsage(usage);
            this.startFireEvent(new ResourceModelEvent(this, m, 1));
        } else {
            this.log.log("Warning: Could not remove resource usage because model for " + usage.getResource() + " does not seem to exist", 1, this.FAC_RM);
        }
    }

    public synchronized void setActual(String rsrc, int time, float value) {
        ResourceModel m = this.getModel(rsrc);
        if (m != null) {
            m.setActual(time, value);
            this.startFireEvent(new ResourceModelEvent(this, m, 1));
            if (this.updatetaems) {
                m.getResource().setState((double)value);
                Resource clone = m.getResource();
                clone.setState(Double.NEGATIVE_INFINITY);
                Enumeration te = this.getTaems();
                while (te.hasMoreElements()) {
                    Taems taems = (Taems)te.nextElement();
                    Resource r = (Resource)taems.findNode((Node)clone);
                    if (r == null) continue;
                    r.setState((double)value);
                    if (!r.isOverloaded() && !r.isDepleted()) continue;
                    this.log.log("Warning: Resource " + r.getLabel() + " has exceeded its bounds: " + r, 1, this.FAC_RM);
                    new Exception().printStackTrace();
                    if (!this.state.hasProperty((Object)"PauseOnResourceFailure") || !((Boolean)this.state.getProperty((Object)"PauseOnResourceFailure")).booleanValue()) continue;
                    ((Control)State.findComponent((String)"Control")).setPaused(true);
                }
            }
        } else {
            this.log.log("Warning: Could not set actual value because model for " + rsrc + " does not seem to exist", 1, this.FAC_RM);
        }
    }

    public ResourceModel getModel(String rsrc) {
        if (rsrc == null) {
            return null;
        }
        return (ResourceModel)this.models.get(rsrc);
    }

    public Enumeration getModels() {
        return this.models.elements();
    }

    public boolean addModel(ResourceModel m) {
        if (this.sensedmodels && this.sensor.findSensor(m.getSensorQuery()) == null) {
            this.log.log("Model for " + m.getResource().getLabel() + " not added - no sensor found", 1, this.FAC_RM);
            return false;
        }
        if (this.getModel(m.getResource().getLabel()) != null) {
            this.log.log("Model for " + m.getResource().getLabel() + " not added - already exists", 1, this.FAC_RM);
            return false;
        }
        this.models.put(m.getResource().getLabel(), m);
        if (State.hasComponent((String)"Observe") && this.sensor.findSensor(m.getResource().getLabel()) != null) {
            Observe observe = (Observe)State.findComponent((String)"Observe");
            Observer observer = new Observer("Failed " + m.getResource().getLabel() + " Predictions"){

                public boolean checkEvent(AgentEvent e) {
                    return e instanceof ResourceModelEvent && e.getID() == 2 && ((ResourceModelEvent)e).getModel().getResource().getLabel().equals(this.getData().get("Resource"));
                }
            };
            observe.addObserver(observer);
            observer.getData().put("Resource", m.getResource().getLabel());
        }
        if (m.getSensorQuery() != null) {
            int time = (Integer)this.state.getProperty((Object)"Time") - 1;
            Float a = (Float)this.sensor.readSensorData(m.getSensorQuery(), "Float");
            if (time >= 0) {
                if (a != null) {
                    this.log.log("Setting value of " + m.getResource().getLabel() + " model to " + a, 2, this.FAC_RM);
                    this.setActual(m.getResource().getLabel(), time, a.floatValue());
                } else {
                    this.log.log("Couldn't sense value of " + m.getResource().getLabel() + ", using known value of " + m.getResource().getState() + " from Taems object", 1, this.FAC_RM);
                    m.setActual(time, (float)m.getResource().getState());
                }
            } else if (a != null) {
                this.log.log("Setting initial value of " + m.getResource().getLabel() + " model to " + a, 2, this.FAC_RM);
                m.setInitialActual(a.floatValue());
            } else {
                this.log.log("Couldn't sense initial value of " + m.getResource().getLabel() + ", using known value of " + m.getResource().getState() + " from Taems object", 1, this.FAC_RM);
                m.setInitialActual((float)m.getResource().getState());
            }
        }
        this.menu.addSeparator();
        MenuItem item = new MenuItem(m.getResource().getLabel() + " All");
        item.addActionListener(new MyActionListener(m){

            public void actionPerformed(ActionEvent e) {
                this.doAllPrinting();
            }
        });
        this.menu.add(item);
        item = new MenuItem(m.getResource().getLabel() + " Previous");
        item.addActionListener(new MyActionListener(m){

            public void actionPerformed(ActionEvent e) {
                this.doOffsetPrinting(-1);
            }
        });
        this.menu.add(item);
        item = new MenuItem(m.getResource().getLabel() + " Current");
        item.addActionListener(new MyActionListener(m){

            public void actionPerformed(ActionEvent e) {
                this.doOffsetPrinting(0);
            }
        });
        this.menu.add(item);
        item = new MenuItem(m.getResource().getLabel() + " Next");
        item.addActionListener(new MyActionListener(m){

            public void actionPerformed(ActionEvent e) {
                this.doOffsetPrinting(1);
            }
        });
        this.menu.add(item);
        item = new MenuItem(m.getResource().getLabel() + " Arbitrary");
        item.addActionListener(new MyActionListener(m){

            public void actionPerformed(ActionEvent e) {
                String time = JOptionPane.showInputDialog(null, "Examine which time slot?", "Examing arbitrary time slot for " + this.model.getResource().getLabel(), 3);
                if (time == null) {
                    return;
                }
                try {
                    this.doPrinting(Integer.parseInt(time));
                }
                catch (Exception ex) {
                    ResourceModeler.this.log.log("Error: " + ex, 64, ResourceModeler.this.FAC_RM);
                }
            }
        });
        this.menu.add(item);
        item = new MenuItem(m.getResource().getLabel() + " Usages");
        item.addActionListener(new MyActionListener(m){

            public void actionPerformed(ActionEvent e) {
                this.doUsagePrinting();
            }
        });
        this.menu.add(item);
        this.startFireEvent(new ResourceModelEvent(this, m, 0));
        this.log.log("Added model for " + m.getResource().getLabel(), 2, this.FAC_RM);
        return true;
    }

    public void scanTaemsStructure(Taems tasks) {
        if (tasks == null) {
            this.log.log("Cannot scan null task structure", 1, this.FAC_RM);
            return;
        }
        this.log.log("Scanning task structure for resources to model", 3, this.FAC_RM);
        Enumeration e = tasks.findNodes((Node)new Resource());
        while (e.hasMoreElements()) {
            Resource rsrc = (Resource)e.nextElement();
            ResourceModel m = this.getModel(rsrc.getLabel());
            if (m == null) {
                m = new ResourceModel(rsrc, this.log);
                this.addModel(m);
                continue;
            }
            if (m.getResource() != rsrc) {
                this.log.log("Updating resource link in " + rsrc.getLabel() + " model.", 3, this.FAC_RM);
                m.setResource(rsrc);
                continue;
            }
            this.log.log("Ignoring previously viewed resource " + rsrc.getLabel(), 4, this.FAC_RM);
        }
    }

    public void checkCommitments(Vector v) {
        Commitment check;
        Enumeration e2;
        Commitment c;
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (v == null) {
            v = new Vector();
        }
        Vector<Object> add = new Vector<Object>();
        Vector<Commitment> rem = new Vector<Commitment>();
        Enumeration e1 = this.commitments.elements();
        while (e1.hasMoreElements()) {
            c = (Commitment)e1.nextElement();
            boolean found = false;
            e2 = v.elements();
            while (e2.hasMoreElements()) {
                check = (Commitment)e2.nextElement();
                if (!check.matches(c)) continue;
                found = true;
                break;
            }
            if (!found) {
                rem.addElement(c);
                continue;
            }
            this.log.log("Keeping commitment " + c.getID(), 5, this.FAC_RM);
        }
        if (rem.size() > 0) {
            this.log.log("Removing " + rem.size() + " old commitment(s)", 2, this.FAC_RM);
        }
        e1 = rem.elements();
        while (e1.hasMoreElements()) {
            c = (Commitment)e1.nextElement();
            this.log.log("Removing commitment " + c, 3, this.FAC_RM);
            ResourceUsage usage = (ResourceUsage)c.getAttribute((Object)"ResourceUsage");
            if (usage == null) {
                this.log.log("Warning: Couldn't update resource model because ResourceUsage on commitment could not be found", 1, this.FAC_RM);
            } else {
                this.removeUsage(usage);
            }
            this.commitments.removeElement(c);
        }
        e1 = v.elements();
        while (e1.hasMoreElements()) {
            c = (Commitment)e1.nextElement();
            boolean found = false;
            e2 = this.commitments.elements();
            while (e2.hasMoreElements()) {
                check = (Commitment)e2.nextElement();
                if (!check.matches(c)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (c.getResource() != null) {
                    add.addElement(c.clone());
                    continue;
                }
                this.log.log("Ignoring non resource commitment " + c.getID(), 3, this.FAC_RM);
                continue;
            }
            this.log.log("Already have commitment " + c.getID(), 5, this.FAC_RM);
        }
        if (add.size() > 0) {
            this.log.log("Found " + add.size() + " new commitment(s)", 2, this.FAC_RM);
        }
        e1 = add.elements();
        while (e1.hasMoreElements()) {
            c = (Commitment)e1.nextElement();
            this.log.log("Adding commitment " + c, 3, this.FAC_RM);
            ResourceUsage usage = new ResourceUsage(c.getLabel() + c.getID(), c.getResource(), true, "per_time_unit", new Distribution((float)c.getEarliestStartTime(), 1.0f), new Distribution((float)(c.getTimeSatisfied() - c.getEarliestStartTime()), 1.0f), new Distribution(c.getQuantity(), 1.0f));
            c.setAttribute((Object)"ResourceUsage", (Object)usage);
            this.commitments.addElement(c);
            this.addUsage(usage);
        }
        this.log.log("I know about " + this.commitments.size() + " commitments", 4, this.FAC_RM);
    }

    public synchronized void checkSchedules(Vector v) {
        ResourceUsage usage;
        Enumeration nse;
        if (v == null) {
            v = new Vector();
        }
        Vector n = (Vector)v.clone();
        SafeEnumeration ose = new SafeEnumeration(this.schedules.elements());
        while (ose.hasMoreElements()) {
            Schedule os = (Schedule)ose.nextElement();
            boolean found = false;
            nse = v.elements();
            while (nse.hasMoreElements()) {
                Schedule ns = (Schedule)nse.nextElement();
                if (!os.matches(ns)) continue;
                found = true;
                n.removeElement(ns);
                break;
            }
            if (found) continue;
            this.log.log("Removing old schedule (" + os.size() + " elements)", 5, this.FAC_RM);
            Enumeration e = ((Vector)this.schedule_usages.get(os)).elements();
            while (e.hasMoreElements()) {
                usage = (ResourceUsage)e.nextElement();
                this.removeUsage(usage);
            }
            this.schedule_usages.remove(os);
            this.schedules.removeElement(os);
        }
        nse = n.elements();
        while (nse.hasMoreElements()) {
            Schedule ns = (Schedule)nse.nextElement();
            this.log.log("Adding new schedule (" + ns.size() + " elements)", 5, this.FAC_RM);
            Enumeration e = ns.getElements();
            Vector uv = new Vector();
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                this.addScheduleElementUsages(uv, se);
            }
            e = uv.elements();
            while (e.hasMoreElements()) {
                usage = (ResourceUsage)e.nextElement();
                this.addUsage(usage);
            }
            this.schedule_usages.put(ns, uv);
            this.schedules.addElement(ns);
        }
    }

    protected void addScheduleElementUsages(Vector v, ScheduleElement se) {
        Method method = se.getMethod();
        this.log.log("Looking for resource effects by " + se.getLabel(), 3, this.FAC_RM);
        Enumeration e = method.getOutInterrelationships();
        while (e.hasMoreElements()) {
            Interrelationship ir = (Interrelationship)e.nextElement();
            Distribution use = null;
            boolean consume = true;
            if (ir instanceof ConsumesInterrelationship) {
                use = ((ConsumesInterrelationship)ir).getConsumes();
                consume = true;
            } else {
                if (!(ir instanceof ProducesInterrelationship)) continue;
                use = ((ProducesInterrelationship)ir).getProduces();
                consume = false;
            }
            ResourceUsage usage = new ResourceUsage(se.getLabel(), ir.getTo().getLabel(), consume, ir.getModel(), se.getStartTime(), se.getDurationDistribution(), use);
            v.addElement(usage);
        }
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals(SimpleTaemsReader.SUBTAEMS)) {
            if (this.autoscan) {
                if (e.getProperty() instanceof Hashtable) {
                    Enumeration en = ((Hashtable)e.getProperty()).elements();
                    while (en.hasMoreElements()) {
                        this.scanTaemsStructure((Taems)en.nextElement());
                    }
                } else if (e.getProperty() instanceof Taems) {
                    this.scanTaemsStructure((Taems)e.getProperty());
                }
            }
        } else if (key.equals(SimpleTaemsReader.CONTAEMS)) {
            if (this.automodel) {
                this.log.log("Task structure changed, analyzing it...", 3, this.FAC_RM);
                Vector sv = new Vector();
                Vector cv = new Vector();
                if (e.getProperty() instanceof Hashtable) {
                    Enumeration en = ((Hashtable)e.getProperty()).elements();
                    while (en.hasMoreElements()) {
                        Taems tasks = (Taems)en.nextElement();
                        Enumeration e2 = tasks.getScheduleVector().elements();
                        while (e2.hasMoreElements()) {
                            sv.addElement(e2.nextElement());
                        }
                        e2 = tasks.getCommitmentVector().elements();
                        while (e2.hasMoreElements()) {
                            cv.addElement(e2.nextElement());
                        }
                    }
                } else if (e.getProperty() instanceof Taems) {
                    Taems tasks = (Taems)e.getProperty();
                    sv = tasks.getScheduleVector();
                    cv = tasks.getCommitmentVector();
                }
                this.checkSchedules(sv);
                this.checkCommitments(cv);
            }
        } else if (key.equals("SensedModels")) {
            this.sensedmodels = (Boolean)e.getProperty();
        } else if (key.equals("AutoModel")) {
            this.automodel = (Boolean)e.getProperty();
        } else if (key.equals("AutoScan")) {
            this.autoscan = (Boolean)e.getProperty();
        } else if (key.equals("UpdateTaemsResources")) {
            this.updatetaems = (Boolean)e.getProperty();
        }
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    public void sensorAdded(SensorEvent e) {
        Taems tasks = (Taems)this.state.getProperty((Object)"SubTaemsTask");
        if (tasks != null) {
            this.scanTaemsStructure(tasks);
        }
    }

    public boolean hasPopupMenu() {
        return true;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 || e.isPopupTrigger()) {
            this.menu.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    private abstract class MyActionListener
    implements ActionListener {
        ResourceModel model;

        public MyActionListener(ResourceModel m) {
            this.model = m;
        }

        public void doUsagePrinting() {
            Enumeration e = this.model.getUsages();
            while (e.hasMoreElements()) {
                System.err.println(e.nextElement());
            }
        }

        public void doAllPrinting() {
            TreeSet sorted = new TreeSet();
            Iterator i = this.model.getExpectationTimes();
            while (i.hasNext()) {
                sorted.add(i.next());
            }
            i = sorted.iterator();
            while (i.hasNext()) {
                Integer slot = (Integer)i.next();
                System.err.println("Time " + slot + ": " + this.model.getExpectations(slot) + " (consumes " + this.model.getConsumesExpectations(slot) + ")");
            }
        }

        public void doOffsetPrinting(int offset) {
            int time = (Integer)ResourceModeler.this.state.getProperty((Object)"Time") + offset;
            this.doPrinting(time);
        }

        public void doPrinting(int time) {
            int t = (Integer)ResourceModeler.this.state.getProperty((Object)"Time");
            if (time > t) {
                System.err.println("Predicted amount for " + this.model.getResource().getLabel() + " at time " + time + ": " + this.model.predictActual(time));
            } else {
                System.err.println("Actual amount for " + this.model.getResource().getLabel() + " at time " + time + ": " + this.model.getActual(time) + " (predicted " + this.model.predictActual(time) + ")");
            }
            System.err.println(this.model.printExpectations(time));
        }

        public abstract void actionPerformed(ActionEvent var1);
    }
}

