/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.model;

import agent.diagnose.model.ResourceContext;
import agent.diagnose.model.ResourceUsage;
import agent.simplest.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.Vector;
import taems.ConsumableResource;
import taems.NonConsumableResource;
import taems.Resource;
import utilities.Distribution;
import utilities.SafeEnumeration;

public class ResourceModel {
    protected static int FAC_RM;
    protected Log log = null;
    protected TreeMap expected = new TreeMap();
    protected Hashtable consumes = new Hashtable(100);
    protected TreeMap actual = new TreeMap();
    protected Vector usages = new Vector();
    protected Resource resource;
    protected String senquery = null;
    protected Hashtable predictions = new Hashtable(100);
    protected Float initial = null;
    private int lastactualtime = -1;

    public ResourceModel(Resource rsrc, Log log) {
        this.setResource(rsrc);
        this.senquery = this.getResource().getLabel();
        if (this.getResource() instanceof NonConsumableResource) {
            this.setInitialActual((float)this.getResource().getState());
        }
        this.log = log;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource r) {
        this.resource = r;
    }

    public String getSensorQuery() {
        return this.senquery;
    }

    public void setSensorQuery(String q) {
        this.senquery = q;
    }

    public Float getActual(int time) {
        return (Float)this.actual.get(new Integer(time));
    }

    public Float getLastActual() {
        Float last = (Float)this.actual.get(new Integer(this.getLastActualTime()));
        if (last == null) {
            last = this.getInitialActual();
        }
        return last;
    }

    public int getLastActualTime() {
        return this.lastactualtime;
    }

    protected synchronized void setActual(int time, float level) {
        if (time > this.getLastActualTime()) {
            this.lastactualtime = time;
        }
        Integer i = new Integer(time);
        this.actual.put(i, new Float(level));
        this.log.log("Set actual value for " + this.getResource().getLabel() + " at time " + time + " to " + level, 3, FAC_RM);
        this.predictions.clear();
    }

    public Float getInitialActual() {
        return this.initial;
    }

    protected synchronized void setInitialActual(float level) {
        this.initial = new Float(level);
        if (this.log != null) {
            this.log.log("Set initial actual value for " + this.getResource().getLabel() + " to " + level, 3, FAC_RM);
        }
        this.predictions.clear();
    }

    public Distribution predictActual(int time) {
        return this.predictActual(time, true);
    }

    public synchronized Distribution predictActual(int time, boolean full) {
        int atime;
        Distribution d;
        boolean spam;
        Float a;
        Integer key;
        Vector<Distribution> v;
        Vector<Object> tv;
        block15: {
            Distribution e;
            Object p;
            block14: {
                tv = null;
                v = new Vector<Distribution>();
                p = null;
                e = null;
                key = full ? new Integer(time) : new Integer((time - 1) * -1);
                a = null;
                boolean first = true;
                spam = false;
                d = null;
                atime = -999;
                if (this.log.getLogLevel(FAC_RM) >= 5) {
                    tv = new Vector<Object>();
                    spam = true;
                }
                this.predictions.clear();
                if (this.predictions.containsKey(key)) {
                    d = (Distribution)this.predictions.get(key);
                } else {
                    this.predictions.remove(key);
                }
                if (d != null || !(this.getResource() instanceof NonConsumableResource)) break block14;
                a = this.getActual(time);
                atime = time;
                if (a != null || (e = full ? this.getExpectations(time - 1) : this.getConsumesExpectations(time - 1)) == null) break block15;
                v.addElement(e);
                if (!spam) break block15;
                tv.addElement(new Integer(time - 1));
                break block15;
            }
            if (d == null && this.getResource() instanceof ConsumableResource) {
                int t;
                atime = t = time;
                a = this.getActual(t);
                while (a == null && t >= 0) {
                    e = full || t != time ? this.getExpectations(t - 1) : this.getConsumesExpectations(t - 1);
                    a = this.getActual(t);
                    atime = t;
                    if (a != null) break;
                    if (e != null) {
                        v.addElement(e);
                        if (spam) {
                            tv.addElement(new Integer(t - 1));
                        }
                    }
                    if (p != null) {
                        v.addElement((Distribution)p);
                        if (spam) {
                            tv.addElement(new Integer(t - 1));
                        }
                        d = Distribution.computeJointDistribution(v);
                        this.predictions.put(key, d);
                        a = null;
                    }
                    t = this.getPreviousInterestingTime(t);
                }
            }
        }
        if (a == null) {
            a = this.getInitialActual();
            atime = -999;
        }
        if (a != null) {
            v.addElement(new Distribution(a, new Float(1.0)));
            if (spam) {
                tv.addElement(new String(atime + " (actual)"));
            }
            d = Distribution.computeJointDistribution(v);
            this.predictions.put(key, d);
        }
        if (spam) {
            this.log.log("Prediction components:", 5, FAC_RM);
            Enumeration en = v.elements();
            Enumeration tn = tv.elements();
            while (en.hasMoreElements()) {
                this.log.log("  " + en.nextElement() + " time:" + tn.nextElement(), 5, FAC_RM);
            }
            this.log.log("Predicted actual for time " + time + " (full:" + full + ") - " + d, 5, FAC_RM);
        }
        return d;
    }

    public synchronized Distribution getExpectations(int time) {
        Vector v = (Vector)this.expected.get(new Integer(time));
        if (v == null) {
            return null;
        }
        Distribution d = Distribution.computeJointDistribution((Vector)v);
        return ResourceUsage.normalizeDistribution(d);
    }

    public synchronized Distribution getConsumesExpectations(int time) {
        Vector v = (Vector)this.consumes.get(new Integer(time));
        if (v == null) {
            return null;
        }
        Distribution d = Distribution.computeJointDistribution((Vector)v);
        return ResourceUsage.normalizeDistribution(d);
    }

    public Iterator getExpectationTimes() {
        return this.expected.keySet().iterator();
    }

    public int getLastExpectationTime() {
        try {
            return (Integer)this.expected.lastKey();
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public boolean timeIsInteresting(int t) {
        if (t == 0) {
            return true;
        }
        if (t == this.lastactualtime) {
            return true;
        }
        Integer time = new Integer(t);
        if (this.expected.containsKey(time)) {
            return true;
        }
        if (this.actual.containsKey(time)) {
            return true;
        }
        time = new Integer(t + 1);
        if (this.expected.containsKey(time)) {
            return true;
        }
        return this.actual.containsKey(time);
    }

    public synchronized int getNextInterestingTime(int t) {
        int next;
        Integer i = new Integer(t);
        if (this.expected.containsKey(i) || this.actual.containsKey(i)) {
            next = t + 1;
        } else {
            int t2;
            int t1;
            i = new Integer(t + 1);
            try {
                t1 = this.expected.tailMap(i).firstKey();
            }
            catch (NoSuchElementException e) {
                t1 = -1;
            }
            try {
                t2 = this.actual.tailMap(i).firstKey();
            }
            catch (NoSuchElementException e) {
                t2 = -1;
            }
            next = t2 == -1 ? t1 : (t1 == -1 ? t2 : (t1 < t2 ? t1 : t2));
        }
        return next;
    }

    public synchronized int getPreviousInterestingTime(int t) {
        int t2;
        int t1;
        Integer i = new Integer(t - 1);
        if (this.expected.containsKey(i) || this.actual.containsKey(i)) {
            return t - 1;
        }
        i = new Integer(t);
        try {
            t1 = this.expected.headMap(i).lastKey() + 1;
        }
        catch (NoSuchElementException e) {
            t1 = -1;
        }
        try {
            t2 = this.actual.headMap(i).lastKey() + 1;
        }
        catch (NoSuchElementException e) {
            t2 = -1;
        }
        return t1 > t2 ? t1 : t2;
    }

    public synchronized int findAvailability(int est, int lst, ResourceUsage usage, float prob) {
        int let;
        if (prob > 1.0f) {
            prob = 1.0f;
        }
        if (est <= this.getLastActualTime()) {
            est = this.getLastActualTime() + 1;
        }
        if (lst > (let = this.getLastExpectationTime()) && est > (lst = let + 1)) {
            lst = est;
        }
        this.log.log("Searching for availability of " + usage + " starting at time " + est + " to time " + lst + " with minimum probability " + prob, 4, FAC_RM);
        int t = est;
        float p = 0.0f;
        while (!((p = this.checkAvailability(t, usage)) >= prob)) {
            if (t >= lst) {
                return -1;
            }
            if ((t = this.getNextInterestingTime(t)) >= 0) continue;
            t = lst;
        }
        return t;
    }

    public synchronized float checkAvailability(int time, ResourceUsage usage) {
        ResourceUsage newusage = usage;
        Distribution start = new Distribution((float)time, 1.0f);
        float success = 1.0f;
        if (!newusage.start.equals(start)) {
            newusage = (ResourceUsage)usage.clone();
            newusage.start = start;
            newusage.generateUses();
        }
        this.addUsage(newusage);
        this.log.log("Checking availability for " + newusage + " of resource " + this.getResource().getLabel(), 4, FAC_RM);
        success = this.checkUsage(newusage);
        this.removeUsage(newusage);
        return success;
    }

    public synchronized float checkUsage(ResourceUsage usage) {
        float success = 1.0f;
        this.log.log("Checking success probability for " + usage + " of resource " + this.getResource().getLabel(), 4, FAC_RM);
        if (!this.usages.contains(usage)) {
            this.log.log("Warning: usage " + usage + " not known to resource model", 1, FAC_RM);
            return 0.0f;
        }
        Enumeration e = usage.getUses().keys();
        while (e.hasMoreElements()) {
            Enumeration pe;
            float cs = 1.0f;
            float ts = 1.0f;
            Integer i = (Integer)e.nextElement();
            cs = 1.0f;
            Distribution pu = this.predictActual(i + 1, false);
            this.log.log("Consume success initialized to " + cs + ", checking predictions: " + pu, 5, FAC_RM);
            if (pu != null) {
                pe = pu.elements();
                while (pe.hasMoreElements()) {
                    float v = ((Float)pe.nextElement()).floatValue();
                    float p = ((Float)pe.nextElement()).floatValue();
                    if (!((double)v < this.getResource().getDepletedAt()) && !((double)v > this.getResource().getOverloadedAt())) continue;
                    this.log.log("Computing cs = " + cs + " - " + p, 5, FAC_RM);
                    this.log.log("Level of " + v + " is bad - success reduced by " + p + " to " + (cs -= p), 5, FAC_RM);
                }
                this.log.log("Time " + i + " - consume success " + cs + ": " + pu, 5, FAC_RM);
            }
            if ((pu = this.predictActual(i + 1)) == null) {
                this.log.log("Warning: Cannot generate real prediction for " + this.getResource().getLabel() + " at time " + (i + 1), 1, FAC_RM);
                pu = this.getExpectations(i);
            }
            pe = pu.elements();
            while (pe.hasMoreElements()) {
                Float v = (Float)pe.nextElement();
                Float p = (Float)pe.nextElement();
                if (!((double)v.floatValue() < this.getResource().getDepletedAt()) && !((double)v.floatValue() > this.getResource().getOverloadedAt())) continue;
                this.log.log("Level of " + v.floatValue() + " is bad - success reduced by " + p.floatValue() + " to " + (ts -= p.floatValue()), 5, FAC_RM);
            }
            this.log.log("Time " + i + " - total success " + ts + ": " + pu, 5, FAC_RM);
            float s = cs < ts ? cs : ts;
            this.log.log("Time " + i + " - min success " + s + ": " + pu, 5, FAC_RM);
            if (!(s < success)) continue;
            success = s;
        }
        this.log.log("Success probability for " + usage + " is " + success, 4, FAC_RM);
        return success;
    }

    protected synchronized void addUsage(ResourceUsage use) {
        Hashtable u = use.getUses();
        this.log.log("Adding usage " + use, 3, FAC_RM);
        if (!use.getResource().equalsIgnoreCase(this.getResource().getLabel())) {
            this.log.log("Warning: ResourceUsage label (" + use.getResource() + ") does not match model's resource name (" + this.getResource().getLabel() + ")", 1, FAC_RM);
        }
        if (u.isEmpty()) {
            this.log.log("Warning: ResourceUsage " + use.getResource() + " has empty use list.", 1, FAC_RM);
        }
        Enumeration ue = u.keys();
        while (ue.hasMoreElements()) {
            Integer i = (Integer)ue.nextElement();
            Distribution d = (Distribution)u.get(i);
            Vector<Distribution> slot = (Vector<Distribution>)this.expected.get(i);
            if (slot == null) {
                slot = new Vector<Distribution>();
                this.log.log("Adding new expected slot " + i, 5, FAC_RM);
                this.expected.put(i, slot);
            }
            slot.addElement(d);
            if (use.isConsume()) {
                slot = (Vector<Distribution>)this.consumes.get(i);
                if (slot == null) {
                    slot = new Vector<Distribution>();
                    this.consumes.put(i, slot);
                }
                slot.addElement(d);
            }
            if (this.log.getLogLevel(FAC_RM) < 4) continue;
            this.log.log(this.printExpectations(i), 4, FAC_RM);
        }
        this.usages.addElement(use);
        this.predictions.clear();
    }

    protected synchronized void removeUsage(ResourceUsage use) {
        Hashtable u = use.getUses();
        this.log.log("Removing usage " + use, 3, FAC_RM);
        if (!this.usages.removeElement(use)) {
            this.log.log("Warning: Removal of ResourceUsage (" + use + ") that model " + this.getResource().getLabel() + " doesn't seem to posess", 1, FAC_RM);
        }
        Enumeration ue = u.keys();
        while (ue.hasMoreElements()) {
            Integer i = (Integer)ue.nextElement();
            Distribution d = (Distribution)u.get(i);
            Vector slot = (Vector)this.expected.get(i);
            if (slot == null) continue;
            slot.removeElement(d);
            if (slot.isEmpty()) {
                this.log.log("Removing empty expected slot " + i, 5, FAC_RM);
                this.expected.remove(i);
            }
            if (!use.isConsume()) continue;
            slot = (Vector)this.consumes.get(i);
            if (slot == null) {
                slot = new Vector();
                this.consumes.put(i, slot);
            }
            slot.removeElement(d);
            if (!slot.isEmpty()) continue;
            this.consumes.remove(i);
        }
        this.predictions.clear();
    }

    protected synchronized void removeAllUsages() {
        SafeEnumeration e = new SafeEnumeration(this.getUsages());
        while (e.hasMoreElements()) {
            ResourceUsage usage = (ResourceUsage)e.nextElement();
            this.removeUsage(usage);
        }
    }

    public Enumeration getUsages() {
        return this.usages.elements();
    }

    public ResourceContext generateContext(int s, int f) {
        float[] as = new float[f - s];
        int i = f - 1;
        while (i >= s) {
            as[s - i] = this.predictActual(i).calculateAvg();
            --i;
        }
        return new ResourceContext(this.getResource().getLabel(), s, f, as);
    }

    public String printExpectations(int time) {
        StringBuffer sb = new StringBuffer("");
        sb.append("Expected usage for " + this.getResource().getLabel() + " at time " + time + "\n");
        Vector v = (Vector)this.expected.get(new Integer(time));
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                sb.append("  Distrib: " + e.nextElement() + "\n");
            }
            sb.append("Total: " + Distribution.computeJointDistribution((Vector)v));
        } else {
            sb.append("No expectations available for that time");
        }
        return sb.toString();
    }

    public String toString() {
        return "(ResourceModel) " + this.getResource().getLabel() + " - contains " + this.usages.size() + " usage object(s)";
    }
}

