/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.model;

import java.util.StringTokenizer;

public class ResourceContext
implements Cloneable,
Comparable {
    protected String resource;
    protected int start;
    protected int finish;
    protected float[] values;
    protected float avg;
    protected float std;

    public ResourceContext(String r, int s, int f, float[] v) {
        this.resource = r;
        this.start = s;
        this.finish = f;
        this.values = v;
        this.generateContext();
    }

    public String getResource() {
        return this.resource;
    }

    public int getStart() {
        return this.start;
    }

    public int getFinish() {
        return this.finish;
    }

    public int getDuration() {
        return this.getFinish() - this.getStart();
    }

    public float[] getValues() {
        return this.values;
    }

    public float getAverage() {
        return this.avg;
    }

    public float getStdDev() {
        return this.std;
    }

    public Object clone() {
        return new ResourceContext(this.getResource(), this.getStart(), this.getFinish(), this.getValues());
    }

    protected void generateContext() {
        float total = 0.0f;
        int i = 0;
        while (i < this.values.length) {
            total += this.values[i];
            ++i;
        }
        this.avg = total / (float)this.values.length;
        total = 0.0f;
        int i2 = 0;
        while (i2 < this.values.length) {
            total += (this.values[i2] - this.avg) * (this.values[i2] - this.avg);
            ++i2;
        }
        this.std = (float)Math.sqrt(total / (float)this.values.length);
    }

    public int compareTo(Object o) {
        ResourceContext c = (ResourceContext)o;
        if (!this.getResource().equals(c.getResource())) {
            return this.getResource().compareTo(c.getResource()) > 0 ? Integer.MAX_VALUE : Integer.MAX_VALUE;
        }
        int value = 0;
        value += this.getDuration() - c.getDuration();
        value = (int)((float)value + (this.getAverage() - c.getAverage()));
        value = (int)((float)value + (this.getStdDev() - c.getStdDev()));
        return value;
    }

    public ResourceContext(String s) {
        StringTokenizer tok = new StringTokenizer(s);
        this.resource = tok.nextToken();
        this.start = Integer.parseInt(tok.nextToken());
        this.finish = Integer.parseInt(tok.nextToken());
        int len = Integer.parseInt(tok.nextToken());
        this.values = new float[len];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.values[i] = Float.parseFloat(tok.nextToken());
            ++i;
        }
        this.generateContext();
    }

    public String output() {
        StringBuffer buf = new StringBuffer(this.getResource());
        buf.append(" " + this.getStart());
        buf.append(" " + this.getFinish());
        buf.append(" " + this.values.length);
        int i = 0;
        while (i < this.values.length) {
            buf.append(" " + this.values[i]);
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return this.getResource() + " Start: " + this.getStart() + " Finish: " + this.getFinish() + " -> " + this.getAverage() + " " + this.getStdDev();
    }
}

