/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.induce;

import agent.base.AgentComponent;
import agent.diagnose.DiagnosticsBoard;
import agent.diagnose.induce.DefaultCommitmentSource;
import agent.diagnose.induce.Effect;
import agent.diagnose.reaction.MakeCommitmentDefault;
import agent.diagnose.reaction.Reaction;
import agent.diagnose.reaction.ReactionEvent;
import agent.diagnose.reaction.ReactionEventListener;
import agent.simplest.Log;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;

public class Inducer
extends AgentComponent
implements ReactionEventListener {
    protected int FAC_INDUCE;
    protected Log log;
    protected State state;
    protected DiagnosticsBoard board;
    protected Vector effects = new Vector();

    public Inducer() {
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("DiagnosticsBoard");
    }

    public void init() {
        this.state = (State)State.findComponent((String)"State");
        this.log = (Log)State.findComponent((String)"Log");
        this.board = (DiagnosticsBoard)State.findComponent((String)"DiagnosticsBoard");
        this.board.addReactionEventListener(this);
        this.FAC_INDUCE = this.log.getFacilityID((AgentComponent)this);
        super.init();
    }

    public void pulse() {
        Enumeration e = this.getEffects();
        while (e.hasMoreElements()) {
            Effect effect = (Effect)e.nextElement();
            effect.pulse();
        }
    }

    public void invokeReaction(Reaction r) {
        DefaultCommitmentSource e = null;
        if (r instanceof MakeCommitmentDefault) {
            e = new DefaultCommitmentSource(this, r);
        }
        if (e != null) {
            this.addEffect(e);
        }
    }

    public void addEffect(Effect e) {
        if (e == null) {
            return;
        }
        this.effects.addElement(e);
        e.init();
    }

    public void removeEffect(Effect e) {
        if (e == null) {
            return;
        }
        e.end();
        this.effects.removeElement(e);
    }

    public Enumeration getEffects() {
        return this.effects.elements();
    }

    public void reactionAdded(ReactionEvent e) {
        this.log.log("Trying to invoke a reaction", 5, this.FAC_INDUCE);
        this.invokeReaction(e.getReaction());
    }

    public void reactionRemoved(ReactionEvent e) {
    }

    public void reactionChanged(ReactionEvent e) {
    }
}

