/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.induce;

import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.coordinate.CoordinateEvent;
import agent.coordinate.CoordinateEventListener;
import agent.coordinate.CoordinateEventProducer;
import agent.coordinate.DefaultCommitmentInitiator;
import agent.coordinate.FSMCoordination;
import agent.diagnose.induce.Effect;
import agent.diagnose.induce.Inducer;
import agent.diagnose.reaction.MakeCommitmentDefault;
import agent.diagnose.reaction.Reaction;
import agent.diagnose.symptom.CommitmentSent;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;
import taems.Agent;
import taems.Commitment;
import taems.Taems;

public class DefaultCommitmentSource
extends Effect
implements CoordinateEventListener,
CoordinateEventProducer {
    protected State state;
    protected FSMCoordination coordinate;
    protected int TIMEOUT = 5;
    protected ListenerVector listeners = new ListenerVector();
    protected Commitment remote;
    protected long id;
    protected boolean accepted = false;
    private boolean ev_firing = false;
    private Vector ev_queue = new Vector();
    private Integer ev_lock = new Integer(0);

    public DefaultCommitmentSource(Inducer i, Reaction r) {
        super(i, r);
        this.state = i.state;
        this.id = State.getRandom().nextLong();
    }

    public void init() {
        int time = (Integer)this.state.getProperty((Object)"Time");
        if (!(this.getReaction() instanceof MakeCommitmentDefault)) {
            Effect.log.log("Reaction for DCS is not the correct object type", 1, Effect.FAC_INDUCE);
            this.deactivate();
            return;
        }
        MakeCommitmentDefault reaction = (MakeCommitmentDefault)this.getReaction();
        Commitment accept = reaction.getCommitment();
        if (accept == null) {
            Effect.log.log("Accept commitment not found for DCS effect", 1, Effect.FAC_INDUCE);
            this.deactivate();
            return;
        }
        accept = (Commitment)accept.clone();
        CommitmentSent pose = null;
        Enumeration e = this.getBoard().getSymptoms(new CommitmentSent(this, new Taems(), 0, "", 0));
        Effect.log.log("Looking for original pose commitment, id " + accept.getID(), 4, Effect.FAC_INDUCE);
        while (e.hasMoreElements()) {
            Commitment tc;
            CommitmentSent cs = (CommitmentSent)e.nextElement();
            if (cs.getStatus() != 16 || (tc = cs.getTaems().getCommitment()) == null || tc.getID() != accept.getID()) continue;
            pose = cs;
            break;
        }
        if (pose == null) {
            Effect.log.log("Pose commitment not found for DCS effect", 1, Effect.FAC_INDUCE);
            this.deactivate();
            return;
        }
        this.id = State.getRandom().nextLong();
        this.remote = new Commitment();
        this.remote.setID(this.id);
        this.remote.setLabel("DefaultCommitment");
        this.remote.setFromAgent(new Agent((String)this.state.getProperty((Object)"Name")));
        this.remote.setToAgent(reaction.getCommitment().getToAgent());
        int i = reaction.getStart();
        while (true) {
            this.remote.setEarliestStartTime(i);
            if (i > time) break;
            i += reaction.getPeriod();
        }
        this.remote.setDeadline((Integer)this.state.getProperty((Object)"Time") + this.TIMEOUT);
        this.remote.setAttribute((Object)"Period", (Object)new Integer(reaction.getPeriod()));
        this.remote.setAttribute((Object)"CommitmentID", (Object)new Long(reaction.getCommitment().getID()));
        this.remote.setAttribute((Object)"Default", (Object)new Boolean(true));
        this.remote.setAttribute((Object)"Pose", (Object)pose);
        this.coordinate = (FSMCoordination)State.findComponent((String)"FSMCoordination");
        if (this.coordinate == null) {
            Effect.log.log("DCS can't find coordinate component", 1, Effect.FAC_INDUCE);
            this.deactivate();
            return;
        }
        this.addCoordinateEventListener(this.coordinate);
        this.coordinate.addCoordinateEventListener(this);
        Taems tasks = new Taems();
        tasks.addCommitment(this.remote);
        CoordinateEvent ce = new CoordinateEvent(this, "DefaultCommitment", 16, tasks);
        ce.setCoordinateID(this.id);
        this.startFireEvent(ce);
    }

    public void end() {
        if (this.remote == null) {
            return;
        }
        if (this.accepted) {
            Effect.log.log("Removing commitment: " + this.remote, 2, Effect.FAC_INDUCE);
            Taems tasks = (Taems)this.state.getProperty((Object)"ConTaemsTask");
            tasks.removeCommitment(this.remote);
            this.state.setProperty((Object)"ConTaemsTask", (Object)tasks);
        }
        this.coordinate.removeCoordinateEventListener(this);
    }

    public void cancelCommitment() {
        Taems tasks = new Taems();
        tasks.addCommitment(this.remote);
        CoordinateEvent ce = new CoordinateEvent(this, "DefaultCommitment", 256, tasks);
        ce.setCoordinateID(this.id);
        this.startFireEvent(ce);
    }

    public void pulse() {
    }

    public void addCoordinateEventListener(CoordinateEventListener l) {
        if (!this.listeners.contains((Object)l)) {
            this.listeners.add((AgentListener)l);
        }
    }

    public void removeCoordinateEventListener(CoordinateEventListener l) {
        if (this.listeners.contains((Object)l)) {
            this.listeners.remove((AgentListener)l);
        }
    }

    public void coordinateEventSent(CoordinateEvent e) {
        System.err.println("afasfaDSf aaaabF");
    }

    public void coordinateEventReceived(CoordinateEvent e) {
        if (e.getCoordinateID() == this.id) {
            if (e.getFsmID() != DefaultCommitmentInitiator.getFsmID()) {
                Effect.log.log("Warning: Event does not have DCI FSM id", 1, Effect.FAC_INDUCE);
                return;
            }
            if (e.getID() == 1) {
                Effect.log.log("Adding commitment: " + this.remote, 2, Effect.FAC_INDUCE);
                Taems tasks = (Taems)this.state.getProperty((Object)"ConTaemsTask");
                tasks.addCommitment(this.remote);
                this.state.setProperty((Object)"ConTaemsTask", (Object)tasks);
                this.accepted = true;
            } else if (e.getID() == 256) {
                this.deactivate();
            } else if (e.getID() == 4096) {
                this.deactivate();
            }
        }
    }

    protected void fireEvent(AgentEvent event) {
        CoordinateEvent e = (CoordinateEvent)event;
        Effect.log.log("Firing a default coordinate event", 4, Effect.FAC_INDUCE);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            CoordinateEventListener l = (CoordinateEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            if (e.wasSent()) {
                l.coordinateEventSent(e);
                continue;
            }
            if (!e.wasReceived()) continue;
            l.coordinateEventReceived(e);
        }
        if (Effect.log != null) {
            Effect.log.log((AgentEvent)e, 2, Effect.FAC_INDUCE);
        }
        Effect.log.log("Fired a default coordinate event", 5, Effect.FAC_INDUCE);
    }

    public void startFireEvent(AgentEvent event) {
        this.ev_queue.addElement(event);
        if (this.ev_firing) {
            return;
        }
        Integer n = this.ev_lock;
        synchronized (n) {
            this.ev_firing = true;
            while (!this.ev_queue.isEmpty()) {
                AgentEvent ev = (AgentEvent)this.ev_queue.firstElement();
                this.ev_queue.removeElement(ev);
                this.fireEvent(ev);
            }
            this.ev_firing = false;
        }
    }
}

