/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.BoardObject;
import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.causal.SimpleConfidenceCheck;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.symptom.ActionAborted;
import agent.diagnose.symptom.ActionEnded;
import agent.diagnose.symptom.ActionStarted;
import agent.diagnose.symptom.Symptom;
import agent.diagnose.symptom.SymptomEvent;
import agent.diagnose.symptom.SymptomEventListener;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import java.util.Enumeration;
import taems.Method;

public class UnexpectedActionDuration
extends DiagnosisComponent
implements SymptomEventListener {
    public static float THRESH = 1.15f;

    public UnexpectedActionDuration() {
        this.setDescription("No description yet");
    }

    public void init() {
        this.getBoard().addSymptomEventListener(this);
        State state = DiagnosisComponent.diagnostics.state;
        State.addParameterInfo((String)"D_UAD_Thresh", (String)"Float", (String)"UnexpectedActionDuration - Diagnose threshold (+/-)");
        if (state.hasProperty((Object)"D_UAD_Thresh")) {
            THRESH = ((Integer)state.getProperty((Object)"D_UAD_Thresh")).intValue();
        }
        super.init();
    }

    public void diagnose() {
        Action a;
        Diagnosis d = this.getSeed();
        if (d == null) {
            d = this.getDiagnosis();
        } else {
            a = (Action)d.getData("Action");
            d = new Diagnosis(this, "Action " + a.getName() + " may have unexpected duration", 0.0);
            Enumeration e = this.getSeed().getSupport();
            while (e.hasMoreElements()) {
                d.addSupport((BoardObject)e.nextElement());
            }
            d.setData("Action", a);
            this.setDiagnosis(d, false);
            this.removeSeed();
        }
        if (d != null) {
            float conf;
            a = (TaemsAction)d.getData("Action");
            int time = (Integer)this.getDiagnostics().state.getProperty((Object)"Time");
            boolean done = false;
            Enumeration e = this.getBoard().getSymptoms(time);
            while (e.hasMoreElements()) {
                Symptom ae;
                Symptom s = (Symptom)e.nextElement();
                if (s instanceof ActionEnded && ((ActionEnded)(ae = (ActionEnded)s)).getAction().getID() == a.getID()) {
                    done = true;
                    d.setData("Action", ((ActionEnded)ae).getAction());
                    if (!(((ActionEnded)ae).getAction() instanceof TaemsAction)) {
                        DiagnosisComponent.log.log("Whoops, ActionEnded does not contain a TaemsAction, UAD aborting.", 1, DiagnosisComponent.FAC_DIAG);
                        this.deactivateInstance();
                        return;
                    }
                    a = (TaemsAction)((ActionEnded)ae).getAction();
                }
                if (!(s instanceof ActionAborted) || ((ActionAborted)(ae = (ActionAborted)s)).getAction().getID() != a.getID()) continue;
                done = true;
                d.setData("Action", ((ActionAborted)ae).getAction());
                if (!(((ActionAborted)ae).getAction() instanceof TaemsAction)) {
                    DiagnosisComponent.log.log("Whoops, ActionAborted does not contain a TaemsAction, UAD aborting.", 1, DiagnosisComponent.FAC_DIAG);
                    this.deactivateInstance();
                    return;
                }
                a = (TaemsAction)((ActionAborted)ae).getAction();
            }
            float over = this.checkDuration((TaemsAction)a);
            if (over > 0.0f && (double)(conf = SimpleConfidenceCheck.calculateConfidence(0.0f, over, THRESH)) != d.getConfidence()) {
                d.setConfidence(conf);
                this.setDiagnosis(d);
                if (!this.hasLivingChildren()) {
                    this.activateChildNodes(d);
                }
            }
            if (done) {
                this.deactivateInstance();
            }
        } else {
            this.deactivateInstance();
        }
    }

    public float checkDuration(TaemsAction t) {
        int time = (Integer)this.getDiagnostics().state.getProperty((Object)"Time");
        Method m = t.getMethod();
        if (m == null) {
            DiagnosisComponent.log.log("Error, cannot find method " + t.getName(), 0, DiagnosisComponent.FAC_DIAG);
            return 0.0f;
        }
        float max = m.getGlobalOutcome().getDuration().calculateMax() + THRESH;
        int start = (Integer)t.getData((Object)"Start");
        float dur = time - start;
        DiagnosisComponent.log.log("Duration - Obs:" + dur + "  Max:" + max, 4, DiagnosisComponent.FAC_DIAG);
        if (dur > max) {
            return dur - max;
        }
        return 0.0f;
    }

    public void symptomRemoved(SymptomEvent e) {
    }

    public void symptomChanged(SymptomEvent e) {
    }

    public void symptomAdded(SymptomEvent e) {
        Action a;
        if (e.getSymptom() instanceof ActionStarted && (a = (Action)e.getSymptom().getValue()) instanceof TaemsAction) {
            Diagnosis d = new Diagnosis(this, "Action " + a.getName() + " may have unexpected duration", 0.0);
            d.addSupport(e.getSymptom());
            d.setData("Action", a);
            this.activateNewInstance(d);
        }
    }
}

