/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.causal.SimpleConfidenceCheck;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.symptom.ActionEnded;
import agent.diagnose.symptom.SymptomEvent;
import agent.diagnose.symptom.SymptomEventListener;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import taems.Method;

public class UnexpectedActionCost
extends DiagnosisComponent
implements SymptomEventListener {
    public static float THRESH = 1.15f;

    public UnexpectedActionCost() {
        this.setDescription("No description yet");
    }

    public void init() {
        this.getBoard().addSymptomEventListener(this);
        State state = DiagnosisComponent.diagnostics.state;
        State.addParameterInfo((String)"D_UAC_Thresh", (String)"Float", (String)"UnexpectedActionCost - Diagnose threshold (+/-)");
        if (state.hasProperty((Object)"D_UAC_Thresh")) {
            THRESH = ((Integer)state.getProperty((Object)"D_UAC_Thresh")).intValue();
        }
        super.init();
    }

    public float checkCost(TaemsAction t) {
        Method m = t.getMethod();
        if (m == null) {
            DiagnosisComponent.log.log("Error, cannot find method " + t.getName(), 0, DiagnosisComponent.FAC_DIAG);
            return 0.0f;
        }
        float cost = t.getCost();
        float closest = m.getGlobalOutcome().getCost().findClosestValue(cost);
        DiagnosisComponent.log.log("Cost - Obs:" + cost + "  Closest:" + closest, 4, DiagnosisComponent.FAC_DIAG);
        if (cost != closest) {
            return Math.abs(cost - closest);
        }
        return 0.0f;
    }

    public void symptomRemoved(SymptomEvent e) {
    }

    public void symptomChanged(SymptomEvent e) {
    }

    public void symptomAdded(SymptomEvent e) {
        Action a;
        if (e.getSymptom() instanceof ActionEnded && (a = (Action)e.getSymptom().getValue()) instanceof TaemsAction) {
            TaemsAction t = (TaemsAction)a;
            float over = this.checkCost(t);
            if (over > 0.0f) {
                float conf = SimpleConfidenceCheck.calculateConfidence(0.0f, over, THRESH);
                Diagnosis d = new Diagnosis(this, "Action " + a.getName() + " had different cost (" + t.getCost() + ") than expected (" + t.getMethod().getGlobalOutcome().getCost() + ")", conf);
                d.setData("Action", a);
                d.setConfidence(conf);
                this.setDiagnosis(d);
                this.activateChildNodes(d);
            } else {
                DiagnosisComponent.log.log("Method " + a.getName() + " had good cost (" + t.getCost() + ")", 4, DiagnosisComponent.FAC_DIAG);
            }
        }
    }
}

