/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.causal.SimpleConfidenceCheck;
import agent.diagnose.diagnosis.Diagnosis;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import taems.ScheduleElement;
import utilities.Distribution;

public class StartTimeDelayed
extends DiagnosisComponent {
    public static float THRESH = 1.15f;

    public StartTimeDelayed() {
        this.setDescription("No description yet");
    }

    public void init() {
        super.init();
        this.addKey("Action");
    }

    public void diagnose() {
        Diagnosis diag = this.getSeed();
        if (diag != null) {
            Action a = (Action)diag.getData("Action");
            if (a == null) {
                return;
            }
            if (a instanceof TaemsAction) {
                int astart;
                TaemsAction t = (TaemsAction)a;
                if (t.getScheduleElement() == null) {
                    DiagnosisComponent.log.log("Error: STD diagnosis requires schedule element", 1, DiagnosisComponent.FAC_DIAG);
                    return;
                }
                ScheduleElement se = t.getScheduleElement();
                Distribution estart = se.getStartTime();
                if (!estart.containsValue((float)(astart = t.getStart()), THRESH)) {
                    float conf = SimpleConfidenceCheck.calculateConfidence(estart.findClosestValue((float)astart), astart, THRESH);
                    Diagnosis d = new Diagnosis(this, "Action " + a.getName() + " had different start time (" + astart + ") than expected (" + estart + ")", conf);
                    d.setData("Action", a);
                    this.activateChildNodes(d);
                    this.setDiagnosis(d);
                } else if (a.isDone()) {
                    DiagnosisComponent.log.log("Method " + a.getName() + " had normal start time (" + astart + ")", 4, DiagnosisComponent.FAC_DIAG);
                }
            } else {
                DiagnosisComponent.log.log("Method " + a.getName() + " is not a TaemsAction, cannot check start time", 4, DiagnosisComponent.FAC_DIAG);
            }
        }
        this.deactivateInstance();
    }
}

