/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.symptom.SensorData;
import agent.diagnose.symptom.Symptom;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import java.util.Enumeration;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Resource;
import taems.Taems;

public class ResourceUnavailable
extends DiagnosisComponent {
    private static State state;

    public ResourceUnavailable() {
        this.setDescription("No description yet");
    }

    public void init() {
        state = DiagnosisComponent.diagnostics.state;
        super.init();
    }

    public void diagnose() {
        Taems tasks = (Taems)state.getProperty((Object)"SubTaemsTask");
        if (tasks == null) {
            return;
        }
        Diagnosis diag = this.getSeed();
        this.removeSeed();
        if (diag != null) {
            Action action = (Action)diag.getData("Action");
            if (action == null || !(action instanceof TaemsAction)) {
                this.deactivateInstance();
                return;
            }
            TaemsAction a = (TaemsAction)action;
            Object[] rrsrc = (Object[])a.getData((Object)"Resources");
            Method m = a.getMethod();
            if (m == null) {
                this.deactivateInstance();
                return;
            }
            Diagnosis d = new Diagnosis(this, "Method " + a.getName() + " may not have had the appropriate resources available", 0.5);
            boolean differ = false;
            Enumeration irs = m.getOutInterrelationships((Interrelationship)new ConsumesInterrelationship());
            int i = 0;
            while (irs.hasMoreElements()) {
                Interrelationship ir = (Interrelationship)irs.nextElement();
                SensorData sd = this.findSensorData(ir.getTo().getLabel(), a.getStart());
                if (sd != null && !((Resource)ir.getTo()).isNormalState(sd.getDataAsDouble())) {
                    d.addSupport(sd);
                    differ = true;
                }
                ++i;
            }
            if (differ) {
                d.setData("Action", a);
                this.setDiagnosis(d);
                this.activateChildNodes(d);
            } else {
                DiagnosisComponent.log.log("Method " + a.getName() + " had the necessary resources available", 4, DiagnosisComponent.FAC_DIAG);
            }
        }
        this.deactivateInstance();
    }

    public SensorData findSensorData(String sensor, int t) {
        DiagnosisComponent.log.log("Looking for sensor data for " + sensor + " on diagnosis board (time " + t + ")", 3, DiagnosisComponent.FAC_DIAG);
        Enumeration e = this.getBoard().getSymptoms(t);
        while (e.hasMoreElements()) {
            SensorData sd;
            Symptom s = (Symptom)e.nextElement();
            if (!(s instanceof SensorData) || !(sd = (SensorData)s).getSensor().equals(sensor)) continue;
            return sd;
        }
        return null;
    }
}

