/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.Execute;
import java.util.Enumeration;
import taems.Schedule;
import taems.ScheduleElement;

public class PreviousTaskDelayed
extends DiagnosisComponent {
    public static float THRESH = 1.15f;
    private static Execute execute;

    public PreviousTaskDelayed() {
        this.setDescription("No description yet");
    }

    public void init() {
        super.init();
        this.addKey("Action");
    }

    public void diagnose() {
        Diagnosis diag = this.getSeed();
        if (diag != null) {
            Action a = (Action)diag.getData("Action");
            if (a == null) {
                this.deactivateInstance();
                return;
            }
            if (a instanceof TaemsAction) {
                TaemsAction t = (TaemsAction)a;
                if (t.getScheduleElement() == null) {
                    DiagnosisComponent.log.log("Error: PTD diagnosis requires schedule element", 1, DiagnosisComponent.FAC_DIAG);
                    this.deactivateInstance();
                    return;
                }
                ScheduleElement se = t.getScheduleElement();
                Schedule s = se.getSchedule();
                int index = s.getScheduleElementIndex(se);
                if (index == 0) {
                    this.deactivateInstance();
                    return;
                }
                if (index == -1) {
                    DiagnosisComponent.log.log("Method " + a.getName() + " was not found in the schedule", 1, DiagnosisComponent.FAC_DIAG);
                    this.deactivateInstance();
                    return;
                }
                se = s.getScheduleElement(index - 1);
                Enumeration de = this.getBoard().getDiagnoses("CompletionTimeDelayed");
                while (de.hasMoreElements()) {
                    TaemsAction ot;
                    Diagnosis od = (Diagnosis)de.nextElement();
                    Action oa = (Action)od.getData("Action");
                    if (!oa.getName().equals(se.getLabel()) || !(ot = (TaemsAction)oa).getScheduleElement().getSchedule().equals(s)) continue;
                    double conf = od.getConfidence();
                    Diagnosis d = new Diagnosis(this, "Action " + a.getName() + " was delayed by previously delayed task " + oa.getName(), conf);
                    d.addSupport(od);
                    d.setData("Action", a);
                    d.setData("PreviousAction", oa);
                    this.activateChildNodes(d);
                    this.setDiagnosis(d);
                }
            } else {
                DiagnosisComponent.log.log("Method " + a.getName() + " is not a TaemsAction, cannot check previous tasks", 4, DiagnosisComponent.FAC_DIAG);
            }
        }
        this.deactivateInstance();
    }
}

