/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.causal.Pattern;
import agent.diagnose.causal.SimpleConfidenceCheck;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.symptom.CommitmentReceived;
import agent.diagnose.symptom.Symptom;
import agent.diagnose.symptom.SymptomEvent;
import agent.diagnose.symptom.SymptomEventListener;
import agent.simplest.PropertyEvent;
import agent.simplest.PropertyEventListener;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Commitment;
import taems.Taems;
import utilities.SafeEnumeration;

public class PeriodicCoordination
extends DiagnosisComponent
implements SymptomEventListener,
PropertyEventListener {
    public static int VIEW_THRESH = 3;
    public static int OBSERVE_WIN = 50;
    private static Hashtable commitments = new Hashtable(10);
    private static State state;
    private static Vector checked;
    private static Hashtable patterns;

    public PeriodicCoordination() {
        this.setDescription("No description yet");
    }

    public void init() {
        super.init();
        this.addKey("Commitments");
        this.addKey("Pattern");
        state = this.getDiagnostics().state;
        State.addParameterInfo((String)"D_PC_View", (String)"Integer", (String)"PeriodicCoordination - View threshold", (Object)new Integer(VIEW_THRESH));
        State.addParameterInfo((String)"D_PC_Win", (String)"Integer", (String)"PeriodicCoordination - View window", (Object)new Integer(OBSERVE_WIN));
        this.getBoard().addSymptomEventListener(this);
        state.addPropertyEventListener((PropertyEventListener)this);
    }

    public Diagnosis checkTrigger() {
        super.checkTrigger();
        int time = (Integer)state.getProperty((Object)"Time");
        int offset = time - OBSERVE_WIN;
        Enumeration e = commitments.elements();
        block0: while (e.hasMoreElements()) {
            Vector v = (Vector)e.nextElement();
            this.pruneCommitments(v, time, OBSERVE_WIN);
            int[] list = PeriodicCoordination.generateList(v, offset, OBSERVE_WIN);
            Pattern p = PeriodicCoordination.findPattern(list);
            while (true) {
                p = PeriodicCoordination.findPattern(list);
                StringBuffer sb = new StringBuffer("");
                int i = time - OBSERVE_WIN;
                while (i < time) {
                    if (i < 0) {
                        sb.append(" ");
                    } else {
                        sb.append(i % 10);
                    }
                    ++i;
                }
                DiagnosisComponent.log.log("Indexs: " + sb.toString(), 5, DiagnosisComponent.FAC_DIAG);
                sb = new StringBuffer("");
                int i2 = 0;
                while (i2 < list.length) {
                    sb.append(list[i2]);
                    ++i2;
                }
                DiagnosisComponent.log.log("String: " + sb.toString(), 5, DiagnosisComponent.FAC_DIAG);
                if (p == null) {
                    DiagnosisComponent.log.log("No pattern", 5, DiagnosisComponent.FAC_DIAG);
                } else {
                    PeriodicCoordination.removePattern(list, p);
                    p.start += offset;
                    DiagnosisComponent.log.log("Pattern: " + p.toString(), 3, DiagnosisComponent.FAC_DIAG);
                }
                if (p == null) continue block0;
                if (!PeriodicCoordination.isCheckedOutVectorPattern(v, p)) {
                    PeriodicCoordination.checkOutVectorPattern(v, p);
                    Diagnosis d = new Diagnosis(this, "Commitment may be predictably periodic.", 0.0);
                    d.setData("Commitments", v);
                    d.setData("Pattern", p);
                    this.activateNewInstance(d);
                    continue;
                }
                DiagnosisComponent.log.log("Pattern: " + p.toString() + " is already being watched", 5, DiagnosisComponent.FAC_DIAG);
            }
        }
        return null;
    }

    public boolean isTriggerable() {
        return true;
    }

    public void reset() {
        super.reset();
        commitments.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void diagnose() {
        block8: {
            Pattern p;
            Vector v;
            Diagnosis diagnosis;
            block7: {
                diagnosis = this.getDiagnosis();
                Diagnosis d = this.getSeed();
                if (d != null) {
                    diagnosis = new Diagnosis(this, d.getDescription(), -1.0);
                    diagnosis.setData("Commitments", d.getData("Commitments"));
                    diagnosis.setData("Pattern", d.getData("Pattern"));
                    this.setDiagnosis(diagnosis, false);
                    this.removeSeed();
                }
                if (diagnosis == null) {
                    this.deactivateInstance();
                    return;
                }
                v = (Vector)diagnosis.getData("Commitments");
                DiagnosisComponent.log.log("Vector has " + v.size() + " elements", 1, DiagnosisComponent.FAC_DIAG);
                p = (Pattern)diagnosis.getData("Pattern");
                int time = (Integer)state.getProperty((Object)"Time");
                int offset = time - OBSERVE_WIN;
                int[] list = PeriodicCoordination.generateList(v, offset, OBSERVE_WIN);
                DiagnosisComponent.log.log("Checking pattern " + p, 3, DiagnosisComponent.FAC_DIAG);
                p.start -= offset;
                if (!PeriodicCoordination.checkPattern(list, p)) break block7;
                p.start += offset;
                diagnosis.setData("Commitment", v.lastElement());
                diagnosis.setData("Start", new Integer(p.start));
                diagnosis.setData("Period", new Integer(p.period));
                float conf = SimpleConfidenceCheck.calculateConfidence(VIEW_THRESH - 1, p.count, OBSERVE_WIN / p.period);
                DiagnosisComponent.log.log("Found a pattern " + p + " (conf " + conf + ")", 2, DiagnosisComponent.FAC_DIAG);
                if ((double)conf != diagnosis.getConfidence()) {
                    diagnosis.setConfidence(conf);
                    this.setDiagnosis(diagnosis);
                    if (!(conf > 0.0f)) {
                        PeriodicCoordination.checkInVectorPattern(v, p);
                        this.deactivateInstance();
                        return;
                    }
                    if (!this.hasLivingChildren()) {
                        this.activateChildNodes(d);
                    }
                    break block8;
                } else {
                    DiagnosisComponent.log.log("Pattern: " + p.toString() + " still exists with same confidence", 2, DiagnosisComponent.FAC_DIAG);
                }
                break block8;
            }
            DiagnosisComponent.log.log("Pattern " + p + " not found", 2, DiagnosisComponent.FAC_DIAG);
            if (diagnosis.getConfidence() > 0.0) {
                diagnosis.setConfidence(0.0);
                this.setDiagnosis(diagnosis);
            }
            PeriodicCoordination.checkInVectorPattern(v, p);
            this.deactivateInstance();
            return;
        }
        this.sleepInstance(5);
    }

    public static Pattern findPattern(int[] list) {
        Pattern p;
        Vector<Pattern> v = new Vector<Pattern>();
        int alimit = (int)Math.ceil((float)list.length / (float)(VIEW_THRESH - 1));
        int index = list.length - 1;
        while (index >= list.length - alimit) {
            if (list[index] == 1) {
                int blimit = (int)Math.ceil((float)index / (float)(VIEW_THRESH - 1));
                int interval = list.length - 1 - index + 1;
                while (interval <= blimit) {
                    if (list[index - interval] == 1) {
                        p = new Pattern(index, interval, 1);
                        int check = index - interval;
                        while (check >= 0) {
                            if (list[check] != 1) break;
                            p.start = check;
                            ++p.count;
                            check -= interval;
                        }
                        if (p.count >= VIEW_THRESH) {
                            v.addElement(p);
                        }
                    }
                    ++interval;
                }
            }
            --index;
        }
        Enumeration e = v.elements();
        Pattern best = null;
        while (e.hasMoreElements()) {
            p = (Pattern)e.nextElement();
            if (best == null) {
                best = p;
                continue;
            }
            if (p.count <= best.count) continue;
            best = p;
        }
        return best;
    }

    public static boolean checkPattern(int[] list, Pattern pattern) {
        int count = 0;
        while (pattern.start < 0) {
            pattern.start += pattern.period;
        }
        if (pattern.start > list.length) {
            return false;
        }
        int i = pattern.start;
        while (i < list.length) {
            if (list[i] != 1) {
                return false;
            }
            ++count;
            i += pattern.period;
        }
        pattern.count = count;
        return true;
    }

    public static void removePattern(int[] list, Pattern pattern) {
        int i = pattern.start;
        while (i < list.length) {
            list[i] = 0;
            i += pattern.period;
        }
    }

    public void pruneCommitments(Vector v, int time, int window) {
        int min = time - window;
        SafeEnumeration e = new SafeEnumeration(v.elements());
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            if (c.getEarliestStartTime() >= min) continue;
            v.removeElement(c);
        }
    }

    public static int[] generateList(Vector v, int offset, int window) {
        int[] list = new int[window];
        int i = 0;
        while (i < list.length) {
            list[i] = 0;
            ++i;
        }
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            Commitment c = (Commitment)e.nextElement();
            if (c.getEarliestStartTime() - offset >= list.length || c.getEarliestStartTime() - offset < 0) continue;
            list[c.getEarliestStartTime() - offset] = 1;
        }
        return list;
    }

    public static void main(String[] args) {
        StringBuffer sb = new StringBuffer("");
        int time = 75;
        int offset = time - OBSERVE_WIN;
        Vector<Commitment> v = new Vector<Commitment>();
        Commitment c = new Commitment();
        c.setEarliestStartTime(10);
        v.addElement(c);
        c = new Commitment();
        c.setEarliestStartTime(30);
        v.addElement(c);
        c = new Commitment();
        c.setEarliestStartTime(50);
        v.addElement(c);
        c = new Commitment();
        c.setEarliestStartTime(70);
        v.addElement(c);
        int[] l = PeriodicCoordination.generateList(v, offset, OBSERVE_WIN);
        while (true) {
            Pattern p = PeriodicCoordination.findPattern(l);
            sb = new StringBuffer("");
            int i = time - OBSERVE_WIN;
            while (i < time) {
                if (i < 0) {
                    sb.append(" ");
                } else {
                    sb.append(i % 10);
                }
                ++i;
            }
            System.err.println("Indexs: " + sb.toString());
            sb = new StringBuffer("");
            int i2 = 0;
            while (i2 < l.length) {
                sb.append(l[i2]);
                ++i2;
            }
            System.err.println("String: " + sb.toString());
            if (p == null) {
                System.err.println("No pattern");
            } else {
                PeriodicCoordination.removePattern(l, p);
                p.start += offset;
                System.err.println("Pattern: " + p.toString());
            }
            if (p == null) {
                return;
            }
            System.err.println("Checked out:" + PeriodicCoordination.isCheckedOutVectorPattern(v, p));
            PeriodicCoordination.checkOutVectorPattern(v, p);
            p.start += p.period;
            System.err.println("Checked out:" + PeriodicCoordination.isCheckedOutVectorPattern(v, p));
            c = new Commitment();
            c.setEarliestStartTime(27);
            v.addElement(c);
        }
    }

    public synchronized Vector findCommitmentVector(Commitment c) {
        Commitment clone = (Commitment)c.clone();
        Vector v = null;
        clone.setEarliestStartTime(Integer.MIN_VALUE);
        clone.setTimeSatisfied(Integer.MIN_VALUE);
        clone.setID(Long.MIN_VALUE);
        Enumeration e = commitments.keys();
        while (e.hasMoreElements()) {
            Commitment check = (Commitment)e.nextElement();
            if (!check.matches(clone)) continue;
            v = (Vector)commitments.get(check);
            break;
        }
        if (v == null) {
            v = new Vector(5);
            commitments.put(clone, v);
        }
        return v;
    }

    public void addCommitment(Commitment c) {
        Vector v = this.findCommitmentVector(c);
        v.addElement(c);
    }

    public static void checkOutVectorPattern(Vector v, Pattern pattern) {
        checked.addElement(v);
        Vector<Pattern> ps = (Vector<Pattern>)patterns.get(v);
        if (ps == null) {
            ps = new Vector<Pattern>();
            patterns.put(v, ps);
        }
        ps.addElement(pattern);
    }

    public static void checkInVectorPattern(Vector v, Pattern pattern) {
        checked.removeElement(v);
        Vector ps = (Vector)patterns.get(v);
        if (ps == null) {
            return;
        }
        SafeEnumeration e = new SafeEnumeration(ps.elements());
        while (e.hasMoreElements()) {
            Pattern p = (Pattern)e.nextElement();
            if (!pattern.matches(p)) continue;
            ps.removeElement(pattern);
        }
    }

    public static boolean isCheckedOutVectorPattern(Vector v, Pattern pattern) {
        if (!checked.contains(v)) {
            return false;
        }
        Vector ps = (Vector)patterns.get(v);
        if (ps == null) {
            return false;
        }
        SafeEnumeration e = new SafeEnumeration(ps.elements());
        while (e.hasMoreElements()) {
            Pattern p = (Pattern)e.nextElement();
            if (!pattern.matches(p)) continue;
            return true;
        }
        return false;
    }

    public void symptomAdded(SymptomEvent e) {
        Symptom s = e.getSymptom();
        if (s instanceof CommitmentReceived) {
            if (((CommitmentReceived)s).getStatus() != 1) {
                DiagnosisComponent.log.log("PeriodicCoordination ignoring non-accept commitment (status is " + ((CommitmentReceived)s).getStatus() + ")", 4, DiagnosisComponent.FAC_DIAG);
                return;
            }
            DiagnosisComponent.log.log("PeriodicCoordination checking out the acceptance commitment that was received", 4, DiagnosisComponent.FAC_DIAG);
            Taems t = ((CommitmentReceived)s).getTaems();
            if (t.numCommitments() != 1) {
                DiagnosisComponent.log.log("Commitment does not have single commitment, I'm avoiding it", 2, DiagnosisComponent.FAC_DIAG);
                return;
            }
            this.addCommitment(t.getCommitment());
        }
    }

    public void symptomRemoved(SymptomEvent e) {
    }

    public void symptomChanged(SymptomEvent e) {
    }

    public void propertyChanged(PropertyEvent e) {
        String key = e.getKey().toString();
        if (key.equals("D_PC_View")) {
            VIEW_THRESH = (Integer)e.getProperty();
        } else if (key.equals("D_PC_Win")) {
            OBSERVE_WIN = (Integer)e.getProperty();
        }
    }

    public void propertyRemoved(PropertyEvent e) {
    }

    public void propertyAdded(PropertyEvent e) {
        this.propertyChanged(e);
    }

    static {
        checked = new Vector(10);
        patterns = new Hashtable(10);
    }
}

