/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import java.util.Enumeration;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Taems;

public class NoResourceCoordination
extends DiagnosisComponent {
    private static State state;

    public NoResourceCoordination() {
        this.setDescription("No description yet");
    }

    public void init() {
        state = DiagnosisComponent.diagnostics.state;
        super.init();
    }

    public void diagnose() {
        Taems stasks = (Taems)state.getProperty((Object)"SubTaemsTask");
        Taems ctasks = (Taems)state.getProperty((Object)"ConTaemsTask");
        if (stasks == null || ctasks == null) {
            return;
        }
        Diagnosis d = this.getSeed();
        if (d != null) {
            Action a = (Action)d.getData("Action");
            if (a == null) {
                this.deactivateInstance();
                return;
            }
            Method m = a instanceof TaemsAction ? ((TaemsAction)a).getMethod() : new Method(a.getName(), null);
            Method sm = (Method)stasks.findNode((Node)m);
            if (sm == null) {
                this.deactivateInstance();
                return;
            }
            Method cm = (Method)ctasks.findNode((Node)m);
            if (cm == null) {
                this.deactivateInstance();
                return;
            }
            Enumeration irs = sm.getOutInterrelationships((Interrelationship)new ConsumesInterrelationship());
            while (irs.hasMoreElements()) {
                Interrelationship ir = (Interrelationship)irs.nextElement();
                String rsrc = ir.getTo().getLabel();
                boolean coord = false;
                Enumeration cirs = cm.getOutInterrelationships(ir);
                while (cirs.hasMoreElements()) {
                    Interrelationship cir = (Interrelationship)cirs.nextElement();
                    if (!cir.getTo().getLabel().equalsIgnoreCase(rsrc)) continue;
                    coord = true;
                }
                if (rsrc != null && !coord) {
                    DiagnosisComponent.log.log("Method " + a.getName() + " not coordinating over " + rsrc, 4, DiagnosisComponent.FAC_DIAG);
                    Diagnosis nd = new Diagnosis(this, "Method " + a.getName() + " not coordinating over resource " + rsrc, 1.0);
                    nd.setData("Action", a);
                    nd.setData("Resource", rsrc);
                    this.activateChildNodes(nd);
                    this.setDiagnosis(nd);
                    continue;
                }
                DiagnosisComponent.log.log("Method " + a.getName() + " already coordinating over " + rsrc, 4, DiagnosisComponent.FAC_DIAG);
            }
        }
        this.deactivateInstance();
    }
}

