/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.base.AgentEvent;
import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.causal.SimpleConfidenceCheck;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.model.ResourceModel;
import agent.diagnose.model.ResourceModelEvent;
import agent.diagnose.model.ResourceModeler;
import agent.diagnose.observe.SymptomObserver;
import agent.diagnose.symptom.ResourceModelPredictionFailure;
import agent.simplest.Observe;
import agent.simplest.Observer;
import agent.simplest.State;
import java.util.Hashtable;

public class IncorrectModelOfResourceUsage
extends DiagnosisComponent {
    public static final int OBSERVE_WINDOW = 10;
    public static final float FAIL_MAX = 0.2f;
    public static final float FAIL_THRESH = 0.6f;
    private static ResourceModeler modeler;
    private static Observe observe;
    private Observer obsres;
    private static Hashtable obses;
    private String resource = null;

    public IncorrectModelOfResourceUsage() {
        this.setDescription("No description yet");
    }

    public void init() {
        super.init();
        this.addKey("Resource");
        modeler = (ResourceModeler)State.findComponent((String)"ResourceModeler");
        if (modeler == null) {
            DiagnosisComponent.log.log("Arg, can't find resource modeler component.", 0, DiagnosisComponent.FAC_DIAG);
        }
        observe = (Observe)State.findComponent((String)"Observe");
    }

    public void reset() {
        super.reset();
        if (this.obsres != null) {
            this.obsres.reset();
        }
    }

    public void diagnose() {
        Diagnosis diagnosis = this.getDiagnosis();
        ResourceModel model = null;
        if (modeler == null) {
            this.deactivateInstance();
            return;
        }
        if (this.resource == null) {
            Diagnosis d = this.getSeed();
            this.resource = (String)d.getData("Resource");
            DiagnosisComponent.log.log("Looking for expectation model for " + this.resource, 4, DiagnosisComponent.FAC_DIAG);
            model = modeler.getModel(this.resource);
            this.removeSeed();
            this.obsres = (Observer)obses.get(this.resource);
            if (this.obsres == null) {
                DiagnosisComponent.log.log("Creating symptom observer for " + this.resource + " expectation failures", 2, DiagnosisComponent.FAC_DIAG);
                this.obsres = new SymptomObserver(this.resource + " Expectation Failure", 10, this.getBoard()){

                    public boolean checkEvent(AgentEvent e) {
                        return e instanceof ResourceModelEvent && e.getID() == 2 && ((ResourceModelEvent)e).getModel().getResource().equals(this.getData().get("Resource"));
                    }

                    public void addEvent(AgentEvent e) {
                        super.addEvent(e);
                        if (this.checkEvent(e)) {
                            this.addSymptom(new ResourceModelPredictionFailure((Object)this, (String)this.getData().get("Resource"), ((ResourceModelEvent)e).getExpected(), ((ResourceModelEvent)e).getActual()));
                        }
                    }
                };
                observe.addObserver(this.obsres);
                this.obsres.getData().put("Resource", model.getResource());
                obses.put(this.resource, this.obsres);
            }
        }
        if (model != null && this.resource != null) {
            float conf;
            int count = (int)this.obsres.getCount();
            float rate = (float)count / (float)this.obsres.getWindowSize();
            if (diagnosis == null) {
                diagnosis = new Diagnosis(this, "Resource model/expectations of " + this.resource + " may be incorrect", 0.0);
                diagnosis.setData("Resource", this.resource);
            }
            if ((double)(conf = SimpleConfidenceCheck.calculateConfidence(0.2f, rate, 0.6f)) != diagnosis.getConfidence()) {
                diagnosis.setConfidence(conf);
                if (!this.hasLivingChildren()) {
                    this.activateChildNodes(diagnosis);
                }
                this.setDiagnosis(diagnosis);
            }
            if (rate == 0.0f) {
                observe.removeObserver(this.obsres);
                this.deactivateInstance();
            }
        } else {
            observe.removeObserver(this.obsres);
            this.deactivateInstance();
        }
    }

    static {
        obses = new Hashtable();
    }
}

