/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Vector;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Taems;
import utilities.Distribution;

public class IncorrectMethodResourceUsage
extends DiagnosisComponent {
    private static State state;

    public IncorrectMethodResourceUsage() {
        this.setDescription("No description yet");
    }

    public void init() {
        super.init();
        state = this.getDiagnostics().state;
    }

    public void diagnose() {
        Taems tasks = (Taems)state.getProperty((Object)"SubTaemsTask");
        if (tasks == null) {
            return;
        }
        Diagnosis diag = this.getSeed();
        if (diag != null) {
            int j;
            Action a = (Action)diag.getData("Action");
            if (a == null) {
                this.deactivateInstance();
                return;
            }
            Object[] rrsrc = (Object[])a.getData((Object)"Resources");
            Vector<String> ersrc = new Vector<String>();
            if (a instanceof TaemsAction) {
                Method m = ((TaemsAction)a).getMethod();
                Enumeration irs = m.getOutInterrelationships((Interrelationship)new ConsumesInterrelationship());
                int i = 0;
                while (irs.hasMoreElements()) {
                    Interrelationship ir = (Interrelationship)irs.nextElement();
                    ersrc.insertElementAt(ir.getTo().getLabel(), i);
                    ersrc.insertElementAt((String)ir.getCost(), i + 1);
                    i += 2;
                }
            }
            boolean differ = false;
            String resource = null;
            int i = 0;
            while (i < rrsrc.length) {
                boolean found = false;
                j = 0;
                while (j < ersrc.size()) {
                    DiagnosisComponent.log.log("Comparing resource " + rrsrc[i] + " to " + ersrc.elementAt(j), 4, DiagnosisComponent.FAC_DIAG);
                    if (((String)rrsrc[i]).equals((String)ersrc.elementAt(j)) && !((Distribution)ersrc.elementAt(j + 1)).containsValue(((Float)rrsrc[i + 1]).floatValue(), 0.0f)) {
                        DiagnosisComponent.log.log("Resource usage differences: Saw: " + rrsrc[i] + " " + rrsrc[i + 1] + " Exp: " + ersrc.elementAt(j) + " " + ersrc.elementAt(j + 1), 2, DiagnosisComponent.FAC_DIAG);
                        differ = true;
                        found = true;
                        resource = (String)rrsrc[i];
                        break;
                    }
                    j += 2;
                }
                if (!found) {
                    DiagnosisComponent.log.log("Resource usage differences: Saw: " + rrsrc[i] + " " + rrsrc[i + 1] + " Exp: Nothing", 2, DiagnosisComponent.FAC_DIAG);
                    resource = (String)rrsrc[i];
                    differ = true;
                }
                i += 2;
            }
            j = 0;
            while (j < ersrc.size()) {
                boolean found = false;
                int i2 = 0;
                while (i2 < rrsrc.length) {
                    if (((String)rrsrc[i2]).equals((String)ersrc.elementAt(j))) {
                        found = true;
                        break;
                    }
                    i2 += 2;
                }
                if (!found) {
                    DiagnosisComponent.log.log("Resource usage differences: Saw: Nothing  Exp: " + ersrc.elementAt(j) + " " + ersrc.elementAt(j + 1), 2, DiagnosisComponent.FAC_DIAG);
                    resource = (String)ersrc.elementAt(j);
                    differ = true;
                }
                j += 2;
            }
            if (differ) {
                Diagnosis d = new Diagnosis(this, "Method " + a.getName() + " had unexpected resource usage", 0.5);
                d.addSupport(diag);
                d.setData("Action", a);
                d.setData("Resource", resource);
                DiagnosisComponent.log.log("Method " + a.getName() + " could have incorrect resource usage", 4, DiagnosisComponent.FAC_DIAG);
                this.setDiagnosis(d);
                this.activateChildNodes(d);
            } else {
                DiagnosisComponent.log.log("Method " + a.getName() + " does not have detectable resource usage", 4, DiagnosisComponent.FAC_DIAG);
            }
            this.removeSeed();
        }
        this.suspendInstance();
    }
}

