/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.learn.Learning;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import taems.Method;
import taems.Node;
import taems.Outcome;
import taems.Taems;
import utilities.Distribution;

public class IncorrectMethodCostDist
extends DiagnosisComponent {
    private static State state;
    private static Learning learning;
    static final double alpha = 0.1;
    private Diagnosis d;

    public IncorrectMethodCostDist() {
        this.setDescription("No description yet");
    }

    public void init() {
        state = DiagnosisComponent.diagnostics.state;
        learning = (Learning)State.findComponent((String)"Learning");
        super.init();
    }

    public void diagnose() {
        Taems subjective = (Taems)state.getProperty((Object)"SubTaemsTask");
        if (subjective == null) {
            DiagnosisComponent.log.log("{IncorrectMethodCostDist}: No access to subjective view", 0, DiagnosisComponent.FAC_DIAG);
            return;
        }
        if (learning == null) {
            DiagnosisComponent.log.log("{IncorrectMethodCostDist}: No access to learning component", 0, DiagnosisComponent.FAC_DIAG);
            return;
        }
        Diagnosis diag = this.getSeed();
        if (diag != null) {
            String mname;
            Method sub_node;
            this.removeSeed();
            Action a = (Action)diag.getData("Action");
            if (a == null) {
                this.deactivateInstance();
                return;
            }
            if (a instanceof TaemsAction && (sub_node = (Method)subjective.findNode((Node)new Method(mname = a.getName(), null))) != null) {
                Outcome o1 = sub_node.getGlobalOutcome();
                Distribution learned = learning.getLearnedTaemsMethodDist(mname, 1);
                Distribution subjective_cost = o1.getCost();
                DiagnosisComponent.log.log("{IncorrectMethodCostDist}:Distributions: learned=" + learned, 5, DiagnosisComponent.FAC_DIAG);
                DiagnosisComponent.log.log("{IncorrectMethodCostDist}:Distributions: subjective=" + subjective_cost, 5, DiagnosisComponent.FAC_DIAG);
                double integralDistance = learned.compare(subjective_cost);
                if (integralDistance > 0.1) {
                    DiagnosisComponent.log.log("{IncorrectMethodCostDist}: Propose diagnosis Method " + mname + " has incorrect cost distribution" + " (Integral Distance = " + integralDistance + ")", 2, DiagnosisComponent.FAC_DIAG);
                    this.d = new Diagnosis(this, "Method " + mname + " has incorrect cost distribution", integralDistance);
                    this.d.setData("Action", a);
                    this.d.setData("Dist", learned);
                    this.d.setData("Prob", new Double(integralDistance));
                    this.d.setConfidence(2.0 * integralDistance);
                    this.d.setDescription("Action " + mname + " has an incorrect Method distribution (Learned: " + learned + " )");
                    this.activateChildNodes(this.d);
                    this.setDiagnosis(this.d);
                } else {
                    DiagnosisComponent.log.log("{IncorrectMethodCostDist}: Method " + a.getName() + " has correct cost distribution", 2, DiagnosisComponent.FAC_DIAG);
                }
            }
        }
        this.deactivateInstance();
    }
}

