/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.learn.Learning;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.Interrelationship;
import taems.LimitsInterrelationship;
import taems.Method;
import taems.Node;
import taems.Taems;
import utilities.Distribution;

public class IncorrectLimitsNLE
extends DiagnosisComponent {
    private static State state;
    private static Learning learning;
    static final double alpha = 0.1;
    private Diagnosis d;

    public IncorrectLimitsNLE() {
        this.setDescription("No description yet");
    }

    public void init() {
        state = DiagnosisComponent.diagnostics.state;
        learning = (Learning)State.findComponent((String)"Learning");
        super.init();
    }

    public void diagnose() {
        Vector<LimitsInterrelationship> NLEtoCheck = new Vector<LimitsInterrelationship>();
        Vector<Interrelationship> NLEtoRemove = new Vector<Interrelationship>();
        Vector<Interrelationship> NLEtoAdd = new Vector<Interrelationship>();
        Hashtable<String, Interrelationship> tableLearnedNLE = new Hashtable<String, Interrelationship>();
        Hashtable<String, Interrelationship> tableSubjectiveNLE = new Hashtable<String, Interrelationship>();
        int found = 0;
        double confidence = 0.0;
        Taems subjective = (Taems)state.getProperty((Object)"SubTaemsTask");
        if (subjective == null) {
            DiagnosisComponent.log.log("{IncorrectLimitsNLE}: No access to subjective view", 0, DiagnosisComponent.FAC_DIAG);
            return;
        }
        if (learning == null) {
            DiagnosisComponent.log.log("{IncorrectLimitsNLE}: No access to learning component", 0, DiagnosisComponent.FAC_DIAG);
            return;
        }
        Diagnosis diag = this.getSeed();
        if (diag != null) {
            String mname;
            Method sub_node;
            this.removeSeed();
            Action a = (Action)diag.getData("Action");
            if (a == null) {
                this.deactivateInstance();
                return;
            }
            if (a instanceof TaemsAction && (sub_node = (Method)subjective.findNode((Node)new Method(mname = a.getName(), null))) != null) {
                Interrelationship rel;
                Vector learnedNLE = learning.getLearnedResourceNLEforMethod(mname);
                DiagnosisComponent.log.log("Before : " + learnedNLE.size() + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                Enumeration e1 = learnedNLE.elements();
                while (e1.hasMoreElements()) {
                    rel = (Interrelationship)e1.nextElement();
                    if (rel instanceof LimitsInterrelationship) {
                        String key = rel.getClass().getName() + rel.getFrom().getLabel() + rel.getTo().getLabel();
                        tableLearnedNLE.put(key, rel);
                        continue;
                    }
                    learnedNLE.removeElement(rel);
                }
                DiagnosisComponent.log.log("After : " + learnedNLE.size() + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                DiagnosisComponent.log.log("Before : " + sub_node.numInInterrelationships() + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                Enumeration e12 = sub_node.getAffectingInterrelationships();
                while (e12.hasMoreElements()) {
                    rel = (Interrelationship)e12.nextElement();
                    if (!(rel instanceof LimitsInterrelationship)) continue;
                    String key = rel.getClass().getName() + rel.getFrom().getLabel() + rel.getTo().getLabel();
                    tableSubjectiveNLE.put(key, rel);
                }
                DiagnosisComponent.log.log("After : " + (sub_node.numInInterrelationships() - tableSubjectiveNLE.size()) + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                Enumeration e13 = tableSubjectiveNLE.keys();
                while (e13.hasMoreElements()) {
                    String key = (String)e13.nextElement();
                    rel = (LimitsInterrelationship)tableSubjectiveNLE.get(key);
                    LimitsInterrelationship rel2 = (LimitsInterrelationship)tableLearnedNLE.get(key);
                    if (rel2 != null) {
                        ++found;
                        boolean toBeAdded = false;
                        Distribution subjective_D = rel.getCost();
                        double integralDistance = subjective_D.compare(rel2.getCost());
                        if (integralDistance > 0.1) {
                            confidence = integralDistance + confidence;
                            toBeAdded = true;
                        }
                        if ((integralDistance = (subjective_D = rel.getDuration()).compare(rel2.getDuration())) > 0.1) {
                            confidence = integralDistance + confidence;
                            toBeAdded = true;
                        }
                        if ((integralDistance = (subjective_D = rel.getQuality()).compare(rel2.getQuality())) > 0.1) {
                            confidence = integralDistance + confidence;
                            toBeAdded = true;
                        }
                        if (!toBeAdded) continue;
                        NLEtoCheck.addElement(rel2);
                        DiagnosisComponent.log.log("{IncorrectLimitsNLE}: Propose diagnosis NLE " + rel.getLabel() + " has incorrect cost power distribution" + " (Integral Distance = " + integralDistance + ")", 2, DiagnosisComponent.FAC_DIAG);
                        continue;
                    }
                    confidence = 1.0 + confidence;
                    NLEtoRemove.addElement(rel);
                    DiagnosisComponent.log.log("{IncorrectLimitsNLE}: Propose diagnosis NLE " + rel.getLabel() + " DOES NOT exist !!", 2, DiagnosisComponent.FAC_DIAG);
                }
                Enumeration e14 = learnedNLE.elements();
                while (e14.hasMoreElements()) {
                    rel = (Interrelationship)e14.nextElement();
                    String key = rel.getClass().getName() + rel.getFrom().getLabel() + rel.getTo().getLabel();
                    if (tableSubjectiveNLE.containsKey(key)) continue;
                    NLEtoAdd.addElement(rel);
                    confidence = 1.0 + confidence;
                    DiagnosisComponent.log.log("{IncorrectLimitsNLE}: Propose diagnosis NLE " + rel.getLabel() + " is MISSING !!", 2, DiagnosisComponent.FAC_DIAG);
                }
                if (confidence >= 1.0) {
                    this.d = new Diagnosis(this, "Method " + mname + " has incorrect NLE model", 1.0);
                    this.d.setData("Action", a);
                    this.d.setData("NLEtoAdd", NLEtoAdd);
                    this.d.setData("NLEtoRemove", NLEtoRemove);
                    this.d.setData("NLEtoCheck", NLEtoCheck);
                    this.d.setData("Prob", new Double(1.0));
                    this.d.setConfidence(confidence);
                    this.d.setDescription("Action " + mname + " has an incorrect NLE model");
                    this.activateChildNodes(this.d);
                    this.setDiagnosis(this.d);
                } else {
                    DiagnosisComponent.log.log("{IncorrectLimitsNLE}: Method " + a.getName() + " has correct NLE model", 2, DiagnosisComponent.FAC_DIAG);
                }
            }
        }
        this.deactivateInstance();
    }
}

