/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.EventLogger;
import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.symptom.CommitmentReceived;
import agent.simplest.Action;
import agent.simplest.State;
import java.util.Enumeration;
import taems.Commitment;

public class IncorrectCoordinatedDurationEstimate
extends DiagnosisComponent {
    private static State state;
    private static EventLogger eventlog;
    private long responseid = 0L;

    public IncorrectCoordinatedDurationEstimate() {
        this.setDescription("No description yet");
    }

    public void init() {
        state = DiagnosisComponent.diagnostics.state;
        super.init();
    }

    public void diagnose() {
        Diagnosis d = this.getSeed();
        if (d != null) {
            Action a = (Action)d.getData("Action");
            if (a == null) {
                this.deactivateInstance();
                return;
            }
            if (a.getData((Object)"NonLocal") == null) {
                this.deactivateInstance();
                return;
            }
            CommitmentReceived cr = this.findContractCommitment(a);
            if (cr != null) {
                Commitment c = cr.getTaems().getCommitment();
                DiagnosisComponent.log.log("Found coordination record for " + a.getName() + ", querying host " + c.getFromAgent(), 4, DiagnosisComponent.FAC_DIAG);
                if (c.getTimeDistribution().findValue((float)a.getDuration()) == 0.0f) {
                    Diagnosis nd = new Diagnosis(this, "Remote host " + c.getFromAgent() + " may have misestimated method duration (expected " + c.getTimeDistribution() + " got " + a.getDuration() + ")", 0.5);
                    nd.addSupport(cr);
                    nd.setData("Action", a);
                    nd.setData("Commitment", c);
                    this.setDiagnosis(nd, false);
                } else {
                    DiagnosisComponent.log.log("Hmm, method " + a.getName() + " seems to have performed as expected.", 3, DiagnosisComponent.FAC_DIAG);
                }
            } else {
                DiagnosisComponent.log.log("Couldn't find coordination record for method " + a.getName(), 3, DiagnosisComponent.FAC_DIAG);
                Diagnosis nd = new Diagnosis(this, "Could not find coordination record for method " + a.getName(), 0.0);
                nd.setData("Action", a);
            }
        }
        this.deactivateInstance();
    }

    public CommitmentReceived findContractCommitment(Action action) {
        CommitmentReceived commit = null;
        DiagnosisComponent.log.log("Looking for committment for action " + action + " on diagnosis board (action started at " + action.getStart() + ")", 3, DiagnosisComponent.FAC_DIAG);
        Enumeration e = this.getBoard().getSymptoms(new CommitmentReceived(null, null, -1, null, -1));
        while (e.hasMoreElements()) {
            Commitment c;
            CommitmentReceived cr = (CommitmentReceived)e.nextElement();
            if (cr.getStatus() != 0x100000 || (c = cr.getTaems().getCommitment()) == null || c.getID() != action.getID()) continue;
            commit = cr;
            break;
        }
        Commitment c = commit.getTaems().getCommitment();
        if (commit == null) {
            DiagnosisComponent.log.log("Did not find matching commitment", 2, DiagnosisComponent.FAC_DIAG);
        } else if (!action.getName().equals(c.getTask())) {
            DiagnosisComponent.log.log("Warning! Commitment does not have matching task name for " + action.getName() + ": " + commit, 0, DiagnosisComponent.FAC_DIAG);
        } else {
            DiagnosisComponent.log.log("Found commitment " + commit, 2, DiagnosisComponent.FAC_DIAG);
        }
        return commit;
    }
}

