/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.learn.Learning;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import agent.simplest.State;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.ConsumesInterrelationship;
import taems.Interrelationship;
import taems.Method;
import taems.Node;
import taems.Taems;
import utilities.Distribution;

public class IncorrectConsumesNLE
extends DiagnosisComponent {
    private static State state;
    private static Learning learning;
    static final double alpha = 0.1;
    private Diagnosis d;

    public IncorrectConsumesNLE() {
        this.setDescription("No description yet");
    }

    public void init() {
        state = DiagnosisComponent.diagnostics.state;
        learning = (Learning)State.findComponent((String)"Learning");
        super.init();
    }

    public void diagnose() {
        Vector<ConsumesInterrelationship> NLEtoCheck = new Vector<ConsumesInterrelationship>();
        Vector<Interrelationship> NLEtoRemove = new Vector<Interrelationship>();
        Vector<Interrelationship> NLEtoAdd = new Vector<Interrelationship>();
        Hashtable<String, Interrelationship> tableLearnedNLE = new Hashtable<String, Interrelationship>();
        Hashtable<String, Interrelationship> tableSubjectiveNLE = new Hashtable<String, Interrelationship>();
        int found = 0;
        double confidence = 0.0;
        Taems subjective = (Taems)state.getProperty((Object)"SubTaemsTask");
        if (subjective == null) {
            DiagnosisComponent.log.log("{IncorrectConsumesNLE}: No access to subjective view", 0, DiagnosisComponent.FAC_DIAG);
            return;
        }
        if (learning == null) {
            DiagnosisComponent.log.log("{IncorrectConsumesNLE}: No access to learning component", 0, DiagnosisComponent.FAC_DIAG);
            return;
        }
        Diagnosis diag = this.getSeed();
        if (diag != null) {
            String mname;
            Method sub_node;
            this.removeSeed();
            Action a = (Action)diag.getData("Action");
            if (a == null) {
                this.deactivateInstance();
                return;
            }
            if (a instanceof TaemsAction && (sub_node = (Method)subjective.findNode((Node)new Method(mname = a.getName(), null))) != null) {
                Interrelationship rel;
                Vector learnedNLE = learning.getLearnedResourceNLEforMethod(mname);
                DiagnosisComponent.log.log("Before : " + learnedNLE.size() + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                Enumeration e1 = learnedNLE.elements();
                while (e1.hasMoreElements()) {
                    rel = (Interrelationship)e1.nextElement();
                    if (rel instanceof ConsumesInterrelationship) {
                        String key = rel.getClass().getName() + rel.getFrom().getLabel() + rel.getTo().getLabel();
                        tableLearnedNLE.put(key, rel);
                        continue;
                    }
                    learnedNLE.removeElement(rel);
                }
                DiagnosisComponent.log.log("After : " + learnedNLE.size() + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                DiagnosisComponent.log.log("Before : " + sub_node.numInInterrelationships() + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                Enumeration e12 = sub_node.getAffectedInterrelationships();
                while (e12.hasMoreElements()) {
                    rel = (Interrelationship)e12.nextElement();
                    if (!(rel instanceof ConsumesInterrelationship)) continue;
                    String key = rel.getClass().getName() + rel.getFrom().getLabel() + rel.getTo().getLabel();
                    tableSubjectiveNLE.put(key, rel);
                }
                DiagnosisComponent.log.log("After : " + (sub_node.numOutInterrelationships() - tableSubjectiveNLE.size()) + " Elements", 2, DiagnosisComponent.FAC_DIAG);
                Enumeration e13 = tableSubjectiveNLE.keys();
                while (e13.hasMoreElements()) {
                    String key = (String)e13.nextElement();
                    rel = (ConsumesInterrelationship)tableSubjectiveNLE.get(key);
                    ConsumesInterrelationship rel2 = (ConsumesInterrelationship)tableLearnedNLE.get(key);
                    if (rel2 != null) {
                        ++found;
                        Distribution subjective_cost = rel.getCost();
                        double integralDistance = subjective_cost.compare(rel2.getCost());
                        if (!(integralDistance > 0.1)) continue;
                        confidence = integralDistance + confidence;
                        NLEtoCheck.addElement(rel2);
                        DiagnosisComponent.log.log("{IncorrectConsumesNLE}: Propose diagnosis NLE " + rel.getLabel() + " has incorrect cost power distribution" + " (Integral Distance = " + integralDistance + ")", 2, DiagnosisComponent.FAC_DIAG);
                        continue;
                    }
                    confidence = 1.0 + confidence;
                    NLEtoRemove.addElement(rel);
                    DiagnosisComponent.log.log("{IncorrectConsumesNLE}: Propose diagnosis NLE " + rel.getLabel() + " DOES NOT exist !!", 2, DiagnosisComponent.FAC_DIAG);
                }
                Enumeration e14 = learnedNLE.elements();
                while (e14.hasMoreElements()) {
                    rel = (Interrelationship)e14.nextElement();
                    String key = rel.getClass().getName() + rel.getFrom().getLabel() + rel.getTo().getLabel();
                    if (tableSubjectiveNLE.containsKey(key)) continue;
                    NLEtoAdd.addElement(rel);
                    confidence = 1.0 + confidence;
                    DiagnosisComponent.log.log("{IncorrectConsumesNLE}: Propose diagnosis NLE " + rel.getLabel() + " is MISSING !!", 2, DiagnosisComponent.FAC_DIAG);
                }
                if (confidence >= 1.0) {
                    this.d = new Diagnosis(this, "Method " + mname + " has incorrect NLE model", 1.0);
                    this.d.setData("Action", a);
                    this.d.setData("NLEtoAdd", NLEtoAdd);
                    this.d.setData("NLEtoRemove", NLEtoRemove);
                    this.d.setData("NLEtoCheck", NLEtoCheck);
                    this.d.setData("Prob", new Double(1.0));
                    this.d.setConfidence(confidence);
                    this.d.setDescription("Action " + mname + " has an incorrect NLE model");
                    this.activateChildNodes(this.d);
                    this.setDiagnosis(this.d);
                } else {
                    DiagnosisComponent.log.log("{IncorrectConsumesNLE}: Method " + a.getName() + " has correct NLE model", 2, DiagnosisComponent.FAC_DIAG);
                }
            }
            this.removeSeed();
        }
    }
}

