/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.mass.TaemsAction;
import agent.simplest.Action;
import java.util.Enumeration;
import taems.EnablesInterrelationship;
import taems.Interrelationship;
import taems.Method;

public class EnablingTaskDelayed
extends DiagnosisComponent {
    public static float THRESH = 1.15f;

    public EnablingTaskDelayed() {
        this.setDescription("No description yet");
    }

    public void init() {
        super.init();
        this.addKey("Action");
    }

    public void diagnose() {
        Diagnosis diag = this.getSeed();
        if (diag != null) {
            Action a = (Action)diag.getData("Action");
            if (a == null) {
                return;
            }
            if (a instanceof TaemsAction) {
                TaemsAction t = (TaemsAction)a;
                Method m = t.getMethod();
                if (m == null) {
                    DiagnosisComponent.log.log("Error, cannot find method " + t.getName(), 0, DiagnosisComponent.FAC_DIAG);
                    return;
                }
                Enumeration ets = m.getInInterrelationships((Interrelationship)new EnablesInterrelationship());
                while (ets.hasMoreElements()) {
                    Interrelationship ir = (Interrelationship)ets.nextElement();
                    Enumeration de = this.getBoard().getDiagnoses("CompletionTimeDelayed");
                    while (de.hasMoreElements()) {
                        TaemsAction ot;
                        Diagnosis od = (Diagnosis)de.nextElement();
                        Action oa = (Action)od.getData("Action");
                        if (!oa.getName().equals(ir.getFrom().getLabel()) || (ot = (TaemsAction)oa).getFinish() + 5 <= t.getStart()) continue;
                        double conf = od.getConfidence();
                        Diagnosis d = new Diagnosis(this, "Action " + a.getName() + " was delayed by previously delayed task " + oa.getName(), conf);
                        d.addSupport(od);
                        d.setData("Action", a);
                        d.setData("EnablingAction", oa);
                        this.activateChildNodes(d);
                        this.setDiagnosis(d);
                    }
                }
            } else {
                DiagnosisComponent.log.log("Method " + a.getName() + " is not a TaemsAction, cannot check previous tasks", 4, DiagnosisComponent.FAC_DIAG);
            }
        }
        this.deactivateInstance();
    }
}

