/*
 * Decompiled with CFR 0.152.
 */
package agent.diagnose.causal;

import agent.base.AgentComponent;
import agent.base.AgentEvent;
import agent.base.AgentListener;
import agent.base.ListenerVector;
import agent.diagnose.DiagnosticsBoard;
import agent.diagnose.causal.DiagnosisComponent;
import agent.diagnose.diagnosis.Diagnosis;
import agent.diagnose.diagnosis.DiagnosisEvent;
import agent.diagnose.diagnosis.DiagnosisEventListener;
import agent.simplest.Log;
import agent.simplest.State;
import agent.simplest.WindowManager;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JFrame;

public class Diagnostics
extends AgentComponent
implements DiagnosisEventListener {
    static final long serialVersionUID = 1234567890L;
    protected Log log;
    protected State state;
    protected DiagnosticsBoard board;
    protected int FAC_DIAG;
    protected Vector components = new Vector();
    protected Vector allcomponents = new Vector();
    protected Vector triggers = new Vector();
    protected Vector active = new Vector();
    protected ListenerVector listeners = new ListenerVector();
    protected JFrame display;
    protected DiagnosisView view;
    private static final Dimension margins = new Dimension(10, 10);
    private transient DiagnosisComponent selected = null;
    private transient Image offscreen;
    private transient Dimension offscreensize;
    private transient Graphics offgraphics;

    public Diagnostics() {
        State.addParameterInfo((String)"DiagWeb", (String)"String", (String)"The name of the web specification entry");
        State.addParameterInfo((String)"DiagDisplay", (String)"String", (String)"The name of the display window.");
        this.addDependency("Log");
        this.addDependency("State");
        this.addDependency("DiagnosticsBoard");
    }

    public void init() {
        this.log = (Log)State.findComponent((String)"Log");
        this.state = (State)State.findComponent((String)"State");
        this.board = (DiagnosticsBoard)State.findComponent((String)"DiagnosticsBoard");
        DiagnosisComponent.FAC_DIAG = this.FAC_DIAG = this.log.getFacilityID((AgentComponent)this);
        this.readWebSpec();
        super.init();
        if (this.state.hasProperty((Object)"DiagDisplay")) {
            String title = (String)this.state.getProperty((Object)"DiagDisplay");
            if (State.hasComponent((String)"WindowManager")) {
                WindowManager wm = (WindowManager)State.findComponent((String)"WindowManager");
                this.display = wm.createWindow(title);
            } else {
                this.display = new JFrame(title);
            }
            this.view = new DiagnosisView();
            this.display.getContentPane().add(this.view);
            this.display.pack();
            if (!State.hasComponent((String)"WindowManager")) {
                this.display.show();
            }
        } else {
            this.log.log("No diagnosis display title found, aborting display creation", 1, this.FAC_DIAG);
        }
    }

    public void begin() {
        super.begin();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readWebSpec() {
        if (!this.state.hasProperty((Object)"DiagWeb")) {
            this.log.log("Hmm...no diagnosis web spec found - is that ok?", 1, this.FAC_DIAG);
            return;
        }
        this.log.log("Setting up diagostics web", 2, this.FAC_DIAG);
        Stack<String> parents = new Stack<String>();
        parents.push("Root");
        try {
            String str;
            BufferedReader file = this.state.getExtendedEntryReader((String)this.state.getProperty((Object)"DiagWeb"));
            if (file == null) {
                this.log.log("Error reading from diagnostics spec: " + this.state.getProperty((Object)"DiagWeb"), 0, this.FAC_DIAG);
                return;
            }
            block10: while (true) {
                if (!file.ready()) {
                    file.close();
                    return;
                }
                str = file.readLine();
                int level = 1;
                while (true) {
                    if (!str.startsWith("\t")) {
                        if (str.indexOf(";") != -1) {
                            str = str.substring(0, str.indexOf(";"));
                        }
                        if ((str = str.trim()).length() > 0) break;
                        continue block10;
                    }
                    str = str.substring(1);
                    ++level;
                }
                String name = str;
                if (name.indexOf("(") != -1) {
                    str = str.substring(0, str.indexOf("("));
                    str = str.trim();
                    if (name.indexOf(")") == -1) {
                        this.log.log("Unmatched ( in web spec", 0, this.FAC_DIAG);
                        return;
                    }
                    name = name.substring(name.indexOf("(") + 1, name.indexOf(")"));
                }
                this.log.log("Working on creation of " + name, 4, this.FAC_DIAG);
                while (true) {
                    if (level >= parents.size()) {
                        if (level == parents.size()) break;
                        this.log.log("Error processing diagnostics web spec", 0, this.FAC_DIAG);
                        return;
                    }
                    parents.pop();
                }
                DiagnosisComponent comp = this.findComponent(name);
                if (comp == null) {
                    Class<?> compclass = null;
                    try {
                        compclass = Class.forName(str);
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            compclass = Class.forName("agent.diagnose.causal." + str);
                        }
                        catch (ClassNotFoundException e2) {
                            this.log.log("Error: Class " + str + " not found", 0, this.FAC_DIAG);
                            return;
                        }
                    }
                    catch (Exception e2) {
                        this.log.log("Error: Class " + str + " couldn't be generated.\n" + e2, 0, this.FAC_DIAG);
                    }
                    try {
                        comp = compclass.newInstance();
                    }
                    catch (InstantiationException e) {
                        this.log.log("Error: " + e, 0, this.FAC_DIAG);
                    }
                    catch (IllegalAccessException e) {
                        this.log.log("Error: " + e, 0, this.FAC_DIAG);
                    }
                    this.log.log("New instance of " + str + " created", 3, this.FAC_DIAG);
                } else {
                    this.log.log("Previously created instance of " + str + " found", 3, this.FAC_DIAG);
                }
                if (comp == null || !(comp instanceof DiagnosisComponent)) break;
                DiagnosisComponent d = comp;
                d.setName(name);
                d.setDiagnostics(this);
                this.addComponent(d, parents.peek().toString());
                parents.push(name);
            }
            this.log.log("Error: Object " + str + " not a DiagnosisComponent", 0, this.FAC_DIAG);
            return;
        }
        catch (IOException e) {
            this.log.log("Error: Diagnosis web file error: " + e, 0, this.FAC_DIAG);
        }
    }

    public void addDiagnosisEventListener(DiagnosisEventListener l) {
        this.listeners.add((AgentListener)l);
    }

    public void removeDiagnosisEventListener(DiagnosisEventListener l) {
        this.listeners.remove((AgentListener)l);
    }

    protected void fireEvent(AgentEvent event) {
        DiagnosisEvent e = (DiagnosisEvent)event;
        Enumeration enumeration = this.listeners.elements();
        this.log.log("Firing a diagnosis event", 4, this.FAC_DIAG);
        while (enumeration.hasMoreElements()) {
            DiagnosisEventListener l = (DiagnosisEventListener)enumeration.nextElement();
            if (!e.isActive()) break;
            switch (e.getID()) {
                case 0: {
                    l.diagnosisAdded(e);
                    break;
                }
                case 1: {
                    l.diagnosisRemoved(e);
                    break;
                }
                case 2: {
                    l.diagnosisChanged(e);
                    break;
                }
            }
        }
        if (this.log != null) {
            this.log.log((Object)e, 2, this.FAC_DIAG);
        }
        this.log.log("Fired a diagnosis event", 5, this.FAC_DIAG);
    }

    public void addComponent(DiagnosisComponent c, String parent) {
        this.log.log("Adding component " + c.getName() + " to " + parent + " in diagnostics web", 3, this.FAC_DIAG);
        if (!this.allcomponents.contains(c)) {
            this.allcomponents.addElement(c);
        }
        if (parent.equalsIgnoreCase("Root")) {
            this.components.addElement(c);
        } else {
            DiagnosisComponent p = this.findComponent(parent);
            if (p != null) {
                p.addChildNode(c);
            } else {
                this.log.log("Error, parent " + parent + " not found in web", 0, this.FAC_DIAG);
                return;
            }
        }
        if (c.isTriggerable() && !this.triggers.contains(c)) {
            this.triggers.addElement(c);
        }
        if (!c.initd) {
            c.init();
        }
        this.log.log("Added component " + c.getName() + " to diagnostic web", 3, this.FAC_DIAG);
    }

    public DiagnosisComponent findComponent(String name) {
        Enumeration e = this.components.elements();
        DiagnosisComponent d = null;
        while (e.hasMoreElements()) {
            DiagnosisComponent c = (DiagnosisComponent)e.nextElement();
            if (c.getName().equalsIgnoreCase(name)) {
                d = c;
                break;
            }
            d = this.findComponent(c, name);
            if (d != null) break;
        }
        return d;
    }

    private DiagnosisComponent findComponent(DiagnosisComponent p, String name) {
        Enumeration e = p.children();
        DiagnosisComponent d = null;
        while (e.hasMoreElements()) {
            DiagnosisComponent c = (DiagnosisComponent)e.nextElement();
            if (c.getName().equalsIgnoreCase(name)) {
                d = c;
                break;
            }
            d = this.findComponent(c, name);
            if (d != null) break;
        }
        return d;
    }

    public void makeInstanceActive(DiagnosisComponent c) {
        if (!this.active.contains(c)) {
            this.log.log("Activating diagnosis instance " + c.getName(), 3, this.FAC_DIAG);
            this.active.addElement(c);
        }
        this.updateView();
    }

    public void makeInstanceInactive(DiagnosisComponent c) {
        if (this.active.removeElement(c)) {
            this.log.log("Deactivating diagnosis instance " + c.getName(), 3, this.FAC_DIAG);
        }
        this.updateView();
    }

    public boolean isInstanceActive(DiagnosisComponent c) {
        return this.active.contains(c);
    }

    public void pulse() {
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            DiagnosisComponent c = (DiagnosisComponent)e.nextElement();
            this.log.log("Checking if " + c.getName() + " was triggered", 4, this.FAC_DIAG);
            Diagnosis d = c.checkTrigger();
            if (d == null) continue;
            c.activateNewInstance(d);
        }
        e = this.active.elements();
        while (e.hasMoreElements()) {
            DiagnosisComponent c = (DiagnosisComponent)e.nextElement();
            if (c.isAsleep()) {
                this.log.log("Diagnosis component " + c.getName() + " is asleep", 4, this.FAC_DIAG);
                c.sleep();
                continue;
            }
            this.log.log("Sending diagnosis pulse to " + c.getName(), 4, this.FAC_DIAG);
            c.diagnose();
        }
    }

    public void reset() {
        super.reset();
        Enumeration e = this.components.elements();
        while (e.hasMoreElements()) {
            ((DiagnosisComponent)e.nextElement()).reset();
        }
        this.active.removeAllElements();
    }

    public void updateView() {
        if (this.view != null) {
            this.view.validate();
            this.view.repaint();
        }
    }

    public void diagnosisAdded(DiagnosisEvent e) {
        this.diagnosisChanged(e);
    }

    public void diagnosisRemoved(DiagnosisEvent e) {
        this.diagnosisChanged(e);
    }

    public void diagnosisChanged(DiagnosisEvent e) {
        this.startFireEvent(e);
    }

    private class DiagnosisView
    extends Canvas {
        public DiagnosisView() {
            this.addMouseListener(new MouseListener(this){
                private final /* synthetic */ DiagnosisView this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$1.handleMouseEvent(e);
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
        }

        public DiagnosisComponent findComponent(Point p) {
            Enumeration e = Diagnostics.this.allcomponents.elements();
            while (e.hasMoreElements()) {
                DiagnosisComponent d = (DiagnosisComponent)e.nextElement();
                if (!d.contains(p)) continue;
                return d;
            }
            return null;
        }

        public void handleMouseEvent(MouseEvent e) {
            DiagnosisComponent d = this.findComponent(e.getPoint());
            if (Diagnostics.this.selected != null) {
                Diagnostics.this.selected.setSelected(false);
                Diagnostics.this.selected.paint(this.getGraphics());
                Diagnostics.this.selected = null;
                if (d == null) {
                    this.update(this.getGraphics());
                }
            }
            if (d != null) {
                Diagnostics.this.selected = d;
                Diagnostics.this.selected.setSelected(true);
                Diagnostics.this.selected.paint(this.getGraphics());
                this.update(this.getGraphics());
            }
        }

        public void update(Graphics g) {
            Dimension d = this.getSize();
            if (Diagnostics.this.offscreen == null || d.width != ((Diagnostics)Diagnostics.this).offscreensize.width || d.height != ((Diagnostics)Diagnostics.this).offscreensize.height) {
                Diagnostics.this.offscreen = this.createImage(d.width, d.height);
                Diagnostics.this.offscreensize = d;
                Diagnostics.this.offgraphics = Diagnostics.this.offscreen.getGraphics();
                Diagnostics.this.offgraphics.setFont(this.getFont());
            }
            Diagnostics.this.offgraphics.setColor(this.getBackground());
            Diagnostics.this.offgraphics.fillRect(0, 0, d.width, d.height);
            this.calculateSize(Diagnostics.this.offgraphics);
            this.drawEdges(Diagnostics.this.offgraphics);
            this.drawComponents(Diagnostics.this.offgraphics);
            g.drawImage(Diagnostics.this.offscreen, 0, 0, null);
        }

        public Dimension calculateSize(Graphics g) {
            Dimension ddim;
            DiagnosisComponent d;
            Dimension dim = new Dimension(0, 0);
            Enumeration e = Diagnostics.this.allcomponents.elements();
            while (e.hasMoreElements()) {
                d = (DiagnosisComponent)e.nextElement();
                ddim = d.getSize(g);
                if (dim.width < ddim.width + margins.width * 2) {
                    dim.width = ddim.width + margins.width * 2;
                }
                dim.height += ddim.height + margins.height * 2;
            }
            e = Diagnostics.this.allcomponents.elements();
            int y = 0;
            while (e.hasMoreElements()) {
                d = (DiagnosisComponent)e.nextElement();
                ddim = d.getSize(g);
                d.setLocation(new Point(dim.width / 2, y += ddim.height / 2 + margins.height));
                y += ddim.height / 2 + margins.height;
            }
            return dim;
        }

        public void drawEdges(Graphics g) {
            if (Diagnostics.this.selected != null) {
                Enumeration e = Diagnostics.this.selected.children();
                while (e.hasMoreElements()) {
                    DiagnosisComponent d = (DiagnosisComponent)e.nextElement();
                    g.setColor(Color.black);
                    g.drawLine(((Diagnostics)Diagnostics.this).selected.getLocation().x, ((Diagnostics)Diagnostics.this).selected.getLocation().y, d.getBounds().x, d.getBounds().y);
                }
            }
        }

        public void drawComponents(Graphics g) {
            Enumeration e = Diagnostics.this.allcomponents.elements();
            while (e.hasMoreElements()) {
                DiagnosisComponent d = (DiagnosisComponent)e.nextElement();
                d.paint(g);
            }
        }

        public synchronized void paint(Graphics g) {
            if (Diagnostics.this.offscreen == null) {
                this.update(g);
            }
            g.drawImage(Diagnostics.this.offscreen, 0, 0, null);
        }

        public Dimension getPreferredSize() {
            return this.calculateSize(this.getGraphics());
        }
    }
}

